/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExpressionTreeNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import edu.cmu.pact.Utilities.trace;

public class NumberNode
extends ExpressionTreeNode {
    public Double numericalValue;
    private boolean simpleTerm;

    public NumberNode(String value, ExpressionTreeProperties properties) {
        block4: {
            super(null, false, properties);
            this.simpleTerm = true;
            String tempString = "";
            if (value.charAt(0) == '-') {
                this.negated = true;
                tempString = value.substring(1, value.length() - 1);
            } else {
                this.negated = false;
                tempString = value;
            }
            try {
                this.numericalValue = Double.parseDouble(tempString);
                this.setString(Double.toString(this.numericalValue));
            }
            catch (NumberFormatException e) {
                if (!trace.getDebugCode("functions")) break block4;
                trace.out("functions", "Error " + value + ": Result not double");
            }
        }
    }

    @Override
    public NumberNode clone() {
        return new NumberNode(this.getNegatedString(), this.properties);
    }

    @Override
    protected void orderTermsRecursive() {
    }

    @Override
    protected void orderTerms() {
    }

    @Override
    protected ExpressionTreeNode attemptCancelTerms(ExpressionTreeNode x) {
        if (!x.getClass().equals(NumberNode.class)) {
            return null;
        }
        NumberNode num = (NumberNode)x;
        return new NumberNode(Double.toString(this.getNegatedValue() / num.getNegatedValue()), this.properties);
    }

    public double getNonNegatedValue() {
        return this.numericalValue;
    }

    public double getNegatedValue() {
        if (this.negated) {
            return -1.0 * this.numericalValue;
        }
        return this.numericalValue;
    }

    @Override
    protected String toCanonicalString(int callerLevel) {
        if (this.negated) {
            return "(-" + this.getNonNegatedString() + ")";
        }
        return this.getNonNegatedString();
    }

    @Override
    protected ExpressionTreeNode removeIdentityOperandsAndDemote(boolean simpleTermsOnly) {
        return this;
    }

    @Override
    protected NumberNode mergeMultiplicands(ExpressionTreeNode candidate) {
        if (this.numericalValue == 0.0) {
            return this;
        }
        if (candidate.getClass().equals(NumberNode.class)) {
            Double candidateValue = ((NumberNode)candidate).getNegatedValue();
            return new NumberNode(Double.toString(this.getNegatedValue() * candidateValue), this.properties);
        }
        return null;
    }

    @Override
    protected ExpressionTreeNode additiveCombine(ExpressionTreeNode x) {
        if (x.getClass() == NumberNode.class) {
            return new NumberNode(Double.toString(this.getNegatedValue() + ((NumberNode)x).getNegatedValue()), this.properties);
        }
        return null;
    }

    @Override
    protected Boolean eval_internal() {
        this.setEvalValue(this.getNegatedValue());
        return true;
    }

    @Override
    protected String getNonNegatedString(boolean preserveSimpleTerms) {
        return this.myString;
    }

    @Override
    public boolean isSimpleTerm() {
        return this.simpleTerm;
    }

    @Override
    public void setSimpleTerm(boolean simpleTerm) {
        super.setSimpleTerm(simpleTerm);
        this.simpleTerm = simpleTerm;
    }
}

