/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExponentNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExpressionTreeNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.MultiplicationNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.NumberNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import java.util.ArrayList;

public class VariableNode
extends ExpressionTreeNode {
    private boolean simpleTerm = true;

    public VariableNode(String value, ExpressionTreeProperties properties) {
        super(null, false, properties);
        if (value.charAt(0) == '-') {
            this.negated = true;
            this.setString(value.substring(1));
        } else {
            this.setString(value);
        }
    }

    @Override
    protected ExpressionTreeNode removeIdentityOperandsAndDemote(boolean simpleTermsOnly) {
        return this;
    }

    @Override
    protected void orderTermsRecursive() {
    }

    @Override
    protected void orderTerms() {
    }

    @Override
    public VariableNode clone() {
        return new VariableNode(this.getNegatedString(), this.properties);
    }

    @Override
    protected String toCanonicalString(int callerLevel) {
        if (this.negated) {
            return "(-" + this.getNonNegatedString() + ")";
        }
        return this.getNonNegatedString();
    }

    @Override
    protected String getNonNegatedString(boolean preserveSimpleTerms) {
        return this.myString;
    }

    @Override
    protected ExpressionTreeNode mergeMultiplicands(ExpressionTreeNode candidate) {
        if (candidate.getClass().equals(ExponentNode.class)) {
            return candidate.mergeMultiplicands(this);
        }
        if (this.getNonNegatedString().equals(candidate.getNonNegatedString())) {
            ArrayList<ExpressionTreeNode> args = new ArrayList<ExpressionTreeNode>();
            Boolean exponentNegated = this.negated ^ candidate.negated;
            candidate.negated = false;
            this.negated = false;
            args.add(candidate);
            args.add(new NumberNode("2", this.properties));
            return new ExponentNode(args, exponentNegated, this.properties);
        }
        return null;
    }

    @Override
    protected ExpressionTreeNode additiveCombine(ExpressionTreeNode x) {
        if (this.getClass() == VariableNode.class && x.getClass() == VariableNode.class && this.getNonNegatedString().equals(x.getNonNegatedString())) {
            if (this.negated ^ x.negated) {
                return new NumberNode("0.0", this.properties);
            }
            ArrayList<ExpressionTreeNode> multiplicands = new ArrayList<ExpressionTreeNode>();
            multiplicands.add(this);
            NumberNode multiplier = new NumberNode("2.0", this.properties);
            multiplicands.add(multiplier);
            return new MultiplicationNode(multiplicands, null, this.negated, this.properties);
        }
        return null;
    }

    @Override
    protected Boolean eval_internal() {
        if (this.properties.variableTable.containsKey(this.myString)) {
            Object result = this.properties.variableTable.get(this.myString);
            Double value = Double.parseDouble(result.toString());
            if (this.negated) {
                value = -value.doubleValue();
            }
            this.setEvalValue(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSimpleTerm() {
        return this.simpleTerm;
    }

    @Override
    public void setSimpleTerm(boolean simpleTerm) {
        super.setSimpleTerm(simpleTerm);
        this.simpleTerm = simpleTerm;
    }
}

