/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ExpressionMatcher;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExponentSyntaxNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExpressionTreeNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.MultiplicationNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.SyntaxTreeNode;
import edu.cmu.pact.Utilities.trace;
import fri.patterns.interpreter.parsergenerator.semantics.TreeBuilderSemantic;
import fri.patterns.interpreter.parsergenerator.syntax.Rule;
import java.util.ArrayList;
import java.util.List;

public class TermSyntaxNode
extends SyntaxTreeNode {
    static TreeBuilderSemantic.Node create(Rule rule, List inputTokens, List ranges, ExpressionTreeProperties properties) {
        if (trace.getDebugCode("expr")) {
            StringBuilder sb = new StringBuilder("TermSyntaxNode.create()");
            sb.append(" inputTokens.size ").append(inputTokens.size());
            for (int i = 0; i < inputTokens.size(); ++i) {
                sb.append("; [").append(i).append("]");
                Object tkn = inputTokens.get(i);
                if (!(tkn instanceof SyntaxTreeNode)) {
                    sb.append(" {not SyntaxTreeNode} ").append(tkn);
                    continue;
                }
                SyntaxTreeNode node = (SyntaxTreeNode)((Object)tkn);
                sb.append(" \"").append(node.toActualString()).append("\"");
                sb.append(" type ").append(((Object)((Object)node)).getClass().getSimpleName());
            }
            trace.out("expr", sb.toString());
        }
        TermSyntaxNode result = new TermSyntaxNode(rule, inputTokens, ranges, properties);
        if (result.type != 5) {
            return result;
        }
        Object rightTkn = result.getInputTokens().get(1);
        if (!(rightTkn instanceof SyntaxTreeNode)) {
            return result;
        }
        SyntaxTreeNode rightOp = (SyntaxTreeNode)((Object)rightTkn);
        try {
            boolean rightIsNumeric = false;
            SyntaxTreeNode base = null;
            if (rightOp instanceof ExponentSyntaxNode) {
                base = ((ExponentSyntaxNode)rightOp).getChildNode(0);
                double rightNum = Double.parseDouble(base.toActualString());
                rightIsNumeric = true;
            }
            if (!rightIsNumeric) {
                return result;
            }
            Object leftTkn = result.getInputTokens().get(0);
            if (!(leftTkn instanceof SyntaxTreeNode)) {
                return result;
            }
            SyntaxTreeNode leftOp = (SyntaxTreeNode)((Object)leftTkn);
            if (trace.getDebugCode("expr")) {
                trace.out("expr", "IMPLICIT_MULTIPLY: right operand numeric " + base.toActualString() + "; left operand is " + leftOp.toActualString() + ", class " + ((Object)((Object)leftOp)).getClass().getSimpleName() + ", type " + leftOp.type);
            }
            if (leftOp.toActualString().trim().endsWith(")")) {
                return result;
            }
            return new SyntaxTreeNode(rule, inputTokens, ranges, properties);
        }
        catch (NumberFormatException e) {
            return result;
        }
        catch (Exception e) {
            if (trace.getDebugCode("functions")) {
                trace.out("functions", "unexpected exception parsing operands: " + e + "; cause " + e.getCause());
            }
            return result;
        }
    }

    private TermSyntaxNode(Rule rule, List inputTokens, List ranges, ExpressionTreeProperties properties) {
        super(rule, inputTokens, ranges, properties);
        this.type = this.getInputTokens().size() == 1 ? 0 : (this.getInputTokens().size() == 2 ? 5 : (this.getChildString(1).equals("*") ? 3 : 4));
    }

    @Override
    public ExpressionTreeNode generateExpressionTree() {
        if (trace.getDebugCode("expr")) {
            trace.out("expr", "TermSyntaxNode.gET() inputTokens.size " + this.getInputTokens().size());
        }
        if (this.type == 3 || this.type == 4 || this.type == 5) {
            ArrayList<ExpressionTreeNode> multiplicands;
            ExpressionTreeNode left = ((SyntaxTreeNode)((Object)this.getInputTokens().get(0))).generateExpressionTree();
            ExpressionTreeNode right = this.type == 3 || this.type == 4 ? ((SyntaxTreeNode)((Object)this.getInputTokens().get(2))).generateExpressionTree() : ((SyntaxTreeNode)((Object)this.getInputTokens().get(1))).generateExpressionTree();
            ArrayList<ExpressionTreeNode> divisors = null;
            if (this.type == 3 || this.type == 5) {
                multiplicands = new ArrayList<ExpressionTreeNode>();
                multiplicands.add(left);
                multiplicands.add(right);
            } else {
                multiplicands = new ArrayList();
                multiplicands.add(left);
                divisors = new ArrayList<ExpressionTreeNode>();
                divisors.add(right);
            }
            MultiplicationNode result = new MultiplicationNode(multiplicands, divisors, false, this.properties);
            result.setSimpleTerm(this.isSimpleTerm(left, right));
            return result;
        }
        return ((SyntaxTreeNode)((Object)this.getInputTokens().get(0))).generateExpressionTree();
    }

    private boolean isSimpleTerm(ExpressionTreeNode left, ExpressionTreeNode right) {
        if (this.type != 5) {
            return false;
        }
        return left.isSimpleTerm() && right.isSimpleTerm();
    }

    @Override
    public String toActualString() {
        if (this.myStringValue == "") {
            this.myStringValue = this.type == 0 ? this.getChildNode(0).toActualString() : (this.type == 5 ? this.getChildNode(0).toActualString() + this.getChildNode(1).toActualString() : (this.type == 3 ? this.getChildNode(0).toActualString() + "*" + this.getChildNode(2).toActualString() : this.getChildNode(0).toActualString() + "/" + this.getChildNode(2).toActualString()));
        }
        return this.myStringValue;
    }
}

