/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.hcii.ctat.CTATRandom;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerPath;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracer;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.DefaultLinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupEditorContext;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.HintPolicyEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.CTATFunctions;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeDeletedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelException;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.SAIList;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTableChangeEvent;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializable;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.EmptyIterator;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.ctat.model.SCORM;
import edu.cmu.pact.ctat.model.Skill;
import edu.cmu.pact.ctat.model.Skills;
import fri.patterns.interpreter.parsergenerator.Parser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import pact.CommWidgets.UniversalToolProxy;

public class ProblemModel
implements Serializable {
    public static final double UNREQUESTED_HINT_FRACTION = 0.3333333333333333;
    static final long serialVersionUID = 3100L;
    public static final String GROUP = "group";
    private String problemName;
    private String problemFullName;
    private String courseName;
    private String unitName;
    private String sectionName;
    private ProblemNode startNode;
    private ProblemGraph problemGraph;
    private GroupEditorContext editContext;
    private Map<String, RuleProduction> ruleProductionMap;
    private boolean startNodeCreatedFlag;
    private List<MessageObject> startNodeMessageVector;
    public static final String BEHAVIOR_RECORDER_MODE = "behaviorRecorderMode";
    public static final String STUDENT_BEGINS_HERE = "startStateNodeName";
    public static final String STUDENT_BEGINS_HERE_VAR = "%(startStateNodeName)%";
    private Vector checkAllEdges;
    private Vector checkAllNodes;
    private Vector linksGroups;
    private Vector willDeleteLinks;
    private Vector willRemovedLinkGroups;
    private boolean useCommWidgetFlag;
    private boolean problemLoadedFromLispTutor;
    private boolean searchPathFlag;
    private boolean lockWidget;
    private boolean caseInsensitive;
    private HintPolicyEnum hintPolicy = HintPolicyEnum.DEFAULT;
    private HashSet<ProblemModelListener> listeners;
    private BR_Controller controller;
    private boolean firstNode;
    private int nodeUniqueIDGenerator;
    private int edgeUniqueIDGenerator;
    private ExampleTracerGraph exampleTracerGraph;
    private VariableTable variableTable;
    private boolean highlightRightSelection;
    private ProblemSummary problemSummary;
    private Set<Integer> beforeStudentBeginsStates;
    private ProblemNode studentBeginsHereState;
    private String behaviorRecorderMode;
    private Boolean confirmDone;
    private RequestGoToState requestGoToState = null;
    private String outOfOrderMessage;
    private boolean randomizeHints = false;
    private int[] unrequestedHintDepths = new int[0];
    private List<MessageObject> unrequestedHintMsgs = null;
    public static final String DEFAULT_OUT_OF_ORDER_MESSAGE = "Instead of the step you are working on, please work on the highlighted step.";
    public static final String OUT_OF_ORDER_MESSAGE = "outOfOrderMessage";
    private static final Pattern MassProductionVarPattern = Pattern.compile("%\\([^)][^)]*\\)%");
    private SAIList studentSAIs = null;
    private int fireCount = 0;
    private CTATFunctions ctatFunctions;

    private void init(BR_Controller controller) {
        Boolean b;
        Enum hpe;
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "PM.init(controller " + controller + ")");
        }
        if (trace.getDebugCode("pm")) {
            trace.out("pm", "controller " + controller);
        }
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "ProblemModel.init()");
        }
        this.problemName = "";
        this.problemFullName = "";
        this.courseName = "";
        this.unitName = "";
        this.sectionName = "";
        if (controller != null) {
            this.controller = controller;
        }
        this.setStartNode(null);
        this.problemGraph = new ProblemGraph();
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        if (!Utils.isRuntime()) {
            if (this.editContext == null) {
                this.editContext = new GroupEditorContext(this.getExampleTracerGraph().getGroupModel());
            } else {
                this.editContext.clear();
            }
        }
        if (this.controller == null) {
            this.addProblemModelListener(this.getExampleTracerGraph());
        }
        this.ruleProductionMap = new LinkedHashMap<String, RuleProduction>();
        this.setStartNodeCreatedFlag(false);
        this.studentSAIs = null;
        this.setStartNodeMessageVector(new Vector());
        this.checkAllEdges = new Vector();
        this.checkAllNodes = new Vector();
        this.setLinksGroups(new Vector());
        this.willDeleteLinks = new Vector();
        this.willRemovedLinkGroups = new Vector();
        this.useCommWidgetFlag = true;
        this.problemLoadedFromLispTutor = false;
        this.searchPathFlag = false;
        this.lockWidget = true;
        this.hintPolicy = HintPolicyEnum.DEFAULT;
        this.caseInsensitive = true;
        this.setFirstNode(true);
        this.nodeUniqueIDGenerator = 0;
        this.edgeUniqueIDGenerator = 0;
        this.ctatFunctions = null;
        if (this.controller != null) {
            this.setVariableTable(new VariableTable(Utils.isRuntime()));
        } else {
            this.setVariableTable(new VariableTable());
        }
        this.setHighlightRightSelection(false);
        this.problemSummary = null;
        if (trace.getDebugCode("pm")) {
            trace.out("pm", "init(" + this.studentBeginsHereState + "=>null)");
        }
        this.studentBeginsHereState = null;
        this.beforeStudentBeginsStates = new LinkedHashSet<Integer>();
        this.getProblemGraph().clear();
        if (this.controller == null) {
            return;
        }
        PreferencesModel pm = this.controller.getPreferencesModel();
        if (pm == null) {
            return;
        }
        Enum fe = pm.getEnumValue("suppressStudentFeedback");
        if (fe != null) {
            this.setSuppressStudentFeedback((FeedbackEnum)fe);
        }
        if ((hpe = pm.getEnumValue("hintPolicy")) != null) {
            this.setHintPolicy((HintPolicyEnum)hpe);
        }
        if ((b = pm.getBooleanValue("Highlight Right Widget")) != null) {
            this.setHighlightRightSelection(b);
        }
        if ((b = pm.getBooleanValue("Case Sensitive")) != null) {
            this.setCaseInsensitive(b == false);
        }
        if ((b = pm.getBooleanValue("Lock Widgets")) != null) {
            this.setLockWidget(b);
        }
    }

    public ProblemModel(BR_Controller controller) {
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "ProblemModel Constructor");
        }
        this.init(controller);
    }

    public ProblemEdge findIncomingEdgeForCommMsg(ProblemNode atNode) {
        ProblemEdge tempEdge;
        if (atNode == null) {
            return null;
        }
        if ((this.controller.getCtatModeModel().isJessMode() || this.controller.getCtatModeModel().isTDKMode()) && (tempEdge = this.findEdgeOnCheckStatus(atNode)) != null) {
            return tempEdge;
        }
        tempEdge = this.findFirableBugEdge(atNode);
        if (tempEdge != null) {
            return tempEdge;
        }
        return null;
    }

    public boolean hasPreferredPath(ProblemNode outNode) {
        if (outNode == null) {
            return false;
        }
        Enumeration<ProblemEdge> connectingEdges = this.getProblemGraph().getConnectingEdges(outNode);
        while (connectingEdges.hasMoreElements()) {
            EdgeData myEdge;
            ProblemEdge tempEdge = connectingEdges.nextElement();
            if (outNode != tempEdge.getNodes()[0] || !(myEdge = tempEdge.getEdgeData()).isPreferredEdge()) continue;
            return true;
        }
        return false;
    }

    public ProblemEdge updatePreferredPath(ProblemNode outNode, ProblemEdge excludeEdge, boolean throwException) throws ProblemModelException {
        EdgeData myEdge;
        ProblemEdge tempEdge;
        if (outNode == null) {
            return null;
        }
        if (outNode.isLeaf()) {
            return null;
        }
        if (outNode.getOutDegree() == 1 && excludeEdge != null) {
            return null;
        }
        Enumeration<ProblemEdge> iterEdges = this.getProblemGraph().getOutgoingEdges(outNode);
        while (iterEdges.hasMoreElements()) {
            tempEdge = iterEdges.nextElement();
            if (outNode != tempEdge.getNodes()[0] || tempEdge == excludeEdge || !(myEdge = tempEdge.getEdgeData()).getActionType().equalsIgnoreCase("Correct Action")) continue;
            myEdge.setPreferredEdge(true);
            EdgeUpdatedEvent e = new EdgeUpdatedEvent(this, myEdge.getEdge(), true);
            this.fireProblemModelEvent(e);
            return tempEdge;
        }
        iterEdges = this.getProblemGraph().getConnectingEdges(outNode);
        while (iterEdges.hasMoreElements()) {
            tempEdge = iterEdges.nextElement();
            if (outNode != tempEdge.getNodes()[0] || tempEdge == excludeEdge || !(myEdge = tempEdge.getEdgeData()).getActionType().equalsIgnoreCase("Fireable Buggy Action")) continue;
            myEdge.setPreferredEdge(true);
            EdgeUpdatedEvent e = new EdgeUpdatedEvent(this, myEdge.getEdge(), true);
            this.fireProblemModelEvent(e);
            return tempEdge;
        }
        if (throwException) {
            throw new ProblemModelException("No preferred path defined");
        }
        return null;
    }

    private ProblemEdge findFirableBugEdge(ProblemNode atNode) {
        ProblemEdge returnEdge = null;
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(atNode);
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            ProblemNode parentTemp = tempEdge.getNodes()[0];
            if (parentTemp == atNode) continue;
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            String authorIntent = tempMyEdge.getActionType();
            if (authorIntent.equalsIgnoreCase("Correct Action")) {
                returnEdge = tempEdge;
                if (tempEdge.isPreferredEdge()) {
                    return tempEdge;
                }
            }
            if (!authorIntent.equalsIgnoreCase("Fireable Buggy Action") || returnEdge != null) continue;
            returnEdge = tempEdge;
        }
        return returnEdge;
    }

    private ProblemEdge findEdgeOnCheckStatus(ProblemNode atNode) {
        ProblemEdge returnEdge = null;
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(atNode);
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            ProblemNode parentTemp = tempEdge.getNodes()[0];
            if (parentTemp == atNode) continue;
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            returnEdge = tempEdge;
            String checkedStatus = tempMyEdge.getCheckedStatus();
            String authorIntent = tempMyEdge.getActionType();
            if (checkedStatus.equalsIgnoreCase("SUCCESS")) {
                returnEdge = tempEdge;
            }
            if (checkedStatus.equalsIgnoreCase("FIREABLE-BUG") && returnEdge == null) {
                returnEdge = tempEdge;
            }
            if ((!checkedStatus.equalsIgnoreCase("SUCCESS") || !authorIntent.equalsIgnoreCase("Correct Action")) && (!checkedStatus.equalsIgnoreCase("FIREABLE-BUG") || !authorIntent.equalsIgnoreCase("Fireable Buggy Action"))) continue;
            return tempEdge;
        }
        return returnEdge;
    }

    public ExampleTracerPath findPath(ProblemNode atNode) {
        if (atNode.equals(this.getStartNode())) {
            return new ExampleTracerPath();
        }
        Set<ExampleTracerPath> paths = this.getExampleTracerGraph().findAllPaths();
        HashSet<ExampleTracerPath> goodPaths = new HashSet<ExampleTracerPath>();
        block0: for (ExampleTracerPath path : paths) {
            for (ExampleTracerLink link : path) {
                if (!this.getExampleTracerGraph().getNode(link.getNextNode()).getProblemNode().equals(atNode)) continue;
                goodPaths.add(path);
                continue block0;
            }
        }
        ExampleTracerPath path = ExampleTracerPath.getBestPath(goodPaths);
        if (trace.getDebugCode("et")) {
            trace.outNT("et", "ProblemModel.findPath(" + atNode + "): " + paths.size() + " paths, " + goodPaths.size() + " goodPaths, best path: " + path);
        }
        ExampleTracerPath restrictedPath = new ExampleTracerPath();
        if (path != null) {
            for (ExampleTracerLink link : path) {
                restrictedPath.addLink(link);
                if (!this.getExampleTracerGraph().getNode(link.getNextNode()).getProblemNode().equals(atNode)) continue;
                break;
            }
        }
        return restrictedPath;
    }

    ProblemEdge findInEdge(ProblemNode testNode) {
        EdgeData myEdgeTemp;
        int i;
        ProblemEdge edgeTemp = null;
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(testNode);
        Vector<ProblemEdge> parentLinks = new Vector<ProblemEdge>();
        while (iter.hasMoreElements()) {
            edgeTemp = iter.nextElement();
            if (edgeTemp.getNodes()[0] == testNode) continue;
            parentLinks.addElement(edgeTemp);
        }
        int sizeOfParentLinks = parentLinks.size();
        for (i = sizeOfParentLinks - 1; i >= 0; --i) {
            edgeTemp = (ProblemEdge)parentLinks.elementAt(i);
            myEdgeTemp = edgeTemp.getEdgeData();
            if (!myEdgeTemp.isPreferredEdge() || !myEdgeTemp.getActionType().equalsIgnoreCase("Correct Action")) continue;
            return edgeTemp;
        }
        for (i = sizeOfParentLinks - 1; i >= 0; --i) {
            edgeTemp = (ProblemEdge)parentLinks.elementAt(i);
            myEdgeTemp = edgeTemp.getEdgeData();
            if (!myEdgeTemp.getActionType().equalsIgnoreCase("Correct Action")) continue;
            return edgeTemp;
        }
        for (i = sizeOfParentLinks - 1; i >= 0; --i) {
            edgeTemp = (ProblemEdge)parentLinks.elementAt(i);
            myEdgeTemp = edgeTemp.getEdgeData();
            if (!myEdgeTemp.getActionType().equalsIgnoreCase("Fireable Buggy Action")) continue;
            return edgeTemp;
        }
        return null;
    }

    public static boolean checkForValidProblemName(String problemName) {
        if (problemName == null || problemName.trim().equals("")) {
            return false;
        }
        Pattern p = Pattern.compile("\\W");
        for (int i = 0; i < problemName.length(); ++i) {
            String textChar = problemName.substring(i, i + 1);
            Matcher m = p.matcher(textChar);
            if (!m.find() || textChar.equals("+") || textChar.equals("-")) continue;
            return false;
        }
        return true;
    }

    public void loadStartStateMessages(Vector<MessageObject> messages, UniversalToolProxy utp) {
        if (messages != null) {
            this.setStartNodeMessageVector(messages);
        } else {
            messages = new Vector();
            this.setStartNodeMessageVector(messages);
        }
        this.sendStartStateMessagesToRuleEngine(utp, messages, this.getClass().getSimpleName() + ".loadStartStateMessages()");
    }

    private void sendStartStateMessagesToRuleEngine(UniversalToolProxy utp, List<MessageObject> msgs, String caller) {
        if (utp == null || !this.getController().getCtatModeModel().isRuleEngineTracing()) {
            return;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "from " + caller + ": Sending " + (msgs == null ? -1 : msgs.size()) + " start state Comm MSGs to LISP");
        }
        int i = 0;
        for (MessageObject msg : msgs) {
            if (msg != null) {
                utp.sendProperty(msg);
            }
            ++i;
        }
    }

    public void updateStartStateMessages(Vector messages, UniversalToolProxy utp) {
        if (messages != null) {
            this.setStartNodeMessageVector(messages);
        } else {
            this.setStartNodeMessageVector(new Vector());
        }
        this.sendStartStateMessagesToRuleEngine(utp, messages, this.getClass().getSimpleName() + ".updateStartStateMessages()");
        this.setStartNodeCreatedFlag(true);
    }

    public static void checkAddRules(String ruleNameProdutionSetText, Vector ruleProductionList, Vector problemSkillFrequency) {
        if (ruleNameProdutionSetText.indexOf(" ") <= 0) {
            return;
        }
        if (ruleNameProdutionSetText.equals("unnamed rule")) {
            return;
        }
        int ruleLength = ruleProductionList.size();
        for (int i = 0; i < ruleLength; ++i) {
            String tempRule = (String)ruleProductionList.elementAt(i);
            if (!ruleNameProdutionSetText.equals(tempRule)) continue;
            Integer tempInteger = (Integer)problemSkillFrequency.elementAt(i);
            problemSkillFrequency.setElementAt(new Integer(1 + tempInteger), i);
            return;
        }
        ruleProductionList.addElement(ruleNameProdutionSetText);
        problemSkillFrequency.addElement(new Integer(1));
    }

    public boolean edgeLispChecked(ProblemEdge edgeTest) {
        boolean checkedFlag = false;
        int checkedSize = this.getCheckAllEdges().size();
        for (int i = 0; !checkedFlag && i < checkedSize; ++i) {
            ProblemEdge tempEdge = (ProblemEdge)this.getCheckAllEdges().elementAt(i);
            if (tempEdge != edgeTest) continue;
            checkedFlag = true;
        }
        return checkedFlag;
    }

    public boolean nodeChecked(ProblemNode nodeTest) {
        boolean checkedFlag = false;
        int checkedSize = this.getCheckAllNodes().size();
        for (int i = 0; !checkedFlag && i < checkedSize; ++i) {
            ProblemNode tempNode = (ProblemNode)this.getCheckAllNodes().elementAt(i);
            if (tempNode != nodeTest) continue;
            checkedFlag = true;
        }
        return checkedFlag;
    }

    public boolean checkConsistency(String tutorCheckResult, String authorIntent) {
        if (trace.getDebugCode("popup")) {
            trace.out("popup", "checkConsistency: tutorCheckResult = " + tutorCheckResult + ", authorIntent = " + authorIntent);
        }
        return (tutorCheckResult.equalsIgnoreCase("SUCCESS") || tutorCheckResult.equalsIgnoreCase("Fail before, Correct now")) && authorIntent.equalsIgnoreCase("Correct Action") || tutorCheckResult.equalsIgnoreCase("NO-MODEL") && authorIntent.equalsIgnoreCase("Untraceable Error") || (tutorCheckResult.equalsIgnoreCase("BUG") || tutorCheckResult.equalsIgnoreCase("Correct before, Fail now")) && authorIntent.equalsIgnoreCase("Buggy Action") || tutorCheckResult.equalsIgnoreCase("FIREABLE-BUG") && authorIntent.equalsIgnoreCase("Fireable Buggy Action") || this.controller.getCtatModeModel().isSimStudentMode() && tutorCheckResult.equalsIgnoreCase("NO-MODEL") && authorIntent.equalsIgnoreCase("Correct Action");
    }

    private List<ProblemEdge> findDirectedPath(ProblemNode atNode, ProblemNode toNode) {
        List<Object> result = null;
        if (atNode.getOutDegree() < 1) {
            return null;
        }
        for (ProblemEdge outEdge : atNode.getOutgoingEdges()) {
            ProblemNode destNode = outEdge.getDest();
            result = destNode == toNode ? new LinkedList() : this.findDirectedPath(destNode, toNode);
            if (result == null) continue;
            result.add(0, outEdge);
            return result;
        }
        return null;
    }

    boolean checkDeleteProductionRule(ProblemNode thisNode) {
        return true;
    }

    public boolean isLeaf(ProblemNode thisNode) {
        return thisNode.getOutDegree() == 0;
    }

    public boolean checkNoParent(ProblemNode checkedNode) {
        return checkedNode.getInDegree() == 0;
    }

    boolean isEdgeInWillDeleteLinks(ProblemEdge testEdge) {
        int willDeleteLinksSize = this.getWillDeleteLinks().size();
        for (int i = 0; i < willDeleteLinksSize; ++i) {
            ProblemEdge tempEdge = (ProblemEdge)this.getWillDeleteLinks().elementAt(i);
            if (tempEdge != testEdge) continue;
            return true;
        }
        return false;
    }

    public List<ProblemEdge> makeDirectedPath(ProblemNode fromNode, ProblemNode toNode) {
        List<ProblemEdge> path = this.findDirectedPath(fromNode, toNode);
        if (trace.getDebugCode("pm")) {
            trace.out("pm", "checkDirectedPath(from " + fromNode + ", to " + toNode + ") found " + path);
        }
        return path;
    }

    public ExampleTracerPath makeSubpath(ProblemNode fromNode, ProblemNode toNode) {
        if (this.getController() == null || this.getController().getCtatModeModel().isExampleTracingMode()) {
            ExampleTracerGraph graph = this.getExampleTracerGraph();
            if (graph == null) {
                return null;
            }
            return graph.getBestSubpath(fromNode.getUniqueID(), toNode.getUniqueID());
        }
        List<ProblemEdge> edges = this.makeDirectedPath(fromNode, toNode);
        if (edges == null) {
            return null;
        }
        ExampleTracerGraph graph = this.getExampleTracerGraph();
        if (graph == null) {
            return null;
        }
        ExampleTracerPath result = new ExampleTracerPath();
        for (ProblemEdge edge : edges) {
            result.addLink(graph.getLink(edge));
        }
        return result;
    }

    public static Vector getNamedRules(Vector rules) {
        Vector<String> namedRules = new Vector<String>();
        for (String rule : rules) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "rule=" + rule + "; log=" + !"unnamed".equalsIgnoreCase(rule.trim()));
            }
            if ("unnamed".equalsIgnoreCase(rule.trim())) continue;
            namedRules.add(rule);
        }
        return namedRules;
    }

    public static boolean testEdgeInVector(ProblemEdge testEdge, Vector testedVector) {
        for (int i = 0; i < testedVector.size(); ++i) {
            ProblemEdge tempEdge = (ProblemEdge)testedVector.elementAt(i);
            if (testEdge != tempEdge) continue;
            return true;
        }
        return false;
    }

    public boolean testNodeInVector(ProblemNode testNode, Vector testedVector) {
        for (int i = 0; i < testedVector.size(); ++i) {
            ProblemNode tempNode = (ProblemNode)testedVector.elementAt(i);
            if (testNode != tempNode) continue;
            return true;
        }
        return false;
    }

    void addToRemoveLinkGroups(String addLinkGroupName) {
        for (int i = 0; i < this.getWillRemovedLinkGroups().size(); ++i) {
            String tempLinkName = (String)this.getWillRemovedLinkGroups().elementAt(i);
            if (!addLinkGroupName.equals(tempLinkName)) continue;
            return;
        }
        this.getWillRemovedLinkGroups().addElement(addLinkGroupName);
    }

    public static ProblemNode findParentNodeForDeletedNode(ProblemNode deletedNode, ProblemGraph problemGraph) {
        ProblemNode foundedNode = null;
        boolean hasPreferPathSet = false;
        Enumeration<ProblemEdge> iter = problemGraph.getConnectingEdges(deletedNode);
        while (iter.hasMoreElements() && !hasPreferPathSet) {
            ProblemEdge tempEdge = iter.nextElement();
            if (deletedNode == tempEdge.getNodes()[0]) continue;
            foundedNode = tempEdge.getNodes()[0];
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            if (!tempMyEdge.isPreferredEdge()) continue;
            hasPreferPathSet = true;
        }
        return foundedNode;
    }

    public ProblemEdge returnsEdge(ProblemNode sourceNode, ProblemNode destinateNode) {
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(sourceNode);
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            if (sourceNode != tempEdge.getNodes()[0] || destinateNode != tempEdge.getNodes()[1]) continue;
            return tempEdge;
        }
        return null;
    }

    public void findParentEdgesList(ProblemNode atNode, Vector parentEdgesList) {
        if (atNode == this.getStartNode()) {
            return;
        }
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(atNode);
        while (iter.hasMoreElements()) {
            ProblemEdge edgeTemp = iter.nextElement();
            if (edgeTemp.getNodes()[0] == atNode || ProblemModel.testEdgeInVector(edgeTemp, parentEdgesList)) continue;
            parentEdgesList.addElement(edgeTemp);
            this.findParentEdgesList(edgeTemp.getNodes()[0], parentEdgesList);
        }
    }

    public void findAncestorNodesListIgnoringLinkX(ProblemNode atNode, Vector<ProblemNode> ancestorNodesList, ProblemEdge linkX) {
        if (atNode == this.getStartNode()) {
            return;
        }
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(atNode);
        while (iter.hasMoreElements()) {
            ProblemNode tempNode;
            ProblemEdge tempEdge = iter.nextElement();
            if (tempEdge == linkX || (tempNode = tempEdge.getNodes()[0]) == atNode || this.testNodeInVector(tempNode, ancestorNodesList)) continue;
            ancestorNodesList.addElement(tempNode);
            this.findAncestorNodesListIgnoringLinkX(tempNode, ancestorNodesList, linkX);
        }
    }

    public void findAncestorNodesList(ProblemNode atNode, Vector ancestorNodesList) {
        if (atNode == this.getStartNode()) {
            return;
        }
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(atNode);
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            ProblemNode tempNode = tempEdge.getNodes()[0];
            if (tempNode == atNode || this.testNodeInVector(tempNode, ancestorNodesList)) continue;
            ancestorNodesList.addElement(tempNode);
            this.findAncestorNodesList(tempNode, ancestorNodesList);
        }
    }

    public static boolean containsEdge(Vector edgeList, ProblemEdge edge) {
        Enumeration enumeration = edgeList.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(edge)) continue;
            return true;
        }
        return false;
    }

    public boolean checkSameParentEdges(ProblemNode parentNode) {
        boolean hasPreferPathSet = false;
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getOutgoingEdges(parentNode);
        while (iter.hasMoreElements() && !hasPreferPathSet) {
            ProblemEdge tempEdge = iter.nextElement();
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            if (!tempMyEdge.isPreferredEdge()) continue;
            hasPreferPathSet = true;
        }
        return !hasPreferPathSet;
    }

    public String checkSameTripleSameAuthorIntent(Vector tripleGroups) {
        for (int i = 0; i < tripleGroups.size(); ++i) {
            Vector singleGroup = (Vector)tripleGroups.elementAt(i);
            String str = this.checkSingleGroupSameTripleSameAuthorIntent(singleGroup);
            if (str.length() == 0) continue;
            return str;
        }
        return "";
    }

    private String checkSingleGroupSameTripleSameAuthorIntent(Vector singleGroup) {
        for (int i = 0; i < singleGroup.size(); ++i) {
            ProblemEdge tempEdge1 = (ProblemEdge)singleGroup.elementAt(i);
            EdgeData tempMyEdge = tempEdge1.getEdgeData();
            String singleGroupAuthorIntent = tempMyEdge.getActionType();
            for (int j = 0; j < singleGroup.size(); ++j) {
                ProblemEdge tempEdge2;
                String tempAuthorIntent;
                if (i == j || singleGroupAuthorIntent.equalsIgnoreCase(tempAuthorIntent = (tempMyEdge = (tempEdge2 = (ProblemEdge)singleGroup.elementAt(j)).getEdgeData()).getActionType())) continue;
                ProblemNode sourceNode = tempEdge1.getNodes()[0];
                ProblemNode destinateNode = tempEdge1.getNodes()[1];
                String str = "The edge from the node '" + sourceNode.getNodeView().getText();
                str = str + "' to the node '" + destinateNode.getNodeView().getText() + "'";
                str = str + " has Author Intent '" + singleGroupAuthorIntent + "'.\n";
                sourceNode = tempEdge2.getNodes()[0];
                destinateNode = tempEdge2.getNodes()[1];
                str = str + "But the edge from the node '" + sourceNode.getNodeView().getText();
                str = str + "' to the node '" + destinateNode.getNodeView().getText() + "'";
                str = str + " has Author Intent '" + tempAuthorIntent + "'.\n";
                return str;
            }
        }
        return "";
    }

    public void addEdgeToTripleGroup(ProblemEdge addEdge, Vector tripleGroups) {
        EdgeData addMyEdge = addEdge.getEdgeData();
        for (int i = 0; i < tripleGroups.size(); ++i) {
            Vector singleGroup = (Vector)tripleGroups.elementAt(i);
            ProblemEdge tempEdge = (ProblemEdge)singleGroup.elementAt(0);
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            if (!this.compareTwoStatesSame(addMyEdge, tempMyEdge, true)) continue;
            singleGroup.addElement(addEdge);
            return;
        }
        Vector<ProblemEdge> newSingleGroup = new Vector<ProblemEdge>();
        newSingleGroup.addElement(addEdge);
        tripleGroups.addElement(newSingleGroup);
    }

    public boolean isBuggyNode(ProblemNode node) {
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getIncomingEdges(node);
        if (iter.hasMoreElements()) {
            while (iter.hasMoreElements()) {
                ProblemEdge tempEdge = iter.nextElement();
                if (!tempEdge.isCorrectorFireableBuggy()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canNodesBeMerged(ProblemNode target, ProblemNode source, BR_Controller controller) {
        int i;
        if (target == null || source == null) {
            return false;
        }
        if (target == source) {
            return false;
        }
        if (this.getStartNode() == source) {
            return false;
        }
        if (this.getStartNode() == target) {
            return false;
        }
        if (source.isDoneState() ^ target.isDoneState()) {
            return false;
        }
        if (source.isBuggyNode() ^ target.isBuggyNode()) {
            return false;
        }
        if (source.isDoneState() ^ target.isDoneState()) {
            return false;
        }
        if (source.isAncestorNode(target)) {
            return false;
        }
        if (target.isAncestorNode(source)) {
            return false;
        }
        Vector<ProblemNode> targetChildren = target.getChildren();
        Vector<ProblemNode> sourceChildren = source.getChildren();
        for (i = 0; i < targetChildren.size(); ++i) {
            if (!sourceChildren.contains(targetChildren.get(i))) continue;
            return false;
        }
        Vector targetParents = target.getParents();
        Vector sourceParents = source.getParents();
        for (i = 0; i < targetParents.size(); ++i) {
            if (!sourceParents.contains(targetParents.get(i))) continue;
            return false;
        }
        return true;
    }

    public String checkSecondaryEffects(ProblemEdge parentEdge) {
        String effectText = "";
        ProblemNode childTemp = parentEdge.getNodes()[1];
        EdgeData myEdge = parentEdge.getEdgeData();
        String secondaryTextGood = "    Because arc " + myEdge.getUniqueID() + " is now consistent you have discovered the following good things:\n";
        String secondaryTextBad = " Because arc " + myEdge.getUniqueID() + " is now consistent you have discovered the following new bad problems:\n";
        boolean goodFlag = false;
        boolean badFlag = false;
        Enumeration<ProblemEdge> iterOutEdge = this.getProblemGraph().getOutgoingEdges(childTemp);
        while (iterOutEdge.hasMoreElements()) {
            ProblemEdge edge = iterOutEdge.nextElement();
            if (this.edgeLispChecked(edge)) continue;
            this.getCheckAllEdges().addElement(edge);
            myEdge = edge.getEdgeData();
            if (!myEdge.getPreLispCheckLabel().preCheckedStatus.equalsIgnoreCase("No-Applicable")) continue;
            if (this.checkConsistency(myEdge.getCheckedStatus(), myEdge.getActionType())) {
                goodFlag = true;
                secondaryTextGood = secondaryTextGood + "    Arc " + myEdge.getUniqueID() + " that used to be " + myEdge.getPreLispCheckLabel().preCheckedStatus + " is now consistent\n";
                continue;
            }
            badFlag = true;
            secondaryTextBad = secondaryTextBad + "  Arc " + myEdge.getUniqueID() + " that used to be " + myEdge.getPreLispCheckLabel().preCheckedStatus + " in now inconsistent\n";
        }
        if (goodFlag) {
            effectText = secondaryTextGood;
        }
        if (badFlag) {
            effectText = effectText + secondaryTextBad;
        }
        return effectText;
    }

    public ProblemNode getProblemNodeForNodeView(NodeView Vertex) {
        return ProblemModel.getNodeForVertexUniqueID(Vertex.getUniqueID(), this.problemGraph);
    }

    public static ProblemNode getNodeForVertexUniqueID(int verTexUniqueID, ProblemGraph problemGraph) {
        Enumeration<ProblemNode> iter = problemGraph.nodes();
        while (iter.hasMoreElements()) {
            ProblemNode node = iter.nextElement();
            if (node.getUniqueID() != verTexUniqueID) continue;
            return node;
        }
        return null;
    }

    public ProblemEdge getEdgeForESE_Label(ActionLabel ese_label) {
        return this.getEdge(ese_label.getUniqueID());
    }

    public ProblemEdge getEdge(int uniqueID) {
        Enumeration<ProblemEdge> iter = this.getProblemGraph().edges();
        while (iter.hasMoreElements()) {
            ProblemEdge edge = iter.nextElement();
            EdgeData myEdge = edge.getEdgeData();
            if (myEdge.getUniqueID() != uniqueID) continue;
            return edge;
        }
        return null;
    }

    public Vector findSameStates(ProblemNode currNodeP, Vector selectionP, Vector actionP, Vector inputP) {
        Vector findMatchNodes = new Vector();
        Vector matchedEdges = this.findSameTripleEdges(selectionP, actionP, inputP);
        int sizeOfMatchedEdges = matchedEdges.size();
        if (sizeOfMatchedEdges == 0) {
            return findMatchNodes;
        }
        Vector correctEdgesListCurr = new Vector();
        this.findEdgesList(currNodeP, correctEdgesListCurr, (ProblemEdge)matchedEdges.elementAt(0));
        int sizeOfCurr = correctEdgesListCurr.size();
        for (int i = 0; i < sizeOfMatchedEdges; ++i) {
            ProblemEdge valuesMatchedEdge = (ProblemEdge)matchedEdges.elementAt(i);
            boolean noMatchEdgeFlag = false;
            Vector correctEdgesListMatch = new Vector();
            this.findEdgesList(valuesMatchedEdge.getNodes()[0], correctEdgesListMatch, valuesMatchedEdge);
            int sizeOfMatch = correctEdgesListMatch.size();
            if (sizeOfMatch > sizeOfCurr) continue;
            Vector correctEdgesListCurrCopy = (Vector)correctEdgesListCurr.clone();
            for (int j = 0; !noMatchEdgeFlag && j < sizeOfMatch; ++j) {
                ProblemEdge tempEdge = (ProblemEdge)correctEdgesListMatch.elementAt(j);
                if (this.findMatchEdgeAndUpdateList(tempEdge, correctEdgesListCurrCopy)) continue;
                noMatchEdgeFlag = !this.testInList(tempEdge, correctEdgesListCurrCopy);
            }
            if (noMatchEdgeFlag) continue;
            if (correctEdgesListCurrCopy.size() == 0) {
                this.addNodeToMatchedNodes(valuesMatchedEdge.getNodes()[1], findMatchNodes);
                continue;
            }
            this.findMatchedStateNode(valuesMatchedEdge.getNodes()[1], correctEdgesListCurrCopy, findMatchNodes);
        }
        return findMatchNodes;
    }

    boolean testInList(ProblemEdge atEdge, Vector edgesList) {
        EdgeData tempMyAtEdge = atEdge.getEdgeData();
        int sizeOfEdgesList = edgesList.size();
        for (int i = 0; i < sizeOfEdgesList; ++i) {
            ProblemEdge tempEdge = (ProblemEdge)edgesList.elementAt(i);
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            if (!this.compareTwoStatesSame(tempMyAtEdge, tempMyEdge, false)) continue;
            return true;
        }
        return false;
    }

    void addNodeToMatchedNodes(ProblemNode atNode, Vector findMatchNodes) {
        boolean noDuplicateFlag = true;
        int sizeOfFindMatchNodes = findMatchNodes.size();
        for (int i = 0; i < sizeOfFindMatchNodes; ++i) {
            ProblemNode tempNode = (ProblemNode)findMatchNodes.elementAt(i);
            if (tempNode != atNode) continue;
            noDuplicateFlag = false;
            break;
        }
        if (noDuplicateFlag) {
            findMatchNodes.addElement(atNode);
        }
    }

    boolean findMatchEdgeAndUpdateList(ProblemEdge atEdge, Vector correctEdgesListCurrCopy) {
        EdgeData myEdge1 = atEdge.getEdgeData();
        int sizeOfCurr = correctEdgesListCurrCopy.size();
        for (int i = 0; i < sizeOfCurr; ++i) {
            ProblemEdge tempEdge = (ProblemEdge)correctEdgesListCurrCopy.elementAt(i);
            EdgeData myEdge2 = tempEdge.getEdgeData();
            if (!this.compareTwoStatesSame(myEdge1, myEdge2, true)) continue;
            correctEdgesListCurrCopy.removeElement(tempEdge);
            return true;
        }
        return false;
    }

    public String testNewDestNodeForLink(ProblemEdge problemEdge, ProblemNode newChildNode) {
        ProblemNode parentNode = problemEdge.getSource();
        ProblemNode childNode = problemEdge.getDest();
        if (newChildNode.equals(problemEdge.getDest())) {
            return "ignore";
        }
        if (parentNode.equals(newChildNode)) {
            return "You cannot set the destination to be the same as the source. Drag the link to a different state.\n";
        }
        if (childNode.isDoneState() && !newChildNode.isDoneState()) {
            return "The graph cannot accept done steps going to states other than done-states.\n";
        }
        if (newChildNode.isDoneState() && !problemEdge.getEdgeData().isDone()) {
            return "Only steps whose selection and action are \"Done ButtonPressed\" may go to a done-state.\n";
        }
        boolean oldChildBuggy = childNode.isBuggyNode();
        boolean newChildBuggy = newChildNode.isBuggyNode();
        if (oldChildBuggy && !newChildNode.isLeaf()) {
            return "You cannot have a buggy link lead to a state that has outgoing edges.\n";
        }
        if (newChildBuggy && !oldChildBuggy) {
            return "You cannot have a state with incoming correct and incorrect links.\n";
        }
        if (oldChildBuggy & !newChildBuggy && newChildNode.getInDegree() > 0 && newChildNode.getOutDegree() == 0) {
            return "You cannot have a state with incoming correct and incorrect links.\n";
        }
        if (this.getProblemGraph().doesEdgeExist(parentNode, newChildNode)) {
            return "There already exists an edge between " + parentNode.getName() + " and " + newChildNode.getName() + ". Drag the link to a different state.\n";
        }
        Vector<ProblemNode> ancestorNodesList = new Vector<ProblemNode>();
        this.findAncestorNodesListIgnoringLinkX(parentNode, ancestorNodesList, problemEdge);
        if (newChildNode.getProblemModel().testNodeInVector(newChildNode, ancestorNodesList)) {
            return "Changing the destination of " + problemEdge.getEdgeData().getName() + " to " + newChildNode.getName() + " would create a cycle in the graph. Drag the link to a different state.\n";
        }
        return null;
    }

    public String testNewSourceNodeForLink(ProblemEdge problemEdge, ProblemNode newSourceNode) {
        ProblemNode childNode = problemEdge.getDest();
        if (newSourceNode.equals(problemEdge.getSource())) {
            return "ignore";
        }
        if (childNode.equals(newSourceNode)) {
            return "You cannot set the source to be the same as the destination. Drag the link to a different state.\n";
        }
        if (newSourceNode.isDoneState()) {
            return "You cannot have the source of a link be a done state. Drag the link to a different state.\n";
        }
        if (newSourceNode.isBuggyNode()) {
            return "You cannot have the source of a link be a buggy state. Drag the link to a different state.\n";
        }
        if (this.getProblemGraph().doesEdgeExist(newSourceNode, childNode)) {
            return "There already exists an edge between " + newSourceNode.getName() + " and " + childNode.getName() + ". Drag the link to a different state.\n";
        }
        Vector<ProblemNode> ancestorNodesList = new Vector<ProblemNode>();
        this.findAncestorNodesListIgnoringLinkX(newSourceNode, ancestorNodesList, problemEdge);
        if (newSourceNode.getProblemModel().testNodeInVector(childNode, ancestorNodesList)) {
            return "Changing the source of " + problemEdge.getEdgeData().getName() + " to " + newSourceNode.getName() + " would create a cycle in the graph. Drag the link to a different state.\n";
        }
        return null;
    }

    void findMatchedStateNode(ProblemNode atNode, Vector correctEdgesListCurrCopy, Vector findMatchNodes) {
        if (correctEdgesListCurrCopy.size() == 0) {
            return;
        }
        Enumeration<ProblemEdge> iterOutEdge = this.getProblemGraph().getOutgoingEdges(atNode);
        while (iterOutEdge.hasMoreElements()) {
            ProblemEdge tempEdge = iterOutEdge.nextElement();
            EdgeData myEdge = tempEdge.getEdgeData();
            if (myEdge.getActionType().equalsIgnoreCase("Correct Action")) {
                Vector correctEdgesListCurrP = (Vector)correctEdgesListCurrCopy.clone();
                if (this.findMatchEdgeAndUpdateList(tempEdge, correctEdgesListCurrP)) {
                    if (correctEdgesListCurrP.size() == 0) {
                        this.addNodeToMatchedNodes(tempEdge.getNodes()[1], findMatchNodes);
                        continue;
                    }
                    this.findMatchedStateNode(tempEdge.getNodes()[1], correctEdgesListCurrP, findMatchNodes);
                    continue;
                }
                if (!this.testInList(tempEdge, correctEdgesListCurrP)) continue;
                this.findMatchedStateNode(tempEdge.getNodes()[1], correctEdgesListCurrP, findMatchNodes);
                continue;
            }
            this.findMatchedStateNode(tempEdge.getNodes()[1], correctEdgesListCurrCopy, findMatchNodes);
        }
    }

    public ProblemEdge findMatchSAIChildEdge(ProblemNode atNode, ProblemEdge edgeTest) {
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getOutgoingEdges(atNode);
        while (iter.hasMoreElements()) {
            ProblemEdge edgeTemp = iter.nextElement();
            if (!this.compareTwoStatesSame(edgeTemp, edgeTest, true)) continue;
            return edgeTemp;
        }
        return null;
    }

    void findEdgesList(ProblemNode atNode, Vector correctEdgesList, ProblemEdge matchedStateEdge) {
        if (atNode == this.getStartNode()) {
            return;
        }
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(atNode);
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            if (tempEdge.getNodes()[0] == atNode) continue;
            if (!this.testSameStateEdges(matchedStateEdge, tempEdge)) {
                this.addToList(correctEdgesList, tempEdge);
            }
            this.findEdgesList(tempEdge.getNodes()[0], correctEdgesList, matchedStateEdge);
            return;
        }
    }

    boolean testSameStateEdges(ProblemEdge edge1, ProblemEdge edge2) {
        EdgeData myEdge1 = edge1.getEdgeData();
        EdgeData myEdge2 = edge2.getEdgeData();
        String tempSelectionName1 = myEdge1.getSelection().toString();
        String tempSelectionName2 = myEdge2.getSelection().toString();
        String tempActionName1 = myEdge1.getAction().toString();
        String tempActionName2 = myEdge2.getAction().toString();
        return tempSelectionName1.equalsIgnoreCase(tempSelectionName2) && tempActionName1.equalsIgnoreCase(tempActionName2);
    }

    void addToList(Vector addToEdgesList, ProblemEdge addedEdge) {
        int addToEdgesListSize = addToEdgesList.size();
        boolean flag = true;
        for (int i = 0; flag && i < addToEdgesListSize; ++i) {
            ProblemEdge tempEdge = (ProblemEdge)addToEdgesList.elementAt(i);
            if (!this.testSameStateEdges(addedEdge, tempEdge)) continue;
            flag = false;
        }
        if (flag) {
            addToEdgesList.addElement(addedEdge);
        }
    }

    Vector findSameTripleEdges(ProblemEdge atEdge) {
        if (atEdge == null) {
            return null;
        }
        EdgeData atMyEdge = atEdge.getEdgeData();
        return this.findSameTripleEdges(atMyEdge.getSelection(), atMyEdge.getAction(), atMyEdge.getInput());
    }

    public Vector findSameTripleEdges(Vector selectionP, Vector actionP, Vector inputP) {
        Vector<ProblemEdge> matchedEdges = new Vector<ProblemEdge>();
        Enumeration<ProblemEdge> iter = this.getProblemGraph().edges();
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            EdgeData myEdge = tempEdge.getEdgeData();
            if (!this.matchStates(myEdge, selectionP, actionP, inputP)) continue;
            matchedEdges.addElement(tempEdge);
        }
        return matchedEdges;
    }

    public Vector findSameProductionSetsEdge(String ruleLabelText) {
        Vector<ProblemEdge> matchedEdges = new Vector<ProblemEdge>();
        Enumeration<ProblemEdge> iter = this.getProblemGraph().edges();
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            int tempNumberOfRules = tempMyEdge.getRuleLabels().size();
            boolean continueFlag = true;
            for (int i = 0; i < tempNumberOfRules && continueFlag; ++i) {
                RuleLabel tempRuleLabel = tempMyEdge.getRuleLabels().elementAt(i);
                if (!tempRuleLabel.isNameSet()) continue;
                if (tempRuleLabel.getText().equals(ruleLabelText)) {
                    matchedEdges.addElement(tempEdge);
                }
                continueFlag = false;
            }
        }
        return matchedEdges;
    }

    public ProblemNode findSameChildState(ProblemNode currNode, Vector selectionP, Vector actionP, Vector inputP) {
        Enumeration<ProblemEdge> iter = this.getProblemGraph().getConnectingEdges(currNode);
        while (iter.hasMoreElements()) {
            ProblemEdge edgeTemp = iter.nextElement();
            EdgeData myEdge = edgeTemp.getEdgeData();
            ProblemNode nodeTemp = edgeTemp.getNodes()[1];
            if (nodeTemp == currNode || !this.matchStates(myEdge, selectionP, actionP, inputP)) continue;
            return nodeTemp;
        }
        return null;
    }

    public ProblemEdge findMatchingEdge(Vector selection, Vector action, Vector input, ProblemNode node) {
        return this.findMatchingEdge(selection, action, input, "Student", node);
    }

    public ProblemEdge findMatchingEdge(Vector selection, Vector action, Vector input, String actor, ProblemNode node) {
        ProblemEdge tempEdge;
        ProblemEdge matchedEdge = null;
        Enumeration<ProblemEdge> iterEdges = this.getProblemGraph().getOutgoingEdges(node);
        while (iterEdges.hasMoreElements()) {
            tempEdge = iterEdges.nextElement();
            if (!this.matchStates(tempEdge, selection, action, input, actor) || !tempEdge.isCorrect() || !(matchedEdge = tempEdge).isPreferredEdge()) continue;
            return matchedEdge;
        }
        if (matchedEdge != null) {
            return matchedEdge;
        }
        iterEdges = this.getProblemGraph().getOutgoingEdges(node);
        while (iterEdges.hasMoreElements()) {
            tempEdge = iterEdges.nextElement();
            if (!this.matchStates(tempEdge, selection, action, input, actor) || !(matchedEdge = tempEdge).isCorrectorFireableBuggy()) continue;
            return matchedEdge;
        }
        return matchedEdge;
    }

    public boolean compareTwoStatesSame(ProblemEdge edge1, ProblemEdge edge2, boolean compareInputFlag) {
        if (edge1 == null || edge2 == null) {
            return false;
        }
        EdgeData myEdge1 = edge1.getEdgeData();
        EdgeData myEdge2 = edge2.getEdgeData();
        if (myEdge1 == null || myEdge2 == null) {
            return false;
        }
        return this.compareTwoStatesSame(myEdge1, myEdge2, compareInputFlag);
    }

    public boolean compareTwoStatesSame(EdgeData myEdge1, EdgeData myEdge2, boolean compareInputFlag) {
        boolean inputCompare;
        Vector selection2 = myEdge2.getSelection();
        Vector action2 = myEdge2.getAction();
        Vector input2 = myEdge2.getInput();
        if (compareInputFlag && !(inputCompare = this.isCaseInsensitive() ? myEdge1.getInput().toString().equalsIgnoreCase(input2.toString()) : myEdge1.getInput().toString().equals(input2.toString()))) {
            return false;
        }
        return myEdge1.getSelection().toString().equalsIgnoreCase(selection2.toString()) && myEdge1.getAction().toString().equalsIgnoreCase(action2.toString());
    }

    public boolean matchStates(ProblemEdge atEdge, Vector selectionP, Vector actionP, Vector inputP) {
        EdgeData edge = atEdge.getEdgeData();
        return this.matchStates(edge, selectionP, actionP, inputP, "Student");
    }

    public boolean matchStates(ProblemEdge atEdge, Vector selectionP, Vector actionP, Vector inputP, String actor) {
        EdgeData edge = atEdge.getEdgeData();
        return this.matchStates(edge, selectionP, actionP, inputP, actor);
    }

    public boolean matchStates(EdgeData edge, Vector selectionP, Vector actionP, Vector inputP) {
        return this.matchStates(edge, selectionP, actionP, inputP, "Student");
    }

    public boolean matchStates(EdgeData edge, Vector selectionP, Vector actionP, Vector inputP, String actorP) {
        edge.getMatcher().setUseAlgebraicEquivalence(this.isUseCommWidgetFlag());
        edge.getMatcher().setCaseInsensitive(this.isCaseInsensitive());
        if (trace.getDebugCode("lispcheckresult")) {
            trace.out("lispcheckresult", "MATCH STATES: case insensitive = " + this.isCaseInsensitive() + " input = " + inputP + " matcher input = " + edge.getMatcher().getInput());
        }
        boolean match = false;
        match = edge.getMatcher().getMatcherType().equals("Exact Match") ? edge.getMatcher().match(selectionP, actionP, inputP, actorP) : edge.getMatcher().match(selectionP, actionP, inputP);
        return match;
    }

    public void setStartNodeCreatedFlag(boolean startNodeCreatedFlag) {
        this.startNodeCreatedFlag = startNodeCreatedFlag;
    }

    public boolean getStartNodeCreatedFlag() {
        return this.startNodeCreatedFlag;
    }

    public void setStartNodeMessageVector(Vector startNodeMessageVector) {
        this.startNodeMessageVector = new ArrayList<MessageObject>(startNodeMessageVector);
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "SETTING START STATE vector; size " + (startNodeMessageVector == null ? -1 : startNodeMessageVector.size()));
        }
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SETTING START STATE vector; size " + (startNodeMessageVector == null ? -1 : startNodeMessageVector.size()));
        }
    }

    public void appendStartNodeMessage(MessageObject o) {
        List<MessageObject> snmv = this.getStartNodeMessageVector();
        if (snmv == null) {
            this.setStartNodeMessageVector(new Vector());
            snmv = this.getStartNodeMessageVector();
        }
        for (int i = snmv.size() - 1; i >= 0; --i) {
            MessageObject oi = snmv.get(i);
            if (oi == null || !"StartStateEnd".equalsIgnoreCase(oi.getMessageType())) continue;
            snmv.add(i, o);
            return;
        }
        snmv.add(o);
    }

    public Iterator<MessageObject> startNodeMessagesIterator() {
        Iterator<MessageObject> result;
        if (this.getController() != null && this.getController().getUniversalToolProxy() != null && (result = this.getController().getUniversalToolProxy().startNodeMessagesIterator(this)) != null) {
            return result;
        }
        return this.startNodeMessagesIteratorForStartStateModel();
    }

    public Iterator<MessageObject> startNodeMessagesIteratorForStartStateModel() {
        if (this.getStartNodeMessageVector() == null) {
            return EmptyIterator.instance();
        }
        return this.getStartNodeMessageVector().iterator();
    }

    private List<MessageObject> getStartNodeMessageVector() {
        return this.startNodeMessageVector;
    }

    public void addStartNodeMessage(MessageObject message) {
        if (this.getStartNodeMessageVector() != null) {
            this.getStartNodeMessageVector().add(message);
        }
    }

    public void setCheckAllEdges(Vector checkAllEdges) {
        this.checkAllEdges = checkAllEdges;
    }

    public Vector getCheckAllEdges() {
        return this.checkAllEdges;
    }

    public void setCheckAllNodes(Vector checkAllNodes) {
        this.checkAllNodes = checkAllNodes;
    }

    public Vector getCheckAllNodes() {
        return this.checkAllNodes;
    }

    public void setProblemName(String problemName) {
        this.problemName = problemName;
        if (problemName != null && problemName.length() > 0) {
            this.problemSummary = new ProblemSummary(problemName, null, this.getSuppressStudentFeedback().gradeLastStepAttempt());
        }
    }

    public String getProblemName() {
        return this.problemName;
    }

    public void setProblemFullName(String problemFullName) {
        this.problemFullName = problemFullName;
    }

    public String getProblemFullName() {
        return this.problemFullName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
        this.controller.getLogger().setCourseName(courseName);
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
        this.controller.getLogger().setUnitName(unitName);
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
        this.controller.getLogger().setSectionName(sectionName);
    }

    public String getCourseName() {
        return this.courseName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setStartNode(ProblemNode startNode) {
        this.startNode = startNode;
        this.studentSAIs = null;
        this.clearStudentSAIs();
    }

    public ProblemNode getStartNode() {
        return this.startNode;
    }

    public GroupEditorContext getEditContext() {
        return this.editContext;
    }

    public ProblemNode getNode(String name) {
        return this.getProblemGraph().getNode(name);
    }

    public ProblemNode getProblemNode(int nodeID) {
        ExampleTracerNode etnode = this.getExampleTracerGraph().getNode(nodeID);
        if (etnode == null) {
            return null;
        }
        return etnode.getProblemNode();
    }

    public void setProblemGraph(ProblemGraph problemGraph) {
        this.problemGraph = problemGraph;
    }

    public ProblemGraph getProblemGraph() {
        return this.problemGraph;
    }

    public boolean getLockWidget() {
        return this.isLockWidget();
    }

    public void setLockWidget(boolean lockWidget) {
        this.lockWidget = lockWidget;
    }

    public boolean isLockWidget() {
        return this.lockWidget;
    }

    public void setHintPolicy(HintPolicyEnum policy) {
        this.hintPolicy = policy;
    }

    public HintPolicyEnum getHintPolicy() {
        return this.hintPolicy;
    }

    public boolean areHintsBiasedByPriorError() {
        return this.hintPolicy.isBiasedByPriorError();
    }

    public boolean areHintsBiasedByCurrentSelection() {
        return this.hintPolicy.isBiasedByCurrentSelection();
    }

    public ExampleTracerGraph getExampleTracerGraph() {
        Boolean isUnordered;
        Boolean bl = isUnordered = this.controller == null ? Boolean.FALSE : this.controller.getPreferencesModel().getBooleanValue("Commutativity");
        if (this.exampleTracerGraph == null) {
            this.exampleTracerGraph = new ExampleTracerGraph(isUnordered == null ? false : isUnordered, false);
        }
        return this.exampleTracerGraph;
    }

    public void setAllowToolMode(boolean toolMode) {
        this.controller.getPreferencesModel().setBooleanValue("Allow Tool-Performed Actions", new Boolean(toolMode));
    }

    public void setMaxStudents(int num) {
        this.controller.getPreferencesModel().setIntegerValue("Maximum Number of Student Actors", num);
    }

    public boolean isUnorderedMode() {
        return !this.getExampleTracerGraph().getGroupModel().isGroupOrdered(this.getExampleTracerGraph().getGroupModel().getTopLevelGroup());
    }

    public void setLinksGroups(Vector linksGroups) {
        this.linksGroups = linksGroups;
    }

    public void setWillDeleteLinks(Vector willDeleteLinks) {
        this.willDeleteLinks = willDeleteLinks;
    }

    public Vector getWillDeleteLinks() {
        return this.willDeleteLinks;
    }

    public void setWillRemovedLinkGroups(Vector willRemovedLinkGroups) {
        this.willRemovedLinkGroups = willRemovedLinkGroups;
    }

    public Vector getWillRemovedLinkGroups() {
        return this.willRemovedLinkGroups;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setUseCommWidgetFlag(boolean useCommWidgetFlag) {
        this.useCommWidgetFlag = useCommWidgetFlag;
    }

    public boolean isUseCommWidgetFlag() {
        return this.useCommWidgetFlag;
    }

    static void printoutESEGraph(Vector ESEGraph) {
        int nodesNum = ESEGraph.size();
        trace.out("Ese-Graph size: " + nodesNum);
        if (nodesNum > 0) {
            for (int i = 0; i < nodesNum; ++i) {
                Vector parentChildList = (Vector)ESEGraph.elementAt(i);
                Vector childrenList = parentChildList.size() > 1 ? (Vector)parentChildList.elementAt(1) : new Vector();
                int childrenNum = childrenList.size();
                if (trace.getDebugCode("test")) {
                    trace.out("test", "ZZZ node " + (String)parentChildList.elementAt(0) + " has " + childrenNum + " children: ");
                }
                for (int j = 0; j < childrenNum; ++j) {
                    Vector childNode = (Vector)childrenList.elementAt(j);
                    if (trace.getDebugCode("test")) {
                        trace.out("test", "Node: " + (String)childNode.elementAt(0));
                    }
                    Integer uniqeID = (Integer)childNode.elementAt(1);
                    trace.out("UniqeID: " + uniqeID);
                    if (trace.getDebugCode("test")) {
                        trace.out("test", "AuthorIntent: " + (String)childNode.elementAt(2));
                    }
                    Vector tempVector = (Vector)childNode.elementAt(3);
                    trace.out("Selection: " + tempVector.toString());
                    tempVector = (Vector)childNode.elementAt(4);
                    trace.out("Action: " + tempVector.toString());
                    tempVector = (Vector)childNode.elementAt(5);
                    trace.out("Input: " + tempVector.toString());
                }
                trace.out("XXXXXXXXXXXXXXXXXXXXXX");
            }
        } else {
            trace.out("No Problem Graph is built yet.");
        }
    }

    public void setProblemLoadedFromLispTutor(boolean problemLoadedFromLispTutor) {
        this.problemLoadedFromLispTutor = problemLoadedFromLispTutor;
    }

    public boolean isProblemLoadedFromLispTutor() {
        return this.problemLoadedFromLispTutor;
    }

    public void setSearchPathFlag(boolean searchPathFlag) {
        this.searchPathFlag = searchPathFlag;
    }

    public boolean isSearchPathFlag() {
        return this.searchPathFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProblemModelListener(ProblemModelListener l) {
        boolean result = false;
        HashSet<ProblemModelListener> hashSet = this.listeners;
        synchronized (hashSet) {
            result = this.listeners.add(l);
        }
        if (trace.getDebugCode("pmevt")) {
            trace.out("pmevt", "PM.addProblemModelListener(" + trace.nh(l) + ") result " + result + ", size " + this.listeners.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProblemModelListener(ProblemModelListener l) {
        HashSet<ProblemModelListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProblemModelEvent(ProblemModelEvent e) {
        this.fireCount = (this.fireCount / 100 + 1) * 100;
        if (this.listeners == null) {
            return;
        }
        ProblemModelListener[] copyOfListeners = null;
        ProblemModelListener[] problemModelListenerArray = this.listeners;
        synchronized (this.listeners) {
            try {
                copyOfListeners = new ProblemModelListener[this.listeners.size()];
                this.listeners.toArray(copyOfListeners);
            }
            catch (ConcurrentModificationException cme) {
                trace.errStack("Continuing after error while firing ProblemModelEvent(" + e + ")", cme);
            }
            for (ProblemModelListener listener : copyOfListeners) {
                if (trace.getDebugCode("pmevt")) {
                    trace.out("pmevt", String.format("fireProblemModelEvent[%5d]: %s", ++this.fireCount, trace.nh(listener)));
                }
                listener.problemModelEventOccurred(e);
            }
            return;
        }
    }

    public void removeNode(ProblemNode thisNode, boolean fireEvent) {
        this.problemGraph.removeNode(thisNode);
        trace.out("XXXX remove node !!!");
        if (fireEvent) {
            NodeDeletedEvent e = new NodeDeletedEvent(thisNode);
            this.fireProblemModelEvent(e);
        }
    }

    public void reset(String problemName, String problemFullName) {
        this.init(null);
        this.setProblemName(problemName);
        this.setProblemFullName(problemFullName);
    }

    public void setVariableTable(VariableTable vt) {
        if (trace.getDebugCode("vt")) {
            trace.outNT("vt", "ProblemModel.setVariableTable() oldVT = VariableTable #" + (this.variableTable == null ? "null" : Integer.valueOf(this.variableTable.getInstance())) + " newVT = VariableTable #" + (vt == null ? "null" : Integer.valueOf(vt.getInstance())));
        }
        VariableTable vtOld = this.variableTable;
        this.variableTable = vt;
        this.getCtatFunctions().setVariableTable(vt);
        VariableTableChangeEvent vtChange = new VariableTableChangeEvent(this, "VariableTable", vtOld, this.variableTable);
        this.fireProblemModelEvent(vtChange);
    }

    public VariableTable getVariableTable() {
        return this.variableTable;
    }

    public Object assignVariable(String key, Object value) {
        ExampleTracerTracer tracer;
        VariableTable variableTable;
        if (trace.getDebugCode("vt")) {
            trace.outNT("vt", "PM.assignVariable(" + key + ") PM.variableTable #" + this.variableTable.getInstance() + ", PM.getVariableTable() #" + this.getVariableTable().getInstance());
        }
        if ((variableTable = this.getVariableTable()) == null || key == null) {
            return null;
        }
        Object result = variableTable.put(key, value);
        ExampleTracerTracer exampleTracerTracer = tracer = this.getExampleTracerGraph() == null ? null : this.getExampleTracerGraph().getExampleTracer();
        if (tracer != null) {
            tracer.assignVariable(key, value);
        }
        return result;
    }

    public int getNodeCount() {
        return this.problemGraph.getNodeCount();
    }

    public int getEdgeCount() {
        return this.problemGraph.getEdgeCount();
    }

    public Vector<ProblemEdge> findPathForProblemSkillsMatrix(ProblemNode atNode) {
        Vector<ProblemEdge> pathEdges = new Vector<ProblemEdge>();
        this.findPathForProblemSkillsMatrix(atNode, pathEdges);
        return pathEdges;
    }

    private void findPathForProblemSkillsMatrix(ProblemNode atNode, Vector<ProblemEdge> pathEdges) {
        if (atNode == null) {
            return;
        }
        ProblemGraph problemDGraph = this.getProblemGraph();
        Enumeration<ProblemEdge> iterEdges = problemDGraph.getOutgoingEdges(atNode);
        if (!iterEdges.hasMoreElements()) {
            return;
        }
        ProblemEdge foundEdge = null;
        while (iterEdges.hasMoreElements()) {
            ProblemEdge tempEdge = iterEdges.nextElement();
            EdgeData myEdge = tempEdge.getEdgeData();
            if (myEdge.isPreferredEdge()) {
                pathEdges.addElement(tempEdge);
                this.findPathForProblemSkillsMatrix(tempEdge.getNodes()[1], pathEdges);
                return;
            }
            if (myEdge.getActionType().equalsIgnoreCase("Correct Action")) {
                foundEdge = tempEdge;
                continue;
            }
            if (!myEdge.getActionType().equalsIgnoreCase("Fireable Buggy Action") || foundEdge != null) continue;
            foundEdge = tempEdge;
        }
        if (foundEdge != null) {
            this.findPathForProblemSkillsMatrix(foundEdge.getNodes()[1], pathEdges);
        }
    }

    public void setSuppressStudentFeedback(FeedbackEnum suppressFeedback) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "set suppress feedback: " + (Object)((Object)suppressFeedback));
        }
        this.getExampleTracerGraph().setFeedback(suppressFeedback);
    }

    public FeedbackEnum getSuppressStudentFeedback() {
        return this.getExampleTracerGraph().getFeedback();
    }

    public BR_Controller getController() {
        return this.controller;
    }

    public Parser getFormulaParser() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getFormulaParser();
    }

    public boolean isFirstNode() {
        return this.firstNode;
    }

    void setFirstNode(boolean firstNode) {
        this.firstNode = firstNode;
    }

    public int getEdgeUniqueIDGenerator() {
        return this.edgeUniqueIDGenerator;
    }

    public int getNodeUniqueIDGenerator() {
        return this.nodeUniqueIDGenerator;
    }

    public void updateEdgeUniqueIDGenerator(int uniqueID) {
        this.edgeUniqueIDGenerator = Math.max(uniqueID, this.edgeUniqueIDGenerator);
    }

    public void updateNodeUniqueIDGenerator(int uniqueID) {
        this.nodeUniqueIDGenerator = Math.max(uniqueID, this.nodeUniqueIDGenerator);
    }

    public int getNextEdgeUniqueIDGenerator() {
        ++this.edgeUniqueIDGenerator;
        return this.edgeUniqueIDGenerator;
    }

    public boolean getHighlightRightSelection() {
        return this.highlightRightSelection;
    }

    public void setHighlightRightSelection(boolean highlightRightSelection) {
        this.highlightRightSelection = highlightRightSelection;
    }

    public static boolean interpolatable(MessageObject mo) {
        if (mo == null) {
            return false;
        }
        try {
            for (Object pv : mo.getPropertyValues()) {
                if (pv instanceof Vector) {
                    for (Object value : (Vector)pv) {
                        if (value == null || !CTATFunctions.interpolatable(value.toString())) continue;
                        return true;
                    }
                    continue;
                }
                if (pv == null || !CTATFunctions.interpolatable(pv.toString())) continue;
                return true;
            }
        }
        catch (Exception de) {
            trace.err("Error getting PROPERTYVALUES: " + de + ". MessageObject was:\n" + mo);
            return false;
        }
        return false;
    }

    public String nextDoneName() {
        ProblemGraph graph = this.getProblemGraph();
        if (graph == null) {
            return "Done";
        }
        return graph.nextDoneName();
    }

    public static MessageObject makeEmptyProblemSummaryResponse(String dummyProblemName) {
        return ProblemModel.handleProblemSummaryRequest(new ProblemSummary(dummyProblemName, null, false));
    }

    public ProblemSummary getProblemSummary() {
        String problemName;
        if (this.problemSummary == null && ((problemName = this.getProblemName()) == null || problemName.length() < 1)) {
            problemName = "NoProblemDefined";
            this.problemSummary = new ProblemSummary(problemName, null, this.getSuppressStudentFeedback().gradeLastStepAttempt());
        }
        if (trace.getDebugCode("skills")) {
            trace.outNT("skills", "getProblemSummary().getSkills() pre  " + (this.problemSummary.getSkills() == null ? null : this.problemSummary.getSkills().getAllSkills()));
        }
        if (this.problemSummary.getSkills() == null) {
            List<RuleProduction> rules;
            this.getController().setRequiredSteps(this.problemSummary);
            RuleProduction.Catalog rpc = this.updateOpportunityCounts();
            List<RuleProduction> list = rules = rpc == null ? null : rpc.getRuleProductionList(true, false);
            if (trace.getDebugCode("problemsummary")) {
                trace.out("problemsummary", "getProblemSummary() ruleNames " + rules + ", XML " + (this.problemSummary == null ? null : "\n " + this.problemSummary.toXML()));
            }
            if (rules == null || Utils.isRuntime() && rules.size() < 1) {
                return this.problemSummary;
            }
            Skills skills = new Skills();
            skills.setVersion(this.getController().getCommShellVersion());
            for (RuleProduction rp : rules) {
                Skill skill = new Skill(rp.getDisplayName());
                skill.setLabel(rp.getLabel());
                skill.setDescription(rp.getDescription());
                skills.add(skill);
            }
            this.problemSummary.setSkills(skills);
        }
        if (trace.getDebugCode("skills")) {
            trace.outNT("skills", "getProblemSummary().getSkills() post " + (this.problemSummary.getSkills() == null ? null : this.problemSummary.getSkills().getAllSkills()));
        }
        return this.problemSummary;
    }

    public MessageObject handleProblemSummaryRequest() {
        return ProblemModel.handleProblemSummaryRequest(this.getProblemSummary());
    }

    private static MessageObject handleProblemSummaryRequest(ProblemSummary ps) {
        MessageObject resp = MessageObject.create("ProblemSummaryResponse");
        resp.setVerb("NotePropertySet");
        String xml = "";
        if (ps != null) {
            xml = ps.toXML();
        }
        resp.setProperty("cmi.core.lesson_status", SCORM.getLessonStatus(ps));
        resp.setProperty("cmi.core.score.raw", SCORM.getRawScore(ps));
        resp.setProperty("cmi.core.exit", SCORM.getExitReason(ps));
        resp.setProperty("cmi.core.session_time", SCORM.getSessionTime(ps));
        resp.setProperty("ProblemSummary", xml);
        resp.setProperty("end_of_transaction", "true");
        return resp;
    }

    String getStudentBeginsHereNameForBRD() {
        if (this.studentBeginsHereState != null) {
            return this.studentBeginsHereState.getName();
        }
        return STUDENT_BEGINS_HERE_VAR;
    }

    public ProblemNode getStudentBeginsHereState() {
        if (this.studentBeginsHereState != null) {
            return this.studentBeginsHereState;
        }
        return this.getStartNode();
    }

    public void setStudentBeginsHereState(String studentBeginsHereStateName) {
        ProblemNode node = this.getNode(studentBeginsHereStateName);
        this.setStudentBeginsHereState(node);
    }

    public synchronized void setStudentBeginsHereState(ProblemNode studentBeginsHereState) {
        if (trace.getDebugCode("pm")) {
            trace.out("pm", "setStudentBeginsHereState(" + this.studentBeginsHereState + "=>" + studentBeginsHereState + ")");
        }
        if (this.studentBeginsHereState == studentBeginsHereState) {
            return;
        }
        LinkedHashSet<Integer> newBSBSs = new LinkedHashSet<Integer>();
        HashSet<ProblemNode> nodesToNotify = new HashSet<ProblemNode>();
        ExampleTracerGraph graph = this.getExampleTracerGraph();
        if (graph != null) {
            ExampleTracerPath pathFromOrigin;
            ExampleTracerPath exampleTracerPath = pathFromOrigin = studentBeginsHereState == null ? new ExampleTracerPath() : this.findPath(studentBeginsHereState);
            if (trace.getDebugCode("br")) {
                trace.out("br", "setStudentBeginsHere() path " + pathFromOrigin);
            }
            for (ExampleTracerLink link : pathFromOrigin.getLinks()) {
                Integer nodeId = new Integer(link.getPrevNode());
                newBSBSs.add(nodeId);
                if (this.beforeStudentBeginsStates.contains(nodeId)) continue;
                nodesToNotify.add(this.getProblemNode(nodeId));
            }
            for (Integer nodeId : this.beforeStudentBeginsStates) {
                if (newBSBSs.contains(nodeId)) continue;
                nodesToNotify.add(this.getProblemNode(nodeId));
            }
        }
        this.studentBeginsHereState = studentBeginsHereState == this.getStartNode() ? null : studentBeginsHereState;
        this.beforeStudentBeginsStates = newBSBSs;
        if (trace.getDebugCode("br")) {
            trace.out("br", "setStudentBeginsHereState(" + studentBeginsHereState + ", id=" + (studentBeginsHereState == null ? -1 : studentBeginsHereState.getUniqueID()) + "), states before " + this.beforeStudentBeginsStates);
        }
        for (ProblemNode node : nodesToNotify) {
            if (node == null) continue;
            this.fireProblemModelEvent(new NodeUpdatedEvent(this.getController(), node));
        }
    }

    public boolean isBeforeStudentBegins(ProblemNode node) {
        if (this.beforeStudentBeginsStates == null) {
            return false;
        }
        return this.beforeStudentBeginsStates.contains(new Integer(node.getUniqueID()));
    }

    public Boolean getConfirmDone() {
        return this.confirmDone;
    }

    public boolean getEffectiveConfirmDone() {
        Boolean property = this.getConfirmDone();
        if (property == null) {
            FeedbackEnum fb = this.getSuppressStudentFeedback();
            property = fb != null && fb.exitOnIncorrectDone();
        }
        if (trace.getDebugCode("cd")) {
            trace.out("cd", "getEffectiveConfirmDone() returns " + property + "; confirmDone " + this.getConfirmDone() + "; feedback " + (Object)((Object)this.getSuppressStudentFeedback()));
        }
        return property;
    }

    public void setConfirmDone(Boolean confirmDone) {
        if (trace.getDebugCode("cd")) {
            trace.out("cd", "setConfirmDone(" + confirmDone + ") replaces " + this.confirmDone);
        }
        this.confirmDone = confirmDone;
    }

    public List<Skill> updateSkills(String transactionResult, Collection<String> skillNames, String stepID) {
        ArrayList<Skill> result = new ArrayList<Skill>();
        if (this.controller != null && this.controller.isRestoringProblemState(null, false)) {
            return result;
        }
        Skills skills = this.getProblemSummary().getSkills();
        if (skills == null) {
            return result;
        }
        for (String skillName : skillNames) {
            Skill modifiedSkill = skills.updateSkill(transactionResult, skillName, stepID);
            if (modifiedSkill == null) continue;
            result.add(modifiedSkill);
        }
        return result;
    }

    public Vector<String> getSkillBarVector() {
        Skills skills = this.getProblemSummary().getSkills();
        if (skills == null) {
            return null;
        }
        return skills.getSkillBarVector();
    }

    public void startSkillTransaction() {
        Skills skills = this.getProblemSummary().getSkills();
        if (skills == null) {
            return;
        }
        skills.startTransaction();
    }

    public void renameNode(ProblemNode problemNode, String oldName, String newName) {
        ProblemGraph graph = this.getProblemGraph();
        if (graph == null) {
            return;
        }
        graph.renameNode(problemNode, oldName, newName);
    }

    public RuleProduction.Catalog updateOpportunityCounts() {
        RuleProduction.Catalog rulesInUse = this.controller.getRuleProductionCatalog().removeUnusedRuleProductions(this.getProblemGraph());
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "rulesInUse after removeUnused: " + rulesInUse);
        }
        if (this.controller.getCtatModeModel().isExampleTracingMode()) {
            Vector<ProblemEdge> preferredPathEdges = this.findPathForProblemSkillsMatrix(this.getStudentBeginsHereState());
            rulesInUse.updateOpportunityCounts(preferredPathEdges);
        }
        return rulesInUse;
    }

    public Map getSessionStorage() {
        if (this.getController() == null) {
            return null;
        }
        return this.getController().getSessionStorage();
    }

    public void handleUntutoredAction(MessageObject mo) {
        if (trace.getDebugCode("vt")) {
            trace.out("vt", "handleUntutoredAction Recieved " + mo);
        }
        Vector<String> selection = mo.getSelection();
        Vector<String> input = mo.getInput();
        Vector<String> action = mo.getAction();
        if (!Utils.isRuntime()) {
            this.controller.updateSAITable(selection, action, input, "Untutored");
        }
        if (selection == null || input == null) {
            return;
        }
        int nAssignments = 0;
        int nVars = Math.min(selection.size(), input.size());
        for (int i = 0; i < nVars; ++i) {
            String s;
            if (trace.getDebugCode("vt")) {
                trace.out("vt", "vt.put(" + selection.get(i) + ", " + input.get(i) + ")");
            }
            if ((s = selection.get(i)) == null) continue;
            this.assignVariable(s.toString(), input.get(i));
            this.assignVariable(s.toString() + ".action", action.get(i));
            nAssignments += 2;
        }
        if (trace.getDebugCode("vt")) {
            trace.out("vt", "handleUntutoredAction nAssignments " + nAssignments);
        }
        if (nAssignments < 1) {
            return;
        }
        ExampleTracerEvent evt = new ExampleTracerEvent(this, new ExampleTracerSAI(selection, action, input, "Student"));
        evt.setResult("UNEVALUATED");
        this.addStudentSAI(evt);
        this.controller.sendProperty(mo);
        VariableTableChangeEvent vtChange = new VariableTableChangeEvent(this, "VariableTable", this.variableTable, this.variableTable);
        this.fireProblemModelEvent(vtChange);
    }

    public void addInterfaceVariables(MessageObject msg) {
        Object v = msg.getProperty("Selection");
        List selection = (List)(v instanceof List ? v : null);
        v = msg.getProperty("Input");
        List input = (List)(v instanceof List ? v : null);
        if (selection == null || input == null) {
            return;
        }
        int nVars = Math.min(selection.size(), input.size());
        for (int i = 0; i < nVars; ++i) {
            Object s = selection.get(i);
            this.assignVariable(s == null ? null : s.toString(), input.get(i));
        }
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "variable table #" + this.getVariableTable().getInstance() + " after adding " + selection + ":" + input + " == " + this.getVariableTable());
        }
    }

    public String getBehaviorRecorderMode() {
        return this.behaviorRecorderMode;
    }

    void setBehaviorRecorderMode(String behaviorRecorderMode) {
        this.behaviorRecorderMode = behaviorRecorderMode;
    }

    public String getSkillBarDelimiter() {
        Skills skills = this.getProblemSummary().getSkills();
        if (skills == null) {
            return "=";
        }
        return skills.getSkillBarDelimiter();
    }

    public void requestGoToState(ProblemNode state) {
        this.requestGoToState = new RequestGoToState(state, false);
    }

    public void requestGoToState(ProblemNode state, boolean suppressOutput) {
        this.requestGoToState = new RequestGoToState(state, suppressOutput);
    }

    public boolean checkRequestGoToState() {
        BR_Controller ctlr;
        ProblemNode node;
        RequestGoToState req = this.requestGoToState;
        this.requestGoToState = null;
        ProblemNode problemNode = node = req == null ? null : req.state;
        if (node == null) {
            return false;
        }
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "checkRequestGoToState(" + node + ")");
        }
        if ((ctlr = this.getController()) == null || this.getStudentSAIs() == null) {
            return false;
        }
        ctlr.setSuppressAllFeedback(req.suppressOutput);
        ctlr.goToState(node, true);
        return true;
    }

    public String getOutOfOrderMessage() {
        if (this.outOfOrderMessage == null || this.outOfOrderMessage.length() < 1) {
            return DEFAULT_OUT_OF_ORDER_MESSAGE;
        }
        return this.outOfOrderMessage;
    }

    public void setOutOfOrderMessage(String outOfOrderMessage) {
        this.outOfOrderMessage = outOfOrderMessage;
    }

    public boolean checkHintRandomization(String conditionName) {
        if (conditionName == null) {
            return false;
        }
        String cn = conditionName.toLowerCase();
        if (cn.indexOf("hint") < 0 || cn.indexOf("random") < 0) {
            return false;
        }
        this.setRandomizeHints(true);
        return true;
    }

    private void setRandomizeHints(boolean b) {
        this.randomizeHints = b;
    }

    public boolean getRandomizeHints() {
        return this.randomizeHints;
    }

    public List<MessageObject> getUnrequestedHint(ProblemNode currentNode, int depthSoFar) {
        if (!this.getRandomizeHints()) {
            return null;
        }
        ExampleTracerNode node = this.getExampleTracerGraph().getNode(currentNode.getUniqueID());
        Set<ExampleTracerPath> paths = this.getExampleTracerGraph().findPathsFromNode(node);
        HashSet pathsToDone = new HashSet();
        ExampleTracerPath shortest = null;
        for (ExampleTracerPath p : paths) {
            if (!p.isDonePath() || shortest != null && p.getLinks().size() >= shortest.getLinks().size()) continue;
            shortest = p;
        }
        if (shortest == null) {
            return null;
        }
        int shortestLen = shortest.getLinks().size();
        CTATRandom cr = new CTATRandom();
        this.unrequestedHintDepths = cr.randomIndices(shortestLen, 0.3333333333333333);
        int i = 0;
        while (i < this.unrequestedHintDepths.length) {
            int n = i++;
            this.unrequestedHintDepths[n] = this.unrequestedHintDepths[n] + depthSoFar;
        }
        Arrays.sort(this.unrequestedHintDepths);
        if (trace.getDebugCode("hints")) {
            trace.out("hints", "PM.getUnrequestedHint() currentNode " + currentNode.getUniqueID() + ", depthSoFar " + depthSoFar + ", shortestLen " + shortestLen + ", fraction " + 0.3333333333333333 + ", unrequestedHintDepths " + Arrays.toString(this.unrequestedHintDepths));
        }
        return this.getUnrequestedHint(depthSoFar);
    }

    public List<MessageObject> getUnrequestedHint(int depthSoFar) {
        if (trace.getDebugCode("hints")) {
            trace.out("hints", "PM.getUnrequestedHint(" + depthSoFar + ") unrequestedHintDepths " + Arrays.toString(this.unrequestedHintDepths));
        }
        if (!this.getRandomizeHints()) {
            return null;
        }
        if (Arrays.binarySearch(this.unrequestedHintDepths, depthSoFar) < 0) {
            return null;
        }
        if (this.controller == null) {
            return null;
        }
        Vector<String> selection = new Vector<String>();
        selection.add("Hint");
        Vector<String> action = new Vector<String>();
        action.add("ButtonPressed");
        Vector<String> input = new Vector<String>();
        input.add("-1");
        ExampleTracerEvent result = new ExampleTracerEvent(this);
        ProblemEdge hintLink = this.controller.getExampleTracer().doHint(selection, action, input, "Student", result, false);
        if (trace.getDebugCode("hints")) {
            trace.out("hints", "PM.getUnrequestedHint(" + depthSoFar + ") hintLink " + hintLink);
        }
        if (hintLink == null) {
            return null;
        }
        result.setActor("Tutor");
        this.unrequestedHintMsgs = new ArrayList<MessageObject>();
        MessageObject toolMsg = PseudoTutorMessageBuilder.buildToolInterfaceAction(selection, action, input, "DATA", "tutor-performed");
        this.controller.setSemanticEventId(toolMsg.getTransactionId());
        this.unrequestedHintMsgs.add(toolMsg);
        if (result.isSolverResult()) {
            String stepID = Skill.makeStepID(result.getTutorSelection(), result.getTutorAction());
            this.unrequestedHintMsgs.add(PseudoTutorMessageBuilder.buildHintsMsg(result.getTutorAdvice(), result.getTutorSelection(), result.getTutorAction(), result.getTutorInput(), Integer.toString(hintLink.getUniqueID()), null, null, this.controller));
            this.unrequestedHintMsgs.add(PseudoTutorMessageBuilder.buildAssocRulesFromEvent(result, this.controller));
        } else {
            this.unrequestedHintMsgs.add(PseudoTutorMessageBuilder.buildHintsMsg(hintLink, this.controller));
            this.unrequestedHintMsgs.add(PseudoTutorMessageBuilder.buildAssociatedRules(hintLink, "Hint", "Tutor", this.controller, null));
        }
        return this.unrequestedHintMsgs;
    }

    public void cancelUnrequestedHint(int depthToRemove) {
        int i = Arrays.binarySearch(this.unrequestedHintDepths, depthToRemove);
        if (i < 0) {
            return;
        }
        int[] result = new int[this.unrequestedHintDepths.length - 1];
        if (result.length < 1) {
            return;
        }
        int k = 0;
        for (int j = 0; j < this.unrequestedHintDepths.length; ++j) {
            if (j == i) continue;
            result[k++] = this.unrequestedHintDepths[j];
        }
        if (trace.getDebugCode("hints")) {
            trace.out("hints", "cancelUnrequestedHint(" + depthToRemove + ") unrequestedHintDepths was " + Arrays.toString(this.unrequestedHintDepths) + ", now " + Arrays.toString(result));
        }
        this.unrequestedHintDepths = result;
    }

    public CTATSerializable.IncludeIn getInterfaceDescriptionFilter() {
        return CTATSerializable.IncludeIn.sparse;
    }

    public boolean isEmpty() {
        return this.getStartNode() == null;
    }

    public void printSelectedLinks() {
        Set<ExampleTracerLink> links = this.editContext.getSelectedLinks();
        for (ExampleTracerLink link : links) {
            trace.out("mg", "ProblemModel (printSelectedLinks): " + link.getID());
        }
    }

    public Set<ExampleTracerLink> getSelectedLinks() {
        return this.editContext.getSelectedLinks();
    }

    public void renameProblem(String newProblemName) {
        this.setProblemName(newProblemName);
        this.getStartNode().setName(newProblemName);
        if (this.getStartNodeMessageVector() != null && this.getStartNodeMessageVector().size() > 0) {
            MessageObject obj = this.getStartNodeMessageVector().get(0);
            if ("StartProblem".equals(obj.getMessageType())) {
                obj.setProperty("ProblemName", newProblemName);
            }
            this.getStartNodeMessageVector().set(0, obj);
        }
        this.getStartNode().getNodeView().setText(newProblemName);
    }

    public static boolean hasMassProductionVarPattern(String str) {
        return ProblemModel.getMassProductionVarPattern().matcher(str).find();
    }

    public static Pattern getMassProductionVarPattern() {
        return MassProductionVarPattern;
    }

    private CTATFunctions getCtatFunctions() {
        if (this.ctatFunctions == null) {
            this.ctatFunctions = new CTATFunctions(this.getVariableTable(), this, this.getFormulaParser());
        }
        return this.ctatFunctions;
    }

    public MessageObject interpolateAllValues(MessageObject mo) {
        MessageObject mo2 = mo.copy();
        for (String name : mo2.getPropertyNames()) {
            Object pv = mo2.getProperty(name);
            if (trace.getDebugCode("functions")) {
                trace.outln("functions", "pv = " + pv);
            }
            if (pv instanceof Vector) {
                Vector<String> interpolatedValues = new Vector<String>();
                for (Object value : (Vector)pv) {
                    interpolatedValues.add(this.getCtatFunctions().interpolate(value.toString()));
                }
                mo2.setProperty(name, interpolatedValues);
                continue;
            }
            if (pv instanceof Element) {
                mo2.setProperty(name, pv);
                continue;
            }
            if (pv == null) continue;
            mo2.setProperty(name, this.getCtatFunctions().interpolate(pv.toString()));
        }
        return mo2;
    }

    public boolean checkReplayState(ExampleTracerEvent result) {
        ExampleTracerLink link = null;
        if (result == null || (link = result.getReportableLink()) == null) {
            return false;
        }
        if (this.getStudentSAIs().getTargetNodeID() != link.getNextNode()) {
            return false;
        }
        this.getStudentSAIs().clearTargetNodeID();
        if (this.getController() != null) {
            this.getController().setSuppressAllFeedback(false);
        }
        return true;
    }

    public boolean addStudentSAI(ExampleTracerEvent result) {
        SAIList sl = this.getStudentSAIs();
        if (sl == null) {
            return false;
        }
        return sl.add(result, this.getExampleTracerGraph().getExampleTracer());
    }

    public SAIList getStudentSAIs() {
        if (this.studentSAIs == null) {
            this.clearStudentSAIs();
        }
        return this.studentSAIs;
    }

    public void clearStudentSAIs() {
        if (this.studentSAIs == null) {
            if (this.getStartNode() != null) {
                this.studentSAIs = new SAIList(this.getStartNode().getUniqueID());
            }
        } else {
            this.studentSAIs.clear();
        }
    }

    public String getDefaultBuggyMsg() {
        LinkGroup tlg = this.getExampleTracerGraph().getGroupModel().getTopLevelGroup();
        if (tlg instanceof DefaultLinkGroup) {
            return ((DefaultLinkGroup)tlg).getDefaultBuggyMsg();
        }
        return null;
    }

    private class RequestGoToState {
        private final ProblemNode state;
        private final boolean suppressOutput;

        private RequestGoToState(ProblemNode state, boolean suppressOutput) {
            this.state = state;
            this.suppressOutput = suppressOutput;
        }
    }
}

