/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSSELink;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATTutorPreview;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

class CTATPreviewHandler
extends CTATBase
implements CTATHTTPHandlerInterface {
    private CTATTutorPreview viewer = null;

    public CTATPreviewHandler(CTATTutorPreview aViewer) {
        this.setClassName("CTATPreviewHandler");
        this.debug("CTATPreviewHandler ()");
        this.setViewer(aViewer);
    }

    private Image getImageData(CTATHTTPExchange arg0) throws IOException {
        this.debug("getImageData ()");
        InputStream din = arg0.getRequestBody();
        if (din == null) {
            this.debug("Error POST input stream is null");
            return null;
        }
        if (din.available() <= 0) {
            this.debug("Error: no data available on input stream, aborting ...");
            return null;
        }
        this.debug("We've got data [" + din.available() + "] available, reading ...");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(){

            @Override
            public byte[] toByteArray() {
                return this.buf;
            }
        };
        int b = -1;
        while (0 <= (b = din.read())) {
            baos.write(b);
        }
        byte[] imageBytes = baos.toByteArray();
        if (imageBytes.length <= 0) {
            this.debug("Read no image bytes from stream; returning null...");
            return null;
        }
        this.debug("Read " + imageBytes.length + " image bytes from stream...");
        ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
        BufferedImage image = ImageIO.read(bais);
        if (image == null) {
            this.debug("Conversion of image data from input stream failed; returning null");
        } else {
            this.debug("We appear to have a valid image; returning it");
        }
        return image;
    }

    @Override
    public boolean handle(CTATHTTPExchange arg0, String requestBody) {
        this.debug("handle ()");
        CTATSSELink.preview = null;
        String requestMethod = arg0.getRequestMethod();
        this.debug("Request method: " + requestMethod + ", Request URI: " + arg0.getRequestURI());
        String fileURI = arg0.getRequestURI().toString();
        if (requestMethod.equalsIgnoreCase("post")) {
            this.debug("Processing POST ...");
            try {
                CTATSSELink.preview = this.getImageData(arg0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.viewer != null) {
                this.viewer.updatePreview();
            }
        }
        if (requestMethod.equalsIgnoreCase("get")) {
            this.debug("Processing GET request ...");
            if (fileURI.equalsIgnoreCase("/crossdomain.xml")) {
                this.debug("Processing crossdomain request ...");
                this.debug("Writing back the crossdomain policy...");
                try {
                    arg0.addResponseHeader("Content-Type", "application/xml");
                    arg0.sendResponseHeaders(200, CTATLink.crossDomainPolicy.getBytes().length);
                    arg0.writeBytesString(CTATLink.crossDomainPolicy, false);
                    this.debug("Wrote back Crossdomain.xml..");
                    arg0.close();
                    return true;
                }
                catch (Exception e) {
                    this.debug("Exception in trying to write back crossdomain.xml");
                }
            }
        }
        return false;
    }

    public CTATTutorPreview getViewer() {
        return this.viewer;
    }

    public void setViewer(CTATTutorPreview viewer) {
        this.viewer = viewer;
    }

    @Override
    public boolean getOutputJSON() {
        return false;
    }
}

