/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.GraphInspector;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupEditorContext;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.View.GraphInspector.GroupNameEditor;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.trace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class GroupTreePopupMenu
extends MouseAdapter
implements ActionListener {
    private GroupModel groupModel;
    private GroupEditorContext editContext;
    private Frame mainWindow;
    private JTree groupTree;
    private JPopupMenu groupPopupMenu;
    private LinkGroup currentGroup;
    private CTAT_Controller controller;
    private JDialog renameGroupDialog;
    private JCheckBoxMenuItem isGroupDisplayed;
    private JMenuItem deleteGroup;
    private JMenuItem renameGroup;
    private JCheckBoxMenuItem isGroupOrdered;
    private JCheckBoxMenuItem isGroupReenterable;
    private JMenuItem deleteSubGroups;
    private GroupNameEditor groupNameEditor;

    public GroupTreePopupMenu(JTree groupTree, GroupEditorContext editContext, Frame mainWindow, CTAT_Controller controller) {
        this.mainWindow = mainWindow;
        this.groupTree = groupTree;
        this.editContext = editContext;
        this.controller = controller;
        this.groupModel = editContext.getGroupModel();
        groupTree.addMouseListener(this);
        this.initWindows();
    }

    private void initWindows() {
        this.groupPopupMenu = new JPopupMenu();
        this.isGroupDisplayed = new JCheckBoxMenuItem("Displayed On Graph");
        this.isGroupDisplayed.addActionListener(this);
        this.groupPopupMenu.add(this.isGroupDisplayed);
        this.deleteGroup = new JMenuItem("Delete");
        this.deleteGroup.addActionListener(this);
        this.groupPopupMenu.add(this.deleteGroup);
        this.renameGroup = new JMenuItem("Rename");
        this.renameGroup.addActionListener(this);
        this.groupPopupMenu.add(this.renameGroup);
        this.isGroupOrdered = new JCheckBoxMenuItem("Ordered");
        this.isGroupOrdered.addActionListener(this);
        this.groupPopupMenu.add(this.isGroupOrdered);
        this.isGroupReenterable = new JCheckBoxMenuItem("Reenterable");
        this.isGroupReenterable.addActionListener(this);
        this.groupPopupMenu.add(this.isGroupReenterable);
        this.deleteSubGroups = new JMenuItem("Delete All Subgroups");
        this.deleteSubGroups.addActionListener(this);
        this.groupPopupMenu.add(this.deleteSubGroups);
        this.renameGroupDialog = new JDialog(this.mainWindow, "Rename Group", true);
        JPanel innerPanel1 = new JPanel();
        innerPanel1.setLayout(new BoxLayout(innerPanel1, 1));
        innerPanel1.add(new JLabel("Enter Group Name"));
        this.groupNameEditor = new GroupNameEditor(this.groupModel);
        innerPanel1.add(this.groupNameEditor);
        JPanel innerPanel2 = new JPanel();
        innerPanel2.setLayout(new BoxLayout(innerPanel2, 0));
        JButton okButton = new JButton("Ok");
        this.groupNameEditor.setTargetButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GroupTreePopupMenu.this.groupModel.setGroupName(GroupTreePopupMenu.this.currentGroup, GroupTreePopupMenu.this.groupNameEditor.getGroupName());
                GroupTreePopupMenu.this.renameGroupDialog.setVisible(false);
                if (GroupTreePopupMenu.this.controller instanceof BR_Controller) {
                    ActionEvent ae = new ActionEvent(this, 0, "Rename Group");
                    ((BR_Controller)GroupTreePopupMenu.this.controller).getUndoPacket().getCheckpointAction().actionPerformed(ae);
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GroupTreePopupMenu.this.renameGroupDialog.setVisible(false);
            }
        });
        innerPanel2.add(okButton);
        innerPanel2.add(cancelButton);
        innerPanel1.add(innerPanel2);
        innerPanel1.add(this.groupNameEditor.getMessageField());
        this.renameGroupDialog.add(innerPanel1);
        this.renameGroupDialog.pack();
        this.renameGroupDialog.setResizable(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            TreePath path = this.groupTree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            Object ob = path.getLastPathComponent();
            if (ob instanceof LinkGroup) {
                this.currentGroup = (LinkGroup)ob;
                this.configureMenuForGroup(this.currentGroup);
                this.groupPopupMenu.show(this.groupTree, e.getX(), e.getY());
                return;
            }
        }
    }

    private void configureMenuForGroup(LinkGroup group) {
        this.isGroupDisplayed.setSelected(this.editContext.getGroupIsDisplayedOnGraph(group));
        this.deleteGroup.setEnabled(!group.equals(this.groupModel.getTopLevelGroup()));
        this.renameGroup.setEnabled(!group.equals(this.groupModel.getTopLevelGroup()));
        this.isGroupOrdered.setSelected(this.groupModel.isGroupOrdered(group));
        this.isGroupReenterable.setSelected(this.groupModel.isGroupReenterable(group));
        this.deleteSubGroups.setEnabled(this.groupModel.getGroupSubgroupCount(group) != 0);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JMenuItem src = (JMenuItem)(arg0.getSource() instanceof JMenuItem ? arg0.getSource() : null);
        if (trace.getDebugCode("undo")) {
            trace.out("undo", "GroupTreePopupMenu.actionPerformed(" + (src != null ? src.getText() : "") + ")");
        }
        if (arg0.getSource().equals(this.isGroupDisplayed)) {
            this.editContext.setGroupIsDisplayedOnGraph(this.currentGroup, this.isGroupDisplayed.isSelected());
        } else if (arg0.getSource().equals(this.deleteGroup)) {
            this.groupModel.removeGroupKeepSubgroups(this.currentGroup);
            if (this.controller instanceof BR_Controller) {
                ActionEvent ae = new ActionEvent(this, 0, "Delete Group");
                ((BR_Controller)this.controller).getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        } else if (arg0.getSource().equals(this.renameGroup)) {
            this.groupNameEditor.redoNamesList();
            this.groupPopupMenu.setVisible(true);
            this.renameGroupDialog.setLocation(this.groupPopupMenu.getLocationOnScreen());
            this.renameGroupDialog.setVisible(true);
        } else if (arg0.getSource().equals(this.isGroupOrdered)) {
            boolean isOrdered = this.isGroupOrdered.isSelected();
            this.groupModel.setGroupOrdered(this.currentGroup, isOrdered);
            if (this.currentGroup == this.groupModel.getTopLevelGroup()) {
                this.controller.getProblemModel().getController().updateStatusPanel(null);
            }
            if (this.controller instanceof BR_Controller) {
                ActionEvent ae = new ActionEvent(this, 0, "Set Group " + (isOrdered ? "Ordered" : "Unordered"));
                ((BR_Controller)this.controller).getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        } else if (arg0.getSource().equals(this.isGroupReenterable)) {
            boolean isReenterable = this.isGroupReenterable.isSelected();
            this.groupModel.setGroupReenterable(this.currentGroup, isReenterable);
            if (this.controller instanceof BR_Controller) {
                ActionEvent ae = new ActionEvent(this, 0, "Set Group " + (isReenterable ? "" : "Not ") + "Reenterable");
                ((BR_Controller)this.controller).getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        } else if (arg0.getSource().equals(this.deleteSubGroups)) {
            this.groupModel.removeAllGroupSubgroups(this.currentGroup);
            if (this.controller instanceof BR_Controller) {
                ActionEvent ae = new ActionEvent(this, 0, "Delete All Subgroups");
                ((BR_Controller)this.controller).getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        }
        this.groupPopupMenu.setVisible(false);
    }
}

