/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.GraphInspector;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupEditorContext;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GroupTreeRenderer
extends DefaultTreeCellRenderer {
    GroupEditorContext editContext;

    public GroupTreeRenderer(GroupEditorContext editContext) {
        this.editContext = editContext;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object target, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        this.setBackgroundNonSelectionColor(Color.WHITE);
        this.setBorderSelectionColor(Color.WHITE);
        if (target instanceof LinkGroup) {
            LinkGroup group = (LinkGroup)target;
            if (!group.equals(this.editContext.getSelectedGroup()) && this.editContext.getGroupIsDisplayedOnGraph(group)) {
                this.setBackgroundNonSelectionColor(this.editContext.getGroupColor(group));
            }
            Component c = super.getTreeCellRendererComponent(tree, target, isSelected, isExpanded, isLeaf, row, hasFocus);
            DefaultTreeCellRenderer label = (DefaultTreeCellRenderer)c;
            label.setText(this.editContext.getGroupModel().getTreeText(group));
            return label;
        }
        if (target instanceof ExampleTracerLink) {
            ExampleTracerLink link = (ExampleTracerLink)target;
            if (this.editContext.getLinkIsSelected(link)) {
                this.setBackgroundNonSelectionColor(Color.LIGHT_GRAY);
            }
            return super.getTreeCellRendererComponent(tree, target, isSelected, isExpanded, isLeaf, row, hasFocus);
        }
        return super.getTreeCellRendererComponent(tree, target, isSelected, isExpanded, isLeaf, row, hasFocus);
    }
}

