/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.GraphInspector;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.Utilities.trace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class GroupTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final DataFlavor linkFlavor = new DataFlavor(ExampleTracerLink.class, "ExampleTracerLink");
    GroupModel groupModel;
    private BR_Controller controller;
    TransferHandler.TransferSupport trans;

    public GroupTreeTransferHandler(GroupModel groupModel, BR_Controller controller) {
        this.groupModel = groupModel;
        this.controller = controller;
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (c instanceof JTree) {
            return 2;
        }
        return 0;
    }

    @Override
    public Transferable createTransferable(JComponent source) {
        if (source instanceof JTree) {
            JTree tree = (JTree)source;
            TreePath[] selectionPaths = tree.getSelectionPaths();
            for (int i = 0; i < selectionPaths.length; ++i) {
                if (!(selectionPaths[i].getLastPathComponent() instanceof ExampleTracerLink)) continue;
                ExampleTracerLink selectedLeaf = (ExampleTracerLink)selectionPaths[i].getLastPathComponent();
                return new DataHandler((Object)selectedLeaf, linkFlavor.getMimeType());
            }
        }
        return null;
    }

    @Override
    public void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (trace.getDebugCode("groups")) {
            trace.out("groups", "GTTH.importData() isDrop " + support.isDrop() + ", dropLocation " + (support.getDropLocation() == null ? "null" : support.getDropLocation().getClass()));
        }
        this.trans = support;
        if (!support.isDrop()) {
            return false;
        }
        TransferHandler.DropLocation dropLocation = support.getDropLocation();
        if (dropLocation instanceof JTree.DropLocation) {
            ExampleTracerLink draggedLink;
            LinkGroup groupDroppedOn;
            JTree.DropLocation treeDropLocation = (JTree.DropLocation)dropLocation;
            TreePath dropPath = treeDropLocation.getPath();
            if (trace.getDebugCode("groups")) {
                trace.out("groups", "GTTH.importData() path " + dropPath + ", lastComponent " + (dropPath == null ? "null" : dropPath.getLastPathComponent().getClass()));
            }
            if (dropPath == null) {
                return false;
            }
            if (dropPath.getLastPathComponent() instanceof LinkGroup) {
                groupDroppedOn = (LinkGroup)dropPath.getLastPathComponent();
            } else if (dropPath.getLastPathComponent() instanceof ExampleTracerLink) {
                ExampleTracerLink linkDroppedOn = (ExampleTracerLink)dropPath.getLastPathComponent();
                groupDroppedOn = this.groupModel.getUniqueContainingGroup(linkDroppedOn);
            } else {
                return false;
            }
            try {
                draggedLink = (ExampleTracerLink)support.getTransferable().getTransferData(linkFlavor);
            }
            catch (Exception e) {
                trace.errStack("GTTH.importData(): error getting draggedLink; groupDroppedOn " + groupDroppedOn, e);
                return false;
            }
            boolean alreadyInGroup = this.groupModel.getUniqueLinks(groupDroppedOn).contains(draggedLink);
            if (trace.getDebugCode("groups")) {
                trace.out("groups", "GTTH.importData() draggedLink " + draggedLink + (alreadyInGroup ? "" : " not") + " already in groupDroppedOn " + groupDroppedOn);
            }
            if (alreadyInGroup) {
                return false;
            }
            this.groupModel.addLinkToGroup(groupDroppedOn, draggedLink);
            ActionEvent ae = new ActionEvent(this, 0, "Move link to different group");
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
        }
        return true;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        JTree.DropLocation treeDropLocation;
        TreePath dropPath;
        TransferHandler.DropLocation dropLocation;
        if (!support.isDataFlavorSupported(linkFlavor)) {
            return false;
        }
        return support.getComponent() instanceof JTree && (dropLocation = support.getDropLocation()) instanceof JTree.DropLocation && (dropPath = (treeDropLocation = (JTree.DropLocation)dropLocation).getPath()) != null;
    }
}

