/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.pact.Log.EmptyIterator;
import edu.cmu.pact.Log.TextIsString;
import edu.cmu.pact.Utilities.trace;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.server.UID;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AuthorActionLog
extends ActionLog
implements TextIsString {
    public static final String DEFAULT_SOURCE = "DATASHOP";
    public static final String DEFAULT_TIME_ZONE = "UTC";
    public static final String MSG_SEQUENCE_ELEMENT = "tutor_related_message_sequence";
    public static final String VERSION_NUMBER_ATTR = "version_number";
    public static final String VERSION_NUMBER = "2";
    public static final String CURRICULUM_MSG_ELEMENT = "curriculum_message";
    public static final String MSG_ELEMENT = "message";
    public static final String PROBLEMNAME_ELEMENT = "problem_name";
    public static final String SCHOOLNAME_ELEMENT = "school_name";
    public static final String COURSENAME_ELEMENT = "course_name";
    public static final String UNITNAME_ELEMENT = "unit_name";
    public static final String SECTIONNAME_ELEMENT = "section_name";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String CUSTOM_FIELD_ELEMENT = "custom_field";
    public static final String CUSTOM_FIELD_NAME_ELEMENT = "name";
    public static final String CUSTOM_FIELD_VALUE_ELEMENT = "value";
    static final String INFO_TYPE = "author_message.dtd";
    private static Iterator emptyIterator = EmptyIterator.getInstance();
    private static DateFormat dateFmtMS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private static DateFormat dateFmtSS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static DateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat().setIndent(" ").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator("\n"));
    private String topElementType = null;
    private String attemptId = null;
    private String name = null;
    private String problemName = null;
    private Map customFields = null;
    private String schoolName = null;
    private String courseName = null;
    private String unitName = null;
    private String sectionName = null;
    private List msgProperties = null;
    public static final String ACTION_TYPE_ELEMENT = "action_type";
    public static final String ARGUMENT_ELEMENT = "argument";
    public static final String RESULT_ELEMENT = "result";
    public static final String RESULT_DETAILS_ELEMENT = "result_details";
    private String actionType = null;
    private String argument = null;
    private String result = null;
    private Object resultDetails = null;
    public static final String STUDENT_INTERFACE = "STUDENT_INTERFACE";
    public static final String BEHAVIOR_RECORDER = "BEHAVIOR_RECORDER";
    public static final String CTAT_WINDOW = "CTAT_WINDOW";
    public static final String DOCKING_WINDOW = "DOCKING_WINDOW";
    public static final String JESS_CONSOLE = "JESS_CONSOLE";
    public static final String ECLIPSE = "ECLIPSE";
    public static final String EXTERNAL_EDITOR = "EXTERNAL_EDITOR";
    public static final String CONFLICT_TREE = "CONFLICT_TREE";
    public static final String WHY_NOT_WINDOW = "WHY_NOT_WINDOW";
    public static final String WORKING_MEMORY_EDITOR = "WORKING_MEMORY_EDITOR";
    public static final String SIM_STUDENT_PLE = "SIM_STUDENT_PLE";
    public static final String SKILLS_CONSOLE = "SKILLS_CONSOLE";
    public static final String WPI_ACTION_HANDLER = "WPI_ACTION_HANDLER";
    public static final String WPI_ACTIONLABEL_HANDLER = "WPI_ACTIONLABEL_HANDLER";
    public static final String WPI_RULELABEL_HANDLER = "WPI_RULELABEL_HANDLER";

    public AuthorActionLog(String actionType, String argument, String result, Object resultDetails) {
        if (trace.getDebugCode("log")) {
            trace.printStack("log", "AuthorActionLog(" + actionType + "," + argument + "," + result + "," + resultDetails + ")");
        }
        this.actionType = actionType == null ? "" : actionType;
        this.argument = argument == null ? "" : argument;
        this.result = result == null ? "" : result;
        this.resultDetails = resultDetails;
    }

    public AuthorActionLog(String actionType, String argument) {
        this(actionType, argument, null, null);
    }

    public AuthorActionLog(String result, Object resultDetails) {
        this(null, null, result, resultDetails);
    }

    protected void addChildElements(Element rootEle) {
        if (this.actionType != null) {
            rootEle.addContent((Content)AuthorActionLog.stringToElement(ACTION_TYPE_ELEMENT, this.actionType));
        }
        if (this.argument != null) {
            rootEle.addContent((Content)AuthorActionLog.stringToElement(ARGUMENT_ELEMENT, this.argument));
        }
        if (this.result != null) {
            rootEle.addContent((Content)AuthorActionLog.stringToElement(RESULT_ELEMENT, this.result));
        }
        if (this.resultDetails != null) {
            rootEle.addContent((Content)AuthorActionLog.stringToElement(RESULT_DETAILS_ELEMENT, this.resultDetails.toString()));
        }
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getArgument() {
        return this.argument;
    }

    public String getResult() {
        return this.result;
    }

    public Object getResultDetails() {
        return this.resultDetails;
    }

    public AuthorActionLog(String topElementType) {
        if (CURRICULUM_MSG_ELEMENT.equalsIgnoreCase(topElementType)) {
            this.topElementType = CURRICULUM_MSG_ELEMENT;
        } else if (MSG_ELEMENT.equalsIgnoreCase(topElementType)) {
            this.topElementType = MSG_ELEMENT;
        } else {
            throw new IllegalArgumentException("Undefined element type: " + topElementType);
        }
    }

    protected void setTopElementType(String topElementType) {
        this.topElementType = topElementType;
    }

    public AuthorActionLog() {
    }

    public AuthorActionLog(Element elt) {
        try {
            this.parseElement(elt);
        }
        catch (JDOMException de) {
            Throwable cause = de.getCause();
            if (cause != null) {
                cause.printStackTrace();
            } else {
                de.printStackTrace();
            }
            throw new RuntimeException("XML exception = " + de.toString() + (cause == null ? "" : "; cause " + cause));
        }
    }

    public static AuthorActionLog factory(String xmlStr) {
        Iterator it = AuthorActionLog.factoryIterator(new StringReader(xmlStr));
        return (AuthorActionLog)it.next();
    }

    public static AuthorActionLog myFactory(String xmlStr) throws JDOMException {
        Iterator it = AuthorActionLog.myFactoryIterator(new StringReader(xmlStr));
        return (AuthorActionLog)it.next();
    }

    public static Iterator myFactoryIterator(Reader rdr) throws JDOMException {
        try {
            return new Factory(rdr);
        }
        catch (IOException exception) {
            Throwable cause = exception.getCause();
            if (cause != null) {
                cause.printStackTrace();
            } else {
                exception.printStackTrace();
            }
            throw new RuntimeException("XML exception = " + exception.toString() + (cause == null ? "" : "; cause " + cause));
        }
    }

    public static Iterator factoryIterator(Reader rdr) {
        try {
            return new Factory(rdr);
        }
        catch (JDOMException de) {
            Throwable cause = de.getCause();
            if (cause != null) {
                cause.printStackTrace();
            } else {
                de.printStackTrace();
            }
            throw new RuntimeException("XML exception = " + de.toString() + (cause == null ? "" : "; cause " + cause));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public String toString() {
        return outputter.outputString(this.getDocument());
    }

    protected Document getDocument() {
        Element root = new Element(MSG_SEQUENCE_ELEMENT);
        root.setAttribute(VERSION_NUMBER_ATTR, VERSION_NUMBER);
        root.addContent((Content)this.getElement());
        return new Document(root);
    }

    public String getElementString() {
        return outputter.outputString(this.getElement());
    }

    protected Element getElement() {
        Element root = new Element(this.topElementType);
        if (this.attemptId != null) {
            root.setAttribute("attempt_id", this.attemptId);
        }
        if (CURRICULUM_MSG_ELEMENT.equals(this.topElementType)) {
            if (this.name != null) {
                root.setAttribute(CUSTOM_FIELD_NAME_ELEMENT, this.name);
            }
            return this.getCurriculumElement(root);
        }
        if (MSG_ELEMENT.equals(this.topElementType)) {
            return this.getMsgElement(root);
        }
        if (this.problemName != null) {
            root.addContent((Content)AuthorActionLog.stringToElement(PROBLEMNAME_ELEMENT, this.problemName));
        }
        return root;
    }

    public String getTopElementType() {
        return this.topElementType;
    }

    protected Element getCurriculumElement(Element root) {
        if (this.schoolName != null) {
            root.addContent((Content)AuthorActionLog.stringToElement(SCHOOLNAME_ELEMENT, this.schoolName));
        }
        if (this.courseName != null) {
            root.addContent((Content)AuthorActionLog.stringToElement(COURSENAME_ELEMENT, this.courseName));
        }
        if (this.unitName != null) {
            root.addContent((Content)AuthorActionLog.stringToElement(UNITNAME_ELEMENT, this.unitName));
        }
        if (this.sectionName != null) {
            root.addContent((Content)AuthorActionLog.stringToElement(SECTIONNAME_ELEMENT, this.sectionName));
        }
        if (this.problemName != null) {
            root.addContent((Content)AuthorActionLog.stringToElement(PROBLEMNAME_ELEMENT, this.problemName));
        }
        return root;
    }

    protected Element getCustomFieldElement(Element root, String customName, String customValue) {
        Element cfElement = new Element(CUSTOM_FIELD_ELEMENT);
        cfElement.addContent((Content)AuthorActionLog.stringToElement(CUSTOM_FIELD_NAME_ELEMENT, customName));
        cfElement.addContent((Content)AuthorActionLog.stringToElement(CUSTOM_FIELD_VALUE_ELEMENT, customValue));
        root.addContent((Content)cfElement);
        return root;
    }

    protected Element getMsgElement(Element root) {
        if (this.msgProperties == null) {
            return root;
        }
        Iterator it = this.msgProperties.iterator();
        while (it.hasNext()) {
            root.addContent((Content)((MsgProperty)it.next()).getElement());
        }
        return root;
    }

    protected void parseElement(Element elt) throws JDOMException {
        this.topElementType = elt.getName();
        this.attemptId = elt.getAttributeValue("attempt_id");
        Element metaElt = elt.getChild("meta");
        if (metaElt != null) {
            this.setUserGuid(metaElt.getChildTextTrim("user_id"));
            this.setSessionId(metaElt.getChildTextTrim("session_id"));
            String time = metaElt.getChildTextTrim("time");
            if (time != null && time.length() > 0) {
                ParsePosition pos = new ParsePosition(0);
                String timeZone = metaElt.getChildTextTrim("time_zone");
                if (timeZone != null && timeZone.length() > 0) {
                    timeZone = DEFAULT_TIME_ZONE;
                }
                this.setTimezone(timeZone);
                String twz = time + " " + timeZone;
                Date timeStamp = dateFmtMS.parse(twz, pos);
                if (null != timeStamp) {
                    this.setTimeStamp(timeStamp);
                } else {
                    timeStamp = dateFmtSS.parse(twz, pos);
                    if (null != timeStamp) {
                        this.setTimeStamp(timeStamp);
                    } else {
                        timeStamp = dateFmt.parse(twz, pos);
                        if (null != timeStamp) {
                            this.setTimeStamp(timeStamp);
                        } else {
                            this.setTimeStamp(new Date());
                        }
                    }
                }
            }
        }
        this.parseActionMsgElement(elt);
        if (CURRICULUM_MSG_ELEMENT.equals(this.topElementType)) {
            this.parseCurriculumContent(elt);
        } else if (MSG_ELEMENT.equals(this.topElementType)) {
            this.parseMsgContent(elt);
        } else {
            throw new JDOMException("Undefined message element tag: " + this.topElementType);
        }
    }

    protected void parseCurriculumContent(Element msgElt) throws JDOMException {
        this.schoolName = msgElt.getChildText(SCHOOLNAME_ELEMENT);
        this.courseName = msgElt.getChildText(COURSENAME_ELEMENT);
        this.unitName = msgElt.getChildText(UNITNAME_ELEMENT);
        this.sectionName = msgElt.getChildText(SECTIONNAME_ELEMENT);
        this.problemName = msgElt.getChildText(PROBLEMNAME_ELEMENT);
    }

    protected void parseMsgContent(Element msgElt) throws JDOMException {
        Iterator it = msgElt.getChildren(PROPERTY_ELEMENT).iterator();
        if (!it.hasNext()) {
            return;
        }
        this.msgProperties = new LinkedList();
        do {
            MsgProperty p = new MsgProperty((Element)it.next());
            this.msgProperties.add(p);
        } while (it.hasNext());
    }

    protected void parseActionMsgElement(Element elt) {
        this.actionType = elt.getChildText(ACTION_TYPE_ELEMENT);
        this.argument = elt.getChildText(ARGUMENT_ELEMENT);
        this.result = elt.getChildText(RESULT_ELEMENT);
        this.resultDetails = elt.getChildText(RESULT_DETAILS_ELEMENT);
    }

    public void addCustomField(String customName, String customValue) {
        if (this.customFields == null) {
            this.customFields = new LinkedHashMap();
        }
        this.customFields.put(customName, customValue);
    }

    public void addMsgProperty(String text, String stringValue) {
        if (this.msgProperties == null) {
            this.msgProperties = new LinkedList();
        }
        MsgProperty e = new MsgProperty(text, stringValue);
        this.msgProperties.add(e);
    }

    public void addMsgProperty(String text, List list) {
        if (this.msgProperties == null) {
            this.msgProperties = new LinkedList();
        }
        MsgProperty e = new MsgProperty(text, list);
        this.msgProperties.add(e);
    }

    public String getProblemName() {
        return this.problemName != null ? this.problemName : "";
    }

    public void setProblemName(String name) {
        this.problemName = name != null ? name : "";
    }

    public Iterator customFieldsIterator() {
        if (this.customFields == null) {
            return emptyIterator;
        }
        return this.customFields.keySet().iterator();
    }

    public String getSchoolName() {
        return this.schoolName != null ? this.schoolName : "";
    }

    public void setSchoolName(String name) {
        this.schoolName = name != null ? name : "";
    }

    public String getCourseName() {
        return this.courseName != null ? this.courseName : "";
    }

    public void setCourseName(String name) {
        this.courseName = name != null ? name : "";
    }

    public String getUnitName() {
        return this.unitName != null ? this.unitName : "";
    }

    public void setUnitName(String name) {
        this.unitName = name != null ? name : "";
    }

    public String getSectionName() {
        return this.sectionName != null ? this.sectionName : "";
    }

    public void setSectionName(String name) {
        this.sectionName = name != null ? name : "";
    }

    public Iterator msgPropertiesIterator() {
        if (this.msgProperties == null) {
            return emptyIterator;
        }
        return this.msgProperties.iterator();
    }

    public String getInfo() {
        return this.toString();
    }

    public void setAttemptId(String attemptId) {
        this.attemptId = attemptId;
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getActionId() {
        return this.topElementType;
    }

    public String getInfoType() {
        return INFO_TYPE;
    }

    public static Element stringToElement(String tag, String text) {
        Element result = new Element(tag);
        result.setText(text);
        return result;
    }

    public static void checkElementName(Element elt, String elementName) throws JDOMException {
        if (null == elt) {
            throw new JDOMException("the element is null, expected " + elementName);
        }
        if (!elementName.equals(elt.getName())) {
            throw new JDOMException("the element is invalid, expected " + elementName + " instead of " + elt.getName());
        }
    }

    public static String getElementId(Element elt, String elementName) throws JDOMException {
        if (null == elt) {
            throw new JDOMException("the element is null, expected " + elementName);
        }
        String id = elt.getAttributeValue("id");
        if (null == id) {
            throw new JDOMException("missing id attribute " + id + " for element " + elementName);
        }
        if (id.length() < 1) {
            throw new JDOMException("empty id attibute: " + id + " for element " + elementName);
        }
        return id;
    }

    public static String generateGUID() {
        UID uid = new UID();
        return "DS" + uid.toString();
    }

    private static final class Factory
    implements Iterator {
        private Document doc = null;
        private Iterator iterator;

        private Factory(Reader rdr) throws JDOMException, IOException {
            SAXBuilder builder = new SAXBuilder();
            this.doc = builder.build(rdr);
            Element root = this.doc.getRootElement();
            String name = root.getName();
            if (AuthorActionLog.MSG_SEQUENCE_ELEMENT.equals(name)) {
                this.iterator = root.getChildren().iterator();
            } else if (AuthorActionLog.CURRICULUM_MSG_ELEMENT.equals(name) || AuthorActionLog.MSG_ELEMENT.equals(name)) {
                LinkedList<Element> singleElt = new LinkedList<Element>();
                singleElt.add(root);
                this.iterator = singleElt.iterator();
            } else {
                throw new JDOMException("Bad root element: " + name);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Element msgElt = (Element)this.iterator.next();
            return new AuthorActionLog(msgElt);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove");
        }
    }

    public static final class MsgProperty {
        public static final String ELEMENT = "property";
        public static final String ENTRY_ELEMENT = "entry";
        private String name = null;
        private String stringValue = null;
        private List entries = null;

        private MsgProperty(String name, String value) {
            this.name = name == null ? "" : name;
            this.stringValue = value;
        }

        private MsgProperty(String name, List entries) {
            String string = this.name = name == null ? "" : name;
            if (entries == null) {
                this.stringValue = "";
            } else {
                this.entries = new LinkedList(entries);
            }
        }

        private MsgProperty(Element elt) throws JDOMException {
            AuthorActionLog.checkElementName(elt, "property");
            this.name = elt.getAttributeValue(AuthorActionLog.CUSTOM_FIELD_NAME_ELEMENT);
            Iterator it = elt.getChildren(ENTRY_ELEMENT).iterator();
            if (!it.hasNext()) {
                this.stringValue = elt.getText();
            } else {
                this.entries = new LinkedList();
                do {
                    this.entries.add(((Element)it.next()).getText());
                } while (it.hasNext());
            }
        }

        public Element getElement() {
            Element result = new Element("property");
            result.setAttribute(AuthorActionLog.CUSTOM_FIELD_NAME_ELEMENT, this.name);
            if (this.isList()) {
                Iterator it = this.entries.iterator();
                while (it.hasNext()) {
                    Element e = new Element(ENTRY_ELEMENT);
                    result.addContent((Content)e.setText((String)it.next()));
                }
            } else {
                result.setText(this.stringValue);
            }
            return result;
        }

        public String getName() {
            return this.name;
        }

        public boolean isList() {
            return this.entries != null;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public List getList() {
            return this.entries;
        }
    }
}

