/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.DataShopSampleSplitter;

import edu.cmu.pact.Log.DataShopSampleSplitter.RowIndices;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.rmi.server.UID;

public class DataShopSampleSplitter {
    private static void parseLine(String fileLine, String[] rowInfo) {
        String tab = new String("\t");
        int index = 0;
        int counter = 0;
        while ((index = fileLine.indexOf(tab)) >= 0) {
            rowInfo[counter++] = fileLine.substring(0, index);
            fileLine = fileLine.substring(index + 1);
        }
    }

    public static boolean isTabDelimited(File inf) throws IOException {
        String[] parsedLine;
        String line;
        StringBuffer stringBuffer;
        FileReader fileReader = new FileReader(inf);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        int firstLineTabs = 0;
        if (bufferedReader.ready()) {
            stringBuffer = new StringBuffer(bufferedReader.readLine());
            line = stringBuffer.toString();
            parsedLine = new String[40];
            DataShopSampleSplitter.parseLine(line, parsedLine);
            while (parsedLine[firstLineTabs++] != null) {
            }
        }
        int secondLineTabs = 0;
        if (bufferedReader.ready()) {
            parsedLine = new String[40];
            stringBuffer = new StringBuffer(bufferedReader.readLine());
            line = stringBuffer.toString();
            DataShopSampleSplitter.parseLine(line, parsedLine);
            while (parsedLine[secondLineTabs++] != null) {
            }
        }
        return --firstLineTabs > 5 || --secondLineTabs > 5;
    }

    private static RowIndices getRowIndices(String fileLine) throws IOException {
        String tab = new String("\t");
        String header = new String("");
        int index = 0;
        int counter = 0;
        RowIndices rowIndices = new RowIndices();
        while ((index = fileLine.indexOf(tab)) >= 0) {
            header = fileLine.substring(0, index);
            fileLine = fileLine.substring(index + 1);
            if (new String("Anon Student Id").equals(header)) {
                rowIndices.setUserGuid(counter);
            } else if (new String("Session Id").equals(header)) {
                rowIndices.setSessionID(counter);
            } else if (new String("Time").equals(header)) {
                rowIndices.setDateTime(counter);
            } else if (new String("Time Zone").equals(header)) {
                rowIndices.setTimezone(counter);
            } else if (new String("Student Response Type").equals(header)) {
                rowIndices.setTransactionName(counter);
            } else if (new String("Problem Name").equals(header)) {
                rowIndices.setProblemName(counter);
            } else if (new String("Selection").equals(header)) {
                rowIndices.setSelection(counter);
            } else if (new String("Action").equals(header)) {
                rowIndices.setAction(counter);
            } else if (new String("Input").equals(header)) {
                rowIndices.setInput(counter);
            }
            ++counter;
        }
        return rowIndices;
    }

    private static int getColumnIndex(String fileLine, String column) {
        String tab = new String("\t");
        int index = 0;
        int counter = 0;
        while ((index = fileLine.indexOf(tab)) >= 0) {
            if (fileLine.substring(0, index).equals(column)) {
                return counter;
            }
            fileLine = fileLine.substring(index + 1);
            ++counter;
        }
        return -1;
    }

    public static void breakUpSample(String path, String fileName, String column, boolean separateFolder) throws IOException, FileNotFoundException {
        String tab = new String("\t");
        String fileExt = new String(".txt");
        String[] rowInfo = new String[40];
        FileReader fileReader = new FileReader(path + File.separator + fileName);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String firstLine = new StringBuffer(bufferedReader.readLine()).toString();
        String columnNamesLine = new StringBuffer(bufferedReader.readLine()).toString();
        RowIndices rowIndices = DataShopSampleSplitter.getRowIndices(columnNamesLine);
        int columnIndex = DataShopSampleSplitter.getColumnIndex(columnNamesLine, column);
        String newColumnName = null;
        File outputFile = null;
        OutputStreamWriter fileWriter = null;
        boolean index = false;
        boolean counter = false;
        while (bufferedReader.ready()) {
            StringBuffer stringBuffer = new StringBuffer(bufferedReader.readLine());
            String fileLine = stringBuffer.toString();
            DataShopSampleSplitter.parseLine(fileLine, rowInfo);
            if (!rowInfo[columnIndex].equals(newColumnName)) {
                if (fileWriter != null) {
                    fileWriter.close();
                }
                newColumnName = new String(rowInfo[columnIndex]);
                if (separateFolder) {
                    outputFile = new File(path + File.separator + newColumnName);
                    outputFile.mkdir();
                    outputFile = new File(outputFile.toString(), newColumnName + fileExt);
                } else {
                    outputFile = new File(path + File.separator + newColumnName + fileExt);
                }
                fileWriter = new FileWriter(outputFile);
                fileWriter.write(firstLine + "\n");
                fileWriter.write(columnNamesLine + "\n");
            }
            fileWriter.write(fileLine + "\n");
        }
        bufferedReader.close();
        fileReader.close();
        fileWriter.close();
    }

    private static String getXMLString(RowIndices rowIndices, String[] rowInfo, String contextMessageID) throws IOException {
        String s = new String("");
        s = s.concat("<log_action auth_token=\"\" session_id=\"");
        s = s.concat(rowInfo[rowIndices.getSessionID()]);
        s = s.concat("\" user_guid=\"");
        s = s.concat(rowInfo[rowIndices.getUserGuid()]);
        s = s.concat("\" date_time=\"");
        s = s.concat(rowInfo[rowIndices.getDateTime()]);
        s = s.concat("\" timezone=\"");
        s = s.concat(rowInfo[rowIndices.getTimezone()]);
        s = s.concat("\" action_id=\"tool_message\" source_id=\"PACT_CTAT\" ");
        s = s.concat("external_object_id=\"\" info_type=\"tutor_message.dtd\">");
        s = s.concat("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        s = s.concat("<tutor_related_message_sequence version_number=\"4\">\n");
        s = s.concat("<tool_message context_message_id=\"");
        s = s.concat(contextMessageID);
        s = s.concat("\">\n\t<problem_name>");
        s = s.concat(rowInfo[rowIndices.getProblemName()]);
        s = s.concat("</problem_name>\n\t<semantic_event transaction_id=\"");
        s = s.concat(new UID().toString());
        s = s.concat("\" name=\"");
        s = s.concat(rowInfo[rowIndices.getTransactionName()]);
        s = s.concat("\"/>\n\t<event_descriptor>\n\t\t<selection>");
        s = s.concat(rowInfo[rowIndices.getSelection()]);
        s = s.concat("</selection>\n\t\t<action>");
        s = s.concat(rowInfo[rowIndices.getAction()]);
        s = s.concat("</action>\n\t\t<input>");
        s = s.concat(rowInfo[rowIndices.getInput()]);
        s = s.concat("</input>\n\t</event_descriptor>\n</tool_message>\n");
        s = s.concat("</tutor_related_message_sequence>\n</log_action>\n\n");
        return s;
    }

    public static void convertTabDelimitedToXML(File input, File output) throws IOException {
        String[] rowInfo = new String[40];
        FileReader fileReader = new FileReader(input);
        FileWriter fileWriter = new FileWriter(output);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        StringBuffer stringBuffer = new StringBuffer(bufferedReader.readLine());
        stringBuffer = new StringBuffer(bufferedReader.readLine());
        String fileLine = stringBuffer.toString();
        RowIndices rowIndices = DataShopSampleSplitter.getRowIndices(fileLine);
        String s = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>\n");
        String contextMessageID = null;
        String problemName = null;
        fileWriter.write(s);
        while (bufferedReader.ready()) {
            stringBuffer = new StringBuffer(bufferedReader.readLine());
            fileLine = stringBuffer.toString();
            DataShopSampleSplitter.parseLine(fileLine, rowInfo);
            if (!rowInfo[rowIndices.getProblemName()].equals(problemName)) {
                contextMessageID = new UID().toString();
                problemName = rowInfo[rowIndices.getProblemName()];
            }
            s = DataShopSampleSplitter.getXMLString(rowIndices, rowInfo, contextMessageID);
            fileWriter.write(s);
        }
        s = new String("</root>");
        fileWriter.write(s);
        bufferedReader.close();
        fileReader.close();
        fileWriter.close();
    }

    public static void splitFiles(String folderPath, String columnName, boolean separateFolders) throws IOException {
        String[] folderList = new File(folderPath).list();
        for (int outerIndex = 0; outerIndex < folderList.length; ++outerIndex) {
            String inputFileParentPath = folderPath + File.separator + folderList[outerIndex];
            File inputFileParent = new File(inputFileParentPath);
            if (inputFileParent.isDirectory()) {
                String[] fileList = inputFileParent.list();
                for (int innerIndex = 0; innerIndex < fileList.length; ++innerIndex) {
                    if (!DataShopSampleSplitter.isTabDelimited(new File(inputFileParentPath + File.separator + fileList[innerIndex]))) continue;
                    DataShopSampleSplitter.breakUpSample(inputFileParentPath, fileList[innerIndex], columnName, separateFolders);
                }
                continue;
            }
            if (!DataShopSampleSplitter.isTabDelimited(new File(inputFileParentPath))) continue;
            DataShopSampleSplitter.breakUpSample(folderPath, folderList[outerIndex], columnName, separateFolders);
        }
    }

    public static void main(String[] args) throws IOException {
        String folderPath = System.getProperty("user.home") + File.separator + "Downloads" + File.separator + "CTAT Files" + File.separator + "Parsed Files";
        String columnName = "Problem Name";
        boolean separateFolders = false;
        DataShopSampleSplitter.splitFiles(folderPath, columnName, separateFolders);
    }
}

