/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.SocketProxy;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.Utilities.SocketReader;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionComparator;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import pact.CommWidgets.RemoteToolProxy;
import pact.CommWidgets.StudentInterfaceConnectionStatus;

public class SocketToolProxy
extends RemoteToolProxy {
    private static Set<String> msgTypesToOmitFromStartState = new HashSet<String>();
    private static final Map<String, String> omitMsgIfUIRecent;
    private boolean logOnly = false;
    private String destHost = "localhost";
    private boolean oneMsgPerConnection = false;
    private Socket sock = null;
    private PrintWriter out = null;
    private boolean oneMsgPerSocket = false;
    private boolean connectFirst = false;
    private static final long MAX_WAIT_FOR_SET_PREFERENCES = 1500L;
    private static final long MAX_WAIT_FOR_INTERFACE_DESCRIPTIONS = 2500L;
    private long nTimers = 0L;
    private static final int SET_PREFERENCES_TIMER_INDEX = 0;
    private static final int INTERFACE_DESCRIPTIONS_TIMER_INDEX = 1;
    private Timer[] timers = new Timer[]{null, null};

    public SocketToolProxy(BR_Controller controller) {
        controller.setUniversalToolProxy(this);
        this.controller = controller;
    }

    public void init(Socket sock, int format, int eom, BR_Controller controller) {
        super.init(controller);
        this.sock = sock;
        this.setFormat(format);
        this.setEom(eom);
    }

    public void init(String destHost, int destPort, int format, int eom, boolean oneMsgPerSocket, BR_Controller controller) {
        super.init(controller);
        this.destHost = destHost;
        this.destPort = destPort;
        this.setFormat(format);
        this.setEom(eom);
        this.oneMsgPerSocket = oneMsgPerSocket;
    }

    public void setUseXML(boolean useXML) {
        this.setFormat(1);
    }

    @Override
    public void sendXMLString(String str) {
        try {
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "SocketToolProxy: guid " + SocketProxy.getGuid(this.controller) + " to send " + str);
            }
            if (this.oneMsgPerSocket || this.out == null) {
                this.connect();
            }
            if (this.out == null) {
                if (trace.getDebugCode("sp")) {
                    trace.out("sp", "failed to connect out socket: null stream");
                }
            } else {
                str = SocketToolProxy.insertXMLPrologue(str);
                SocketReader.sendString(str, this.out, this.eom);
                if (trace.getDebugCode("tsltstp")) {
                    trace.outNT("tsltstp", this.getGuid() + " " + str);
                }
                if (this.oneMsgPerSocket) {
                    this.disconnect();
                }
            }
        }
        catch (Exception e) {
            trace.err("SocketToolProxy failed to connect outgoing socket to Tutor Interface: " + e.toString());
        }
    }

    private String getGuid() {
        return SocketProxy.getGuid(this.getController());
    }

    @Override
    protected Object getSocket() {
        try {
            this.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.sock;
    }

    void setSocket(Socket sock) {
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "old socket " + this.sock + ", new socket " + sock);
        }
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        this.out = null;
        if (this.sock != sock) {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.sock = sock;
        if (sock == null) {
            return;
        }
        try {
            this.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recover() {
    }

    private synchronized Socket connect() throws IOException {
        if (this.sock == null && this.getConnectFirst()) {
            InetAddress addr = InetAddress.getByName(this.destHost);
            this.sock = new Socket(addr, this.destPort);
            this.out = null;
        }
        if (this.out == null && this.sock != null) {
            this.out = new PrintWriter(new OutputStreamWriter(this.sock.getOutputStream(), "UTF-8"));
            if (!Utils.isRuntime()) {
                this.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.NewlyConnected);
            }
            this.recover();
        }
        return this.sock;
    }

    private synchronized void disconnect() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        this.out = null;
        if (this.sock != null) {
            this.sock.close();
        }
        this.sock = null;
        if (!Utils.isRuntime()) {
            this.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.Disconnected);
        }
    }

    public void setLogOnly(boolean logOnly) {
        this.logOnly = logOnly;
    }

    public boolean getLogOnly() {
        return this.logOnly;
    }

    @Override
    public void handleMessage(MessageObject o) {
        super.handleMessage(o);
        this.sendToTee(this.convertMsgToString(o, this.teeFormat));
    }

    @Override
    protected String createMessageString(MessageObject o, boolean pssOverride) {
        String toSend = super.createMessageString(o, pssOverride);
        if (this.logOnly) {
            System.out.println("SocketToolProxy.handleCommMessage():\n" + toSend);
            return null;
        }
        return toSend;
    }

    private String convertMsgToString(MessageObject o, int format) {
        String msgType = o.getMessageType();
        String toSend = null;
        if (format == 1) {
            toSend = o.toString();
            toSend = toSend.replace('\n', ' ');
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "XML-ized msg, type " + msgType + ":\n" + toSend);
            }
        } else if (format == 2) {
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "OLI XML-ized msg, type " + msgType + ":\n" + toSend);
            }
        } else {
            toSend = null;
        }
        return toSend;
    }

    boolean getConnectFirst() {
        return this.connectFirst;
    }

    void setConnectFirst(boolean connectFirst) {
        this.connectFirst = connectFirst;
    }

    public void rebootStartState(boolean startStateLock) {
        MessageObject mo = MessageObject.create("InterfaceReboot");
        this.handleMessage(mo);
    }

    @Override
    public void setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus sics) {
        if (!sics.isConnected()) {
            this.awaitSetPreferences(false);
        }
        super.setStudentInterfaceConnectionStatus(sics);
    }

    @Override
    protected boolean suppressMsgFromInterface(MessageObject o) {
        if (super.suppressMsgFromInterface(o)) {
            return true;
        }
        boolean result = false;
        String msgType = o.getMessageType();
        if (msgType == null) {
            trace.err("RTP.suppressMsgFromInterface(): no MessageType in message.\n  " + o);
            result = false;
        } else {
            String omitIfVersion = omitMsgIfUIRecent.get(msgType.toLowerCase());
            if (omitIfVersion == null) {
                result = false;
            } else {
                String uiVersion = this.getController().getCommShellVersion();
                if (uiVersion == null) {
                    return false;
                }
                boolean bl = result = VersionComparator.vc.compare(omitIfVersion, uiVersion) <= 0;
            }
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", "*! RTP.suppressMsgFromInterface(): to " + (result ? "suppress" : "send") + " " + msgType);
            }
        }
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "RTP.suppressMsgFromInterface(" + msgType + ") returns " + result);
        }
        return result;
    }

    private synchronized void setWaitForIncomingMsgs(long ms, final int t, final Runnable runUponTimeout) {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", String.format("STP.setWaitForIncomingMsgs(%d, %d, %s) timers [%s,%s]", ms, t, trace.nh(runUponTimeout), trace.nh(this.timers[0]), trace.nh(this.timers[1])));
        }
        if (this.timers[t] != null) {
            this.timers[t].cancel();
        }
        this.timers[t] = null;
        if (ms <= 0L) {
            return;
        }
        this.timers[t] = new Timer(++this.nTimers + "STP.timer@" + this.hashCode() + "_" + this.getGuid(), true);
        TimerTask task = new TimerTask(){
            private Timer myTimer;
            {
                this.myTimer = SocketToolProxy.this.timers[t];
            }

            @Override
            public void run() {
                if (this.myTimer != SocketToolProxy.this.timers[t]) {
                    return;
                }
                SocketToolProxy.this.timers[t].cancel();
                ((SocketToolProxy)SocketToolProxy.this).timers[t] = null;
                runUponTimeout.run();
            }
        };
        this.timers[t].schedule(task, ms);
    }

    @Override
    public void awaitSetPreferences(boolean begin) {
        if (Utils.isRuntime()) {
            return;
        }
        this.setWaitForIncomingMsgs(begin ? 1500L : -1L, 0, new Runnable(){

            @Override
            public void run() {
                SocketToolProxy.this.getController().goToStartState(true, true);
            }
        });
    }

    @Override
    public void awaitInterfaceDescriptions(boolean begin) {
        if (Utils.isRuntime()) {
            return;
        }
        this.setWaitForIncomingMsgs(begin ? 2500L : -1L, 1, new Runnable(){

            @Override
            public void run() {
                SocketToolProxy.this.fireStartStateEvent(SocketToolProxy.this.getStartStateModel());
            }
        });
    }

    static {
        msgTypesToOmitFromStartState.add("InterfaceIdentification".toLowerCase());
        msgTypesToOmitFromStartState.add("SetPreferences".toLowerCase());
        msgTypesToOmitFromStartState.add("ResetAction".toLowerCase());
        omitMsgIfUIRecent = new LinkedHashMap<String, String>();
        String[][] typesToOmit = new String[][]{{"StartProblem".toLowerCase(), "3.3"}};
        int i = 0;
        for (String[] typeVersion : typesToOmit) {
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("omitMsgIfUIRecent[%2d] %-20s => %s\n", i++, typeVersion[0], typeVersion[1]));
            }
            omitMsgIfUIRecent.put(typeVersion[0], typeVersion[1]);
        }
    }
}

