/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.pact.TutoringService.RequestHandler;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.trace;
import org.jdom.Content;
import org.jdom.Element;

public class SessionRequest
extends RequestHandler {
    private TSLauncherServer ls;
    public static final String NAME = "session";

    public SessionRequest(TSLauncherServer ls) {
        this.ls = ls;
    }

    @Override
    protected SessionRequest clone() throws CloneNotSupportedException {
        this.debug("clone ()");
        return (SessionRequest)super.clone();
    }

    @Override
    public Element handleRequest(Element req) {
        this.debug("handleRequest (Element)");
        Element resp = new Element(NAME);
        String guid = req.getAttributeValue("guid");
        if (guid == null || guid.length() < 1) {
            resp.setAttribute("guid", guid == null ? "null" : guid);
            resp.setAttribute("result", "error: null or empty guid");
            return resp;
        }
        resp.setAttribute("guid", guid);
        String cmd = req.getAttributeValue("cmd");
        if ("remove".equalsIgnoreCase(cmd)) {
            String result;
            String string = result = this.ls.removeSession(guid) ? "removed" : "not found";
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "SessionRequest.handleRequest() guid " + guid + ", result " + result);
            }
            resp.setAttribute("result", result);
        } else if ("detail".equalsIgnoreCase(cmd)) {
            Element sessElt = this.ls.generateSessionElement(guid);
            if (sessElt != null) {
                resp.addContent((Content)sessElt);
            } else {
                String errMsg = "null session object for guid " + guid;
                trace.err(errMsg);
                resp.setAttribute("result", errMsg);
            }
        } else {
            resp.setAttribute("result", "error: unknown cmd " + cmd);
        }
        return resp;
    }
}

