/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import Networking.ntp.NTPUDPClient;
import Networking.ntp.TimeInfo;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.Utilities.trace;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NtpClient
extends Thread
implements ExitableServer {
    public static final String REFRESH_INTERVAL_PROPERTY = "NtpClient.RefreshInterval";
    public static final String NTP_SERVER_PROPERTY = "NtpClient.NtpServer";
    private static final int DEFAULT_REFRESH_INTERVAL_SECS = 1800;
    private static final int DEFAULT_TEST_REFRESH_COUNT = 4;
    private static String DEFAULT_NTP_SERVER = "3.north-america.pool.ntp.org";
    private String ntpServer = DEFAULT_NTP_SERVER;
    private TimeInfo lastTimeInfo = null;
    private Date lastTimeInfoAsOf = null;
    private String lastTimeInfoServer = null;
    private int refreshInterval = 1800;
    private boolean quitting = false;
    private Thread myThread;
    private volatile boolean nowExiting;

    public Date getNTPDate() {
        return this.getNTPDate(new Date(), null);
    }

    public Date getNTPDate(String[] ntpServer) {
        return this.getNTPDate(new Date(), ntpServer);
    }

    public Date getNTPDate(Date dateToAdjust, String[] ntpServer) {
        return new Date(dateToAdjust.getTime() + this.getTimeOffset(ntpServer));
    }

    public long getNTPTime() {
        return this.getNTPTime(System.currentTimeMillis(), null);
    }

    public long getNTPTime(long timeToAdjustMillis, String[] ntpServer) {
        return timeToAdjustMillis + this.getTimeOffset(ntpServer);
    }

    public long getTimeOffset() {
        return this.getTimeOffset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeOffset(String[] ntpServer) {
        TimeInfo info = null;
        long asOf = -1L;
        long offset = 0L;
        NtpClient ntpClient = this;
        synchronized (ntpClient) {
            info = this.lastTimeInfo;
            if (info != null) {
                offset = info.getOffset();
                if (this.lastTimeInfoAsOf != null) {
                    asOf = this.lastTimeInfoAsOf.getTime();
                }
                if (ntpServer != null && ntpServer.length > 0) {
                    ntpServer[0] = this.lastTimeInfoServer;
                }
            }
        }
        if (info == null) {
            trace.err("Null TimeInfo from server " + this.getNtpServer());
        }
        long d = System.currentTimeMillis() - asOf;
        if (asOf >= 0L && d > (long)this.getRefreshInterval()) {
            trace.err("TimeInfo from server " + this.getNtpServer() + " is " + d / 1000L + "." + d % 1000L + " secs old; refresh interval is " + this.getRefreshInterval() + " secs");
        }
        return offset;
    }

    public Long getDelay() {
        TimeInfo info = this.lastTimeInfo;
        if (info == null) {
            return null;
        }
        return info.getDelay();
    }

    private boolean refreshTimeInfo() {
        String ntpServer = this.getNtpServer();
        if (this.refreshTimeInfo(ntpServer)) {
            return true;
        }
        if (this.ntpServer != null && !this.ntpServer.equalsIgnoreCase(ntpServer) && this.refreshTimeInfo(ntpServer = this.ntpServer)) {
            return true;
        }
        if (!DEFAULT_NTP_SERVER.equalsIgnoreCase(ntpServer)) {
            ntpServer = DEFAULT_NTP_SERVER;
            return this.refreshTimeInfo(ntpServer);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean refreshTimeInfo(String ntpServer) {
        InetAddress hostAddr = null;
        NTPUDPClient ntpClient = null;
        TimeInfo info = null;
        try {
            ntpClient = new NTPUDPClient();
            ntpClient.setDefaultTimeout(10000);
            ntpClient.open();
            hostAddr = InetAddress.getByName(ntpServer);
            info = ntpClient.getTime(hostAddr);
            info.computeDetails();
            NtpClient ntpClient2 = this;
            synchronized (ntpClient2) {
                this.lastTimeInfo = info;
                this.lastTimeInfoAsOf = new Date();
                this.lastTimeInfoServer = ntpServer;
            }
        }
        catch (Throwable e) {
            try {
                trace.errStack("Error retrieving time from server " + ntpServer + " (IP: " + hostAddr + "):" + e + (e.getCause() == null ? "" : "; cause " + e.getCause().toString()), e);
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    ntpClient.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            ntpClient.close();
        }
        catch (Exception exception) {}
        if (!trace.getDebugCode("ntp")) return true;
        if (info != null) return true;
        if (!trace.getDebugCode("ntp")) {
            if (!trace.getDebugCode("ntp")) return true;
            trace.outNT("ntp", "NtpClient timeInfo offset " + info.getOffset() + ", delay " + info.getDelay() + ", comments " + info.getComments());
            return true;
        }
        trace.outNT("ntp", "NtpClient timeInfo null");
        return true;
    }

    public String getNtpServer() {
        String prop = System.getProperty(NTP_SERVER_PROPERTY);
        if (prop != null && prop.length() > 0) {
            return prop;
        }
        return this.ntpServer;
    }

    public void setNtpServer(String ntpServer) {
        this.ntpServer = ntpServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.myThread = Thread.currentThread();
        while (!this.quitting) {
            this.refreshTimeInfo();
            NtpClient ntpClient = this;
            synchronized (ntpClient) {
                this.notifyAll();
            }
            try {
                if (this.quitting) continue;
                NtpClient.sleep(this.getRefreshInterval());
            }
            catch (InterruptedException e) {
                if (this.quitting) continue;
                trace.err("NtpClient interrupted: " + e + (e.getCause() == null ? "" : "; cause " + e.getCause().toString()));
            }
        }
    }

    public void quit() {
        this.quitting = true;
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
    }

    private static void usageExit(String[] args, int i, Throwable e) {
        System.out.printf("Error in command-line argument %d \"%s\": %s.\nUsage:\n    NtpClient [-h hostname] [-t timer] [-n count] [-c]\nwhere--\n    hostname is the NTP server (default %s);\n    timer is the refresh interval in seconds (default %d);\n    count is the number of refreshes to wait for (default %d);\n    -c means run until count refreshes have occurred.\n", i, args.length <= i ? "(range error)" : args[i], e == null ? "null" : e.toString(), DEFAULT_NTP_SERVER, 1800, 4);
        System.exit(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        int i;
        NtpClient nc = new NtpClient();
        boolean continuous = false;
        int nRefreshes = 4;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            try {
                char c = args[i].charAt(1);
                switch (c) {
                    case 'H': 
                    case 'h': {
                        nc.setNtpServer(args[++i]);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        nc.setRefreshInterval(Integer.parseInt(args[++i]));
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        nRefreshes = Integer.parseInt(args[++i]);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        continuous = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown command-line option " + c);
                    }
                }
                continue;
            }
            catch (Exception e) {
                NtpClient.usageExit(args, i, e);
            }
        }
        if (!continuous) {
            nc.refreshTimeInfo();
            NtpClient.testClient(nc);
            return;
        }
        nc.start();
        for (i = 0; i < nRefreshes; ++i) {
            NtpClient ntpClient = nc;
            synchronized (ntpClient) {
                nc.wait();
            }
            NtpClient.testClient(nc);
        }
        System.out.printf("Thread state before quit:      %s.\n", nc.getState().toString());
        nc.quit();
        NtpClient.sleep(1000L);
        System.out.printf("Thread state 1 sec after quit: %s.\n", nc.getState().toString());
    }

    private static void testClient(NtpClient nc) {
        String[] ntpServer = new String[1];
        Date localNow = new Date();
        Date ntpNow = nc.getNTPDate(localNow, ntpServer);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ZZZ");
        System.out.printf("%6s = %s from %s\n%6s = %s, delta %d ms, delay %d\n", "NTP", df.format(ntpNow), ntpServer[0], "local", df.format(localNow), ntpNow.getTime() - localNow.getTime(), nc.getDelay());
    }

    public int getRefreshInterval() {
        try {
            int result = Integer.parseInt(System.getProperty(REFRESH_INTERVAL_PROPERTY));
            return result * 1000;
        }
        catch (Exception e) {
            return this.refreshInterval * 1000;
        }
    }

    public void setRefreshInterval(int refreshIntervalSecs) {
        this.refreshInterval = refreshIntervalSecs;
    }

    public synchronized String getLastTimeInfoServer() {
        return this.lastTimeInfoServer;
    }

    @Override
    public boolean isExiting() {
        return this.nowExiting;
    }

    @Override
    public boolean startExiting() {
        boolean result = this.nowExiting;
        this.nowExiting = true;
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "NtpClient.startExiting(): previous nowExiting " + result + "; to quit()");
        }
        this.quit();
        return result;
    }
}

