/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ScanBRD {
    private Map<String, Link> fixedLinkMap;
    private Map<String, Link> linkMap;
    private boolean showHeadings = false;
    private String label = null;

    public ScanBRD(File brd0, File brd, boolean showHeadings) throws Exception {
        this.fixedLinkMap = this.buildLinkMap(brd0);
        this.linkMap = this.buildLinkMap(brd);
        this.showHeadings = showHeadings;
    }

    public String countLinksOverTraversalThreshold(int traversalThreshold) {
        int totalLinks = 0;
        int addedLinks = 0;
        int traversedLinks = 0;
        StringWriter sResult = new StringWriter();
        PrintWriter result = new PrintWriter(sResult);
        if (this.showHeadings) {
            this.printLabelLabel(result);
            result.printf("%5s\t%5s\t%9s\n", "total", "added", "traversed");
        }
        for (Link link : this.linkMap.values()) {
            ++totalLinks;
            String name = link.getName();
            if (this.fixedLinkMap.get(name) != null) continue;
            ++addedLinks;
            if (link.getTraversalCount() < traversalThreshold) continue;
            ++traversedLinks;
        }
        this.printLabel(result);
        result.printf("%5d\t%5d\t%9d\n", totalLinks, addedLinks, traversedLinks);
        return sResult.toString();
    }

    private void printLabel(PrintWriter pw) {
        if (this.label != null) {
            pw.printf("%s\t", this.label);
        }
    }

    private void printLabelLabel(PrintWriter pw) {
        if (this.label != null) {
            pw.printf("%." + this.label.length() + "s\t", "label");
        }
    }

    public String traversalCounts() {
        StringWriter sResult = new StringWriter();
        PrintWriter result = new PrintWriter(sResult);
        if (this.showHeadings) {
            this.printLabelLabel(result);
            result.printf("%5s\t%-50s\t%10s\n", "ID", "Selection,Action,Input", "traversals");
        }
        for (Link link : this.linkMap.values()) {
            this.printLabel(result);
            result.printf("%5s\t%-50.50s\t%10d\n", link.getName(), link.getSai(), link.getTraversalCount());
        }
        return sResult.toString();
    }

    private Map<String, Link> buildLinkMap(File brd0) throws IOException, JDOMException {
        Document doc = this.getDoc(brd0);
        Element root = doc.getRootElement();
        LinkedHashMap<String, Link> result = new LinkedHashMap<String, Link>();
        int i = 0;
        for (Object obj : root.getChildren("edge")) {
            Element elt = (Element)obj;
            Link link = new Link(elt, i);
            result.put(link.getName(), link);
            ++i;
        }
        return result;
    }

    private Document getDoc(File brd) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(brd);
        return doc;
    }

    public static void main(String[] args) {
        int i;
        boolean showHeadings = false;
        int traversalThreshold = -1;
        boolean traversalCounts = false;
        String label = null;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if ("showHeadings".equalsIgnoreCase(args[i].substring(1))) {
                showHeadings = true;
                continue;
            }
            if ("traversalCounts".equalsIgnoreCase(args[i].substring(1))) {
                traversalCounts = true;
                continue;
            }
            if ("traversalThreshold".equalsIgnoreCase(args[i].substring(1))) {
                if (++i >= args.length) {
                    ScanBRD.usageExit("Missing traversalThreshold", 2);
                }
                try {
                    traversalThreshold = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException nfe) {
                    ScanBRD.usageExit("Non-numeric traversalThreshold: " + nfe, 2);
                }
                continue;
            }
            if (!"label".equalsIgnoreCase(args[i].substring(1))) continue;
            if (++i >= args.length) {
                ScanBRD.usageExit("Missing label", 2);
            }
            label = args[i];
        }
        if (args.length < i + 2 || args[i].length() < 1 || args[i + 1].length() < 1) {
            ScanBRD.usageExit("Too few filenames", 2);
        }
        try {
            File brd0 = new File(args[i++]);
            File brd = new File(args[i++]);
            ScanBRD s = new ScanBRD(brd0, brd, showHeadings);
            if (label != null) {
                s.setLabel(label);
            }
            if (traversalThreshold > -1) {
                System.out.print(s.countLinksOverTraversalThreshold(traversalThreshold));
            }
            if (traversalCounts) {
                System.out.print(s.traversalCounts());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ScanBRD.usageExit(e.toString(), 2);
        }
    }

    private static int usageExit(String errMsg, int exitStatus) {
        if (errMsg != null && errMsg.length() > 0) {
            System.err.print(errMsg + ". ");
        }
        System.err.println("\nUsage: java ScanBRD [-showHeadings] [-label \"label\"] [-traversalThreshold T] [-traversalCounts] brd0 brd\nwhere\n   showHeadings means print column headings\n   traversalCounds means print traversal count for each link\n   label is a string to prefix to each line of output\n   T = is the minimum number of traversals to retain;\n   brd0 = initial BRD with content to ignore;\n   brd  = current BRD to analyze.\n");
        System.exit(exitStatus);
        return exitStatus;
    }

    private String getLabel() {
        return this.label;
    }

    private void setLabel(String label) {
        this.label = label;
    }

    private class Link {
        private final String name;
        private String sai = "";
        private int traversalCount;

        Link(Element elt, int serialNo) {
            Element actionLabel = elt.getChild("actionLabel");
            if (actionLabel == null) {
                throw new IllegalArgumentException("actionLabel missing on link " + serialNo);
            }
            this.name = actionLabel.getChildText("uniqueID");
            if (this.name == null) {
                throw new IllegalArgumentException("uniqueID missing on link " + serialNo);
            }
            Element matcher = actionLabel.getChild("matcher");
            StringBuffer sb = new StringBuffer();
            for (Object mpElt : matcher.getChildren("matcherParameter")) {
                sb.append(", ").append(((Element)mpElt).getTextTrim());
            }
            this.sai = sb.substring(2);
            String traversalCount = elt.getChildText("traversalCount");
            this.traversalCount = traversalCount == null ? 0 : Integer.parseInt(traversalCount);
        }

        public String getName() {
            return this.name;
        }

        private int getTraversalCount() {
            return this.traversalCount;
        }

        public String toString() {
            return "[" + this.name + ": traversalCount " + this.traversalCount + "]";
        }

        private String getSai() {
            return this.sai;
        }
    }
}

