/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class StringTransferable
implements Transferable,
ClipboardOwner {
    public static final DataFlavor plainTextFlavor = DataFlavor.plainTextFlavor;
    public static final DataFlavor localStringFlavor = DataFlavor.stringFlavor;
    public static final DataFlavor[] flavors = new DataFlavor[]{plainTextFlavor, localStringFlavor};
    private static final List flavorList = Arrays.asList(flavors);
    private String string;

    public StringTransferable(String string) {
        this.string = string;
    }

    private void dumpFlavor(DataFlavor flavor) {
        System.out.println("getMimeType " + flavor.getMimeType());
        System.out.println("getHumanPresentableName " + flavor.getHumanPresentableName());
        System.out.println("getRepresentationClass " + flavor.getRepresentationClass().getName());
        System.out.println("isMimeTypeSerializedObject " + flavor.isMimeTypeSerializedObject());
        System.out.println("isRepresentationClassInputStream " + flavor.isRepresentationClassInputStream());
        System.out.println("isRepresentationClassSerializable " + flavor.isRepresentationClassSerializable());
        System.out.println("isRepresentationClassRemote " + flavor.isRepresentationClassRemote());
        System.out.println("isFlavorSerializedObjectType " + flavor.isFlavorSerializedObjectType());
        System.out.println("isFlavorRemoteObjectType " + flavor.isFlavorRemoteObjectType());
        System.out.println("isFlavorJavaFileListType " + flavor.isFlavorJavaFileListType());
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavorList.contains(flavor);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        System.err.println("getTransferData(): ");
        this.dumpFlavor(flavor);
        if (flavor.equals(plainTextFlavor)) {
            return new ByteArrayInputStream(this.string.getBytes("Unicode"));
        }
        if (localStringFlavor.equals(flavor)) {
            return this.string;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public String toString() {
        return "StringTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        System.out.println("StringTransferable lost ownership of " + clipboard.getName());
        System.out.println("data: " + contents);
    }
}

