/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class WindowUtils {
    private static final int CENTER = 0;
    private static final int RIGHT = 1;
    private static final int LEFT = 2;

    public static JPanel justify(JComponent component, boolean right) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)component, right ? "East" : "West");
        return p;
    }

    public static JPanel wrap(List components, int pad, int location) {
        JPanel p = new JPanel();
        Box b = new Box(0);
        if (location == 1) {
            b.add(Box.createHorizontalStrut(pad));
        }
        for (Object o : components) {
            Component c = o instanceof String ? new JLabel((String)o) : (Component)o;
            b.add(c);
            b.add(Box.createHorizontalStrut(3));
        }
        if (location == 1) {
            p.setLayout(new BorderLayout());
            p.add((Component)b, "East");
        } else if (location == 0) {
            p.setLayout(new FlowLayout());
            p.add(b);
        } else if (location == 2) {
            p.setLayout(new BorderLayout());
            p.add((Component)b, "West");
        }
        return p;
    }

    public static Component wrapCenter(List l) {
        return WindowUtils.wrap(l, 0, 0);
    }

    public static Component wrapCenter(JComponent c) {
        ArrayList<JComponent> l = new ArrayList<JComponent>();
        l.add(c);
        return WindowUtils.wrapCenter(l);
    }

    public static JPanel wrapRight(JComponent component) {
        return WindowUtils.wrapRight(component, 0);
    }

    public static Component wrapRight(String label) {
        return WindowUtils.wrapRight(new JLabel(label), 0);
    }

    public static Component wrapRight(String label, int padRight) {
        return WindowUtils.wrapRight(new JLabel(label), padRight);
    }

    public static JPanel wrapRight(JComponent component, int padRight) {
        ArrayList<JComponent> l = new ArrayList<JComponent>();
        l.add(component);
        return WindowUtils.wrapRight(l, padRight);
    }

    public static Component wrapRight(List components) {
        return WindowUtils.wrapRight(components, 0);
    }

    public static JPanel wrapRight(List components, int padRight) {
        return WindowUtils.wrap(components, padRight, 1);
    }

    public static JPanel wrapLeft(JComponent component) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(component);
        return WindowUtils.wrapLeft(list);
    }

    public static void setNativeLookAndFeel() {
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JPanel wrapLeft(List components) {
        JPanel p = WindowUtils.wrap(components, 0, 2);
        p.setAlignmentX(0.0f);
        return p;
    }
}

