/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.SocketProxy.ActionHandler;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MsgType;
import edu.cmu.pact.ctat.TutorController;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pact.CommWidgets.UniversalToolProxy;

public class CommTimer
extends Timer
implements ExitableServer,
Cloneable {
    private static volatile int id = 0;
    private volatile Date exitTime = null;
    private ActionHandler actionHandler;
    private TutorController controller;
    public static final Pattern timerNamePattern = Pattern.compile("_CTATTimer_([0-9]+)_[_0-9a-z]+", 2);
    public static final String SET_TIMEOUT_ACTION = "setTimeout";
    public static final String CLEAR_TIMEOUT_ACTION = "clearTimeout";
    public static final String TIME_EXPIRED_ACTION = "timeExpired";
    private Map<String, CommTimerTask> timerMap = new LinkedHashMap<String, CommTimerTask>();

    public CommTimer(String sessionID, ActionHandler actionHandler) {
        super("CommTimer_" + sessionID + "_" + ++id, false);
        this.actionHandler = actionHandler;
        this.controller = null;
    }

    public CommTimer(String sessionID, TutorController controller) {
        this(sessionID, (ActionHandler)null);
        this.controller = controller;
    }

    @Override
    public synchronized boolean isExiting() {
        return this.exitTime != null;
    }

    @Override
    public synchronized boolean startExiting() {
        boolean result = this.isExiting();
        this.exitTime = new Date();
        this.cancel();
        this.purge();
        return result;
    }

    public static boolean isTimerMessage(MessageObject msg) {
        boolean result;
        String msgType;
        if (msg == null || (msgType = msg.getMessageType()) == null) {
            result = false;
        } else if (msgType.equalsIgnoreCase("AssociatedRules") || MsgType.hasTextFeedback(msg)) {
            result = false;
        } else {
            boolean bl = result = CommTimer.getSelection(msg) != null;
        }
        if (trace.getDebugCode("timer")) {
            trace.out("timer", "CT.isTimerMessage(" + msg.summary() + ") => " + result);
        }
        return result;
    }

    private static String getSelection(MessageObject msg) {
        String selection = msg.getSelection0();
        if (selection == null) {
            return null;
        }
        Matcher m = timerNamePattern.matcher(selection);
        if (trace.getDebugCode("timer")) {
            trace.out("timer", "CT.getSelection(" + msg.summary() + ") matcher " + m);
        }
        return m.matches() ? selection : null;
    }

    public synchronized CommTimer reset(MessageObject msg) {
        String selection;
        if (trace.getDebugCode("timer")) {
            trace.out("timer", "CT.reset(" + msg.summary() + ")");
        }
        if ((selection = msg.getSelection0()) == null) {
            return this;
        }
        for (CommTimerTask ctt : this.timerMap.values()) {
            if (!ctt.matches(selection)) continue;
            this.replace(ctt);
        }
        return this;
    }

    private synchronized void replace(CommTimerTask ctt) {
        CommTimerTask newCtt = ctt.clone();
        this.timerMap.put(newCtt.name.toLowerCase(), newCtt);
        boolean wasActive = ctt.cancel();
        this.schedule((TimerTask)newCtt, newCtt.duration);
        if (trace.getDebugCode("timer")) {
            trace.out("timer", "CT.replace() wasActive " + wasActive + ", newCtt " + newCtt + ";\n  timerMap " + this.timerMap);
        }
    }

    public synchronized CommTimer process(MessageObject msg) {
        String msgType;
        String selection = CommTimer.getSelection(msg);
        if (selection == null) {
            return this;
        }
        if (msg == null || (msgType = msg.getMessageType()) == null) {
            return this;
        }
        if (!msgType.equalsIgnoreCase("InterfaceAction") && !msgType.equalsIgnoreCase("UntutoredAction")) {
            return this;
        }
        String action = msg.getAction0();
        String[] revisedAction = new String[1];
        int delay = UniversalToolProxy.isDelayedAction(action, revisedAction);
        if (trace.getDebugCode("timer")) {
            trace.out("timer", "CT.process() selection " + selection + ", action " + action + ", delay " + delay);
        }
        CommTimerTask ctt = this.timerMap.get(selection.toLowerCase());
        if (revisedAction[0].equalsIgnoreCase(CLEAR_TIMEOUT_ACTION)) {
            this.remove(ctt, true);
        } else if (revisedAction[0].equalsIgnoreCase(SET_TIMEOUT_ACTION)) {
            String regex = msg.getInput0();
            if (ctt != null) {
                this.remove(ctt, false);
                if (delay <= 0) {
                    delay = ctt.duration;
                }
                if (regex == null || regex.trim().length() < 1) {
                    regex = ctt.selectionPattern.pattern();
                }
            }
            CommTimerTask newCtt = new CommTimerTask(selection, delay, regex);
            this.add(newCtt);
            this.schedule((TimerTask)newCtt, delay);
        } else if (revisedAction[0].equalsIgnoreCase(TIME_EXPIRED_ACTION)) {
            if (trace.getDebugCode("timer")) {
                trace.out("timer", "CT.process(): action timeExpired no-op on receipt");
            }
        } else {
            trace.err("CommTimer.process(): Undefined action " + action + "; msg:\n  " + msg);
        }
        return this.isExiting() ? null : this;
    }

    private synchronized void add(CommTimerTask ctt) {
        this.timerMap.put(ctt.name.toLowerCase(), ctt);
    }

    private synchronized void remove(CommTimerTask ctt, boolean shouldExit) {
        CommTimerTask remCtt = null;
        boolean wasActive = false;
        if (ctt != null) {
            wasActive = ctt.cancel();
            remCtt = this.timerMap.remove(ctt.name.toLowerCase());
        }
        if (remCtt != ctt) {
            trace.err("CommTimer.remove(" + ctt + ") wasActive " + wasActive + ", CTT not match entry from map " + remCtt + ";\n  timerMap " + this.timerMap);
        }
        if (trace.getDebugCode("timer")) {
            trace.out("timer", "CommTimer.remove(" + ctt + ") wasActive " + wasActive + ", succeeded; results:\n  timerMap " + this.timerMap);
        }
        if (shouldExit && this.timerMap.isEmpty()) {
            this.startExiting();
        }
    }

    class CommTimerTask
    extends TimerTask
    implements Comparable<CommTimerTask> {
        private String name = null;
        private int duration = 0;
        private boolean active = true;
        private int rank = -1;
        private Pattern selectionPattern;

        CommTimerTask(String name, int duration, String selectionRegex) {
            this.name = name;
            this.duration = duration;
            Matcher m = timerNamePattern.matcher(name);
            if (!m.matches()) {
                throw new IllegalArgumentException("name " + name + " fails to match timerNamePattern; matcher " + m);
            }
            this.rank = Integer.valueOf(m.group(1));
            this.selectionPattern = Pattern.compile(selectionRegex, 2);
        }

        private CommTimerTask() {
        }

        protected CommTimerTask clone() {
            CommTimerTask newCtt = new CommTimerTask();
            newCtt.name = this.name;
            newCtt.duration = this.duration;
            newCtt.rank = this.rank;
            newCtt.selectionPattern = this.selectionPattern;
            return newCtt;
        }

        public boolean matches(String selection) {
            return this.selectionPattern.matcher(selection).matches();
        }

        public String toString() {
            return "CommTimerTask[" + this.name + "] active " + this.active + ", " + this.duration + " ms";
        }

        @Override
        public synchronized void run() {
            if (trace.getDebugCode("timer")) {
                trace.out("timer", "CT.CTT.run(): " + this);
            }
            if (!this.active) {
                return;
            }
            CommTimer.this.remove(this, true);
            MessageObject msg = PseudoTutorMessageBuilder.buildInterfaceAction(PseudoTutorMessageBuilder.s2v(this.name), PseudoTutorMessageBuilder.s2v(CommTimer.TIME_EXPIRED_ACTION), PseudoTutorMessageBuilder.s2v(Integer.toString(this.duration)), null, null, MessageObject.makeTransactionId(), true);
            if (CommTimer.this.actionHandler != null) {
                CommTimer.this.actionHandler.enqueue(msg);
            } else {
                CommTimer.this.controller.handleCommMessage(msg);
            }
        }

        @Override
        public synchronized boolean cancel() {
            this.active = false;
            return super.cancel();
        }

        @Override
        public int compareTo(CommTimerTask o) {
            return Integer.compare(this.rank, o.rank);
        }
    }
}

