/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctatview;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeListener;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SkillsConsoleDialog;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorException;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorManager;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemSetWizard.CTATProblemSetWizard;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATStartStateEditor;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.BehaviorRecorder.View.GraphInspector.GroupEditor;
import edu.cmu.pact.BehaviorRecorder.View.VariableViewer.VariableViewer;
import edu.cmu.pact.Log.AuthorLogListener;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.CtatFrame;
import edu.cmu.pact.ctatview.CtatviewException;
import edu.cmu.pact.ctatview.DockGraphWindowAdapter;
import edu.cmu.pact.ctatview.DockWindowAdapter;
import edu.cmu.pact.ctatview.GraphEditorDefaultPanel;
import edu.cmu.pact.jess.JessConsolePanel;
import edu.cmu.pact.jess.RuleActivationTreePanel;
import edu.cmu.pact.jess.WMEEditorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewMap;
import pact.CommWidgets.StudentInterfaceConnectionStatus;

public class DockManager
extends CTATBase {
    private static final String SIM_STUDENT_PERSPECTIVE = "simStudentPerspective.bin";
    private static final String JESS_PERSPECTIVE = "jessPerspective.bin";
    private static final String EXAMPLE_TRACING_PERSPECTIVE = "exampleTracingPerspective.bin";
    private static final String TDK_PERSPECTIVE = "tdkPerspective.bin";
    private static final String LISTEN_REPLAY_PERSPECTIVE = "listenReplayPerspective.bin";
    private static final String USER_PERSPECTIVE_DIR = System.getProperty("user.home") + File.separatorChar + ".ctat";
    private static final String DEFAULT_PERSPECTIVE_DIR = "perspectives";
    RootWindow rootWindow;
    ViewMap viewMap = new ViewMap();
    ViewMap graphViewMap = new ViewMap();
    private RootWindow graphEditorRootWindow;
    private View graphPlaceholderView;
    private boolean graphPlaceholderAdded = false;
    CtatFrame ctatFrame;
    private int LastViewCount = 0;
    private static final int CONFLICT_TREE = 1;
    private static final int JESS_CONSOLE = 2;
    private static final int WME_EDITOR = 3;
    private static final int GROUP_EDITOR = 4;
    private static final int VARIABLE_VIEWER = 5;
    private static final int SKILLS_CONSOLE = 6;
    private static final int SS_EDITOR = 7;
    private static final int PSD_WIZARD = 8;
    private static final int DYNAMIC_VIEW_MIN_ID = 9;
    private static final int MAX_DYNAMIC_VIEWS = 3;
    private static final int SIM_STUDENT = 12;
    private static final int GRAPH_EDITOR = 13;
    private Map<DockingWindow, Integer> menuIdMap = new HashMap<DockingWindow, Integer>();
    private int currentGraphNumber;
    private LinkInspectorManager LinkPanelManager;
    private JMenu experimentalViewMenu = null;
    private CTAT_Launcher server;
    private GroupEditor groupEditor;
    private VariableViewer variableViewer;
    private SkillsConsoleDialog skillsConsoleDialog;
    private CTATStartStateEditor startStateEditor;
    private RuleActivationTreePanel conflictTreePanel;
    private JessConsolePanel jessPanel;
    private WMEEditorPanel wmeEditorPanel;

    public DockManager(CTAT_Launcher server) {
        this.setClassName("DockManager");
        this.debug("DockManager ()");
        this.server = server;
        this.conflictTreePanel = null;
        this.wmeEditorPanel = null;
    }

    public DockManager(BR_Controller controller) {
        this.setClassName("DockManager");
        this.debug("DockManager ()");
        controller.addCtatModeListener(new CtatModeListener(){

            @Override
            public void ctatModeEventOccured(CtatModeEvent e) {
                trace.out("br", "ctatModeEventOccured: " + e.toString());
                if (e instanceof CtatModeEvent.SetModeEvent) {
                    CtatModeEvent.SetModeEvent m = (CtatModeEvent.SetModeEvent)e;
                    String previousMode = m.getPreviousMode();
                    String currentMode = m.getMode();
                    DockManager.this.updatePerspective(previousMode, currentMode);
                } else if (e instanceof CtatModeEvent.SetVisibleEvent) {
                    final CtatModeEvent.SetVisibleEvent sve = (CtatModeEvent.SetVisibleEvent)e;
                    if (DockManager.this.ctatFrame != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DockManager.this.ctatFrame.setVisible(sve.isVisible());
                            }
                        });
                    }
                }
            }
        });
    }

    protected void updatePerspective(String previousMode, String currentMode) {
        trace.out("br", "DockManager.updatePerspective(" + previousMode + ", " + currentMode + ")");
        if (!currentMode.equals(previousMode)) {
            this.saveLayout(previousMode);
            String perspectiveName = this.getPerspectiveName(currentMode);
            if (perspectiveName == null) {
                return;
            }
            String perspectiveFile = this.getUserPerspectiveFile(currentMode);
            if (perspectiveFile == null || !new File(perspectiveFile).exists()) {
                perspectiveFile = this.getDefaultPerspectiveFile(currentMode);
            }
            if (!this.loadPerspective(perspectiveFile)) {
                trace.outNT("br", "loadLayout(" + perspectiveFile + ") failed. Retrying...");
                this.loadPerspective(perspectiveFile);
            }
        }
    }

    private String getPerspectiveName(String mode) {
        String perspectiveFileName = null;
        if ("Example-tracing Tutor".equals(mode)) {
            perspectiveFileName = EXAMPLE_TRACING_PERSPECTIVE;
        } else if ("Cognitive Tutor (Jess)".equals(mode)) {
            perspectiveFileName = JESS_PERSPECTIVE;
        } else if ("Simulated Student".equals(mode)) {
            perspectiveFileName = SIM_STUDENT_PERSPECTIVE;
        } else if ("Cognitive Tutor (TDK)".equals(mode)) {
            perspectiveFileName = SIM_STUDENT_PERSPECTIVE;
        } else if ("Listen & Replay".equals(mode)) {
            perspectiveFileName = LISTEN_REPLAY_PERSPECTIVE;
        }
        return perspectiveFileName;
    }

    public void saveLayout(String mode) {
        if (this.rootWindow == null) {
            return;
        }
        String perspectiveFileName = this.getPerspectiveName(mode);
        trace.outNT("br", "DockManager.saveLayout(" + mode + ") perspective " + perspectiveFileName);
        if (perspectiveFileName == null) {
            return;
        }
        try {
            File f = new File(USER_PERSPECTIVE_DIR);
            trace.out("br", "Does " + USER_PERSPECTIVE_DIR + " exist? " + f.exists());
            if (!f.exists()) {
                trace.out("br", "DockManager.saveLayout(" + mode + ") creating dir " + USER_PERSPECTIVE_DIR);
                f.mkdir();
            }
        }
        catch (NullPointerException e) {
            trace.out("br", "Value of USER_PERSPECTIVE_DIR is null");
        }
        String perspectiveFile = this.getUserPerspectiveFile(mode);
        trace.outNT("br", "DockManager.saveLayout(" + mode + ") to file " + perspectiveFile);
        try {
            FileOutputStream fos = new FileOutputStream(new File(perspectiveFile));
            ObjectOutputStream out = new ObjectOutputStream(fos);
            this.rootWindow.write(out);
            out.close();
        }
        catch (FileNotFoundException e) {
            trace.err("User perspective file " + perspectiveFile + " not found");
        }
        catch (IOException e) {
            trace.err("User perspective file " + perspectiveFile + " IO error: " + e.getMessage());
        }
    }

    private String getDefaultPerspectiveFile(String mode) {
        String perspectiveFileName = this.getPerspectiveName(mode);
        if (perspectiveFileName == null) {
            return null;
        }
        String defaultPerspectiveFile = DEFAULT_PERSPECTIVE_DIR + File.separatorChar + perspectiveFileName;
        return defaultPerspectiveFile;
    }

    private String getUserPerspectiveFile(String mode) {
        String perspectiveFileName = this.getPerspectiveName(mode);
        if (perspectiveFileName == null) {
            return null;
        }
        String userPerspectiveFile = USER_PERSPECTIVE_DIR + File.separatorChar + perspectiveFileName;
        return userPerspectiveFile;
    }

    public boolean loadLayout(String mode) {
        String perspectiveFile = this.getUserPerspectiveFile(mode);
        File f = new File(perspectiveFile);
        if (trace.getDebugCode("br")) {
            trace.outNT("br", "DockManager.loadLayoutForMode(" + mode + ") user perspective file " + perspectiveFile + ", can read " + f.canRead());
        }
        if (!f.canRead()) {
            perspectiveFile = this.getDefaultPerspectiveFile(mode);
        }
        return this.loadPerspective(perspectiveFile);
    }

    private boolean loadPerspective(String filename) {
        boolean layoutLoaded = false;
        trace.outNT("br", "DockManager.loadLayout(" + filename + ") rootWindow " + (this.rootWindow == null ? "null" : "created"));
        if (filename == null || this.rootWindow == null) {
            return layoutLoaded;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(filename));
            this.rootWindow.read(new ObjectInputStream(fileInputStream));
            fileInputStream.close();
            layoutLoaded = true;
        }
        catch (FileNotFoundException e) {
            trace.err("exception " + e + " on loadLayout(" + filename + "): No stored window layout found");
        }
        catch (IOException e) {
            trace.err("exception " + e + " on loadLayout(" + filename + ")");
            new File(filename).delete();
        }
        catch (IndexOutOfBoundsException e) {
            trace.err("exception " + e + " on loadLayout(" + filename + ")");
        }
        catch (NullPointerException e) {
            trace.err("exception " + e + " on loadLayout(" + filename + ")");
        }
        catch (Exception e) {
            trace.err("exception " + e + " on loadLayout(" + filename + ")");
        }
        return layoutLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dockWindows(boolean showCtatWindow) {
        boolean notReduced;
        this.experimentalViewMenu = null;
        BR_Controller controller = this.server.getFocusedController();
        boolean bl = notReduced = !(controller instanceof BR_Controller) || !this.server.isReducedMode();
        if (VersionInformation.includesJess()) {
            this.jessPanel = new JessConsolePanel(this.getServer(), true);
            if (notReduced) {
                this.wmeEditorPanel = new WMEEditorPanel(this.getServer(), null, false, false);
                this.conflictTreePanel = new RuleActivationTreePanel(this.getServer());
            }
            this.addView(this.conflictTreePanel, "Conflict Tree", 1);
            this.addView(this.jessPanel, "Jess Console", 2);
            this.addView(this.wmeEditorPanel, "WME Editor", 3);
        }
        this.groupEditor = new GroupEditor(this.server);
        this.addView(this.groupEditor, "Group Editor", 4);
        this.variableViewer = new VariableViewer(this.server);
        this.addView(this.variableViewer, "Variable Viewer", 5);
        this.skillsConsoleDialog = SkillsConsoleDialog.create(this.server);
        this.addView(this.skillsConsoleDialog, "Skills Console", 6);
        this.addGraphWindows();
        this.graphEditorRootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.graphViewMap, (boolean)true);
        this.addGraphEditorView((JComponent)this.graphEditorRootWindow, "Behavior Graph Editor", 13);
        this.startStateEditor = new CTATStartStateEditor();
        this.startStateEditor.setController(controller);
        this.addExperimentalView(this.startStateEditor, "Start State Editor", 7);
        CTATProblemSetWizard psetwizard = new CTATProblemSetWizard();
        this.addExperimentalView(psetwizard, "Problem Set and Deployment Wizard", 8);
        try {
            trace.out("linkinspector", "Adding Link Inspector Manager.");
            this.LinkPanelManager = new LinkInspectorManager(this, this.getServer().getFocusedController());
        }
        catch (LinkInspectorException E) {
            trace.err("Error in LinkInspector Initialization: " + E);
        }
        if (this.experimentalViewMenu != null) {
            this.ctatFrame.getCtatMenuBar().getViewPanelMenu().add(this.experimentalViewMenu);
        }
        trace.out("views", "Drawing Window.");
        this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (boolean)true);
        this.rootWindow.addListener((DockingWindowListener)new DockWindowAdapter(this, 0));
        this.menuIdMap.put((DockingWindow)this.rootWindow, 0);
        trace.out("views", "Done Drawing Window.");
        this.ctatFrame.setTitle("Cognitive Tutor Authoring Tools");
        this.ctatFrame.setName("Docked Window");
        this.ctatFrame.setDockable(false);
        RootWindowProperties properties = new RootWindowProperties();
        properties.addSuperObject(new ShapedGradientDockingTheme().getRootWindowProperties());
        this.rootWindow.getRootWindowProperties().addSuperObject(properties);
        this.graphEditorRootWindow.getRootWindowProperties().addSuperObject(properties);
        this.ctatFrame.getContentPane().add((Component)this.rootWindow);
        this.ctatFrame.applyPreferences();
        this.ctatFrame.storeLocation();
        this.ctatFrame.storeSize();
        this.ctatFrame.setVisible(showCtatWindow);
        this.ctatFrame.setDefaultCloseOperation(0);
        this.ctatFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DockManager.this.getServer().getFocusedController().closeApplication(true);
            }
        });
    }

    void addGraphWindows() {
        GraphEditorDefaultPanel defaultGraphPanel = new GraphEditorDefaultPanel();
        defaultGraphPanel.setName("defaultGraphPanel");
        this.graphPlaceholderView = new View("Start", null, (Component)defaultGraphPanel);
        this.graphPlaceholderView.getWindowProperties().setCloseEnabled(true);
        this.addGraphTabView(1);
    }

    public void showGraphPlaceHolder(boolean show) {
        if (show) {
            if (this.graphPlaceholderAdded) {
                this.graphPlaceholderView.restore();
                this.graphPlaceholderView.maximize();
            } else {
                DockingUtil.addWindow((DockingWindow)this.graphPlaceholderView, (RootWindow)this.graphEditorRootWindow);
                this.graphPlaceholderAdded = true;
                this.graphPlaceholderView.maximize();
            }
        } else {
            this.graphPlaceholderView.close();
        }
    }

    private void addExperimentalView(JComponent panel, String title, int viewCount) {
        final View view = this.addCoreView(panel, title, viewCount);
        JMenuItem menuItem = new JMenuItem(view.getTitle());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                view.restore();
            }
        });
        this.addExperimentalViewMenuItem(menuItem);
    }

    public void addExperimentalViewMenuItem(JMenuItem menuItem) {
        if (this.experimentalViewMenu == null) {
            this.experimentalViewMenu = new JMenu("Experimental");
        }
        this.experimentalViewMenu.add(menuItem);
    }

    static JComponent getPanelFromFrame(JFrame frame) {
        JRootPane panel = new JRootPane();
        ((JComponent)frame.getContentPane()).setMinimumSize(new Dimension(20, 20));
        panel.setContentPane(frame.getContentPane());
        panel.setJMenuBar(frame.getJMenuBar());
        frame.setVisible(false);
        return panel;
    }

    private void addView(JComponent panel, String title, int viewCount) {
        View view = this.addCoreView(panel, title, viewCount);
        view.addListener((DockingWindowListener)new DockWindowAdapter(this, viewCount));
        this.menuIdMap.put((DockingWindow)view, viewCount);
        this.ctatFrame.addView(view, viewCount);
    }

    private void addGraphEditorView(JComponent panel, String title, int viewCount) {
        View view = this.addCoreView(panel, title, viewCount);
        view.addListener((DockingWindowListener)new DockWindowAdapter(this, -1));
        view.getViewProperties().setAlwaysShowTitle(false);
        view.getWindowProperties().setCloseEnabled(false);
        TabWindowProperties props = this.graphEditorRootWindow.getRootWindowProperties().getTabWindowProperties();
        props.getCloseButtonProperties().setVisible(false);
        props.getUndockButtonProperties().setVisible(false);
        props.getMaximizeButtonProperties().setVisible(false);
    }

    public void addGraphTabView(int tabNumber) {
        CTATTabManager manager = this.getServer().getTabManager();
        CTATTab tab = manager.getTabByNumber(tabNumber);
        View tabView = tab.getView();
        tabView.getWindowProperties().setCloseEnabled(true);
        tabView.getWindowProperties().setUndockEnabled(false);
        tabView.addListener((DockingWindowListener)new DockGraphWindowAdapter(this, manager, tabNumber));
        this.graphViewMap.addView(tabNumber, tabView);
    }

    public int newGraphTab() {
        CTATTabManager manager = this.getServer().getTabManager();
        CTATTab newTab = null;
        int tabNumber = -1;
        if (manager.getFreeTab() != null) {
            newTab = manager.getFreeTab();
            tabNumber = newTab.getTabNumber();
        } else {
            int tabNum = manager.getNextTabNumber();
            newTab = new CTATTab(tabNum);
            if ((newTab = manager.getNewTab(newTab, null)) != null) {
                this.addGraphTabView(tabNum);
                DockingUtil.addWindow((DockingWindow)newTab.getView(), (RootWindow)this.graphEditorRootWindow);
                this.updateGraphConnectionStatus(tabNum, newTab.getController().getUniversalToolProxy().getStudentInterfaceConnectionStatus());
                tabNumber = tabNum;
            }
        }
        if (newTab != null) {
            manager.setFocusedTab(newTab, true);
        }
        return tabNumber;
    }

    public int findView(DockingWindow view) {
        Integer result = this.menuIdMap.get(view);
        if (result != null) {
            return result;
        }
        return -1;
    }

    public View addDynamicView(JComponent panel, String title) {
        trace.outNT("views", "Producing Dynamic window.");
        int NewViewCount = this.LastViewCount < 9 ? 9 : this.LastViewCount + 1;
        View NewView = this.addCoreView(panel, title, NewViewCount);
        NewView.restore();
        trace.outNT("views", "Dynamic window: " + NewViewCount);
        return NewView;
    }

    private View addCoreView(JComponent panel, String title, int viewCount) {
        View view = new View(title, null, (Component)panel);
        trace.out("views", "Producing Window: " + title);
        if (this.getServer().getLoggingSupport() != null) {
            view.addListener((DockingWindowListener)new AuthorLogListener(this.getServer().getLoggingSupport()));
        }
        this.viewMap.addView(viewCount, view);
        if (viewCount > this.LastViewCount) {
            this.LastViewCount = viewCount;
        }
        trace.outNT("views", "Curr View Count: " + this.viewMap.getViewCount());
        return view;
    }

    public View getCoreView(String title) {
        this.debug("getCoreView (" + title + ")");
        if (this.viewMap == null) {
            this.debug("Internal error: viewMap is null");
            return null;
        }
        for (int i = 0; i < this.viewMap.getViewCount(); ++i) {
            View testView = this.viewMap.getView(i);
            if (testView != null) {
                if (testView.getTitle() != null) {
                    if (!testView.getTitle().equalsIgnoreCase(title)) continue;
                    this.debug("Found view " + title + " at index: " + i);
                    return testView;
                }
                this.debug("Info: a view in the view map does not have a title");
                continue;
            }
            this.debug("Internal error: view is null at index: " + i);
        }
        return null;
    }

    public void addListenerToRootWindow(DockingWindowAdapter Adapter) throws CtatviewException {
        if (this.rootWindow == null) {
            throw new CtatviewException("Null Root Window.");
        }
        this.rootWindow.addListener((DockingWindowListener)Adapter);
    }

    private void informViewStatus() throws CtatviewException {
        this.LinkPanelManager.postWindowingUpdate();
    }

    public void addSimStConsole() {
        this.addView(this.getServer().getMissController().getMissConsole(), "Simulated Student Console", 12);
    }

    public void dockWindowsNow(boolean showCtatWindow) throws CtatviewException {
        this.dockWindows(showCtatWindow);
        String currentMode = this.getServer().getFocusedController().getCtatModeModel().getCurrentMode();
        this.updatePerspective("", currentMode);
        this.informViewStatus();
    }

    public void restoreDefaultView() {
        int firstUnusedID = 13;
        for (int i = 1; i < firstUnusedID; ++i) {
            if (!this.ctatFrame.isTracked(i)) continue;
            this.setMenuVisibilityMarker(i, false);
        }
        String mode = this.getServer().getFocusedController().getCtatModeModel().getCurrentMode();
        String perspectiveFileName = this.getPerspectiveName(mode);
        if (perspectiveFileName == null) {
            return;
        }
        String defaultPerspectiveFile = this.getDefaultPerspectiveFile(mode);
        if (!this.loadPerspective(defaultPerspectiveFile)) {
            trace.out("br", "loadLayout(" + defaultPerspectiveFile + ") failed. Retrying...");
            this.loadPerspective(defaultPerspectiveFile);
        }
    }

    private CTAT_Launcher getServer() {
        return this.server;
    }

    public void refreshViews(boolean connectionChanged) {
        boolean notReduced;
        if (!this.getServer().isDoneIntializing()) {
            return;
        }
        this.changeModes();
        if (this.isWindowVisible(5)) {
            this.variableViewer.refresh();
        }
        if (connectionChanged) {
            return;
        }
        if (this.isWindowVisible(4)) {
            this.groupEditor.refresh();
        }
        if (this.isWindowVisible(6)) {
            this.skillsConsoleDialog.refresh();
        }
        BR_Controller controller = this.getServer().getFocusedController();
        if (this.isWindowVisible(7)) {
            this.startStateEditor.setController(controller);
        }
        boolean bl = notReduced = !this.getServer().isReducedMode();
        if (VersionInformation.includesJess()) {
            if (this.isWindowVisible(2)) {
                this.jessPanel.refresh();
            }
            if (notReduced) {
                if (this.isWindowVisible(1)) {
                    this.conflictTreePanel.refresh();
                }
                if (this.isWindowVisible(3)) {
                    this.wmeEditorPanel.refresh();
                }
            }
        }
    }

    public void setViewVisibility(int viewID, boolean visible) {
        View view = this.viewMap.getView(viewID);
        if (visible) {
            view.restore();
        } else {
            view.close();
        }
        this.setMenuVisibilityMarker(viewID, visible);
    }

    public void setGraphVisibility(int viewID, boolean visible) {
        View view = this.graphViewMap.getView(viewID);
        if (visible) {
            view.restore();
        } else {
            view.close();
        }
    }

    public void showGraphWindow(int tabNumber) {
        this.setGraphVisibility(tabNumber, true);
        this.focusOnGraph(tabNumber);
    }

    public void focusOnGraph(int tabNumber) {
        View view = this.graphViewMap.getView(tabNumber);
        view.restoreFocus();
    }

    private boolean isWindowVisible(int viewID) {
        return this.ctatFrame.isWindowVisible(viewID);
    }

    void setMenuVisibilityMarker(int viewID, boolean visible) {
        if (viewID <= 0) {
            return;
        }
        this.ctatFrame.setViewVisibilityMarker(viewID, visible);
    }

    public JessConsolePanel getJessPanel() {
        return this.jessPanel;
    }

    public RuleActivationTreePanel getConflictTreePanel() {
        return this.conflictTreePanel;
    }

    private void changeModes() {
        this.ctatFrame.getCtatModePanel().changeModes(this.getServer().getFocusedController());
    }

    void refreshWindow(int windowID) {
        switch (windowID) {
            case 1: {
                this.conflictTreePanel.refresh();
                break;
            }
            case 2: {
                this.jessPanel.refresh();
                break;
            }
            case 3: {
                this.wmeEditorPanel.refresh();
                break;
            }
            case 4: {
                this.groupEditor.refresh();
                break;
            }
            case 6: {
                this.skillsConsoleDialog.refresh();
                break;
            }
        }
    }

    public WMEEditorPanel getMainWMEEditorPanel() {
        return this.wmeEditorPanel;
    }

    public void refreshGraphTitle(int tabNumber) {
        String newTabTitle;
        View view = this.graphViewMap.getView(tabNumber);
        ProblemModel pm = this.server.getTabManager().getTabByNumber(tabNumber).getProblemModel();
        if (!pm.isEmpty()) {
            String fullName = this.server.getTabManager().getTabByNumber(tabNumber).getProblemModel().getProblemFullName();
            String newMenuText = newTabTitle = fullName.substring(fullName.lastIndexOf(File.separator) + 1);
        } else {
            newTabTitle = "Graph " + tabNumber;
            String newMenuText = "";
        }
        view.getViewProperties().setTitle(newTabTitle);
        view.validate();
        view.repaint();
    }

    public void updateGraphConnectionStatus(int tabNumber, StudentInterfaceConnectionStatus sics) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "DockMgr.udpateGraphConnectionStatus(" + tabNumber + ", " + (Object)((Object)sics) + ")");
            trace.out("mg", "Is HTML5 tab? " + this.server.getTabManager().getTabByNumber(tabNumber).isHTMLInterfaceTab());
        }
        View view = this.graphViewMap.getView(tabNumber);
        view.getViewProperties().setIcon((Icon)sics.getIcon(this.server.getTabManager().getTabByNumber(tabNumber).isHTMLInterfaceTab()));
        this.refreshViews(true);
    }

    public boolean isGraphView(View view) {
        int index = -1;
        if (this.graphEditorRootWindow != null) {
            index = this.graphEditorRootWindow.getChildWindowIndex((DockingWindow)view);
        }
        return index > -1;
    }

    public void clearGraphViews(String mode) {
        for (int i = 0; i < CTATTabManager.getNumTabs(); ++i) {
            int tabNumber = i + 1;
            View view = this.graphViewMap.getView(tabNumber);
            CTATTab tab = this.getServer().getTabManager().getTabByNumber(tabNumber);
            String defaultWindowName = tab.getName();
            view.getViewProperties().setTitle(defaultWindowName);
            if (!tab.getController().getInterfaceLoaded()) continue;
            this.updateGraphConnectionStatus(tabNumber, StudentInterfaceConnectionStatus.Disconnected);
        }
        this.saveLayout(mode);
    }

    public void markAsFocused(int tabNumber, int lastTabNumber) {
        if (tabNumber == lastTabNumber) {
            return;
        }
        if (lastTabNumber > 0) {
            View lastView = this.graphViewMap.getView(lastTabNumber);
            lastView.setBorder(null);
        }
        View view = this.graphViewMap.getView(tabNumber);
        view.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        this.currentGraphNumber = tabNumber;
    }

    public void graphTabFocused(int tabNumber) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "DockManager (graphTabFocused): focused tabNumber = " + tabNumber);
        }
        if (tabNumber != this.currentGraphNumber) {
            this.getServer().getTabManager().setFocusedTabByNumber(tabNumber, true);
        }
    }

    protected int getGraphEditorId() {
        return 13;
    }
}

