/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.TextOutput;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessConsolePanel;
import edu.cmu.pact.jess.MTRete;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.swing.text.PlainDocument;
import jess.JessException;
import jess.Main;
import jess.Rete;
import jess.Value;

public class JessConsole
implements Serializable,
TextOutput.OutputEventListener,
PropertyChangeListener {
    private static final long serialVersionUID = -3004760790112650076L;
    private static final String BREAK_ON_EXCEPTIONS = "Break on Exceptions";
    private static final String FIRABLE = "Firable";
    private static final String CHAIN = "Chain";
    private volatile MTRete m_rete;
    boolean m_doEcho = true;
    private TextOutput textOutput = TextOutput.getNullOutput();
    public static final String USER_COMMAND = "USER_COMMAND";
    public static final String STOP = "STOP";
    public static final String CLEAR = "CLEAR";
    public static final String RELOAD = "RELOAD";
    private PrintWriter pw;
    private StringBuffer lastTextOutputData = new StringBuffer();

    public JessConsole(String title, MTRete engine, boolean doEcho, CTAT_Controller controller) {
        PreferencesModel pm;
        this.m_rete = engine;
        this.textOutput = TextOutput.getTextOutput(new PlainDocument());
        this.pw = this.textOutput.getWriter();
        this.m_doEcho = doEcho;
        trace.out("mps", "CREATING WINDOW HELPER");
        if (controller != null && (pm = controller.getPreferencesModel()) != null) {
            pm.addPropertyChangeListener(CHAIN, this);
            pm.addPropertyChangeListener(FIRABLE, this);
            pm.addPropertyChangeListener(BREAK_ON_EXCEPTIONS, this);
            this.getPreferencesFromModel(pm);
        }
        this.connectToRete(engine);
    }

    public TextOutput getTextOutput() {
        return this.textOutput;
    }

    public void clearOutputArea() {
        this.getTextOutput().clear();
    }

    private void getPreferencesFromModel(PreferencesModel model) {
        Boolean booleanValue3;
        Boolean booleanValue2;
        Boolean booleanValue = model.getBooleanValue(CHAIN);
        if (booleanValue != null) {
            MTRete.displayChain = booleanValue;
        }
        if ((booleanValue2 = model.getBooleanValue(FIRABLE)) != null) {
            MTRete.displayFired = booleanValue2;
        }
        if ((booleanValue3 = model.getBooleanValue(BREAK_ON_EXCEPTIONS)) != null) {
            MTRete.breakOnExceptions = booleanValue3;
        }
    }

    public Rete getEngine() {
        return this.m_rete;
    }

    void execute(String[] argv) {
        Main m = new Main();
        m.initialize(argv, (Rete)this.m_rete);
        this.getJessPanel().setFocus();
        m.execute(this.m_doEcho);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        String name = arg0.getPropertyName();
        Object newValue = arg0.getNewValue();
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "Changed " + name + " from " + arg0.getOldValue() + " to " + newValue);
        }
        if (name.equals(CHAIN)) {
            MTRete.displayChain = (Boolean)newValue;
        }
        if (name.equals(FIRABLE)) {
            MTRete.displayFired = (Boolean)newValue;
        }
        if (name.equals(BREAK_ON_EXCEPTIONS)) {
            MTRete.breakOnExceptions = (Boolean)newValue;
        }
    }

    void setRete(MTRete rete) {
        this.m_rete = rete;
        this.connectToRete(this.m_rete);
    }

    public JessConsolePanel getJessPanel() {
        if (this.m_rete.getMT().getController() == null) {
            return null;
        }
        return this.m_rete.getMT().getController().getServer().getCtatFrameController().getDockManager().getJessPanel();
    }

    void connectToRete(MTRete rete) {
        if (rete == null) {
            return;
        }
        rete.addOutputRouter("t", this.pw);
        rete.addOutputRouter("WSTDOUT", this.pw);
        rete.addOutputRouter("WSTDERR", this.pw);
        try {
            rete.setWatchRouter("WSTDOUT");
        }
        catch (JessException je) {
            this.pw.println("Error connecting watch router to this window: " + (Object)((Object)je));
            je.printStackTrace();
        }
        rete.setTextOutput(this.getTextOutput());
    }

    public void executeCommand(String cmd) {
        block2: {
            try {
                this.textOutput.addOutputEventListener(this);
                Value result = this.m_rete.eval(cmd);
                this.textOutput.removeOutputEventListener(this);
                String resultStr = result.toStringWithParens();
                this.textOutput.append(resultStr);
                this.m_rete.getEventLogger().log(true, "JESS_CONSOLE", USER_COMMAND, cmd, resultStr, this.getLastTextOutputData());
                this.textOutput.prompt("\n\nJess> ");
            }
            catch (JessException je) {
                PrintWriter err = this.textOutput.getWriter();
                this.displayException(err, je);
                if (je.getCause() == null) break block2;
                err.write("\nNested exception is:\n");
                this.displayException(err, je.getCause());
            }
        }
    }

    private void displayException(PrintWriter err, Throwable ex) {
        if (ex instanceof JessException) {
            err.println(ex.toString());
        } else {
            err.println(ex.getMessage());
        }
        ex.printStackTrace();
    }

    public void doEcho(String cmd) {
        this.textOutput.prompt("\n\nJess> ");
        this.textOutput.append(cmd);
        this.textOutput.append("\n");
    }

    private synchronized String getLastTextOutputData() {
        String result = this.lastTextOutputData.toString();
        this.lastTextOutputData = new StringBuffer();
        return result;
    }

    private synchronized void addLastTextOutputData(String s) {
        this.lastTextOutputData.append(s);
    }

    @Override
    public void outputOccurred(TextOutput.OutputEvent e) {
        if (trace.getDebugCode("jc")) {
            trace.out("jc", "JessConsole from " + e.getSource() + ": " + e.getOutput());
        }
        this.addLastTextOutputData(e.getOutput());
    }
}

