/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.miss.AlgebraProblemAssessor;
import edu.cmu.pact.miss.AskHint;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.JTabbedPaneWithCloseIcons;
import edu.cmu.pact.miss.PeerLearning.AplusPlatform;
import edu.cmu.pact.miss.PeerLearning.CurriculumBrowser;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowUtilities;
import edu.cmu.pact.miss.PeerLearning.QuizPane;
import edu.cmu.pact.miss.PeerLearning.SimStConversation;
import edu.cmu.pact.miss.PeerLearning.SimStExample;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.PeerLearning.SimStMessageDialog;
import edu.cmu.pact.miss.PeerLearning.SimStPeerTutoringPlatform;
import edu.cmu.pact.miss.PeerLearning.StudentAvatarDesigner;
import edu.cmu.pact.miss.PeerLearning.YesNoBucket;
import edu.cmu.pact.miss.ProblemAssessor;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStNode;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStProblemGraph;
import edu.cmu.pact.miss.RegexHashtable;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.SimStInteractiveLearning;
import edu.cmu.pact.miss.WebStartFileDownloader;
import edu.cmu.pact.miss.console.controller.MissController;
import edu.cmu.pact.miss.storage.StorageClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import pact.CommWidgets.JCommComboBox;
import pact.CommWidgets.JCommLabel;
import pact.CommWidgets.JCommTable;
import pact.CommWidgets.JCommWidget;

public class SimStPLE {
    public static final String NEXT_PROBLEM = "next problem";
    public static final String QUIZ = "quiz";
    public static final String QUIZ_FILE = "quiz.txt";
    public static final String EXAMPLES = "examples";
    public static final String UNDO = "undo";
    public static final String RESTART = "restart";
    public static final String CFG = "configure";
    public static final String EXAMPLES_FILE = "examples.txt";
    public static final String COMPONENT_NAME_FILE = "compNames.txt";
    public static final String CONFIG_FILE = "simSt-config.txt";
    public static final String CURRICULUM_BROWSER = "curriculum browser";
    public static final String CURRICULUM_FILE = "curriculum.html";
    private static final String ASK_NEW_PROBLEM_MSG = "Enter next problem";
    public static final String NOT_UNDERSTAND = "I still don't get it.  Let's move on to another problem.  Is there an easier one we can try?";
    public static final String ENTER_FULL_PROBLEM = "You haven't finished with entering a problem yet.";
    public static final String PROBLEM_STAT_FILE = "problemStatisticsStudy.csv";
    public static final String PROBLEM_BANK = "problem bank";
    public static final String START_STATE_ELEMENTS_HEADER = "startStateElements";
    private static final String FOA_ELEMENTS_HEADER = "foaElements";
    private static final String COMPONENT_NAMES_HEADER = "componentNames";
    private static final String QUIZ_PROBLEMS_HEADER = "quizProblems";
    private static final String EXAMPLES_HEADER = "examples";
    private static final String MISTAKE_EXPLANATION_HEADER = "mistakeExplanations";
    private static final String PROBLEM_CHOICE_EXPLANATION_HEADER = "problemChoiceExplanations";
    private static final String HINT_EXPLANATION_HEADER = "hintExplanations";
    private static final String SECTIONS_HEADER = "sections";
    private static final String PROBLEM_DELIMITER_HEADER = "problemDelimiter";
    private static final String VALID_SELECTIONS_FOR_SE = "validSelectionsForSelfExplanation";
    private final String USER_ID_REQUEST_TITLE = "User ID";
    private final String USER_ID_REQUEST_MSG = "Please enter your User ID:";
    public static final int FIRST_EXAMPLE = 1;
    public static final int SIM_ST_TAB = 0;
    public static final int PROBLEM_BANK_TAB = 1;
    public static final String START_MESSAGE = "Alright, what problem should I try?";
    public static final String THINK_MESSAGE = "Hmm....";
    public static final String CONFUSE_MESSAGE = "Uh...";
    public static final String UNCONFUSE_MESSAGE = "Oh, okay.  I think I understand a little better now.";
    public static final String DONE_MESSAGE = "...and done!  What should I do next?";
    public static final String QUIZ_MESSAGE = "I'm taking the quiz now.  Let's see how I do.";
    public static final String DO_PROBLEM_MSG = "Should I do this problem?";
    public static final String DO_PROBLEM_NO = "OK. Click \"Yes\" when you've entered a problem you like better.";
    public static final String NO_UNDO_MSG = "But we haven't gotten through any work on this problem yet!";
    public static final String UNDO_DONE_MSG = "Oh, is that not the answer to the problem?  Should I go back to working on it?";
    public static final String SHOULD_DO_MSG = "Alright, I erased $.  Now let me think what I should do instead...";
    public static final String UNDO_ERROR_MSG = "I'm not quite sure how to undo that step.  Can we just restart the problem or go on to a different one?";
    public static final String RESUME_MSG = "OK, I'm still not sure what I should do next though.  Can you please show me what to do?";
    public static final String RESTART_MSG = "OK, I'm trying this problem again from the beginning.";
    public static final String BACK_TO_WORK_MSG = "Alright, back to the problem.  Let me think what I should do.";
    public static final String METATUTOR_SPLASH_MESSAGE = "Your goal is to help SimStudent pass all the quizzes.\nMy name is Mr Williams and I am here to help you.\nYou can click on me anytime you want to ask a question!\n\nGood luck!";
    public static final String FINALCHALLENGE_PASSED_SPLASH_MESSAGE = "You have already completed the final challenge!\n I made another set of final challenge problems\n for SimStudent. To see if SimStudent can pass them click\n the 'YES' button. ";
    public static final String METATUTOR_SPLASH_BUTTON_TEXT = "Click here to close this window";
    public static final String EXAMPLE_COMM_TEXT = "You can use the following examples for practice.\nSelect an example problem and use the buttons\nabove to view the solution steps!";
    public static final String WELCOME_SPLASH = "img/metatutor_splash.gif";
    public static final String TEACHER_BANK_IMAGE = "img/teacher_bank.png";
    public static final String OTHER_OPTION = "Other - Type Your Own Explanation";
    public static final String SELECT_OPTION = "Please Select One";
    public static final String FOA_EXAMPLE_MATCH_SYMBOL = "(E)";
    public static final String INPUT_MATCH_SYMBOL = "(I)";
    public static final String OPERAND_MATCH_SYMBOL = "(#)";
    public static final String OPERATOR_MATCH_SYMBOL = "(O)";
    public static final String PROBLEM_MATCH_SYMBOL = "(P)";
    public static final String FOA_PART_MATCH_SYMBOL = "(F)";
    public static final String TEACHER_IMAGE = "img/teacher.png";
    public static String STUDENT_IMAGE = "%img/head1.png%img/hair1.png%img/shirt1.png";
    public static final String NORMAL_EXPRESSION = "img/face1.png";
    public static final String SUCCESS_EXPRESSION = "img/face2.png";
    public static final String THINK_EXPRESSION = "img/face6.png";
    public static final String ASK_EXPRESSION = "img/face5.png";
    public static final String SAD_EXPRESSION = "img/face3.png";
    public static final String CONFUSE_EXPRESSION = "img/face3.png";
    public static final String UNDOCK_ICON_IMAGE = "img/Undock_Icon.png";
    public static final String METATUTOR_EMPTY_DESK = "img/metatutor_empty.png";
    public static final String METATUTOR_IMAGE = "img/metatutor.png";
    public static final String METATUTOR_STUDENT_INTERACTION_IMAGE = "img/metatutor_student_interaction.gif";
    public static final String BASELINE_MR_WILLIAMS_IMAGE = "img/baseline_Mr.Williams.png";
    public static final String BOARD_IMAGE = "img/board.png";
    public static final String NEXT_EXAMPLE_IMAGE = "img/next.png";
    public static final String PREVIOUS_EXAMPLE_IMAGE = "img/previous.png";
    public static final String FFWD_EXAMPLE_IMAGE = "img/ffwd.png";
    public static final String FBWD_EXAMPLE_IMAGE = "img/fbwd.png";
    public static final String NORMAL_STATUS = "NORMAL";
    public static final String FINISHED_STATUS = "FINISHED";
    public static final String THINK_STATUS = "THINK";
    public static final String ASK_STATUS = "ASK";
    public static final String QUIZ_STATUS = "QUIZ";
    private String status = "NORMAL";
    private static final int BORDER_WIDTH = 5;
    private static final int QUIZ_COMPLETED_EXIT = 104;
    private static final int MAX_THREAD_COUNT = 1;
    private SimStMessageDialog messageDialog;
    public boolean hasExamples = false;
    private static ExecutorService quizThreadPool = Executors.newFixedThreadPool(1);
    public static Object quizLock = new Object();
    static String videoIntroductionName = "";
    static String overviewPageName = "";
    private JTextArea aplusQuizTextArea;
    BR_Controller brController = null;
    SimSt simSt = null;
    MissController missController = null;
    SimStInteractiveLearning ssInteractiveLearning = null;
    SimStLogger logger;
    SimStPeerTutoringPlatform simStPeerTutoringPlatform = null;
    CurriculumBrowser curriculumBrowser = null;
    int currentLevel = 1;
    private String problem = null;
    private ArrayList<String> quizProblems;
    private ArrayList<String> randomizedQuizProblems;
    ArrayList<ArrayList<String>> allQuizProblems;
    ArrayList<ArrayList<Integer>> allQuizSections;
    ArrayList<Integer> quizSections;
    ArrayList<String> currentQuizSection;
    int currentQuizSectionNumber = 0;
    private static File videoFile = null;
    private ArrayList<String> sections;
    private RegexHashtable componentNames;
    private ArrayList<String> startStateElements;
    private ArrayList<SimStExample> examples;
    private Hashtable<String, String> exampleExplanations;
    private Hashtable<String, LinkedList<Explanation>> mistakeExplanations;
    private Hashtable<String, LinkedList<Explanation>> problemChoiceExplanations;
    private Hashtable<String, LinkedList<Explanation>> hintExplanations;
    private HashSet<String> validSelections;
    private boolean startStatus = false;
    private boolean confused = false;
    private static boolean quizPassed = false;
    private int quizLevel = 0;
    private SimStConversation conversation;
    private long startPleTime;
    String newSectionTitleBase = "";
    boolean hasPassedFinalChallenge = false;
    transient Hashtable<String, LinkedHashMap> quizAttemptsHash = null;
    public static final String EXAMPLE_LOCATION_MARKER = "#";
    public static final String EXAMPLE_VALUE_MARKER = ":";
    int tableNumber = 0;
    private String wasDone = "Was Done";
    private String wasFailToLearn = "Was FailToLearn Stop";
    private String wasNormal = "Was Normal HintRequest";
    private String wasVerify = "Was Verifying Production";
    private static int currentProblem = 0;
    private int currentCorrect = 0;
    protected static int currentOverallProblem = 0;
    public static final int MAX_SEARCH_DEPTH = 10;
    private Vector<ProblemEdge> solutionEdges = null;
    public static final String PROBLEM_NOT_SOLVED = "PROBLEM_NOT_SOLVED";
    private final String NEXT_PROBLEM_BUTTON_TEXT = "<html><p>Tutor $ Next Problem</p></html>";
    private final String NEXT_PROBLEM_DIALOG_TEXT = "Tutor $ Next Problem";
    private final String QUIZ_BUTTON_TEXT = "<html><p>Quiz $</p></html>";
    private final String CURRICULUM_BROWSER_BUTTON_TEXT = "<html><p>$</p><p>Introduction</p></html>";
    private final String EXAMPLE_BUTTON_TEXT_SHOW = "<html><p>Show</p><p>Examples</p></html>";
    private final String EXAMPLE_BUTTON_TEXT_HIDE = "<html><p>Hide</p><p>Examples</p></html>";
    private final String ENTER_PROBLEM_BUTTON_TEXT = "<html><p>Click Here When</p><p>Problem Entered</p></html>";
    private final String UNDO_BUTTON_TEXT = "<html><p>Erase Last Step ($)</p></html>";
    private final String UNDO_DONE_BUTTON_TEXT = "<html><p>Problem Is Not Done</p></html>";
    private final String RESTART_BUTTON_TEXT = "<html><p>Restart Problem</p></html>";
    private final String PROBLEM_BANK_BUTTON_TEXT = "<html><p>Generate Bank</p><p>of Problems</html>";
    String cellText1 = null;
    String cellText2 = null;
    JPopupMenu undoContextMenu;
    String undoCandidate = "";
    JCommTable.TableExpressionCell cellToUse;
    String previousSpeechText = "";
    boolean buttonsVisible = false;
    public static Object[][] problemStatData = null;
    public static java.util.HashMap<String, String> problemMap = null;
    private static ProblemAssessor assessor;
    public ArrayList<JProgressBar> quizProg;
    public int currentQuizSectionCorrect;

    public String getStatus() {
        return this.status;
    }

    public static void setVideoIntroductionName(String name) {
        videoIntroductionName = name;
    }

    public static void setOverviewPageName(String name) {
        overviewPageName = name;
    }

    public void setAplusQuizTextArea(JTextArea aplusQuizTextArea) {
        this.aplusQuizTextArea = aplusQuizTextArea;
    }

    public static void setVideoFile(File file) {
        videoFile = file;
    }

    ArrayList<String> getQuizProblems() {
        return this.quizProblems;
    }

    String getQuizProblem(int i) {
        return this.quizProblems.get(i);
    }

    String getRandomizedQuizProblem(int i) {
        return this.randomizedQuizProblems.get(i);
    }

    private void randomizeQuizProblems() {
        this.randomizedQuizProblems = new ArrayList();
        for (int i = 0; i < this.currentQuizSection.size(); ++i) {
            this.randomizedQuizProblems.add(GameShowUtilities.generate(this.currentQuizSection.get(i)));
        }
    }

    public int getCurrentQuizSectionNumber() {
        return this.currentQuizSectionNumber;
    }

    public ArrayList<String> getSections() {
        return this.sections;
    }

    public ArrayList<String> getStartStateElements() {
        return this.startStateElements;
    }

    public ArrayList<SimStExample> getExamples() {
        return this.examples;
    }

    public HashSet<String> getValidSelections() {
        return this.validSelections;
    }

    public boolean isStartStatus() {
        return this.startStatus;
    }

    public boolean isConfused() {
        return this.confused;
    }

    public static boolean isQuizPassed() {
        return quizPassed;
    }

    public int getQuizLevel() {
        return this.quizLevel;
    }

    public SimStConversation getConversation() {
        return this.conversation;
    }

    public void setConversation(SimStConversation conv) {
        this.conversation = conv;
    }

    public boolean getHasPassedFinalChallenge() {
        return this.hasPassedFinalChallenge;
    }

    public void setHasPassedFinalChallenge(boolean value) {
        this.hasPassedFinalChallenge = value;
    }

    public Hashtable<String, LinkedHashMap> getQuizAttemptsHash() {
        return this.quizAttemptsHash;
    }

    public void setQuizAttemptsHash(Hashtable<String, LinkedHashMap> quizAttemptsHash) {
        this.quizAttemptsHash = quizAttemptsHash;
    }

    public void initQuizAttemptHash() {
        Hashtable<String, LinkedHashMap> hashtable = new Hashtable<String, LinkedHashMap>();
        this.setQuizAttemptsHash(hashtable);
    }

    public SimStPLE(BR_Controller brController, SimStPeerTutoringPlatform simStPeerTutoringPlatform) {
        this.setBrController(brController);
        this.getBrController().activateMissController(false);
        this.setMissController((MissController)this.getBrController().getMissController());
        this.getMissController().setPLEon(true);
        this.setCurriculumBrowser(new CurriculumBrowser());
        if (videoIntroductionName != null && videoIntroductionName.length() > 0) {
            this.getCurriculumBrowser().setVideoSource(videoIntroductionName);
        }
        if (overviewPageName != null && overviewPageName.length() > 0) {
            this.getCurriculumBrowser().setHtmlSource(overviewPageName);
        }
        SimSt simSt = this.getMissController().getSimSt();
        this.setSimSt(simSt);
        this.logger = new SimStLogger(this.getBrController());
        String user = simSt.getUserID();
        if (user == null) {
            user = JOptionPane.showInputDialog(brController.getActiveWindow(), "Please enter your User ID:", "User ID", 3);
            simSt.setUserID(user);
        }
        if (this.getSimSt().getLoggingEnabled() || this.getSimSt().getLocalLoggingEnabled()) {
            this.logger.enableLogging(this.getSimSt().getLoggingEnabled(), this.getSimSt().getLocalLoggingEnabled(), user);
            this.logger.simStLog("SIM_STUDENT_PLE", "Peer Learning Environment Started", "");
            this.startPleTime = System.currentTimeMillis();
        } else {
            this.logger.enableLogging(this.getSimSt().getLoggingEnabled(), this.getSimSt().getLocalLoggingEnabled(), user);
        }
        this.getSimSt().setDontShowAllRA(true);
        ((MissController)this.getBrController().getMissController()).setSimStPLE(this);
        this.setSsInteractiveLearning(new SimStInteractiveLearning(this.getSimSt()));
        this.setSimStPeerTutoringPlatform(simStPeerTutoringPlatform);
        this.messageDialog = new SimStMessageDialog(new Frame(), this.logger);
        this.messageDialog.setLocationRelativeTo(this.getSimStPeerTutoringPlatform());
        this.config();
        this.loadAccountInfo();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Loading the instructions now");
        }
        long startTime = System.currentTimeMillis();
        boolean loadingSucceeded = false;
        loadingSucceeded = this.getMissController().loadInstDeSerialize();
        if (!loadingSucceeded) {
            this.getSimStPeerTutoringPlatform().showWaitMessage(true);
            this.getMissController().autoLoadInstructions();
            this.getSimStPeerTutoringPlatform().showWaitMessage(false);
        }
        long endTime = System.currentTimeMillis();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Time to load the instructions was: " + (endTime - startTime));
        }
        this.initQuizAttemptHash();
    }

    public int getFinalChallengeID(ArrayList<String> sections) {
        int returnVal = 0;
        for (int i = 0; i < sections.size(); ++i) {
            if (!sections.get(i).equalsIgnoreCase("-Final Challenge")) continue;
            returnVal = i;
            break;
        }
        return returnVal;
    }

    public void loadAccountInfo() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "loadAccountInfo: " + this.getSimSt().getUserID());
        }
        String accountInfo = this.getSimSt().getUserID() + ".account";
        File accountFile = null;
        boolean successful = false;
        if (!this.getMissController().getSimSt().isWebStartMode()) {
            accountFile = new File(accountInfo);
        } else {
            try {
                successful = this.getMissController().getStorageClient().retrieveFile(this.getSimSt().getUserID() + ".account", accountInfo, WebStartFileDownloader.SimStWebStartDir);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (successful) {
                accountFile = new File(WebStartFileDownloader.SimStWebStartDir + accountInfo);
            }
        }
        if (accountFile != null && accountFile.exists()) {
            try {
                this.quizLevel = 0;
                BufferedReader read = new BufferedReader(new FileReader(accountFile));
                String charName = read.readLine();
                SimSt.setSimStName(charName);
                String imgName = read.readLine();
                this.getSimSt().setSimStImage(imgName);
                STUDENT_IMAGE = imgName;
                String tmp = read.readLine();
                if (tmp != null && tmp.length() > 0) {
                    currentProblem = currentOverallProblem = Integer.parseInt(tmp);
                    trace.out("ss", "Overall: " + currentOverallProblem);
                    int totalNumberOfProblems = 0;
                    for (int j = 0; j < this.allQuizProblems.size(); ++j) {
                        totalNumberOfProblems += this.allQuizProblems.get(j).size();
                    }
                    int numberOfProblemsInFinalChallenge = this.allQuizProblems.get(1).size();
                    if (currentProblem >= totalNumberOfProblems) {
                        int howMany2Add = 1 + (currentProblem - totalNumberOfProblems) / numberOfProblemsInFinalChallenge;
                        int start = this.allQuizSections.get(this.allQuizSections.size() - 1).get(0) + 1;
                        for (int k = 0; k < howMany2Add; ++k) {
                            this.allQuizProblems.add(this.allQuizProblems.get(1));
                            ArrayList<Integer> tmpQuizSectionNumber = new ArrayList<Integer>();
                            for (int i = 0; i < numberOfProblemsInFinalChallenge; ++i) {
                                tmpQuizSectionNumber.add(start);
                            }
                            this.allQuizSections.add(tmpQuizSectionNumber);
                            ++start;
                        }
                    }
                    while (this.quizLevel < this.allQuizProblems.size() && currentProblem >= this.allQuizProblems.get(this.quizLevel).size()) {
                        currentProblem -= this.allQuizProblems.get(this.quizLevel).size();
                        ++this.quizLevel;
                        this.getSimStPeerTutoringPlatform().addTrophy(false);
                    }
                    this.quizProblems = this.allQuizProblems.get(this.quizLevel);
                    this.quizSections = this.allQuizSections.get(this.quizLevel);
                    this.currentQuizSection = new ArrayList();
                    this.currentQuizSectionNumber = this.quizSections.get(currentProblem);
                    for (int i = 0; i < this.quizProblems.size(); ++i) {
                        if (this.quizSections.get(i) != this.currentQuizSectionNumber) continue;
                        this.currentQuizSection.add(GameShowUtilities.generate(this.quizProblems.get(i)));
                    }
                    int addedSectionCnt = 2;
                    this.newSectionTitleBase = this.sections.get(this.sections.size() - 1);
                    if (this.newSectionTitleBase.startsWith("-")) {
                        this.newSectionTitleBase = this.newSectionTitleBase.substring(1);
                    }
                    while (this.currentQuizSectionNumber >= this.sections.size()) {
                        String newSectionTitle = this.newSectionTitleBase + " " + addedSectionCnt;
                        this.sections.add(newSectionTitle);
                        ++addedSectionCnt;
                        this.setHasPassedFinalChallenge(true);
                    }
                    this.getSimStPeerTutoringPlatform().augmentMedals(currentProblem, false);
                }
                read.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            StudentAvatarDesigner.createAndShowGUI(this.simStPeerTutoringPlatform, this.simSt.getUserID());
        }
    }

    public boolean isFailedQuizProblem(String problemName, Hashtable<String, LinkedHashMap> quizAttemptsHash) {
        return quizAttemptsHash.containsKey(problemName);
    }

    public boolean isBehaviourDiscrepencyDetected(String problemName, RuleActivationNode ran) {
        boolean returnValue = false;
        if (this.isFailedQuizProblem(problemName, this.getQuizAttemptsHash())) {
            LinkedHashMap quizSolution = this.getQuizAttemptsHash().get(this.brController.getProblemName());
            if (ran != null && quizSolution.containsKey(ran.getActualSelection())) {
                String action_input = (String)quizSolution.get(ran.getActualSelection());
                String[] parts = action_input.split("\\$");
                if (!ran.getActualInput().equals(parts[1]) && !this.getConversation().getBehaviourDiscrepencyBroughtUp()) {
                    this.getConversation().setBehaviourDiscrepency(true);
                    returnValue = true;
                }
            } else if (this.brController.getProblemModel().getEdgeCount() != quizSolution.size() && !this.getConversation().getBehaviourDiscrepencyBroughtUp()) {
                this.getConversation().setBehaviourDiscrepency(true);
                returnValue = true;
            }
        }
        return returnValue;
    }

    public void config() {
        this.componentNames = new RegexHashtable();
        this.startStateElements = new ArrayList();
        this.examples = new ArrayList();
        this.exampleExplanations = new Hashtable();
        this.mistakeExplanations = new Hashtable();
        this.problemChoiceExplanations = new Hashtable();
        this.hintExplanations = new Hashtable();
        this.readConfigFile();
        this.conversation = new SimStConversation(this.brController, "simSt-speech.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfigFile() {
        String file = this.simSt.getPackageName() + "/" + CONFIG_FILE;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(file);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(isr);
            String line = reader.readLine();
            while (line != null) {
                if (line.equals(START_STATE_ELEMENTS_HEADER)) {
                    this.configStartState(reader);
                } else if (line.equals(FOA_ELEMENTS_HEADER)) {
                    this.configFoAElements(reader);
                } else if (line.equals(COMPONENT_NAMES_HEADER)) {
                    this.configCompNames(reader);
                } else if (line.equals(QUIZ_PROBLEMS_HEADER)) {
                    this.configQuiz(reader);
                } else if (line.equals("examples")) {
                    this.hasExamples = true;
                    this.configExamples(reader);
                } else if (line.equals(MISTAKE_EXPLANATION_HEADER)) {
                    this.configMistakeExplanations(reader);
                } else if (line.equals(PROBLEM_CHOICE_EXPLANATION_HEADER)) {
                    this.configProblemChoiceExplanations(reader);
                } else if (line.equals(HINT_EXPLANATION_HEADER)) {
                    this.configHintExplanations(reader);
                } else if (line.equals(VALID_SELECTIONS_FOR_SE)) {
                    this.configValidSelections(reader);
                } else if (line.equals(SECTIONS_HEADER)) {
                    this.configSections(reader);
                } else if (line.equals(PROBLEM_DELIMITER_HEADER)) {
                    this.configProblemDelimiter(reader);
                }
                if (line == null) continue;
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file: " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file: " + e.getMessage());
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                this.logger.simStLogException(e);
            }
        }
    }

    public void configStartState(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                this.startStateElements.add(line);
                this.addStartStateListener(line);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file (start state): " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file (start state): " + e.getMessage());
        }
    }

    public void configFoAElements(BufferedReader br) {
        try {
            String line = br.readLine();
            while (line != null && line.length() > 0) {
                this.addFoAStateListener(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void configCompNames(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                int index = line.indexOf(32);
                String regex = line.substring(0, index);
                String name = line.substring(index + 1);
                this.componentNames.put(regex, name);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file (comp names): " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file (comp names): " + e.getMessage());
        }
    }

    public void configProblemDelimiter(BufferedReader reader) {
        try {
            String line = reader.readLine();
            this.simSt.setProblemDelimiter(line);
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file (comp names): " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file (comp names): " + e.getMessage());
        }
    }

    public void configSections(BufferedReader reader) {
        try {
            this.sections = new ArrayList();
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                this.sections.add(line);
                line = reader.readLine();
            }
            trace.out("ss", "Sections-------------------------------");
            for (int i = 0; i < this.sections.size(); ++i) {
                trace.out("ss", this.sections.get(i));
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file (sections): " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file (sections): " + e.getMessage());
        }
    }

    public void configQuiz(BufferedReader reader) {
        try {
            int segment = 0;
            this.allQuizProblems = new ArrayList();
            this.allQuizSections = new ArrayList();
            this.allQuizProblems.add(new ArrayList());
            this.allQuizSections.add(new ArrayList());
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                if (line.equals(".")) {
                    ++segment;
                    this.allQuizProblems.add(new ArrayList());
                    this.allQuizSections.add(new ArrayList());
                } else {
                    String[] parts = line.split(EXAMPLE_VALUE_MARKER);
                    this.allQuizProblems.get(segment).add(parts[1]);
                    this.allQuizSections.get(segment).add(Integer.parseInt(parts[0]));
                }
                line = reader.readLine();
            }
            this.quizProblems = this.allQuizProblems.get(this.quizLevel);
            this.quizSections = this.allQuizSections.get(0);
            this.currentQuizSection = new ArrayList();
            int currentQuizSectionNumber = 0;
            for (int i = 0; i < this.quizProblems.size(); ++i) {
                if (this.quizSections.get(i) != currentQuizSectionNumber) continue;
                this.currentQuizSection.add(this.quizProblems.get(i));
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file (quiz): " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file (quiz): " + e.getMessage());
        }
    }

    public void configExamples(BufferedReader reader) {
        int numExamples = 0;
        try {
            String line = reader.readLine();
            SimStExample example = new SimStExample();
            ++numExamples;
            while (line != null && line.length() > 0) {
                if (line.startsWith("section:")) {
                    String section = line.substring(line.indexOf(58) + 1);
                    example.setSection(Integer.parseInt(section));
                } else if (line.startsWith("title:")) {
                    String title = line.substring(line.indexOf(58) + 1);
                    example.setTitle(title);
                } else if (line.startsWith("text:")) {
                    String explanation = line.substring(line.indexOf(58) + 1);
                    example.setExplanation(explanation);
                } else if (line.startsWith("shortDescription:")) {
                    String hint = line.substring(line.indexOf(58) + 1);
                    example.setShortDescription(hint);
                } else if (line.equals(".")) {
                    ++numExamples;
                    this.examples.add(example);
                    example = new SimStExample();
                } else {
                    String[] values = line.split(EXAMPLE_VALUE_MARKER);
                    if (values.length == 3) {
                        example.addStep(values[0], values[1], "", "");
                    } else if (values.length == 4) {
                        example.addStep(values[0], values[1], values[2], values[4]);
                    } else if (values.length >= 4) {
                        if (values[3].equals("correct")) {
                            example.addStep(values[0], values[1], values[2], true, values[4]);
                        } else if (values[3].equals("incorrect")) {
                            example.addStep(values[0], values[1], values[2], false, values[4]);
                        } else {
                            example.addStep(values[0], values[1], values[2], values[4]);
                        }
                    }
                }
                line = reader.readLine();
            }
            this.examples.add(example);
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file (examples): " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file (examples): " + e.getMessage());
        }
    }

    public void configMistakeExplanations(BufferedReader reader) {
        this.configExplanations(reader, this.mistakeExplanations);
    }

    public void configProblemChoiceExplanations(BufferedReader reader) {
        this.configExplanations(reader, this.problemChoiceExplanations);
    }

    public void configHintExplanations(BufferedReader reader) {
        this.configExplanations(reader, this.hintExplanations);
    }

    private void configExplanations(BufferedReader reader, Hashtable<String, LinkedList<Explanation>> explanations) {
        try {
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                LinkedList<Explanation> questionChoices = new LinkedList<Explanation>();
                if (line.startsWith("text:")) {
                    String question = line.substring(line.indexOf(58) + 1);
                    explanations.put(question, questionChoices);
                    line = reader.readLine();
                }
                while (line != null && !line.equals(".") && line.length() > 0) {
                    String[] parts = line.split(EXAMPLE_VALUE_MARKER);
                    if (parts.length == 2) {
                        String explain = parts[1];
                        String[] conditions = parts[0].split(",");
                        questionChoices.add(new Explanation(conditions, explain));
                    }
                    line = reader.readLine();
                }
                if (line != null && line.length() != 0) {
                    line = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file (explanations): " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file (explanations): " + e.getMessage());
        }
    }

    public void configValidSelections(BufferedReader reader) {
        try {
            this.validSelections = new HashSet();
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                this.validSelections.add(line);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Unable to read config file (valid selections) : " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Unable to read config file (valid selections): " + e.getMessage());
        }
    }

    public QuestionAnswers getMatchingMistakeExplanation(String skill, Sai sai, String problem, RuleActivationNode ran) {
        Object[] questions = this.mistakeExplanations.keySet().toArray();
        if (questions.length == 0) {
            return null;
        }
        String question = questions[(int)(Math.random() * (double)questions.length)].toString();
        List<String> matches = this.getMatching((List<Explanation>)this.mistakeExplanations.get(question), skill, sai, problem, ran);
        if ((question = this.replaceMatchSymbols(question, skill, sai, problem, ran)) == null) {
            return null;
        }
        QuestionAnswers qa = new QuestionAnswers(question, matches);
        return qa;
    }

    public QuestionAnswers getMatchingProblemChoiceExplanation(String problem) {
        Object[] questions = this.problemChoiceExplanations.keySet().toArray();
        if (questions.length == 0) {
            return null;
        }
        String question = questions[(int)(Math.random() * (double)questions.length)].toString();
        List<String> matches = this.getMatching((List<Explanation>)this.problemChoiceExplanations.get(question), "", null, problem, null);
        if ((question = this.replaceMatchSymbols(question, "", null, problem, null)) == null) {
            return null;
        }
        QuestionAnswers qa = new QuestionAnswers(question, matches);
        return qa;
    }

    public QuestionAnswers getMatchingHintExplanation(String skill, Sai sai, String problem) {
        Object[] questions = this.hintExplanations.keySet().toArray();
        if (questions.length == 0) {
            return null;
        }
        String question = questions[(int)(Math.random() * (double)questions.length)].toString();
        List<String> matches = this.getMatching((List<Explanation>)this.hintExplanations.get(question), skill, sai, problem, null);
        if ((question = this.replaceMatchSymbols(question, skill, sai, problem, null)) == null) {
            return null;
        }
        QuestionAnswers qa = new QuestionAnswers(question, matches);
        return qa;
    }

    public List<String> getMatching(List<Explanation> explanations, String skill, Sai sai, String problem, RuleActivationNode ran) {
        LinkedList<String> matches = new LinkedList<String>();
        String input = "";
        if (sai != null) {
            input = sai.getI();
        }
        matches.add(SELECT_OPTION);
        for (Explanation me : explanations) {
            String explanation;
            if (!me.matches(skill, problem, input) || (explanation = this.replaceMatchSymbols(me.explanation, skill, sai, problem, ran)) == null) continue;
            matches.add(explanation);
        }
        if (matches.size() == 1) {
            matches.remove(SELECT_OPTION);
        } else {
            matches.add(OTHER_OPTION);
        }
        return matches;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String replaceMatchSymbols(String matchString, String skill, Sai sai, String problem, RuleActivationNode ran) {
        Object foas;
        if (matchString.contains(FOA_EXAMPLE_MATCH_SYMBOL)) {
            if (this.simSt.instructions.get(skill) == null || this.simSt.instructions.get(skill).size() <= 0 || ran == null) return null;
            foas = this.simSt.instructionDesc(skill, sai, ran.getRuleFoas());
            if (foas == null) return null;
            matchString = matchString.replace(FOA_EXAMPLE_MATCH_SYMBOL, (CharSequence)foas);
        }
        if (matchString.contains(INPUT_MATCH_SYMBOL)) {
            if (sai != null) {
                String input = sai.getI();
                if (sai.getS().equalsIgnoreCase("DONE")) {
                    input = "clicking the problem solved button";
                }
                matchString = matchString.replace(INPUT_MATCH_SYMBOL, input);
            } else {
                matchString = matchString.replace(INPUT_MATCH_SYMBOL, "that input");
            }
        }
        if (matchString.contains(OPERAND_MATCH_SYMBOL)) {
            if (sai != null) {
                String operand = sai.getI();
                if (sai.getS().equalsIgnoreCase("DONE")) {
                    operand = "done";
                }
                if (operand.contains(" ")) {
                    operand = operand.substring(operand.indexOf(32) + 1);
                }
                matchString = matchString.replace(OPERAND_MATCH_SYMBOL, operand);
            } else {
                matchString = matchString.replace(OPERAND_MATCH_SYMBOL, "that operand");
            }
        }
        if (matchString.contains(OPERATOR_MATCH_SYMBOL)) {
            if (sai != null) {
                String operator = sai.getI();
                if (operator.contains(" ")) {
                    operator = operator.substring(0, operator.indexOf(32));
                }
                if (sai.getS().equalsIgnoreCase("DONE")) {
                    operator = "click done";
                }
                matchString = matchString.replace(OPERATOR_MATCH_SYMBOL, operator);
            } else {
                matchString = matchString.replace(OPERAND_MATCH_SYMBOL, "do that");
            }
        }
        if (matchString.contains(PROBLEM_MATCH_SYMBOL)) {
            if (problem != null) {
                problem = SimSt.convertFromSafeProblemName(problem);
                matchString = matchString.replace(PROBLEM_MATCH_SYMBOL, problem);
            } else {
                matchString = matchString.replace(PROBLEM_MATCH_SYMBOL, "this problem");
            }
        }
        if (matchString.contains(FOA_PART_MATCH_SYMBOL)) {
            if (sai != null) {
                foas = ran == null ? this.simSt.listFoas(sai) : ran.getRuleFoas();
                String relevant = this.simSt.relevantFoaString(sai.getI(), (Vector)foas);
                matchString = relevant != null ? matchString.replace(FOA_PART_MATCH_SYMBOL, relevant) : matchString.replace(FOA_PART_MATCH_SYMBOL, "the relevant part");
            } else {
                matchString = matchString.replace(FOA_PART_MATCH_SYMBOL, "the relevant part");
            }
        }
        while (matchString.indexOf(62) > -1) {
            String segment = "";
            int indexEnd = matchString.indexOf(62);
            if (matchString.substring(0, indexEnd).indexOf(60) <= -1) return null;
            segment = matchString.substring(matchString.substring(0, indexEnd).lastIndexOf(60), indexEnd + 1);
            String wOutBracket = segment.replaceAll("<", "").replaceAll(">", "");
            if (wOutBracket.indexOf(34) > -1) {
                int index1 = wOutBracket.indexOf(34);
                int index2 = wOutBracket.lastIndexOf(34) + 1;
                String toReplace = wOutBracket.substring(index1, index2);
                String replaceWith = toReplace.replaceAll("\"", "");
                replaceWith = replaceWith.replaceAll(" ", "&");
                wOutBracket = wOutBracket.replaceAll(toReplace, replaceWith);
            }
            String[] parts = wOutBracket.split(" ");
            MTRete mtRete = this.brController.getModelTracer().getRete();
            Userfunction function = mtRete.findUserfunction(parts[0]);
            if (function == null) {
                return null;
            }
            if (wOutBracket.indexOf(38) > -1) {
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = parts[i].replaceAll("&", " ");
                }
            }
            String result = "";
            ValueVector values = new ValueVector();
            try {
                for (int i = 0; i < parts.length; ++i) {
                    if (parts[i] == null) continue;
                    values.add(parts[i]);
                }
                Value resultValue = function.call(values, mtRete.getGlobalContext());
                result = resultValue.stringValue(mtRete.getGlobalContext());
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (JessException e) {
                e.printStackTrace();
            }
            if (result.equals("FALSE")) {
                if (!sai.getS().equalsIgnoreCase("DONE") || parts.length <= 1) return null;
                result = parts[1];
            }
            matchString = matchString.replace(segment, result);
        }
        return matchString;
    }

    public void reloadQuizQuestions() {
        this.randomizeQuizProblems();
        this.getSimStPeerTutoringPlatform().clearQuizzes();
        for (int i = 0; i < this.quizProblems.size(); ++i) {
            SimStExample quizProblem = null;
            if (i < currentProblem) {
                if (this.simSt != null && this.simSt.getSolvedQuizProblem() != null && this.simSt.getSolvedQuizProblem().size() > i) {
                    quizProblem = this.simSt.getSolvedQuizProblem().get(i);
                }
                if (quizProblem == null) {
                    quizProblem = new SimStExample();
                    quizProblem.setIndex(i);
                    quizProblem.setTitle(i + 1 + ". " + GameShowUtilities.generate(this.getQuizProblem(i)));
                    quizProblem.setStatus(SimStExample.QUIZ_OLD);
                    quizProblem.setSection(this.quizSections.get(i));
                }
            } else {
                quizProblem = new SimStExample();
                quizProblem.setTitle(i + 1 + ". -----------------");
                quizProblem.setIndex(i);
                quizProblem.setStatus(SimStExample.QUIZ_LOCKED);
                quizProblem.setSection(this.quizSections.get(i));
            }
            this.getSimStPeerTutoringPlatform().addQuiz(quizProblem);
        }
    }

    public String getComponentName(String formalName) {
        Object cname = this.componentNames.getRegexMatch(formalName);
        if (cname != null) {
            return cname.toString();
        }
        return null;
    }

    public void setFocusTab(int tabNum) {
        JTabbedPaneWithCloseIcons tabPane = this.getSimStPeerTutoringPlatform().getExamplePane();
        if (tabNum >= tabPane.getTabCount()) {
            this.logger.simStLogException(new ArrayIndexOutOfBoundsException(), "Error: Unable to set tab to " + tabNum + " with " + tabPane.getTabCount() + " tabs.");
            return;
        }
        tabPane.setSelectedIndex(tabNum);
    }

    public void showCurriculumBrowser() {
        this.getCurriculumBrowser().showCB();
    }

    public CurriculumBrowser getCurriculumBrowser() {
        return this.curriculumBrowser;
    }

    public void setCurriculumBrowser(CurriculumBrowser curriculumBrowser) {
        this.curriculumBrowser = curriculumBrowser;
    }

    public void examples() {
        if (this.getSimStPeerTutoringPlatform().getExampleButton().getText().equals("<html><p>Hide</p><p>Examples</p></html>")) {
            this.hideExamples();
            this.getSimStPeerTutoringPlatform().getExampleButton().setText("<html><p>Show</p><p>Examples</p></html>");
        } else {
            this.showExamples();
            this.getSimStPeerTutoringPlatform().getExampleButton().setText("<html><p>Hide</p><p>Examples</p></html>");
        }
    }

    public void showExamples() {
        JTabbedPaneWithCloseIcons exampleTabPane = this.getSimStPeerTutoringPlatform().getExamplePane();
        JComponent studentInterface = this.getSimStPeerTutoringPlatform().getStudentInterface();
        for (int exampleNum = 0; exampleNum < this.examples.size(); ++exampleNum) {
            JPanel examplePanel = new JPanel();
            exampleTabPane.addTab("Example " + (exampleNum + 1), examplePanel, false);
        }
    }

    public void showExample(JPanel examplePanel, Hashtable<String, String> example, JComponent studentInterface) {
        try {
            JComponent newInterface = (JComponent)studentInterface.getClass().newInstance();
            SimStPLE.setComponentEnabled(false, newInterface);
            this.tableNumber = 0;
            this.fillInExample(example, newInterface);
            newInterface.setPreferredSize(studentInterface.getSize());
            examplePanel.setLayout(new FlowLayout());
            SimStPLE.setComponentFont(newInterface, new Font("Serif", 0, 18));
            examplePanel.add(newInterface);
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Error in creating example tab for example: " + e.getMessage());
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "Error in creating example tab for example: " + e.getMessage());
        }
    }

    public void fillInExample(Hashtable<String, String> example, JComponent exampleInterface) {
        if (exampleInterface instanceof JCommTable) {
            JCommTable table = (JCommTable)exampleInterface;
            for (int x = 0; x < table.getColumns(); ++x) {
                for (int y = 0; y < table.getRows(); ++y) {
                    String key = this.tableNumber + EXAMPLE_LOCATION_MARKER + x + EXAMPLE_LOCATION_MARKER + y;
                    if (!example.containsKey(key)) continue;
                    JCommTable.TableCell cell = table.getCell(y, x);
                    cell.setText(example.get(key));
                }
            }
            ++this.tableNumber;
        } else {
            for (int i = 0; i < exampleInterface.getComponentCount(); ++i) {
                JComponent c = (JComponent)exampleInterface.getComponent(i);
                this.fillInExample(example, c);
            }
        }
    }

    public void hideExamples() {
        JTabbedPaneWithCloseIcons examplePane = this.getSimStPeerTutoringPlatform().getExamplePane();
        for (int i = examplePane.getTabCount() - 1; i > 0; --i) {
            examplePane.removeTabAt(i);
        }
    }

    public void undo() {
        this.setFocusTab(0);
        new Thread(new UndoThread()).start();
    }

    public String generateUndoQueryMessage(String selection, String action, String input) {
        String message = "";
        message = action.equalsIgnoreCase("ButtonPressed") ? (selection.equalsIgnoreCase("DONE") ? UNDO_DONE_MSG : (this.getComponentName(selection) != null ? "Should I go back before I clicked " + this.getComponentName(selection) + "?" : "Should I go back before I clicked the " + selection + " button?")) : (this.getComponentName(selection) != null ? (!this.simSt.isInteractiveLearning() ? "I guess I can give it another try.  Should I erase \"" + input + "\" " + this.getComponentName(selection) + "?" : "Should I erase \"" + input + "\" in " + this.getComponentName(selection) + "?") : (!this.simSt.isInteractiveLearning() ? "I guess I can give it another try.  Should I erase \"" + input + "\" from " + selection + "?" : "Should I erase \"" + input + "\" from " + selection + "?"));
        return message;
    }

    public void nextProblem() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Enter nextProblem to call autoSaveInstructions()");
        }
        this.getMissController().autoSaveInstructions();
        this.getMissController().getSimSt().saveSimStState();
        this.getMissController().getSimSt().setProblemStepString("START");
        this.setFocusTab(0);
        JButton nextProblemButton = this.getSimStPeerTutoringPlatform().getNextProblemButton();
        if (nextProblemButton.getText().equals(this.getProblemEnteredButtonString())) {
            this.startProblem();
        } else {
            this.requestEnterNewProblem();
        }
    }

    public String getNextSuggestedProblem() {
        if (problemMap == null) {
            trace.err("Problem Bank was not initialized");
            return "";
        }
        Set<String> keys = problemMap.keySet();
        for (String problem : keys) {
            String status = problemMap.get(problem);
            if (status != "NotUsed") continue;
            return problem;
        }
        trace.err("No next suggested problem as all the problems in the Problem Bank have been used");
        return "";
    }

    public void restartProblem() {
        this.setFocusTab(0);
        String step = this.simSt.getProblemStepString();
        this.simSt.killInteractiveLearningThreadIfAny();
        this.brController.goToStartState();
        this.simSt.displayMessage("Problem Restart", RESTART_MSG);
        int problemDuration = (int)(Calendar.getInstance().getTimeInMillis() - this.getSsInteractiveLearning().getProblemRecentTime());
        this.getSsInteractiveLearning().setProblemRecentTime(Calendar.getInstance().getTimeInMillis());
        this.logger.simStLog("SIM_STUDENT_PROBLEM", "Problem Restarted", step, "", (Object)"", problemDuration);
        this.startProblem(true);
    }

    public void quizSimSt() {
        new Thread(new SSQuizThread()).start();
    }

    public Vector<ProblemEdge> getSolutionEdges() {
        return this.solutionEdges;
    }

    public void setSolutionEdges(Vector<ProblemEdge> solutionEdges) {
        this.solutionEdges = solutionEdges;
    }

    private Vector<Vector<ProblemEdge>> solveQuizProblems() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "####### solveQuizProblems...");
        }
        long startQuizTime = Calendar.getInstance().getTimeInMillis();
        int numCorrect = 0;
        Vector<Vector<ProblemEdge>> solutions = new Vector<Vector<ProblemEdge>>();
        this.randomizeQuizProblems();
        for (int i = 0; i < this.currentQuizSection.size(); ++i) {
            this.getSimStPeerTutoringPlatform().refresh();
            String problem = this.getRandomizedQuizProblem(i);
            this.giveMessage("I'm working on quiz problem #" + (currentProblem + i + 1) + " now.");
            this.getSimStPeerTutoringPlatform().refresh();
            this.logger.simStLog("SIM_STUDENT_QUIZ", "Sim Student Given Quiz Question", "Quiz" + (this.currentQuizSectionNumber + 1) + "." + (currentProblem + i + 1), "", problem);
            long startQuizQuestionTime = Calendar.getInstance().getTimeInMillis();
            this.getBrController().startNewProblem();
            this.getSsInteractiveLearning().ssInteractiveLearningOnProblem(problem);
            ProblemNode startState = this.getBrController().getProblemModel().getStartNode();
            Vector<ProblemEdge> solution = this.simSt.getProblemAssessor().findSolutionPath(startState);
            solutions.add(solution != null ? solution : new Vector<ProblemEdge>());
            this.getSimStPeerTutoringPlatform().refresh();
            boolean result = this.getSimSt().getProblemAssessor().isProblemComplete(problem, solution);
            if (result) {
                ++numCorrect;
            }
            long quizQuestionDuration = Calendar.getInstance().getTimeInMillis() - startQuizQuestionTime;
            this.logger.simStLog("SIM_STUDENT_QUIZ", "Sim Student Answers Quiz Question", "Quiz" + this.currentQuizSectionNumber + "." + (currentProblem + i), this.solutionSteps(problem, solution), (Object)"", result, (int)quizQuestionDuration);
        }
        float pctCorrect = (float)(numCorrect + currentProblem) / (float)this.getQuizProblems().size();
        int quizDuration = (int)(Calendar.getInstance().getTimeInMillis() - startQuizTime);
        this.logger.simStLog("SIM_STUDENT_QUIZ", "Quiz Completed", "Quiz" + this.currentQuizSectionNumber, "" + pctCorrect, (Object)("" + numCorrect + "/" + this.getQuizProblems().size()), quizDuration);
        this.currentCorrect = numCorrect;
        this.getSimStPeerTutoringPlatform().setQuizProgress(pctCorrect);
        this.getBrController().startNewProblem();
        return solutions;
    }

    private static void printInstrumentation(Properties properties) {
        for (String string : properties.keySet()) {
            String property = properties.getProperty(string);
            System.out.println(string + " : " + property);
        }
    }

    private String solutionSteps(String problem, Vector<ProblemEdge> solutionPath) {
        String solution = problem;
        if (solutionPath == null) {
            solution = solution + ",PROBLEM_NOT_SOLVED";
        } else {
            for (ProblemEdge edge : solutionPath) {
                if (edge.getSelection().equalsIgnoreCase("DONE")) {
                    solution = solution + "," + edge.getSelection();
                    continue;
                }
                solution = solution + "," + edge.getInput();
            }
        }
        return solution;
    }

    private String quizSolutionSteps(String problem, Vector<ProblemEdge> solutionPath) {
        StringBuffer solution = new StringBuffer();
        if (solutionPath == null) {
            solution.append(",PROBLEM_NOT_SOLVED");
        } else {
            for (ProblemEdge edge : solutionPath) {
                if (edge.getSelection().equalsIgnoreCase("DONE")) {
                    solution.append("," + edge.getSelection());
                    continue;
                }
                solution.append("," + edge.getInput());
            }
        }
        return solution.toString();
    }

    private static boolean correctCompleteAnswers(String problem, Vector<ProblemEdge> solutionPath) {
        String[] problemParts = problem.split("=");
        if (problemParts.length < 2) {
            return false;
        }
        String firstPrev = problemParts[0];
        String secondPrev = problemParts[1];
        if (solutionPath == null || solutionPath.size() == 0) {
            return false;
        }
        for (ProblemEdge edge : solutionPath) {
            if (edge.getSelection().equalsIgnoreCase("DONE")) {
                if (firstPrev.length() == 1 && Character.isLetter(firstPrev.charAt(0))) {
                    boolean valid = true;
                    for (int i = 0; i < secondPrev.length(); ++i) {
                        if (secondPrev.charAt(0) == '-' && i == 0 || secondPrev.charAt(i) == '.') continue;
                        if (secondPrev.charAt(i) == '/') {
                            if (!secondPrev.substring(i + 1).contains("/")) continue;
                            valid = false;
                            break;
                        }
                        if (Character.isDigit(secondPrev.charAt(i))) continue;
                        valid = false;
                        break;
                    }
                    return !secondPrev.contains(firstPrev) && !secondPrev.contains(" ") && valid;
                }
                if (secondPrev.length() == 1 && Character.isLetter(secondPrev.charAt(0))) {
                    boolean valid = true;
                    for (int i = 0; i < firstPrev.length(); ++i) {
                        if (firstPrev.charAt(0) == '-' && i == 0 || firstPrev.charAt(i) == '.') continue;
                        if (firstPrev.charAt(i) == '/') {
                            if (!firstPrev.substring(i + 1).contains("/")) continue;
                            valid = false;
                            break;
                        }
                        if (Character.isDigit(firstPrev.charAt(i))) continue;
                        valid = false;
                        break;
                    }
                    return !firstPrev.contains(secondPrev) && !firstPrev.contains(" ");
                }
            }
            if (!edge.isCorrect()) {
                return false;
            }
            firstPrev = secondPrev;
            secondPrev = edge.getInput();
        }
        return false;
    }

    private void displayQuizResultsAlgebra(Vector<Vector<ProblemEdge>> results) {
        SimStPeerTutoringPlatform ssPTP = this.getSimStPeerTutoringPlatform();
        String solutions = this.formatSolutionsAlgebra(results);
        if (this.currentCorrect == this.getSimSt().getProblemsPerQuiz() && this.getSimSt().getProblemsPerQuiz() != 0 || currentProblem + this.currentCorrect == this.quizProblems.size()) {
            int numSections = (int)Math.ceil((double)this.quizProblems.size() / (double)this.getSimSt().getProblemsPerQuiz());
            int sectionNum = currentProblem * numSections / this.quizProblems.size() + 1;
            ssPTP.displayQuizResults(solutions, sectionNum, true, this.getQuizLevel() + 1);
        } else if (this.getSimSt().getProblemsPerQuiz() != 0) {
            int numSections = (int)Math.ceil((double)this.quizProblems.size() / (double)this.getSimSt().getProblemsPerQuiz());
            int sectionNum = currentProblem * numSections / this.quizProblems.size() + 1;
            ssPTP.displayQuizResults(solutions, sectionNum, false, this.getQuizLevel() + 1);
        } else {
            ssPTP.displayQuizResults(solutions);
        }
    }

    private String formatSolutionsAlgebra(Vector<Vector<ProblemEdge>> results) {
        if (results.size() == 0) {
            trace.out("ss", this.quizProblems.size() + " " + this.quizProblems.get(0));
        }
        String solutions = "<html>";
        if (this.getSimSt().getProblemsPerQuiz() > 0) {
            int numSections = (int)Math.ceil((double)this.quizProblems.size() / (double)this.getSimSt().getProblemsPerQuiz());
            int sectionNum = currentProblem * numSections / this.quizProblems.size() + 1;
            solutions = solutions + "+++ Quiz Section " + sectionNum + " of " + numSections + " ++<br><br>";
        }
        int i = 0;
        int nCorrect = 0;
        for (Vector<ProblemEdge> path : results) {
            String solution = "";
            if (this.simSt.getProblemAssessor() != null) {
                solution = this.simSt.getProblemAssessor().formatSolution(path, this.getRandomizedQuizProblem(i));
            }
            if (solution.indexOf("green") > solution.indexOf("red") && solution.indexOf("done") > 0) {
                ++nCorrect;
            }
            solutions = solutions + "++++ Problem No." + (i + 1) + " ++++++++++<br>";
            solutions = solutions + solution + "<br>";
            ++i;
        }
        int partialPercent = nCorrect * 100 / results.size();
        int percent = (this.currentCorrect + currentProblem) * 100 / this.quizProblems.size();
        if (percent >= 100) {
            quizPassed = true;
        }
        if (this.getSimSt().getProblemsPerQuiz() > 0) {
            solutions = solutions + "++ Score:<br>++This section: " + nCorrect + "/" + results.size() + " (" + partialPercent + "%)<br>";
            solutions = solutions + "++ Overall: " + (this.currentCorrect + currentProblem) + "/" + this.quizProblems.size() + " (" + percent + "%)<br>";
        } else {
            solutions = solutions + "++ Score: " + nCorrect + "/" + results.size() + " (" + partialPercent + "%)<br>";
        }
        solutions = solutions + "</html>";
        solutions = solutions.replace("LHS", "");
        solutions = solutions.replace("RHS", "");
        return solutions;
    }

    private void displayQuizResultsAlgebraI(Vector<Vector<ProblemEdge>> results) {
        SimStPeerTutoringPlatform ssPTP = this.getSimStPeerTutoringPlatform();
        String solutions = this.formatSolutionsAlgebraV2(results);
        if (this.currentCorrect == this.getSimSt().getProblemsPerQuiz() && this.getSimSt().getProblemsPerQuiz() != 0 || currentProblem + this.currentCorrect == this.quizProblems.size()) {
            int numSections = (int)Math.ceil((double)this.quizProblems.size() / (double)this.getSimSt().getProblemsPerQuiz());
            int sectionNum = currentProblem * numSections / this.quizProblems.size() + 1;
            ssPTP.displayQuizResults(solutions, sectionNum, true, this.getQuizLevel() + 1);
        } else if (this.getSimSt().getProblemsPerQuiz() != 0) {
            int numSections = (int)Math.ceil((double)this.quizProblems.size() / (double)this.getSimSt().getProblemsPerQuiz());
            int sectionNum = currentProblem * numSections / this.quizProblems.size() + 1;
            ssPTP.displayQuizResults(solutions, sectionNum, false, this.getQuizLevel() + 1);
        } else {
            ssPTP.displayQuizResults(solutions);
        }
    }

    private String formatSolutionsAlgebraV2(Vector<Vector<ProblemEdge>> results) {
        if (results.size() == 0) {
            trace.out("ss", this.quizProblems.size() + " " + this.quizProblems.get(0));
        }
        String solutions = "<html>";
        if (this.getSimSt().getProblemsPerQuiz() > 0) {
            int numSections = (int)Math.ceil((double)this.quizProblems.size() / (double)this.getSimSt().getProblemsPerQuiz());
            int sectionNum = currentProblem * numSections / this.quizProblems.size() + 1;
            solutions = solutions + "+++ Quiz Section " + sectionNum + " of " + numSections + " ++<br><br>";
        }
        int i = 0;
        int nCorrect = 0;
        for (Vector<ProblemEdge> path : results) {
            String solution = this.getSimSt().getProblemAssessor().formatSolution(path, this.getRandomizedQuizProblem(i));
            if (solution.indexOf("green") > solution.indexOf("red") && solution.indexOf("done") > 0) {
                ++nCorrect;
            }
            solutions = solutions + "++++ Problem No." + (i + 1) + " ++++++++++<br>";
            solutions = solutions + solution + "<br>";
            ++i;
        }
        int partialPercent = nCorrect * 100 / results.size();
        int percent = (this.currentCorrect + currentProblem) * 100 / this.quizProblems.size();
        if (percent >= 100) {
            quizPassed = true;
        }
        if (this.getSimSt().getProblemsPerQuiz() > 0) {
            solutions = solutions + "++ Score:<br>++This section: " + nCorrect + "/" + results.size() + " (" + partialPercent + "%)<br>";
            solutions = solutions + "++ Overall: " + (this.currentCorrect + currentProblem) + "/" + this.quizProblems.size() + " (" + percent + "%)<br>";
        } else {
            solutions = solutions + "++ Score: " + nCorrect + "/" + results.size() + " (" + partialPercent + "%)<br>";
        }
        solutions = solutions + "</html>";
        solutions = solutions.replace("LHS", "");
        solutions = solutions.replace("RHS", "");
        return solutions;
    }

    public String genCurrentLevelTitleString() {
        return "Prepare " + this.getSimStName() + " for Quiz Level " + this.getCurrentLevel();
    }

    private String replaceName(String str) {
        return str.replace("$", this.getSimStName());
    }

    public String getNextProblemButtonTitleString() {
        return this.replaceName("<html><p>Tutor $ Next Problem</p></html>");
    }

    public String getProblemEnteredButtonString() {
        return "<html><p>Click Here When</p><p>Problem Entered</p></html>";
    }

    public String getCurriculumBrowserButtonTitleString() {
        return this.replaceName("<html><p>$</p><p>Introduction</p></html>");
    }

    public String getShowExampleButtonTitleString() {
        return "<html><p>Show</p><p>Examples</p></html>";
    }

    public String getHideExampleButtonTitleString() {
        return "<html><p>Hide</p><p>Examples</p></html>";
    }

    public String getUndoButtonTitleString() {
        return "<html><p>Erase Last Step ($)</p></html>".replace("$", "Last Step");
    }

    public String getUndoButtonTitleString(String step) {
        if (step.equalsIgnoreCase("done")) {
            return "<html><p>Problem Is Not Done</p></html>";
        }
        return "<html><p>Erase Last Step ($)</p></html>".replace("$", step);
    }

    public String getRestartButtonTitleString() {
        return "<html><p>Restart Problem</p></html>";
    }

    public String getNextProblemDialogTitleString() {
        return this.replaceName("Tutor $ Next Problem");
    }

    public String getQuizButtonTitleString() {
        return this.replaceName("<html><p>Quiz $</p></html>");
    }

    public String getProblemBankButtonTitleString() {
        return "<html><p>Generate Bank</p><p>of Problems</html>";
    }

    public void requestEnterNewProblem() {
        this.getBrController().startNewProblem();
        this.setAvatarStart();
        this.getConversation().setBehaviourDiscrepencyBroughtUp(false);
    }

    public void startProblem() {
        this.startProblem(false);
    }

    public void startProblem(boolean restart) {
        if (trace.getDebugCode("miss")) {
            trace.out("startProblem");
        }
        if (!this.checkValidProblemEntered()) {
            this.setAvatarStart();
            return;
        }
        this.getSimSt().setIsInteractiveLearning(true);
        new Thread(new ProblemStartThread(restart)).start();
    }

    private String getCurrentProblem() {
        String problem = "";
        for (int i = 0; i < this.startStateElements.size(); ++i) {
            String element2 = this.startStateElements.get(i);
            Object widget = this.brController.lookupWidgetByName(element2);
            if (widget == null || !(widget instanceof JCommTable.TableExpressionCell)) continue;
            JCommTable.TableExpressionCell cell = (JCommTable.TableExpressionCell)widget;
            String input = cell.getText();
            if (i + 1 == this.startStateElements.size()) {
                problem = problem + "=";
                problem = problem + input;
                continue;
            }
            problem = problem + input;
        }
        return problem;
    }

    public boolean checkValidProblemEntered() {
        for (int i = 0; i < this.startStateElements.size(); ++i) {
            String element2 = this.startStateElements.get(i);
            Object widget = this.brController.lookupWidgetByName(element2);
            if (widget == null || !(widget instanceof JCommTable.TableExpressionCell)) continue;
            JCommTable.TableExpressionCell cell = (JCommTable.TableExpressionCell)widget;
            String input = cell.getText();
            if (input.length() < 1) {
                this.giveMessage(ENTER_FULL_PROBLEM);
                return false;
            }
            if (!this.getSimSt().isInputCheckerDefined() || this.getSimSt().getInputChecker().checkInput(element2, input, null, this.getBrController())) continue;
            this.giveMessage(this.getSimSt().getInputChecker().invalidInputMessage(element2, input, null));
            return false;
        }
        return true;
    }

    public void addStartStateListener(String element2) {
        Object widget = this.brController.lookupWidgetByName(element2);
        if (widget != null && widget instanceof JCommTable.TableExpressionCell) {
            JCommTable.TableExpressionCell cell = (JCommTable.TableExpressionCell)widget;
            cell.addCaretListener(new StartStateChangeListener());
            cell.addFocusListener(new StartStateChangeListener());
        }
    }

    public void addFoAStateListener(String element2) {
        Object widget = this.brController.lookupWidgetByName(element2);
        if (widget != null && widget instanceof JCommTable.TableExpressionCell) {
            JCommTable.TableExpressionCell cell = (JCommTable.TableExpressionCell)widget;
            cell.addCaretListener(new FoAStateChangeListener());
            cell.addFocusListener(new FoAStateChangeListener());
        }
    }

    public void checkCompletedStartState() {
        String element2 = null;
        String input = null;
        if (this.getSsInteractiveLearning() != null && this.getSsInteractiveLearning().isTakingQuiz()) {
            return;
        }
        if (this.getSimStPeerTutoringPlatform().getButtonsShowing()) {
            return;
        }
        for (int i = 0; i < this.startStateElements.size(); ++i) {
            JCommTable.TableExpressionCell cell;
            element2 = this.startStateElements.get(i);
            Object widget = this.brController.lookupWidgetByName(element2);
            if (widget == null || !(widget instanceof JCommTable.TableExpressionCell) || (input = (cell = (JCommTable.TableExpressionCell)widget).getText().toLowerCase()).length() >= 1) continue;
            return;
        }
        this.simSt.displayActionListenerMessage(this.conversation.getMessage("START_PROBLEM"), new SimpleListener());
    }

    public boolean checkVariableUsedStartState() {
        if (!this.getSimSt().isInputCheckerDefined()) {
            return true;
        }
        for (int i = 0; i < this.startStateElements.size(); ++i) {
            String element2 = this.startStateElements.get(i);
            Object widget = this.brController.lookupWidgetByName(element2);
            if (widget == null || !(widget instanceof JCommTable.TableExpressionCell)) continue;
            JCommTable.TableExpressionCell cell = (JCommTable.TableExpressionCell)widget;
            String input = cell.getText();
            if (i == 0) {
                this.cellText1 = input.toLowerCase();
                continue;
            }
            if (i != 1) continue;
            this.cellText2 = input.toLowerCase();
        }
        return this.getSimSt().getInputChecker().checkVariables(this.cellText1, this.cellText2);
    }

    private String askNewProblem() {
        String message = ASK_NEW_PROBLEM_MSG;
        String title = this.getNextProblemDialogTitleString();
        String problem = JOptionPane.showInputDialog(this.getSimStPeerTutoringPlatform(), message, title, 3);
        this.logger.simStLog("SIM_STUDENT_DIALOGUE", "New Problem Requested", problem, title + EXAMPLE_VALUE_MARKER + message);
        return problem;
    }

    public void blockInputWrongFoaEmpty(boolean isBlocking) {
        Component[] components = this.getSimStPeerTutoringPlatform().getStudentInterface().getComponents();
        for (int i = 0; i < components.length; ++i) {
            SimStPLE.setComponentEnabled(!isBlocking, components[i]);
        }
    }

    public void blockInput(boolean isBlocking) {
        Component[] components = this.getSimStPeerTutoringPlatform().getStudentInterface().getComponents();
        for (int i = 0; i < components.length; ++i) {
            SimStPLE.setComponentEnabled(!isBlocking, components[i]);
        }
        if (!isBlocking) {
            this.setCorrectFocus();
        }
    }

    public void unblockOnly(String toUnblock) {
        this.blockInput(true);
        Component unblockComp = (Component)this.brController.lookupWidgetByName(toUnblock);
        SimStPLE.setComponentEnabled(true, unblockComp);
        unblockComp.requestFocus();
    }

    private void setCorrectFocus() {
        if (this.simSt.isSelectionOrderGetterDefined() && this.brController.getCurrentNode().getInDegree() > 0) {
            ProblemEdge lastEdge = this.brController.getCurrentNode().getIncomingEdges().get(0);
            String lastSelection = lastEdge.getSelection();
            String nextComponent = "";
            if (lastEdge.getSource().getInDegree() > 0) {
                String priorSelection = lastEdge.getSource().getIncomingEdges().get(0).getSelection();
                nextComponent = this.simSt.getSelectionOrderGetter().nextSelection(lastSelection, priorSelection);
            } else {
                nextComponent = this.simSt.getSelectionOrderGetter().nextSelection(lastSelection);
            }
            if (nextComponent == null) {
                return;
            }
            Object widget = this.brController.lookupWidgetByName(nextComponent);
            if (widget != null && widget instanceof Component) {
                ((Component)widget).requestFocus();
            }
        } else if (this.simSt.isSelectionOrderGetterDefined()) {
            String nextComponent = this.simSt.getSelectionOrderGetter().startSelection();
            if (nextComponent == null) {
                return;
            }
            Object widget = this.brController.lookupWidgetByName(nextComponent);
            if (widget != null && widget instanceof Component) {
                ((Component)widget).requestFocus();
            }
        }
    }

    public void setAvatarStart() {
        this.status = NORMAL_STATUS;
        this.blockInput(true);
        for (int i = 0; i < this.startStateElements.size(); ++i) {
            Object widget = this.brController.lookupWidgetByName(this.startStateElements.get(i));
            if (widget == null || !(widget instanceof Component)) continue;
            SimStPLE.setComponentEnabled(true, (Component)widget);
        }
        this.getSimStPeerTutoringPlatform().clearSpeech();
        this.giveMessage(this.conversation.getMessage("NEW_PROBLEM"));
        this.startStatus = true;
        this.getSimStPeerTutoringPlatform().setExpression(NORMAL_EXPRESSION);
        this.getSimStPeerTutoringPlatform().setUndoButtonEnabled(false);
        this.getSimStPeerTutoringPlatform().setUndoButtonText(this.getUndoButtonTitleString());
        this.getSimStPeerTutoringPlatform().setRestartButtonEnabled(false);
        this.getSimStPeerTutoringPlatform().setWait(false);
        this.getSimStPeerTutoringPlatform().hideTakingQuiz();
    }

    public void setAvatarQuiz() {
        this.startStatus = false;
        this.status = QUIZ_STATUS;
        this.blockInput(true);
        this.getSimStPeerTutoringPlatform().refresh();
        this.getSimStPeerTutoringPlatform().clearSpeech();
        this.getSimStPeerTutoringPlatform().setExpression(NORMAL_EXPRESSION);
        this.getSimStPeerTutoringPlatform().setUpTakingQuiz();
        this.getSimStPeerTutoringPlatform().setUndoButtonEnabled(false);
        this.getSimStPeerTutoringPlatform().setRestartButtonEnabled(false);
        this.getSimStPeerTutoringPlatform().setWait(true);
    }

    public void setAvatarFinished() {
        this.status = FINISHED_STATUS;
        this.blockInput(true);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Enter setAvatarFinished to call autoSaveInstructions()");
        }
        this.getMissController().getSimSt().saveSimStState();
        this.giveMessage(this.conversation.getMessage("SOLVED"));
        this.startStatus = false;
        this.getSimStPeerTutoringPlatform().setExpression(SUCCESS_EXPRESSION);
        this.getSimStPeerTutoringPlatform().setUndoButtonEnabled(true);
        this.getSimStPeerTutoringPlatform().setRestartButtonEnabled(true);
        this.getSimStPeerTutoringPlatform().setWait(false);
    }

    public void setAvatarFinishedWrong() {
        this.status = FINISHED_STATUS;
        this.blockInput(true);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Enter setAvatarFinished to call autoSaveInstructions()");
        }
        this.getMissController().getSimSt().saveSimStState();
        this.giveMessage(this.conversation.getMessage("VERIFY_WRONG"));
        this.startStatus = false;
        this.getSimStPeerTutoringPlatform().setExpression("img/face3.png");
        this.getSimStPeerTutoringPlatform().setUndoButtonEnabled(true);
        this.getSimStPeerTutoringPlatform().setRestartButtonEnabled(true);
        this.getSimStPeerTutoringPlatform().setWait(false);
    }

    public void setAvatarThinking() {
        this.status = THINK_STATUS;
        this.blockInput(true);
        this.giveMessage(this.conversation.getMessage(THINK_STATUS));
        this.startStatus = false;
        this.getSimStPeerTutoringPlatform().setExpression(THINK_EXPRESSION);
        this.getSimStPeerTutoringPlatform().setUndoButtonEnabled(false);
        this.getSimStPeerTutoringPlatform().setRestartButtonEnabled(true);
        this.getSimStPeerTutoringPlatform().setWait(true);
    }

    public void setAvatarNormal() {
        this.status = NORMAL_STATUS;
        this.getSimStPeerTutoringPlatform().getSimStAvatarLayerIcon().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.blockInput(false);
        this.startStatus = false;
        if (this.isConfused()) {
            this.getSimStPeerTutoringPlatform().setExpression("img/face3.png");
        } else {
            this.getSimStPeerTutoringPlatform().setExpression(NORMAL_EXPRESSION);
        }
        this.getSimStPeerTutoringPlatform().setUndoButtonEnabled(true);
        this.getSimStPeerTutoringPlatform().setRestartButtonEnabled(true);
        this.getSimStPeerTutoringPlatform().setWait(false);
        this.getSimStPeerTutoringPlatform().hideTakingQuiz();
    }

    public void setAvatarAsking() {
        this.status = ASK_STATUS;
        this.blockInput(true);
        this.startStatus = false;
        this.getSimStPeerTutoringPlatform().setExpression(ASK_EXPRESSION);
        this.getSimStPeerTutoringPlatform().setUndoButtonEnabled(false);
        this.getSimStPeerTutoringPlatform().setRestartButtonEnabled(true);
        this.getSimStPeerTutoringPlatform().setWait(false);
    }

    public void setAvatarConfused(boolean confusion) {
        this.confused = confusion;
        if (confusion) {
            this.getSimStPeerTutoringPlatform().setExpression("img/face3.png");
            this.giveMessage(CONFUSE_MESSAGE);
        } else {
            this.getSimStPeerTutoringPlatform().setExpression(NORMAL_EXPRESSION);
            this.giveMessage(UNCONFUSE_MESSAGE);
        }
    }

    public static void setComponentEnabled(boolean enabled, Component comp) {
        block9: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                if (!(comp instanceof JCommTable)) break block8;
                                JCommTable table = (JCommTable)comp;
                                JCommTable.TableExpressionCell[][] cells = table.getCells();
                                for (int j = 0; j < cells.length; ++j) {
                                    for (int k = 0; k < cells[j].length; ++k) {
                                        Border space;
                                        Border outline;
                                        cells[j][k].setEnabled(enabled);
                                        if (enabled) {
                                            if (cells[j][k].getBackground() != Color.pink) {
                                                cells[j][k].setBackground(Color.white);
                                            }
                                            outline = BorderFactory.createLineBorder(Color.darkGray, 1);
                                            space = BorderFactory.createLineBorder(Color.white, 5);
                                            cells[j][k].setBorder(BorderFactory.createCompoundBorder(outline, space));
                                            continue;
                                        }
                                        if (cells[j][k].getBackground() != Color.pink) {
                                            cells[j][k].setBackground(Color.white);
                                        }
                                        outline = BorderFactory.createLineBorder(Color.lightGray, 1);
                                        space = BorderFactory.createLineBorder(Color.white, 5);
                                        cells[j][k].setBorder(BorderFactory.createCompoundBorder(outline, space));
                                    }
                                }
                                break block9;
                            }
                            if (!(comp instanceof JCommTable.TableExpressionCell)) break block10;
                            JCommTable.TableExpressionCell cell = (JCommTable.TableExpressionCell)comp;
                            cell.setEnabled(enabled);
                            if (enabled) {
                                cell.setBackground(Color.white);
                                Border outline = BorderFactory.createLineBorder(Color.darkGray, 1);
                                Border space = BorderFactory.createLineBorder(Color.white, 5);
                                cell.setBorder(BorderFactory.createCompoundBorder(outline, space));
                            } else {
                                cell.setBackground(Color.white);
                                Border outline = BorderFactory.createLineBorder(Color.lightGray, 1);
                                Border space = BorderFactory.createLineBorder(Color.white, 5);
                                cell.setBorder(BorderFactory.createCompoundBorder(outline, space));
                            }
                            break block9;
                        }
                        if (!(comp instanceof JCommComboBox)) break block11;
                        comp.setEnabled(enabled);
                        break block9;
                    }
                    if (!(comp instanceof JTextField)) break block12;
                    comp.setEnabled(enabled);
                    break block9;
                }
                if (!(comp instanceof JButton)) break block13;
                comp.setEnabled(enabled);
                break block9;
            }
            if (!(comp instanceof Container)) break block9;
            Component[] compsInComp = ((Container)comp).getComponents();
            for (int m = 0; m < compsInComp.length; ++m) {
                SimStPLE.setComponentEnabled(enabled, compsInComp[m]);
            }
        }
    }

    public static void setComponentFont(JComponent component, Font f) {
        component.setFont(f);
        if (component instanceof JCommTable.TableExpressionCell) {
            JCommTable.TableExpressionCell table = (JCommTable.TableExpressionCell)component;
            ((JCommTable.TableExpressionCell)component).setDisabledTextColor(Color.DARK_GRAY);
        }
        Component[] comps = component.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JComponent) || comps[i] instanceof JCommLabel) continue;
            SimStPLE.setComponentFont((JComponent)comps[i], f);
        }
    }

    public void removeComponentColor(Component comp) {
        if (comp instanceof JCommWidget) {
            JCommWidget widget = (JCommWidget)comp;
            widget.setCorrectColor(Color.black);
            widget.setIncorrectColor(Color.black);
            widget.setLISPCheckColor(Color.black);
        } else if (comp instanceof Container) {
            Component[] compsInComp = ((Container)comp).getComponents();
            for (int m = 0; m < compsInComp.length; ++m) {
                this.removeComponentColor(compsInComp[m]);
            }
        }
    }

    public void setUpUndo(JComponent studentInterface) {
        this.undoContextMenu = new JPopupMenu();
        JMenuItem anItem = new JMenuItem("Erase back through this step");
        anItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SimStPLE.this.setFocusTab(0);
                new Thread(new UndoThread(SimStPLE.this.undoCandidate)).start();
            }
        });
        this.undoContextMenu.add(anItem);
        if (this.getSimSt().isSsMetaTutorMode()) {
            anItem = new JMenuItem("Is this step correct?");
            anItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SimStPLE.this.isStepCorrect(SimStPLE.this.cellToUse);
                }
            });
            this.undoContextMenu.add(anItem);
        }
        MouseAdapter undoMenuListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    JCommTable.TableExpressionCell source = (JCommTable.TableExpressionCell)event.getSource();
                    if (SimStPLE.this.getStartStateElements().contains(source.getCommName())) {
                        return;
                    }
                    if (source.getText().length() > 0) {
                        SimStPLE.this.undoContextMenu.show(event.getComponent(), event.getX(), event.getY());
                        SimStPLE.this.undoCandidate = source.getCommName();
                        SimStPLE.this.cellToUse = source;
                    }
                }
            }
        };
        SimStPLE.addUndoMenu(studentInterface, undoMenuListener);
    }

    public static void addUndoMenu(JComponent component, MouseListener ml) {
        if (component instanceof JCommTable.TableExpressionCell) {
            component.addMouseListener(ml);
        }
        Component[] comps = component.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JComponent) || comps[i] instanceof JCommLabel) continue;
            SimStPLE.addUndoMenu((JComponent)comps[i], ml);
        }
    }

    public void isStepCorrect(JCommTable.TableExpressionCell verifyCell) {
        String selection = verifyCell.getCommName();
        String action = "UpdateTable";
        String input = verifyCell.getText();
        ProblemNode node = this.getBrController().getCurrentNode();
        boolean nodeFound = false;
        while (node != null && node.getInDegree() > 0 && !nodeFound) {
            ProblemEdge edge = node.getIncomingEdges().get(0);
            String select = edge.getSelection();
            if (select.equals(selection)) {
                nodeFound = true;
            }
            node = edge.getSource();
        }
        if (!nodeFound) {
            node = this.getBrController().getCurrentNode();
        }
        String problem = "";
        problem = this.getSsInteractiveLearning() == null || !this.getSsInteractiveLearning().isTakingQuiz() ? this.getBrController().getProblemModel().getStartNode().getName() : this.simSt.getValidationGraph().getStartNode().getName();
        String correctness = this.simSt.builtInInquiryClTutor(selection, action, input, node, problem);
        String message = "";
        message = correctness.equals("Correct Action") ? this.getConversation().getMessage("STEP_CORRECT", this.getComponentName(selection), input) : this.getConversation().getMessage("STEP_INCORRECT", this.getComponentName(selection), input);
        this.getMissController().getSimStPLE().giveDialogMessage(message);
        Sai sai = new Sai(selection, action, input);
        this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Context Menu Question Asked", this.simSt.getProblemStepString(), "Is this step correct?", (Object)"", sai, 0, message);
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void incCurrentLevel() {
        ++this.currentLevel;
    }

    public BR_Controller getBrController() {
        return this.brController;
    }

    public void setBrController(BR_Controller brController) {
        this.brController = brController;
    }

    public MissController getMissController() {
        return this.missController;
    }

    public void setMissController(MissController missController) {
        this.missController = missController;
    }

    public SimSt getSimSt() {
        return this.simSt;
    }

    public void setSimSt(SimSt simSt) {
        this.simSt = simSt;
    }

    public SimStPeerTutoringPlatform getSimStPeerTutoringPlatform() {
        return this.simStPeerTutoringPlatform;
    }

    public void setSimStPeerTutoringPlatform(SimStPeerTutoringPlatform simStPeerTutoringPlatform) {
        this.simStPeerTutoringPlatform = simStPeerTutoringPlatform;
    }

    public String getSimStName() {
        SimStPLE simStPLE = this;
        return simStPLE.simSt.getSimStName();
    }

    public void setSimStName(String simStName) {
        SimSt.setSimStName(simStName);
    }

    public String getTeacherName() {
        SimStPLE simStPLE = this;
        return simStPLE.simSt.getTeacherName();
    }

    public void setTeacherName(String teacherName) {
        SimSt.setTeacherName(teacherName);
    }

    public SimStInteractiveLearning getSsInteractiveLearning() {
        return this.ssInteractiveLearning;
    }

    public void setSsInteractiveLearning(SimStInteractiveLearning ssInteractiveLearning) {
        this.ssInteractiveLearning = ssInteractiveLearning;
    }

    public void giveMessage(String message) {
        this.getSimStPeerTutoringPlatform().showButtons(false);
        this.getSimStPeerTutoringPlatform().appendSpeech(message, this.getSimStName());
    }

    public void giveDialogMessage(String message) {
        this.messageDialog.showMessage(message);
    }

    public void setMessage(String message) {
        this.getSimStPeerTutoringPlatform().showButtons(false);
        this.getSimStPeerTutoringPlatform().setSpeech(message);
    }

    public int giveMessageRequiringResponse(String message) {
        this.setAvatarAsking();
        this.getSimStPeerTutoringPlatform().appendSpeech(message, this.getSimStName());
        this.getSimStPeerTutoringPlatform().showButtons(true);
        YesNoBucket lock = new YesNoBucket();
        this.getSimStPeerTutoringPlatform().getYesResponseButton().addActionListener(new YesNoListener(lock));
        this.getSimStPeerTutoringPlatform().getYesResponseButton().setActionCommand("0");
        this.getSimStPeerTutoringPlatform().getNoResponseButton().addActionListener(new YesNoListener(lock));
        this.getSimStPeerTutoringPlatform().getNoResponseButton().setActionCommand("1");
        String response = lock.waitForYesNo();
        this.getSimStPeerTutoringPlatform().showButtons(false);
        if (response.equals(this.getSimStPeerTutoringPlatform().getYesResponseButton().getActionCommand())) {
            this.getSimStPeerTutoringPlatform().appendSpeech("Yes", "Me");
        } else {
            this.getSimStPeerTutoringPlatform().appendSpeech("No", "Me");
        }
        return Integer.parseInt(response);
    }

    public void giveMessagePossibleResponse(String message, ActionListener al) {
        this.getSimStPeerTutoringPlatform().appendSpeech(message, this.getSimStName());
        this.getSimStPeerTutoringPlatform().showButtons(true);
        this.getSimStPeerTutoringPlatform().getYesResponseButton().addActionListener(al);
        this.getSimStPeerTutoringPlatform().getYesResponseButton().setActionCommand("0");
        this.getSimStPeerTutoringPlatform().getNoResponseButton().addActionListener(al);
        this.getSimStPeerTutoringPlatform().getNoResponseButton().setActionCommand("1");
    }

    public String giveMessageFreeTextResponse(String message) {
        LinkedBlockingQueue<String> bucket = new LinkedBlockingQueue<String>();
        this.setAvatarAsking();
        this.getSimStPeerTutoringPlatform().appendSpeech(message, this.getSimStName());
        this.getSimStPeerTutoringPlatform().showTextResponse(true);
        for (ActionListener al : this.getSimStPeerTutoringPlatform().getTextResponseSubmitButton().getActionListeners()) {
            this.getSimStPeerTutoringPlatform().getTextResponseSubmitButton().removeActionListener(al);
        }
        this.getSimStPeerTutoringPlatform().getTextResponseSubmitButton().addActionListener(new TextEntryListener(bucket));
        String response = "";
        this.getSimStPeerTutoringPlatform().scrollPaneToBottom();
        try {
            response = bucket.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (response.length() > 0) {
            this.getSimStPeerTutoringPlatform().appendSpeech(response, "Me");
        }
        this.getSimStPeerTutoringPlatform().getTextResponse().setSelectedItem("");
        this.getSimStPeerTutoringPlatform().showTextResponse(false);
        this.setAvatarNormal();
        return response;
    }

    public String giveMessageSelectableResponse(String message, List<String> selections) {
        LinkedBlockingQueue<String> bucket = new LinkedBlockingQueue<String>();
        this.setAvatarAsking();
        this.getSimStPeerTutoringPlatform().appendSpeech(message, this.getSimStName());
        this.getSimStPeerTutoringPlatform().showTextResponseOptions(true, selections);
        for (ActionListener al : this.getSimStPeerTutoringPlatform().getTextResponseSubmitButton().getActionListeners()) {
            this.getSimStPeerTutoringPlatform().getTextResponseSubmitButton().removeActionListener(al);
        }
        this.getSimStPeerTutoringPlatform().getTextResponseSubmitButton().addActionListener(new TextEntryListener(bucket));
        String response = "";
        this.getSimStPeerTutoringPlatform().scrollPaneToBottom();
        try {
            response = bucket.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (response.length() > 0) {
            this.getSimStPeerTutoringPlatform().appendSpeech(response, "Me");
        }
        this.getSimStPeerTutoringPlatform().getTextResponse().setSelectedItem("");
        this.getSimStPeerTutoringPlatform().showTextResponseOptions(false, null);
        this.setAvatarNormal();
        return response;
    }

    public void startQuestion(String arg) {
        if (arg != null && arg.equals("0")) {
            if (this.validateQuestion()) {
                this.startProblem();
            }
        } else if (arg != null && arg.equals("1")) {
            this.giveMessage(this.conversation.getMessage("START_PROBLEM_NO"));
        } else {
            this.giveMessage(START_MESSAGE);
        }
    }

    public boolean validateQuestion() {
        String element2 = null;
        String input = null;
        for (int i = 0; i < this.startStateElements.size(); ++i) {
            element2 = this.startStateElements.get(i);
            Object widget = this.brController.lookupWidgetByName(element2);
            if (widget == null || !(widget instanceof JCommTable.TableExpressionCell)) continue;
            JCommTable.TableExpressionCell cell = (JCommTable.TableExpressionCell)widget;
            input = cell.getText().toLowerCase();
            if (input.length() < 1) {
                this.giveDialogMessage(ENTER_FULL_PROBLEM);
                return false;
            }
            if (!this.getSimSt().isInputCheckerDefined() || this.getSimSt().getInputChecker().checkInput(element2, input, null, this.getBrController())) continue;
            this.giveDialogMessage(this.getSimSt().getInputChecker().invalidInputMessage(element2, input, null));
            return false;
        }
        boolean passed = false;
        passed = this.checkVariableUsedStartState();
        if (!passed) {
            this.giveDialogMessage(this.getSimSt().getInputChecker().invalidVariablesMessage(this.cellText1, this.cellText2));
            return false;
        }
        return true;
    }

    public void setUpVideoTab() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "setUpVideoTab");
        }
        if (videoIntroductionName == null || videoIntroductionName.length() <= 0) {
            return;
        }
        JTabbedPaneWithCloseIcons exampleTabPane = this.getSimStPeerTutoringPlatform().getExamplePane();
        Container video = this.getCurriculumBrowser().getVideoPanel();
        String videoTab = "Tutorial";
        ImageIcon icon = this.getSimStPeerTutoringPlatform().createImageIcon("img/video.png");
        exampleTabPane.insertTab(videoTab, icon, video, "", 7);
        this.exampleExplanations.put(videoTab, "This video should give you an idea of how to tutor a student.");
    }

    public void setUpOverviewTab() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "setUpOverviewTab");
        }
        if (!this.getCurriculumBrowser().isHtmlSet()) {
            return;
        }
        JTabbedPaneWithCloseIcons exampleTabPane = this.getSimStPeerTutoringPlatform().getExamplePane();
        JScrollPane overview = this.getCurriculumBrowser().getBrowserPane();
        overview.setName("Unit Overview");
        String overviewTab = "Unit Overview";
        overview.setSize(200, 200);
        exampleTabPane.addTab(overviewTab, overview, false);
        this.exampleExplanations.put(overviewTab, "This page shows you what is covered in the unit and gives some suggested problems.");
        exampleTabPane.setSelectedComponent(overview);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Exit setUpOverviewTab");
        }
    }

    public void generateProblemBankTab() {
        JTabbedPaneWithCloseIcons exampleTabPane = this.getSimStPeerTutoringPlatform().getExamplePane();
        String[] columns = new String[]{"Problem", "Attempts", "Difficulty"};
        SimStPLE.readProblemStatisticFile();
        Component bank = this.getSimStPeerTutoringPlatform().createProblemBank(columns, problemStatData);
        String bankTab = "Problem Bank";
        bank.setSize(400, 400);
        int tabIndex = exampleTabPane.indexOfTab(bankTab);
        if (tabIndex >= 0) {
            exampleTabPane.remove(tabIndex);
        }
        exampleTabPane.addTab(bankTab, bank, true);
        this.exampleExplanations.put(bankTab, "This page lists problems similar to ones that have been used before.  The number of attempts is how many times a problem like it was tried, and the difficulty depends on how many of those tries were successful.");
    }

    public void setUpTab(String tab) {
    }

    public void showTabText(String tab) {
        if (tab.equals(this.getSimStName())) {
            if (this.previousSpeechText.isEmpty()) {
                this.getSimStPeerTutoringPlatform().clearSpeech();
                this.getSimStPeerTutoringPlatform().appendSpeech(START_MESSAGE, this.getSimStName());
            } else {
                this.getSimStPeerTutoringPlatform().setFormattedSpeech(this.previousSpeechText);
            }
            if (this.buttonsVisible) {
                this.getSimStPeerTutoringPlatform().restoreButtons();
            }
            this.previousSpeechText = "";
            this.buttonsVisible = true;
            this.getSimStPeerTutoringPlatform().setImageTeacher(false);
            this.getSimStPeerTutoringPlatform().showMedals(true);
            if (this.simSt.isSsMetaTutorMode()) {
                this.getSimStPeerTutoringPlatform().getMetaTutorComponent().setVisible(true);
            }
        } else {
            if (this.previousSpeechText.length() == 0) {
                this.previousSpeechText = this.getSimStPeerTutoringPlatform().getCurrentSpeechText();
                this.buttonsVisible = this.getSimStPeerTutoringPlatform().getButtonsShowing();
            }
            this.setMessage(this.exampleExplanations.get(tab));
            this.getSimStPeerTutoringPlatform().showButtons(false);
            this.getSimStPeerTutoringPlatform().showMedals(false);
            this.getSimStPeerTutoringPlatform().setImageTeacher(true);
        }
    }

    public static synchronized void readProblemStatisticFile() {
        LinkedList<String> fileData = new LinkedList<String>();
        try {
            File file = null;
            file = !SimSt.WEBSTARTENABLED ? new File(PROBLEM_STAT_FILE) : new File(WebStartFileDownloader.SimStWebStartDir + PROBLEM_STAT_FILE);
            if (!file.exists()) {
                return;
            }
            BufferedReader f = new BufferedReader(new FileReader(file));
            String line = f.readLine();
            while (line != null && !line.equals("-1")) {
                fileData.add(line);
                line = f.readLine();
            }
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        problemStatData = new Object[fileData.size()][];
        problemMap = new java.util.HashMap();
        for (int i = 0; i < fileData.size(); ++i) {
            String[] problemDetails = ((String)fileData.get(i)).split(",");
            Integer tmp1 = new Integer(problemDetails[1]);
            Integer tmp2 = new Integer(problemDetails[2]);
            int pct = (int)(tmp2.doubleValue() * 100.0 / tmp1.doubleValue());
            String diff = "img/" + (5 - (pct - 1) / 20) + "-star.png";
            assessor = new AlgebraProblemAssessor();
            SimStPLE.problemStatData[i] = new Object[4];
            SimStPLE.problemStatData[i][0] = GameShowUtilities.generate(problemDetails[0]);
            SimStPLE.problemStatData[i][1] = assessor.classifyProblem(GameShowUtilities.generate(problemDetails[0]));
            SimStPLE.problemStatData[i][2] = new Integer(problemDetails[1]);
            SimStPLE.problemStatData[i][3] = GameShowUtilities.createImageIcon(diff);
            problemMap.put((String)problemStatData[i][0], "NotUsed");
        }
    }

    public static void saveAccountFile(String accountFile) {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "saveAccountFile: " + accountFile);
        }
        if (!SimSt.WEBSTARTENABLED) {
            try {
                FileWriter f = new FileWriter(new File(accountFile));
                f.write(SimSt.getSimStName() + "\n");
                f.write(STUDENT_IMAGE + "\n");
                f.write("" + currentOverallProblem);
                f.flush();
                f.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            File acFile = new File(WebStartFileDownloader.SimStWebStartDir + accountFile);
            try {
                FileWriter fw = new FileWriter(acFile);
                fw.write(SimSt.getSimStName() + "\n");
                fw.write(STUDENT_IMAGE + "\n");
                fw.write("" + currentOverallProblem);
                fw.flush();
                fw.close();
                StorageClient sc = new StorageClient();
                sc.storeFile(accountFile, acFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTitle(JFrame activeWindow) {
        activeWindow.setTitle("SimStudent V8.7 - " + this.simSt.getUserID());
    }

    private void updateQuizAttemptHash(String problem, Vector<ProblemEdge> solution) {
        LinkedHashMap<String, String> shm = new LinkedHashMap<String, String>();
        for (int i1 = 0; i1 < solution.size(); ++i1) {
            String stepname = solution.get(i1).getSource().getName();
            String value = "" + solution.get(i1).getAction() + "$" + solution.get(i1).getInput();
            shm.put(solution.get(i1).getSelection(), value);
        }
        this.getQuizAttemptsHash().put(SimSt.convertToSafeProblemName(problem), shm);
    }

    private Vector<SimStExample> startQuizProblems() {
        long startQuizTime = Calendar.getInstance().getTimeInMillis();
        int numCorrect = 0;
        Vector<SimStExample> solutions = new Vector<SimStExample>();
        HashMap hm = new HashMap();
        String failedQuizProblems = "";
        this.randomizeQuizProblems();
        this.giveMessage(QUIZ_MESSAGE);
        this.getQuizAttemptsHash().clear();
        for (int i = 0; i < this.currentQuizSection.size(); ++i) {
            int j;
            this.getSimStPeerTutoringPlatform().refresh();
            String problem = this.getRandomizedQuizProblem(i);
            this.getSimStPeerTutoringPlatform().refresh();
            long startQuizQuestionTime = Calendar.getInstance().getTimeInMillis();
            this.getBrController().startNewProblem();
            this.getSsInteractiveLearning().createStartStateQuizProblem(problem);
            this.logger.simStLog("SIM_STUDENT_QUIZ", "Sim Student Given Quiz Question", "Quiz" + (this.currentQuizSectionNumber + 1) + "." + (currentProblem + i + 1), problem, "");
            this.getSimStPeerTutoringPlatform().setQuizMessage("Working on quiz problem #" + (currentProblem + i + 1) + ".");
            this.getSsInteractiveLearning().startQuizProblem();
            SimStProblemGraph problemGraph = this.getSsInteractiveLearning().getQuizGraph();
            SimStNode startNode = problemGraph.getStartNode();
            Vector<ProblemEdge> solution = startNode.findSolutionPath();
            long questionDuration = Calendar.getInstance().getTimeInMillis() - startQuizQuestionTime;
            boolean result = false;
            if (this.simSt.getProblemAssessor() != null) {
                result = this.simSt.getProblemAssessor().isProblemComplete(problem, solution);
            }
            if (!result) {
                failedQuizProblems = failedQuizProblems + problem + EXAMPLE_VALUE_MARKER;
            }
            hm.put(" " + problem + " ", (Object)result);
            this.currentQuizSectionCorrect = ++numCorrect;
            if (this.quizProg.get(this.currentQuizSectionNumber) != null) {
                this.quizProg.get(this.currentQuizSectionNumber).setValue(this.currentQuizSectionCorrect);
            }
            if (!result) {
                this.updateQuizAttemptHash(problem, solution);
            }
            long quizQuestionDuration = Calendar.getInstance().getTimeInMillis() - startQuizQuestionTime;
            this.logger.simStLog("SIM_STUDENT_QUIZ", "Sim Student Answers Quiz Question", "Quiz" + (this.currentQuizSectionNumber + 1) + "." + (currentProblem + i + 1), this.quizSolutionSteps(problem, solution), (Object)"", result, (int)quizQuestionDuration);
            this.getSsInteractiveLearning().setQuizGraph(null);
            SimStExample quizResult = new SimStExample();
            trace.out("ss", "Taking the Quiz ()()()()())()()()()()()()()()()()()()())))()()");
            trace.out("ss", "Current Problem: " + (currentProblem + i + 1) + " Current Quiz Section #: " + (this.currentQuizSectionNumber + 1));
            quizResult.setSection(this.quizSections.get(currentProblem));
            quizResult.setIndex(currentProblem + i);
            quizResult.setTitle(currentProblem + i + 1 + ". " + problem);
            boolean incorrect = false;
            boolean finishTypein = false;
            String incorrectStep = "";
            String[] sp = problem.split(this.simSt.getProblemDelimiter());
            ArrayList<String> startElements = this.getStartStateElements();
            for (j = 0; j < startElements.size() && j < sp.length; ++j) {
                quizResult.addStep(startElements.get(j), sp[j].trim(), "", "");
            }
            if (solution != null) {
                for (j = 0; j < solution.size(); ++j) {
                    boolean correctness = solution.get(j).isCorrect();
                    String selection = solution.get(j).getSelection();
                    String input = solution.get(j).getInput();
                    if (selection.equalsIgnoreCase("DONE")) {
                        input = "Saying the problem is complete here";
                    }
                    trace.out("ss", "Selection: " + selection + " Input: " + input + " Correctness: " + correctness);
                    EdgeData edge = solution.get(j).getEdgeData();
                    if (incorrect && !finishTypein && edge.getRuleNames() != null && edge.getRuleNames().size() > 0 && !edge.getRuleNames().get(0).contains("-typein")) {
                        finishTypein = true;
                    }
                    if (!incorrect || !finishTypein) {
                        String comment = input + " is correct.";
                        if (!correctness) {
                            comment = input + " is not correct.";
                        }
                        quizResult.addStep(selection, input, comment, correctness, "");
                        if (incorrect) continue;
                        boolean bl = incorrect = !correctness;
                        if (!incorrect) continue;
                        incorrectStep = input;
                        if (edge.getRuleNames() == null || edge.getRuleNames().size() <= 0 || edge.getRuleNames().get(0).contains("-typein")) continue;
                        finishTypein = true;
                        continue;
                    }
                    quizResult.addStep(selection, input, "This step wasn't graded, because a mistake was already made.", "");
                }
            }
            if (incorrect) {
                quizResult.setExplanation(incorrectStep + " is incorrect.");
                quizResult.setStatus(SimStExample.QUIZ_INCORRECT);
            } else if (!result) {
                quizResult.setExplanation("The problem doesn't have any mistakes, but it wasn't finished.");
                quizResult.setStatus(SimStExample.QUIZ_INCOMPLETE);
            } else {
                quizResult.setExplanation("This problem is correct.");
                quizResult.setStatus(SimStExample.QUIZ_CORRECT);
            }
            solutions.add(quizResult);
        }
        System.out.println(this.quizAttemptsHash);
        float pctCorrect = (float)(numCorrect + currentProblem) / (float)this.getQuizProblems().size();
        int quizDuration = (int)(Calendar.getInstance().getTimeInMillis() - startQuizTime);
        if (numCorrect == this.currentQuizSection.size()) {
            if (this.simSt != null && this.simSt.getSolvedQuizProblem() == null) {
                this.simSt.setSolvedQuizProblem(new Vector<SimStExample>());
            }
            for (SimStExample ssExample : solutions) {
                this.simSt.getSolvedQuizProblem().add(ssExample);
            }
        }
        if (this.simSt.isSsMetaTutorMode()) {
            String quizResult = "";
            String input = "";
            if (numCorrect == this.currentQuizSection.size()) {
                input = quizResult = "pass";
            } else {
                quizResult = "fail";
                input = quizResult + EXAMPLE_VALUE_MARKER + failedQuizProblems;
            }
            this.brController.getAmt().handleInterfaceAction("ssquizCompleted", "implicit", input);
        }
        this.logger.simStLog("SIM_STUDENT_QUIZ", "Quiz Completed", "Quiz" + (this.currentQuizSectionNumber + 1), "" + pctCorrect, (Object)("" + numCorrect + "/" + this.getQuizProblems().size()), quizDuration);
        this.currentCorrect = numCorrect;
        this.getSimStPeerTutoringPlatform().setQuizProgress(pctCorrect);
        this.getBrController().startNewProblem();
        this.simSt.setProblemStepString("START");
        return solutions;
    }

    public void shutdown() {
        int pleDuration = (int)(Calendar.getInstance().getTimeInMillis() - this.startPleTime);
        this.logger.simStShortLog("SIM_STUDENT_PLE", "Peer Learning Environment Closed", "", "", pleDuration);
    }

    class SSQuizThread
    implements Runnable {
        SSQuizThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = quizLock;
            synchronized (object) {
                int percent;
                if (SimStPLE.this.currentQuizSectionNumber == SimStPLE.this.sections.size()) {
                    SimStPLE.this.currentQuizSectionNumber = SimStPLE.this.sections.size() - 1;
                }
                SimStPLE.this.getSimStPeerTutoringPlatform().setQuizButtonEnabled(false);
                SimStPLE.this.getSimStPeerTutoringPlatform().setNextProblemButtonEnabled(false);
                MouseListener[] mListeners = null;
                if (SimStPLE.this.simSt != null && SimStPLE.this.simSt.isSsMetaTutorMode()) {
                    mListeners = SimStPLE.this.getSimStPeerTutoringPlatform().setMetaTutorComponentEnabled(false, null);
                }
                if (currentProblem == 0) {
                    SimStPLE.this.reloadQuizQuestions();
                }
                boolean dontShowAllRA = SimStPLE.this.getSimSt().dontShowAllRA();
                SimStPLE.this.getSimSt().setDontShowAllRA(true);
                boolean ilSignalNegative = SimStPLE.this.getSimSt().isILSignalNegative();
                SimStPLE.this.getSimSt().setIlSignalNegative(false);
                boolean ilSignalPositive = SimStPLE.this.getSimSt().isILSignalPositive();
                SimStPLE.this.getSimSt().setIlSignalPositive(false);
                String raTestMethod = SimStPLE.this.getSimSt().getRuleActivationTestMethod();
                SimStPLE.this.getSimSt().setRuleActivationTestMethod(SimStPLE.this.getSimSt().getQuizGradingMethod());
                SimStPLE.this.setAvatarQuiz();
                SimStPLE.this.getSsInteractiveLearning().setTakingQuiz(true);
                Vector results = SimStPLE.this.startQuizProblems();
                for (int i = 0; i < results.size(); ++i) {
                    SimStPLE.this.getSimStPeerTutoringPlatform().addQuiz((SimStExample)results.get(i));
                    trace.out("ss", "Problem: " + ((SimStExample)results.get(i)).getTitle() + " Section: " + ((SimStExample)results.get(i)).getSection());
                }
                trace.out("ss", "Taking the Quiz ()()()()())()()()()()()()()()()()()()())))()()");
                trace.out("ss", "Current Problem: " + currentProblem + " Current Quiz Section #: " + SimStPLE.this.currentQuizSectionNumber);
                if (SimStPLE.this.getSimStPeerTutoringPlatform().getMedalCount() < currentProblem + SimStPLE.this.currentCorrect) {
                    SimStPLE.this.getSimStPeerTutoringPlatform().augmentMedals(currentProblem + SimStPLE.this.currentCorrect - SimStPLE.this.getSimStPeerTutoringPlatform().getMedalCount(), true);
                }
                if ((percent = (SimStPLE.this.currentCorrect + currentProblem) * 100 / SimStPLE.this.quizProblems.size()) >= 100) {
                    quizPassed = true;
                }
                SimStPLE.this.getSimStPeerTutoringPlatform().showQuizResultFrame(true);
                String sectn = (String)SimStPLE.this.sections.get(SimStPLE.this.currentQuizSectionNumber);
                if (sectn.startsWith("-")) {
                    sectn = sectn.substring(1);
                }
                String quizAssessment = "I've graded " + SimSt.getSimStName() + "'s quiz on " + sectn + ".\n\n";
                if (SimStPLE.this.currentCorrect == SimStPLE.this.currentQuizSection.size()) {
                    int passedQuizSectionSize = SimStPLE.this.currentQuizSection.size();
                    trace.out("ss", "Updating ================================================");
                    currentProblem = currentProblem + SimStPLE.this.currentQuizSection.size();
                    currentOverallProblem += SimStPLE.this.currentQuizSection.size();
                    SimStPLE.this.currentCorrect = 0;
                    ++SimStPLE.this.currentQuizSectionNumber;
                    SimStPLE.this.currentQuizSection.clear();
                    SimStPLE.this.currentQuizSection = new ArrayList();
                    for (int i = 0; i < SimStPLE.this.quizProblems.size(); ++i) {
                        if (SimStPLE.this.quizSections.get(i) != SimStPLE.this.currentQuizSectionNumber) continue;
                        SimStPLE.this.currentQuizSection.add((String)SimStPLE.this.quizProblems.get(i));
                        trace.out("ss", "Added " + (String)SimStPLE.this.quizProblems.get(i) + " to " + SimStPLE.this.currentQuizSectionNumber);
                    }
                    SimStPLE.this.getSimStPeerTutoringPlatform().unlockQuiz(SimStPLE.this.currentQuizSectionNumber);
                    quizAssessment = passedQuizSectionSize == 1 ? quizAssessment + "An excellent job!  The problem was completed correctly." : quizAssessment + "An excellent job!  All of the problems were completed correctly.";
                } else {
                    quizAssessment = SimStPLE.this.currentCorrect > 0 ? quizAssessment + SimStPLE.this.currentCorrect + " out of the " + SimStPLE.this.currentQuizSection.size() + " problems were completed correctly." : quizAssessment + "None of the problems were right this time.";
                }
                if (!quizPassed) {
                    SimStPLE.this.giveDialogMessage(quizAssessment);
                }
                SimStPLE.this.getSimStPeerTutoringPlatform().setQuizButtonEnabled(true);
                SimStPLE.this.getSimStPeerTutoringPlatform().setNextProblemButtonEnabled(true);
                if (SimStPLE.this.simSt != null && SimStPLE.this.simSt.isSsMetaTutorMode()) {
                    SimStPLE.this.getSimStPeerTutoringPlatform().setMetaTutorComponentEnabled(true, mListeners);
                }
                SimStPLE.this.getSsInteractiveLearning().setTakingQuiz(false);
                SimStPLE.this.getSimSt().setDontShowAllRA(dontShowAllRA);
                SimStPLE.this.getSimSt().setIlSignalNegative(ilSignalNegative);
                SimStPLE.this.getSimSt().setIlSignalPositive(ilSignalPositive);
                SimStPLE.this.getSimSt().setRuleActivationTestMethod(raTestMethod);
                SimStPLE.this.requestEnterNewProblem();
                SimStPLE.saveAccountFile(SimStPLE.this.getSimSt().getUserID() + ".account");
                if (quizPassed) {
                    int reply;
                    SimStPLE.this.getSimStPeerTutoringPlatform().addTrophy(true);
                    if (SimStPLE.this.getSimSt().getSSCLQuizReqMode()) {
                        reply = JOptionPane.showConfirmDialog(null, "<html><p>Congratulations!</p><p>With your help, " + SimStPLE.this.getSimStName() + " was able to pass the final challenge!</p><p>I have another set of challenging quiz problems. Would you like to see if " + SimStPLE.this.getSimStName() + " can solve them?</p>", "You did it!", 0);
                        if (reply == 0) {
                            SimStPLE.this.getSimSt().archiveAndSaveFilesOnLogout();
                            SimStPLE.saveAccountFile(SimStPLE.this.getSimSt().getUserID() + ".account");
                            SimStPLE.this.quizProblems = SimStPLE.this.allQuizProblems.get(SimStPLE.this.quizLevel);
                            SimStPLE.this.quizSections = SimStPLE.this.allQuizSections.get(SimStPLE.this.quizLevel);
                            quizPassed = false;
                            currentProblem = 0;
                            SimStPLE.this.loadAccountInfo();
                            String newPaneTitle = SimStPLE.this.newSectionTitleBase + " " + (SimStPLE.this.quizLevel + 1);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizProblems.add(new LinkedList());
                            QuizPane quizTaskPane = new QuizPane(newPaneTitle, SimStPLE.this.logger, SimStPLE.this.brController, ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).actionListener);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizPanes.add(quizTaskPane);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizContainer.add((Component)((Object)quizTaskPane));
                            quizTaskPane.updatePane(false, false);
                            quizTaskPane.setCollapsed(true);
                            JProgressBar pb = new JProgressBar(0, SimStPLE.this.currentQuizSection.size());
                            JLabel levelLabel = new JLabel(newPaneTitle);
                            pb.setStringPainted(true);
                            Border emptyBorder = BorderFactory.createLineBorder(Color.black, 1);
                            pb.setBorder(emptyBorder);
                            pb.setValue(0);
                            SimStPLE.this.quizProg.add(pb);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizmeter.add(levelLabel);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizmeter.add(SimStPLE.this.quizProg.get(SimStPLE.this.currentQuizSectionNumber));
                            AplusPlatform.splashBLShown = true;
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizButtonQuiz.doClick();
                        } else {
                            JOptionPane.showMessageDialog(null, "<html><p>Thank you for your participation in our study!</p><p>Click OK to close SimStudent now.</p>", "You did it!", 1);
                            SimStPLE.saveAccountFile(SimStPLE.this.getSimSt().getUserID() + ".account");
                            System.exit(104);
                        }
                    } else {
                        reply = JOptionPane.showConfirmDialog(null, "<html><p>Congratulations!</p><p>With your help, " + SimStPLE.this.getSimStName() + " was able to pass the final challenge!</p><p>I have another set of challenging quiz problems. Would you like to see if " + SimStPLE.this.getSimStName() + " can solve them?</p>", "You did it!", 0);
                        if (reply == 0) {
                            SimStPLE.saveAccountFile(SimStPLE.this.getSimSt().getUserID() + ".account");
                            SimStPLE.this.quizProblems = SimStPLE.this.allQuizProblems.get(SimStPLE.this.quizLevel);
                            SimStPLE.this.quizSections = SimStPLE.this.allQuizSections.get(SimStPLE.this.quizLevel);
                            quizPassed = false;
                            currentProblem = 0;
                            SimStPLE.this.loadAccountInfo();
                            String newPaneTitle = SimStPLE.this.newSectionTitleBase + " " + (SimStPLE.this.quizLevel + 1);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizProblems.add(new LinkedList());
                            QuizPane quizTaskPane = new QuizPane(newPaneTitle, SimStPLE.this.logger, SimStPLE.this.brController, ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).actionListener);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizPanes.add(quizTaskPane);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizContainer.add((Component)((Object)quizTaskPane));
                            quizTaskPane.updatePane(false, false);
                            quizTaskPane.setCollapsed(true);
                            JProgressBar pb = new JProgressBar(0, SimStPLE.this.currentQuizSection.size());
                            JLabel levelLabel = new JLabel(newPaneTitle);
                            pb.setStringPainted(true);
                            Border emptyBorder = BorderFactory.createLineBorder(Color.black, 1);
                            pb.setBorder(emptyBorder);
                            pb.setValue(0);
                            SimStPLE.this.quizProg.add(pb);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizmeter.add(levelLabel);
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizmeter.add(SimStPLE.this.quizProg.get(SimStPLE.this.currentQuizSectionNumber));
                            AplusPlatform.splashBLShown = true;
                            ((AplusPlatform)SimStPLE.this.getSimStPeerTutoringPlatform()).quizButtonQuiz.doClick();
                        } else {
                            JOptionPane.showMessageDialog(null, "<html><p>Thank you for your participation in our study!</p><p>Click OK to close SimStudent now.</p>", "Thank you!", 1);
                            SimStPLE.saveAccountFile(SimStPLE.this.getSimSt().getUserID() + ".account");
                            System.exit(104);
                        }
                    }
                }
            }
        }
    }

    class YesNoListener
    implements ActionListener {
        YesNoBucket response;

        YesNoListener(YesNoBucket response) {
            this.response = response;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.response.put(arg0.getActionCommand());
        }
    }

    class SimpleListener
    implements ActionListener {
        SimpleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimStPLE.this.getSimStPeerTutoringPlatform().showButtons(false);
            if (e.getActionCommand().equals("0")) {
                SimStPLE.this.getSimStPeerTutoringPlatform().appendSpeech("Yes", "Me");
                if (SimStPLE.this.simSt.isSsMetaTutorMode() && SimStPLE.this.brController.getAmt() != null) {
                    SimStPLE.this.brController.getAmt().handleInterfaceAction("yes", "ButtonPressed", "-1");
                }
            } else if (e.getActionCommand().equals("1")) {
                SimStPLE.this.getSimStPeerTutoringPlatform().appendSpeech("No", "Me");
                if (SimStPLE.this.simSt.isSsMetaTutorMode() && SimStPLE.this.brController.getAmt() != null) {
                    SimStPLE.this.brController.getAmt().handleInterfaceAction("no", "ButtonPressed", "-1");
                }
            }
            SimStPLE.this.startQuestion(e.getActionCommand());
        }
    }

    class TextEntryListener
    implements ActionListener {
        BlockingQueue<String> bucket;

        TextEntryListener(BlockingQueue<String> bucket) {
            this.bucket = bucket;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String response = "";
            if (e.getSource() instanceof JTextField) {
                response = ((JTextField)e.getSource()).getText();
            }
            if (e.getSource() instanceof JComboBox) {
                if (((JComboBox)e.getSource()).getSelectedItem() == null) {
                    return;
                }
                response = ((JComboBox)e.getSource()).getSelectedItem().equals(SimStPLE.SELECT_OPTION) ? "" : (String)((JComboBox)e.getSource()).getSelectedItem();
            }
            if (e.getSource() == SimStPLE.this.getSimStPeerTutoringPlatform().getTextResponseSubmitButton()) {
                JComboBox combo = SimStPLE.this.getSimStPeerTutoringPlatform().getTextResponse();
                response = combo.getSelectedItem() == null ? "" : (combo.getSelectedItem().equals(SimStPLE.SELECT_OPTION) ? "" : (String)combo.getSelectedItem());
            }
            try {
                this.bucket.put(response);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            SimStPLE.this.getSimStPeerTutoringPlatform().getTextResponseSubmitButton().removeActionListener(this);
        }
    }

    class FoAStateChangeListener
    implements CaretListener,
    FocusListener {
        FoAStateChangeListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            JCommTable.TableExpressionCell cell;
            String selection;
            if (SimStPLE.this.simSt != null && SimStPLE.this.simSt.getSsInteractiveLearning() != null && !SimStPLE.this.simSt.getSsInteractiveLearning().foaCorrectness && SimStPLE.this.simSt.getSsInteractiveLearning().getHint().getSai().getS().length() > 0 && SimStPLE.this.brController.lookupWidgetByName(selection = SimStPLE.this.simSt.getSsInteractiveLearning().getHint().getSai().getS()) instanceof JCommTable.TableExpressionCell && (cell = (JCommTable.TableExpressionCell)SimStPLE.this.brController.lookupWidgetByName(selection)).getText().isEmpty()) {
                SimStPLE.this.blockInputWrongFoaEmpty(false);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class StartStateChangeListener
    implements CaretListener,
    FocusListener {
        StartStateChangeListener() {
        }

        @Override
        public void caretUpdate(CaretEvent arg0) {
            if (SimStPLE.this.brController.getCurrentNode() == null) {
                SimStPLE.this.checkCompletedStartState();
            }
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (SimStPLE.this.simSt != null && SimStPLE.this.simSt.isSsMetaTutorMode() && arg0.getComponent() instanceof JCommTable.TableExpressionCell && SimStPLE.this.simSt.getBrController() != null && SimStPLE.this.simSt.getBrController().getAmt() != null) {
                ArrayList<String> ssElements = SimStPLE.this.getStartStateElements();
                for (String s : ssElements) {
                    JCommTable.TableExpressionCell cell;
                    String input;
                    Object widget = SimStPLE.this.brController.lookupWidgetByName(s);
                    if (widget == null || !(widget instanceof JCommTable.TableExpressionCell) || (input = (cell = (JCommTable.TableExpressionCell)widget).getText()) == null || input.length() <= 0) continue;
                    SimStPLE.this.simSt.getBrController().getAmt().handleInterfaceAction(cell.getCommName(), "UpdateTable", input);
                }
            }
        }
    }

    class ProblemStartThread
    implements Runnable {
        boolean isRestart = false;

        ProblemStartThread(boolean restart) {
            this.isRestart = restart;
        }

        @Override
        public void run() {
            SimStPLE.this.getSsInteractiveLearning().createStartState(SimStPLE.this.getSimStPeerTutoringPlatform().getStudentInterface(), this.isRestart);
            new Thread(SimStPLE.this.getSsInteractiveLearning()).start();
        }
    }

    class QuizThread
    implements Runnable {
        QuizThread() {
        }

        @Override
        public void run() {
            int percent;
            SimStPLE.this.getSimStPeerTutoringPlatform().showQuizResultFrame(false);
            SimStPLE.this.getSimStPeerTutoringPlatform().setQuizButtonEnabled(false);
            SimStPLE.this.getSimStPeerTutoringPlatform().setNextProblemButtonEnabled(false);
            SimStPLE.this.setFocusTab(0);
            boolean dontShowAllRA = SimStPLE.this.getSimSt().dontShowAllRA();
            SimStPLE.this.getSimSt().setDontShowAllRA(true);
            boolean ilSignalNegative = SimStPLE.this.getSimSt().isILSignalNegative();
            SimStPLE.this.getSimSt().setIlSignalNegative(false);
            boolean ilSignalPositive = SimStPLE.this.getSimSt().isILSignalPositive();
            SimStPLE.this.getSimSt().setIlSignalPositive(false);
            String raTestMethod = SimStPLE.this.getSimSt().getRuleActivationTestMethod();
            SimStPLE.this.getSimSt().setRuleActivationTestMethod("builtInClSolverTutor");
            SimStPLE.this.setAvatarQuiz();
            SimStPLE.this.getSsInteractiveLearning().setTakingQuiz(true);
            long startTime = new Date().getTime();
            Vector results = SimStPLE.this.solveQuizProblems();
            long endTime = new Date().getTime();
            long duration = endTime - startTime;
            SimStPLE.this.displayQuizResultsAlgebraI(results);
            if (SimStPLE.this.getSimStPeerTutoringPlatform().getMedalCount() < currentProblem + SimStPLE.this.currentCorrect) {
                SimStPLE.this.getSimStPeerTutoringPlatform().augmentMedals(currentProblem + SimStPLE.this.currentCorrect - SimStPLE.this.getSimStPeerTutoringPlatform().getMedalCount(), true);
            }
            if ((percent = (SimStPLE.this.currentCorrect + currentProblem) * 100 / SimStPLE.this.quizProblems.size()) >= 100) {
                quizPassed = true;
            }
            if (SimStPLE.this.currentCorrect == SimStPLE.this.currentQuizSection.size()) {
                currentProblem = currentProblem + SimStPLE.this.currentQuizSection.size();
                currentOverallProblem += SimStPLE.this.currentQuizSection.size();
                SimStPLE.this.currentCorrect = 0;
            }
            SimStPLE.this.getSimStPeerTutoringPlatform().showQuizResultFrame(true);
            SimStPLE.this.getSimStPeerTutoringPlatform().setQuizButtonEnabled(true);
            SimStPLE.this.getSimStPeerTutoringPlatform().setNextProblemButtonEnabled(true);
            SimStPLE.this.getSsInteractiveLearning().setTakingQuiz(false);
            SimStPLE.this.getSimSt().setDontShowAllRA(dontShowAllRA);
            SimStPLE.this.getSimSt().setIlSignalNegative(ilSignalNegative);
            SimStPLE.this.getSimSt().setIlSignalPositive(ilSignalPositive);
            SimStPLE.this.getSimSt().setRuleActivationTestMethod(raTestMethod);
            if (quizPassed) {
                SimStPLE.this.getSimStPeerTutoringPlatform().addTrophy(true);
                if (SimStPLE.this.getSimSt().getSSCLQuizReqMode()) {
                    JOptionPane.showMessageDialog(null, "<html><p>Congratulations!</p><p>With your help, " + SimStPLE.this.getSimStName() + " was able to pass the quiz.</p><p>Click OK to close SimStudent now.</p>", "You did it!", 1, SimStPLE.this.getSimStPeerTutoringPlatform().createImageIcon("img/trophyIcon.png"));
                    SimStPLE.saveAccountFile(SimStPLE.this.getSimSt().getUserID() + ".account");
                    System.exit(104);
                } else if (SimStPLE.this.getQuizLevel() + 1 < SimStPLE.this.allQuizProblems.size()) {
                    JOptionPane.showMessageDialog(null, "<html><p>Congratulations!</p><p>With your help, " + SimStPLE.this.getSimStName() + " was able to pass the quiz</p><p>and is ready to move on to the next level.</p>", "You did it!", 1, SimStPLE.this.getSimStPeerTutoringPlatform().createImageIcon("img/trophyIcon.png"));
                    SimStPLE.this.quizLevel++;
                    SimStPLE.this.quizProblems = SimStPLE.this.allQuizProblems.get(SimStPLE.this.quizLevel);
                    SimStPLE.this.quizSections = SimStPLE.this.allQuizSections.get(SimStPLE.this.quizLevel);
                    quizPassed = false;
                    currentProblem = 0;
                    SimStPLE.this.currentCorrect = 0;
                    SimStPLE.this.reloadQuizQuestions();
                } else {
                    JOptionPane.showMessageDialog(null, "<html><p>Congratulations!</p><p>With your help, " + SimStPLE.this.getSimStName() + " was able to pass the quiz.</p><p>Click OK to close SimStudent now.</p>", "You did it!", 1, SimStPLE.this.getSimStPeerTutoringPlatform().createImageIcon("img/trophyIcon.png"));
                    SimStPLE.saveAccountFile(SimStPLE.this.getSimSt().getUserID() + ".account");
                    System.exit(104);
                }
            }
            SimStPLE.this.requestEnterNewProblem();
            SimStPLE.saveAccountFile(SimStPLE.this.getSimSt().getUserID() + ".account");
        }
    }

    class UndoThread
    implements Runnable {
        private String undoThroughSelection = "";

        public UndoThread() {
            this.undoThroughSelection = "";
        }

        public UndoThread(String undoThrough) {
            this.undoThroughSelection = undoThrough;
        }

        @Override
        public void run() {
            if (SimStPLE.this.brController.getCurrentNode() == null || SimStPLE.this.brController.getCurrentNode().getIncomingEdges().size() <= 0) {
                SimStPLE.this.simSt.displayMessage("Undo?", SimStPLE.NO_UNDO_MSG);
                return;
            }
            if (this.undoThroughSelection.length() > 0) {
                this.undoThroughStep(this.undoThroughSelection);
            } else {
                this.undoLastStep();
            }
        }

        public void undoThroughStep(String undoThroughSelection) {
            SimStPLE.this.blockInput(true);
            boolean undoable = true;
            String query = "";
            ProblemEdge finalEdge = null;
            String currentStatus = SimStPLE.this.wasNormal;
            Sai sai = null;
            ProblemNode currentNode = SimStPLE.this.brController.getCurrentNode();
            ProblemEdge edge = currentNode.getIncomingEdges().get(0);
            if (edge.getEdgeData().getActionType().equals("Given Action")) {
                trace.out("ss", "Dismissing current inquiry " + edge.getSelection());
                currentNode = edge.getSource();
                SimStPLE.this.brController.setCurrentNode2(currentNode);
                if (currentNode.getInDegree() <= 0) {
                    SimStPLE.this.simSt.displayMessage("Undo?", SimStPLE.this.getConversation().getMessage("NOTHING_TO_UNDO"));
                    undoable = false;
                }
                currentStatus = SimStPLE.this.wasVerify;
            }
            ProblemNode revertTo = currentNode;
            if (!SimStPLE.this.simSt.isInteractiveLearning()) {
                currentStatus = SimStPLE.this.brController.getCurrentNode().getDoneState() ? SimStPLE.this.wasDone : SimStPLE.this.wasFailToLearn;
            }
            int result = 2;
            if (undoable) {
                ProblemEdge currentEdge;
                Object obj;
                do {
                    if ((obj = SimStPLE.this.brController.lookupWidgetByName((sai = (currentEdge = currentNode.getIncomingEdges().get(0)).getSai()).getS())) != null && obj instanceof JCommTable.TableCell) {
                        ((JCommTable.TableCell)obj).setBackground(Color.pink);
                    }
                    currentNode = currentEdge.getSource();
                } while (!sai.getS().equals(undoThroughSelection) && currentNode.getInDegree() > 0);
                if (currentNode.getInDegree() <= 0 && !sai.getS().equals(undoThroughSelection)) {
                    undoable = false;
                }
                query = SimStPLE.this.getConversation().getMessage("UNDO_CONFIRM_STEPS", sai.getI());
                result = SimStPLE.this.simSt.displayConfirmMessage("Undo?", query);
                sai = null;
                currentNode = SimStPLE.this.brController.getCurrentNode();
                do {
                    if ((obj = SimStPLE.this.brController.lookupWidgetByName((sai = (currentEdge = currentNode.getIncomingEdges().get(0)).getSai()).getS())) != null && obj instanceof JCommTable.TableCell) {
                        ((JCommTable.TableCell)obj).setBackground(Color.white);
                    }
                    currentNode = currentEdge.getSource();
                    finalEdge = currentEdge;
                } while (!sai.getS().equals(undoThroughSelection) && currentNode.getInDegree() > 0);
                if (currentNode.getInDegree() <= 0 && !sai.getS().equals(undoThroughSelection)) {
                    undoable = false;
                }
            }
            if (result == 0 && undoable) {
                if (trace.getDebugCode("rr")) {
                    trace.out("rr", "Modeltracing the student action: undo  ButtonPressed  -1");
                }
                if (SimStPLE.this.simSt.isSsMetaTutorMode() && SimStPLE.this.brController.getAmt() != null) {
                    SimStPLE.this.brController.getAmt().handleInterfaceAction(SimStPLE.UNDO, "ButtonPressed", "-1");
                }
                boolean traversed = false;
                if (currentNode.isStudentBeginsHereState()) {
                    trace.out("ss", "Back to start state");
                    SimStPLE.this.brController.goToStartState();
                    traversed = true;
                } else {
                    trace.out("ss", "Back to " + currentNode);
                    traversed = SimStPLE.this.brController.goToState(currentNode);
                }
                if (traversed) {
                    Instruction inst;
                    String message;
                    if (currentNode.getInDegree() > 0) {
                        ProblemEdge prev = currentNode.getIncomingEdges().get(0);
                        SimStPLE.this.getSimStPeerTutoringPlatform().setUndoButtonText(SimStPLE.this.getUndoButtonTitleString(prev.getInput()));
                        SimStPLE.this.simSt.setLastSkillOperand(this.findLastSkillOperand(prev));
                    } else {
                        SimStPLE.this.getSimStPeerTutoringPlatform().setUndoButtonText(SimStPLE.this.getUndoButtonTitleString());
                        SimStPLE.this.simSt.setLastSkillOperand(null);
                    }
                    if (currentStatus.equals(SimStPLE.this.wasDone)) {
                        message = SimStPLE.this.getConversation().getMessage("UNDO_RESUME", sai.getI());
                        SimStPLE.this.simSt.displayMessage("SimStudent says...", message);
                    } else {
                        message = SimStPLE.this.getConversation().getMessage("UNDO_SHOULD_DO", sai.getI());
                        SimStPLE.this.simSt.displayMessage("SimStudent asks...", message);
                        if (SimStPLE.this.simSt.getLastSkillOperand() != null && !SimStPLE.this.simSt.getLastSkillOperand().equals(sai.getI())) {
                            message = SimStPLE.this.getConversation().getMessage("UNDO_REMEMBER_PREVIOUS", SimStPLE.this.simSt.getLastSkillOperand());
                            SimStPLE.this.simSt.displayMessage("SimStudent says...", message);
                        } else {
                            String string = SimStPLE.this.simSt.revertLastSkillOperand();
                        }
                    }
                    if (finalEdge != null && finalEdge.getSai().getS().equals(undoThroughSelection) && (inst = SimStPLE.this.simSt.lookupInstructionWithNode(finalEdge.getDest())) != null) {
                        SimStPLE.this.simSt.negateBadPositiveExample(inst);
                        SimStPLE.this.simSt.signalInstructionAsNegativeExample(inst);
                    }
                    SimStPLE.this.simSt.setIsInteractiveLearning(true);
                    SimStPLE.this.getSsInteractiveLearning().runInteractiveLearning(currentNode, false);
                }
            } else if (currentStatus.equals(SimStPLE.this.wasDone)) {
                SimStPLE.this.simSt.displayMessage("No undo", SimStPLE.this.getConversation().getMessage("NO_UNDO_DONE"));
                SimStPLE.this.getSimStPeerTutoringPlatform().setExpression(SimStPLE.SUCCESS_EXPRESSION);
            } else if (currentStatus.equals(SimStPLE.this.wasFailToLearn)) {
                SimStPLE.this.simSt.displayMessage("No undo", SimStPLE.this.getConversation().getMessage("NO_UNDO_FAIL_TO_LEARN"));
                SimStPLE.this.getSimStPeerTutoringPlatform().setExpression("img/face3.png");
            } else {
                if (revertTo.isStudentBeginsHereState()) {
                    trace.out("ss", "Back to start state");
                    SimStPLE.this.brController.goToStartState();
                } else {
                    trace.out("ss", "Back to " + currentNode);
                    SimStPLE.this.brController.goToState(revertTo);
                }
                SimStPLE.this.simSt.displayMessage("No undo", SimStPLE.this.getConversation().getMessage("NO_UNDO"));
                SimStPLE.this.simSt.setIsInteractiveLearning(true);
                SimStPLE.this.getSsInteractiveLearning().runInteractiveLearning(revertTo, true);
            }
        }

        public String findLastSkillOperand(ProblemEdge lastEdge) {
            ProblemEdge prev = lastEdge;
            if (SimStPLE.this.simSt.isSkillNameGetterDefined()) {
                while (prev != null) {
                    if (!SimStPLE.this.simSt.getSkillNameGetter().skillNameGetter(SimStPLE.this.brController, prev.getSai().getS(), prev.getSai().getA(), prev.getSai().getI()).contains("typein")) {
                        return prev.getInput();
                    }
                    ProblemNode source = prev.getSource();
                    if (source.getInDegree() > 0) {
                        prev = source.getIncomingEdges().get(0);
                        continue;
                    }
                    return null;
                }
            }
            return prev.getInput();
        }

        public void undoLastStep() {
            SimStPLE.this.blockInput(true);
            ProblemEdge edge = SimStPLE.this.brController.getCurrentNode().getIncomingEdges().get(0);
            Sai sai = edge.getSai();
            Object obj = SimStPLE.this.brController.lookupWidgetByName(sai.getS());
            if (obj != null && obj instanceof JCommTable.TableCell) {
                ((JCommTable.TableCell)obj).setBackground(Color.pink);
            }
            String query = SimStPLE.this.generateUndoQueryMessage(sai.getS(), sai.getA(), sai.getI());
            int result = SimStPLE.this.simSt.displayConfirmMessage("Undo?", query);
            if (obj != null && obj instanceof JCommTable.TableCell) {
                ((JCommTable.TableCell)obj).setBackground(Color.white);
            }
            if (result == 0) {
                AskHint hint;
                if (trace.getDebugCode("rr")) {
                    trace.out("rr", "Modeltracing the student action: undo  ButtonPressed  -1");
                }
                if (SimStPLE.this.simSt.isSsMetaTutorMode() && SimStPLE.this.brController.getAmt() != null) {
                    SimStPLE.this.brController.getAmt().handleInterfaceAction(SimStPLE.UNDO, "ButtonPressed", "-1");
                }
                String currentStatus = SimStPLE.this.wasNormal;
                if (!SimStPLE.this.simSt.isInteractiveLearning()) {
                    currentStatus = SimStPLE.this.brController.getCurrentNode().getDoneState() ? SimStPLE.this.wasDone : SimStPLE.this.wasFailToLearn;
                }
                if ((hint = SimStPLE.this.simSt.askForHintQuizGradingOracle(SimStPLE.this.brController, edge.getSource())) != null) {
                    int problemDuration = (int)(Calendar.getInstance().getTimeInMillis() - SimStPLE.this.getSsInteractiveLearning().getProblemRecentTime());
                    SimStPLE.this.getSsInteractiveLearning().setProblemRecentTime(Calendar.getInstance().getTimeInMillis());
                    SimStPLE.this.logger.simStLog("SIM_STUDENT_STEP", "Step Undone", SimStPLE.this.simSt.getProblemStepString(), currentStatus, "", sai, edge.getSource(), hint.getSelection(), hint.getAction(), hint.getInput(), problemDuration, query);
                }
                boolean traversed = false;
                if (edge.getSource().isStudentBeginsHereState()) {
                    SimStPLE.this.brController.goToStartState();
                    traversed = true;
                } else {
                    traversed = SimStPLE.this.brController.goToState(edge.getSource());
                }
                if (traversed) {
                    if (edge.getSource().getInDegree() > 0) {
                        ProblemEdge prev = edge.getSource().getIncomingEdges().get(0);
                        SimStPLE.this.getSimStPeerTutoringPlatform().setUndoButtonText(SimStPLE.this.getUndoButtonTitleString(prev.getInput()));
                    } else {
                        SimStPLE.this.getSimStPeerTutoringPlatform().setUndoButtonText(SimStPLE.this.getUndoButtonTitleString());
                    }
                    if (currentStatus.equals(SimStPLE.this.wasDone)) {
                        SimStPLE.this.simSt.displayMessage("SimStudent says...", SimStPLE.BACK_TO_WORK_MSG);
                    } else {
                        String NOTHING_DONE_YET;
                        SimStPLE.this.simSt.displayMessage("SimStudent asks...", SimStPLE.SHOULD_DO_MSG.replace("$", sai.getI()));
                        if (SimStPLE.this.simSt.getLastSkillOperand() == null) {
                            NOTHING_DONE_YET = "I don't remember having done anything before that...";
                            SimStPLE.this.simSt.displayMessage(null, NOTHING_DONE_YET);
                        } else if (!SimStPLE.this.simSt.getLastSkillOperand().equals(sai.getI())) {
                            SimStPLE.this.simSt.displayMessage("SimStudent says...", "I remember I was trying to " + SimStPLE.this.simSt.getLastSkillOperand() + ".");
                        } else {
                            NOTHING_DONE_YET = SimStPLE.this.simSt.revertLastSkillOperand();
                        }
                    }
                    Instruction inst = SimStPLE.this.simSt.lookupInstructionWithNode(edge.getDest());
                    SimStPLE.this.simSt.negateBadPositiveExample(inst);
                    SimStPLE.this.simSt.signalInstructionAsNegativeExample(inst);
                    SimStPLE.this.simSt.setIsInteractiveLearning(true);
                    SimStPLE.this.getSsInteractiveLearning().runInteractiveLearning(edge.getSource(), false);
                }
            } else if (!SimStPLE.this.brController.getCurrentNode().getDoneState()) {
                SimStPLE.this.blockInput(false);
                SimStPLE.this.simSt.displayMessage("SimStudent asks...", SimStPLE.RESUME_MSG);
            }
        }
    }

    public class QuestionAnswers {
        String question;
        List<String> answers;

        public QuestionAnswers(String q, List<String> a) {
            this.question = q;
            this.answers = a;
        }

        public String getQuestion() {
            return this.question;
        }

        public List<String> getAnswers() {
            return this.answers;
        }
    }

    class Explanation {
        List<String> skillConditions = new LinkedList<String>();
        List<String> problemConditions;
        List<String> inputConditions;
        String explanation;

        Explanation(String[] conditions, String exp) {
            for (int i = 0; i < conditions.length; ++i) {
                String condition = conditions[i];
                this.skillConditions.add(condition);
            }
            this.explanation = exp;
        }

        boolean singleMatch(String contains, String containedIn) {
            if (contains.startsWith("!")) {
                return !containedIn.contains(contains.substring(1));
            }
            return containedIn.contains(contains);
        }

        boolean matches(String skill, String problem, String input) {
            for (String str : this.skillConditions) {
                if (str.contains(";")) {
                    String[] ors = str.split(";");
                    boolean match = false;
                    for (int i = 0; i < ors.length; ++i) {
                        if (!this.singleMatch(ors[i], skill)) continue;
                        match = true;
                    }
                    if (match) continue;
                    return false;
                }
                if (this.singleMatch(str, skill)) continue;
                return false;
            }
            return true;
        }
    }
}

