/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.miss.Decomposer;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.Relation;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.SimStudentModelTracerFunction;
import java.util.Iterator;
import java.util.Vector;
import jess.Context;
import jess.Deftemplate;
import jess.Fact;
import jess.JessException;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

public class WMEChunkLoader
extends SimStudentModelTracerFunction {
    private Vector decomposers;
    private Vector defTemplateCache = new Vector();
    public static final String DEFAULT_ARG_PREFIX = "arg";

    @Override
    public Value javaCall(ValueVector vv, Context context) throws JessException {
        if (vv == null) {
            return new Value(false);
        }
        Rete rete = context.getEngine();
        Vector<String> initValues = new Vector<String>();
        Vector<Object> allInputs = new Vector<Object>();
        Vector<Object> decomposedValues = new Vector();
        for (int i = 0; i < vv.size(); ++i) {
            initValues.add(vv.get(i).stringValue(context));
        }
        allInputs.addAll(initValues);
        decomposedValues = SimSt.chainDecomposedValues(initValues, this.decomposers);
        allInputs.addAll(decomposedValues);
        Iterator predIter = this.predicates.iterator();
        if (!decomposedValues.isEmpty()) {
            while (predIter.hasNext()) {
                FeaturePredicate curPred = (FeaturePredicate)predIter.next();
                if (!curPred.isDecomposedRelationship()) continue;
                Vector argSets = Relation.permuteArgs(allInputs, curPred.getArity());
                String curName = curPred.getName();
                for (Vector curArgs : argSets) {
                    if (curPred.apply(curArgs) == null) continue;
                    this.assertUnOrderedWME(curName, curPred.getArgNames(), curArgs, rete);
                }
            }
        }
        return new Value(true);
    }

    public String getName() {
        return "wme-chunk-loader";
    }

    @Override
    public ValueVector getArguments(String selection, String action, String input, Rete rete) throws JessException {
        ValueVector v = new ValueVector();
        MTRete mtRete = (MTRete)rete;
        Fact f = mtRete.getFactByName(selection);
        if (f == null) {
            return null;
        }
        Deftemplate dt = f.getDeftemplate();
        if (dt.getSlotIndex("value") == -1) {
            return null;
        }
        v.add(input);
        return v;
    }

    public void assertUnOrderedWME(String name, Vector argNames, Vector args, Rete rete) throws JessException {
        Deftemplate curType = rete.findDeftemplate(name);
        Fact curFact = new Fact(curType);
        for (int argnum = 0; argnum < args.size(); ++argnum) {
            String curArgName = (String)argNames.get(argnum);
            Value v = MTRete.stringToValue((String)args.get(argnum));
            curFact.setSlotValue(curArgName, v);
        }
        rete.assertFact(curFact);
    }

    private static Deftemplate makeDefTemplate(String name, Vector argNames, Rete rete) throws JessException {
        Deftemplate type = new Deftemplate(name, "", rete);
        for (int i = 0; i < argNames.size(); ++i) {
            type.addSlot((String)argNames.get(i), new Value("", 2), "STRING");
        }
        rete.addDeftemplate(type);
        return type;
    }

    public Vector getDecomposers() {
        return this.decomposers;
    }

    public void setDecomposers(Vector decomposers) {
        this.decomposers = decomposers;
    }

    public void addDecomposer(Decomposer d) {
        if (this.decomposers == null) {
            this.decomposers = new Vector();
        }
        this.decomposers.add(d);
    }
}

