/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.AmlRete;
import edu.cmu.pact.miss.WmePathNode;
import java.util.Iterator;
import java.util.Vector;
import jess.Fact;

public class WmePath
implements Cloneable {
    private AmlRete rete;
    private Vector nodes = new Vector();
    private int generality = -1;

    private AmlRete getRete() {
        return this.rete;
    }

    private void setRete(AmlRete rete) {
        this.rete = rete;
    }

    Vector getNodes() {
        return this.nodes;
    }

    private void setNodes(Vector nodes) {
        this.nodes = nodes;
    }

    private void addNodes(WmePathNode node) {
        this.nodes.add(node);
    }

    WmePathNode getLastNode() {
        return (WmePathNode)this.nodes.lastElement();
    }

    private WmePathNode getWmePathNode(int i) {
        return (WmePathNode)this.nodes.get(i);
    }

    public int length() {
        return this.nodes.size();
    }

    private int getGenerality() {
        if (this.generality == -1) {
            this.setGenerality();
        }
        return this.generality;
    }

    private void setGenerality() {
        int generality = 0;
        Vector nodes = this.getNodes();
        for (WmePathNode node : nodes) {
            generality = generality * 2 + (node.isMostSpecific() ? 0 : 1);
        }
        this.generality = generality;
    }

    private void resetGenerality() {
        this.generality = -1;
    }

    public WmePath(AmlRete rete) {
        this.setRete(rete);
    }

    void add(Fact fact, String ParentSlotName) {
        if (this.getNodes().isEmpty()) {
            this.addNodes(new WmePathNode(fact, this.getRete()));
        } else {
            WmePathNode last2 = this.getLastNode();
            String var = last2.replaceVar(fact);
            WmePathNode next = new WmePathNode(var, fact, this.getRete());
            next.setParentSlot(ParentSlotName);
            last2.setChild(next);
            this.addNodes(next);
        }
    }

    WmePath generalize() {
        int generality = this.getGenerality();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "WmePath.generalize()");
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "  generality = " + generality);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "  wmtPath = " + this);
        }
        if (generality + 1 == (1 << this.length()) - 1) {
            return null;
        }
        WmePath generalizedPath = (WmePath)this.clone();
        WmePathNode targetNode = null;
        int index = -1;
        for (int i = this.length() - 2; i >= 0; --i) {
            trace.out("i = " + i);
            trace.out("(generality + 2) % (2 << i) = " + (generality + 2) % (2 << i));
            if ((generality + 2) % (2 << i) != 0) continue;
            index = this.length() - i - 2;
            targetNode = (WmePathNode)this.getNodes().get(index);
            trace.out("targetNode: " + targetNode);
            break;
        }
        WmePathNode generalizedNode = targetNode.generalize();
        trace.out("generalizedNode: " + generalizedNode);
        generalizedPath.getNodes().setElementAt(generalizedNode, index);
        generalizedPath.resetGenerality();
        return generalizedPath;
    }

    WmePath generalize(int targetPaths) {
        WmePath generalizedPath = (WmePath)this.clone();
        for (int i = 0; i < this.length(); ++i) {
            if ((1 << i & targetPaths) == 0) continue;
            int index = this.length() - i - 1;
            WmePathNode targetNode = (WmePathNode)this.getNodes().get(index);
            WmePathNode generalizedNode = targetNode.generalize();
            if (generalizedNode == null) {
                return null;
            }
            generalizedPath.getNodes().setElementAt(generalizedNode, index);
        }
        generalizedPath.resetGenerality();
        return generalizedPath;
    }

    boolean isUnifiable(WmePath wmePath) {
        boolean test;
        boolean bl = test = this.length() == wmePath.length();
        if (test) {
            Vector thisNodes = this.getNodes();
            Vector thatNodes = wmePath.getNodes();
            int size = thisNodes.size();
            for (int i = 0; i < size; ++i) {
                WmePathNode thatNode;
                WmePathNode thisNode = (WmePathNode)thisNodes.get(i);
                if (thisNode.isUnifiable(thatNode = (WmePathNode)thatNodes.get(i))) continue;
                test = false;
                break;
            }
        }
        return test;
    }

    Vector findFloatingWme() {
        Vector<WmePathNode> floatingWmes = new Vector<WmePathNode>();
        for (int i = 0; i < this.length() - 1; ++i) {
            if (!this.getWmePathNode(i).hasMultivariable()) continue;
            floatingWmes.add(this.getWmePathNode(i + 1));
        }
        return floatingWmes;
    }

    boolean hasNode(Fact fact) {
        boolean test = false;
        for (int i = 0; i < this.getNodes().size(); ++i) {
            WmePathNode node = (WmePathNode)this.getNodes().get(i);
            if (!node.hasSameFact(fact)) continue;
            test = true;
            break;
        }
        return test;
    }

    boolean hasNode(WmePathNode wmePathNode) {
        return this.getNodes().contains(wmePathNode);
    }

    int indexOf(WmePathNode wmePathNode) {
        return this.getNodes().indexOf(wmePathNode);
    }

    public WmePathNode lookupNodeOfType(String type) {
        WmePathNode theNode = null;
        for (int i = 0; i < this.getNodes().size(); ++i) {
            WmePathNode node = (WmePathNode)this.getNodes().get(i);
            if (!node.isWmeType(type)) continue;
            theNode = node;
            break;
        }
        return theNode;
    }

    public WmePathNode removeLastNode() {
        WmePathNode last2 = (WmePathNode)this.nodes.remove(this.nodes.size() - 1);
        WmePathNode nextToLast = this.getLastNode();
        if (nextToLast != null) {
            nextToLast.setChild(null);
        }
        return last2;
    }

    public Object clone() {
        WmePath cloneWmePath = null;
        try {
            cloneWmePath = (WmePath)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        Vector<WmePathNode> cloneNodes = new Vector<WmePathNode>();
        Vector nodes = this.getNodes();
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            WmePathNode cloneNode = (WmePathNode)((WmePathNode)nodes.get(i)).clone();
            cloneNodes.add(cloneNode);
        }
        cloneWmePath.setNodes(cloneNodes);
        return cloneWmePath;
    }

    public String toString() {
        String str = "";
        Iterator paths = this.getNodes().iterator();
        while (paths.hasNext()) {
            str = str + ((WmePathNode)paths.next()).toString() + "\n";
        }
        return str;
    }
}

