/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.jess;

import edu.cmu.pact.jess.SimStRete;
import edu.cmu.pact.miss.jess.APlusModelTracing;
import edu.cmu.pact.miss.minerva_3_1.Problem;
import java.io.Serializable;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public class GetAbstractedProblem
implements Userfunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String GET_ABSTRACTED_PROBLEM = "get-abstracted-problem";
    protected transient APlusModelTracing amt;
    protected transient Context context;

    public GetAbstractedProblem() {
        this(null);
    }

    public GetAbstractedProblem(APlusModelTracing amt) {
        this.amt = amt;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        if (!vv.get(0).stringValue(context).equals(GET_ABSTRACTED_PROBLEM)) {
            throw new JessException(GET_ABSTRACTED_PROBLEM, "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        String problem = "NotSpecified";
        if (context.getEngine() instanceof SimStRete && vv.size() > 1) {
            problem = vv.get(1).resolveValue(context).stringValue(context);
        }
        if (problem != "NotSpecified") {
            String[] token = problem.split("=");
            if (token.length != 2) {
                return Funcall.FALSE;
            }
            problem = " " + token[0] + "=" + token[1] + " ";
            Problem minervaProblem = new Problem(problem);
            String abstractedProblemWithSign = minervaProblem.getSignedAbstraction();
            abstractedProblemWithSign = GetAbstractedProblem.formatProblem(abstractedProblemWithSign);
            Value rtnValue = new Value(abstractedProblemWithSign, 2);
            return rtnValue;
        }
        return Funcall.FALSE;
    }

    protected static String abstractProblemUsingMinerva(String inputP) {
        Problem minervaProblem = new Problem(inputP);
        return minervaProblem.getSignedAbstraction();
    }

    protected static String formatProblem(String abstractedProblemWithSign) {
        String prob = "";
        char nextConstant = 'A';
        char varUpper = 'V';
        char varLower = 'v';
        for (int i = 0; i < abstractedProblemWithSign.length(); ++i) {
            char current = abstractedProblemWithSign.charAt(i);
            if (current == varUpper || current == varLower) {
                prob = prob + current;
                continue;
            }
            if (Character.isLetter(current)) {
                char c = nextConstant;
                nextConstant = (char)(nextConstant + 1);
                prob = prob + c;
                continue;
            }
            prob = prob + current;
        }
        return prob;
    }

    public String getName() {
        return GET_ABSTRACTED_PROBLEM;
    }
}

