/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.minerva_3_1;

import edu.cmu.pact.miss.minerva_3_1.InputCapsule;
import edu.cmu.pact.miss.minerva_3_1.Problem;
import edu.cmu.pact.miss.minerva_3_1.Step;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class Minerva3 {
    private Map<String, Problem> problemSet = new HashMap<String, Problem>();
    String[] headerExtension = new String[]{"Problem Signed Abs", "Problem Unsigned Abs", "Problem Context Abs", "Problem Side Signed Abs", "Problem Side UnSigned Abs", "Problem Side Context Abs", "Step Signed Abs", "Step Unsigned Abs", "Step Signed Context Abs", "Step Unsigned Context Abs", "Step Side Signed Abs", "Step Side Unsigned Abs", "Step Side Signed Context Abs", "Step Side Unsigned Context Abs"};

    private void processFile(String inputFile, String outputFile) throws Exception {
        String header;
        Scanner infile = new Scanner(new FileReader(inputFile));
        PrintWriter outfile = new PrintWriter(new FileWriter(outputFile));
        String outputHeader = header = infile.nextLine();
        for (String column : this.headerExtension) {
            outputHeader = outputHeader + "\t" + column;
        }
        outfile.println(outputHeader);
        while (infile.hasNextLine()) {
            String inputLine;
            String outputLine = inputLine = infile.nextLine();
            InputCapsule capsule = new InputCapsule(inputLine, header);
            String problemName = capsule.getValue("Problem Name");
            if (this.isValidEquation(problemName)) {
                if (!this.problemSet.containsKey(problemName)) {
                    this.problemSet.put(problemName, new Problem(problemName));
                }
                Problem inputProblem = this.problemSet.get(problemName);
                String stepName = capsule.getValue("Step Name");
                Step inputStep = new Step(stepName);
                outputLine = outputLine + "\t" + inputProblem.getSignedAbstraction() + "\t" + inputProblem.getUnsignedAbstraction() + "\t" + inputProblem.getAbstractionContext() + "\t" + this.getSideAbstraction(inputProblem.getSignedAbstraction()) + "\t" + this.getSideAbstraction(inputProblem.getUnsignedAbstraction()) + "\t" + inputProblem.getSideAbstractionContext(this.reverseSide(inputProblem.getName())) + "\t" + inputStep.getSignedAbstraction() + "\t" + inputStep.getUnsignedAbstraction() + "\t" + inputStep.getSignedInputAbstractionContext() + "\t" + inputStep.getUnsignedInputAbstractionContext() + "\t" + this.getSideAbstraction(inputStep.getSignedAbstraction()) + "\t" + this.getSideAbstraction(inputStep.getUnsignedAbstraction()) + "\t" + inputStep.getSignedSideAbstractionContext(this.reverseSide(inputStep.getStep_Name())) + "\t" + inputStep.getUnsignedSideAbstractionContext(this.reverseSide(inputStep.getStep_Name()));
            }
            outfile.println(outputLine);
        }
        outfile.close();
    }

    private String getSideAbstraction(String expression) {
        return this.reverseSide(expression);
    }

    private String reverseSide(String expression) {
        int idx = 0;
        if (expression != null) {
            idx = expression.indexOf("=");
        }
        if (idx <= 0) {
            return expression;
        }
        String lhs = expression.substring(0, idx);
        String rhs = expression.substring(idx + 1);
        if (lhs.matches("[0-9]+")) {
            return rhs + "=" + lhs;
        }
        return expression;
    }

    private boolean isValidEquation(String expression) {
        return expression.indexOf(61) != -1;
    }

    public static void main(String[] Args) throws Exception {
        String inputFile = Args[0];
        String outputFile = Args[1];
        System.out.println("Minerva V3: InputFile " + inputFile + ", OutputFile: " + outputFile);
        System.out.println("Current dir: " + new File(".").getAbsolutePath());
        new Minerva3().processFile(inputFile, outputFile);
    }
}

