/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra;

import cl.utilities.sm.Expression;
import edu.cmu.pact.miss.userDef.algebra.CLBased;
import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import java.util.Vector;

public class MulTerm
extends CLBased {
    public MulTerm() {
        this.setName("mul-term");
        this.setArity(2);
        this.setReturnValueType(1);
        this.setArgValueType(new int[]{1, 1});
    }

    @Override
    public String apply(Vector args) {
        String expString1 = (String)args.get(0);
        String expString2 = (String)args.get(1);
        try {
            AlgExp e1 = AlgExp.parseExp(expString1);
            AlgExp e2 = AlgExp.parseExp(expString2);
            if (e1.isPolynomial() && e2.isPolynomial()) {
                return null;
            }
            if (e1.isPolynomial() && e2.isSimpleTerm()) {
                return null;
            }
            if (e1.isSimpleTerm() && e2.isPolynomial()) {
                return null;
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        Expression exp1 = this.parse(expString1);
        Expression exp2 = this.parse(expString2);
        Expression multiplied = exp1.multiply(exp2).simplify();
        return this.typecheck(expString1, expString2, multiplied);
    }
}

