/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class Polynomial
extends AlgExp {
    protected AlgExp firstHalf;
    protected AlgExp secondHalf;

    public Polynomial(AlgExp e1, AlgExp e2) {
        this.firstHalf = e1;
        this.secondHalf = e2;
        this.isSimple = false;
        this.isPolynomial = true;
        this.hasVariable = this.firstHalf.hasVariable || this.secondHalf.hasVariable();
    }

    @Override
    public AlgExp commute() {
        return new Polynomial(this.secondHalf, this.firstHalf);
    }

    public AlgExp getFirstHalf() {
        return this.firstHalf;
    }

    public AlgExp getSecondHalf() {
        return this.secondHalf;
    }

    @Override
    public AlgExp add(IntConst c) {
        return this.doAdd(c);
    }

    @Override
    public AlgExp add(DoubleConst c) {
        return this.doAdd(c);
    }

    @Override
    public AlgExp add(Variable v) {
        return this.doAdd(v);
    }

    @Override
    public AlgExp add(ConstantFraction f) {
        return this.doAdd(f);
    }

    @Override
    public AlgExp add(SimpleTerm t) {
        return this.doAdd(t);
    }

    @Override
    public AlgExp add(Polynomial e) {
        AlgExp result = this.add(e.getFirstHalf()).add(e.getSecondHalf());
        return result;
    }

    @Override
    public AlgExp add(ComplexTerm ct) {
        return this.doAdd(ct);
    }

    @Override
    public AlgExp add(ComplexFraction cf) {
        return this.doAdd(cf);
    }

    @Override
    public AlgExp mul(IntConst c) {
        return new Polynomial(this.firstHalf.mul(c), this.secondHalf.mul(c));
    }

    @Override
    public AlgExp mul(DoubleConst c) {
        return new Polynomial(this.firstHalf.mul(c), this.secondHalf.mul(c));
    }

    @Override
    public AlgExp mul(Variable v) {
        return new Polynomial(this.firstHalf.mul(v), this.secondHalf.mul(v));
    }

    @Override
    public AlgExp mul(ConstantFraction f) {
        return new Polynomial(this.firstHalf.mul(f), this.secondHalf.mul(f));
    }

    @Override
    public AlgExp mul(SimpleTerm t) {
        return new Polynomial(this.firstHalf.mul(t), this.secondHalf.mul(t));
    }

    @Override
    public AlgExp mul(Polynomial e) {
        return new ComplexTerm(this, e);
    }

    @Override
    public AlgExp mul(ComplexTerm ct) {
        return ct.mul(this);
    }

    @Override
    public AlgExp mul(ComplexFraction cf) {
        return cf.mul(this);
    }

    @Override
    public AlgExp div(IntConst c) {
        return this.mul(c.invert());
    }

    @Override
    public AlgExp div(DoubleConst c) {
        return this.mul(c.invert());
    }

    @Override
    public AlgExp div(Variable v) {
        return this.mul(v.invert());
    }

    @Override
    public AlgExp div(ConstantFraction f) {
        return this.mul(f.invert());
    }

    @Override
    public AlgExp div(SimpleTerm t) {
        return this.mul(t.invert());
    }

    @Override
    public AlgExp div(Polynomial e) {
        if (e.equals(this)) {
            return AlgExp.ONE;
        }
        return this.mul(e.invert());
    }

    @Override
    public AlgExp div(ComplexTerm ct) {
        return this.mul(ct.invert());
    }

    @Override
    public AlgExp div(ComplexFraction cf) {
        return this.mul(cf.invert());
    }

    @Override
    public AlgExp invert() {
        return new ComplexFraction(AlgExp.ONE, this);
    }

    @Override
    public String parseRep() {
        return "(" + this.firstHalf + ")+(" + this.secondHalf + ")";
    }

    public String toString() {
        String firstRep = this.firstHalf.toString();
        String secondRep = this.secondHalf.toString();
        if (secondRep.charAt(0) == '-') {
            return firstRep.toString() + secondRep.toString();
        }
        return firstRep + "+" + secondRep;
    }

    public int getNumTerms() {
        return this.getNumTerms(this);
    }

    private int getNumTerms(AlgExp e) {
        if (!e.isPolynomial()) {
            return 1;
        }
        Polynomial p = (Polynomial)e;
        return this.getNumTerms(p.getFirstHalf()) + this.getNumTerms(p.getSecondHalf());
    }

    private AlgExp doAdd(AlgExp e) {
        AlgExp result = this.secondHalf.add(e);
        if (!result.isPolynomial()) {
            if (result.equals(AlgExp.ZERO)) {
                if (this.firstHalf.isPolynomial()) {
                    return (Polynomial)this.firstHalf;
                }
                return this.firstHalf;
            }
            return new Polynomial(this.firstHalf, result);
        }
        if (this.getNumTerms(result) == this.getNumTerms(this.secondHalf)) {
            return new Polynomial(this.firstHalf, result);
        }
        result = this.firstHalf.add(e);
        if (!result.isPolynomial()) {
            if (result.equals(AlgExp.ZERO)) {
                if (this.secondHalf.isPolynomial()) {
                    return (Polynomial)this.secondHalf;
                }
                return this.secondHalf;
            }
            return new Polynomial(result, this.secondHalf);
        }
        if (this.getNumTerms(result) == this.getNumTerms(this.firstHalf)) {
            return new Polynomial(result, this.secondHalf);
        }
        return new Polynomial(this, e);
    }

    @Override
    public boolean equals(IntConst c) {
        return false;
    }

    @Override
    public boolean equals(DoubleConst c) {
        return false;
    }

    @Override
    public boolean equals(Variable v) {
        return false;
    }

    @Override
    public boolean equals(ConstantFraction f) {
        return false;
    }

    @Override
    public boolean equals(SimpleTerm t) {
        return false;
    }

    @Override
    public boolean equals(Polynomial e) {
        return this.firstHalf.equals(e.getFirstHalf()) && this.secondHalf.equals(e.getSecondHalf());
    }

    @Override
    public boolean equals(ComplexTerm ct) {
        return false;
    }

    @Override
    public boolean equals(ComplexFraction cf) {
        return false;
    }

    @Override
    public AlgExp eval() {
        AlgExp result;
        AlgExp lastResult = this;
        while (!(result = this.firstHalf.eval().add(this.secondHalf.eval())).equals(lastResult = result)) {
        }
        return result;
    }

    public AlgExp evalAdd() {
        AlgExp newFirst = this.firstHalf.isPolynomial() ? ((Polynomial)this.firstHalf).evalAdd() : this.firstHalf.eval();
        AlgExp newSecond = this.secondHalf.isPolynomial() ? ((Polynomial)this.secondHalf).evalAdd() : this.secondHalf.eval();
        return newFirst.add(newSecond);
    }

    public AlgExp getFirstVarTerm() {
        AlgExp result;
        if (this.firstHalf.isPolynomial() && (result = ((Polynomial)this.firstHalf).getFirstVarTerm()) != null) {
            return result;
        }
        if (this.secondHalf.isPolynomial() && (result = ((Polynomial)this.secondHalf).getFirstVarTerm()) != null) {
            return result;
        }
        if (this.firstHalf.hasVariable) {
            return this.firstHalf;
        }
        if (this.secondHalf.hasVariable()) {
            return this.secondHalf;
        }
        return null;
    }

    public AlgExp getLastVarTerm() {
        AlgExp result;
        if (this.secondHalf.isPolynomial() && (result = ((Polynomial)this.secondHalf).getLastVarTerm()) != null) {
            return result;
        }
        if (this.secondHalf.hasVariable()) {
            return this.secondHalf;
        }
        if (this.firstHalf.isPolynomial() && (result = ((Polynomial)this.firstHalf).getLastVarTerm()) != null) {
            return result;
        }
        if (this.firstHalf.hasVariable()) {
            return this.firstHalf;
        }
        return null;
    }

    public AlgExp getFirstTerm() {
        AlgExp result;
        if (this.firstHalf.isPolynomial() && (result = ((Polynomial)this.firstHalf).getFirstTerm()) != null) {
            return result;
        }
        if (this.secondHalf.isPolynomial() && (result = ((Polynomial)this.secondHalf).getFirstTerm()) != null) {
            return result;
        }
        return this.firstHalf;
    }

    public AlgExp getLastTerm() {
        AlgExp result;
        if (this.secondHalf.isPolynomial()) {
            result = ((Polynomial)this.secondHalf).getLastTerm();
            if (result != null) {
                return result;
            }
        } else {
            return this.secondHalf;
        }
        if (this.firstHalf.isPolynomial() && (result = ((Polynomial)this.firstHalf).getLastTerm()) != null) {
            return result;
        }
        return null;
    }

    public AlgExp getLastConstTerm() {
        AlgExp result;
        if (this.secondHalf.isPolynomial() && (result = ((Polynomial)this.secondHalf).getLastConstTerm()) != null) {
            return result;
        }
        if (this.secondHalf.isConstant()) {
            return this.secondHalf;
        }
        if (this.firstHalf.isPolynomial() && (result = ((Polynomial)this.firstHalf).getLastConstTerm()) != null) {
            return result;
        }
        if (this.firstHalf.isConstant()) {
            return this.firstHalf;
        }
        return null;
    }

    @Override
    public AlgExp negate() {
        return new ComplexTerm(AlgExp.NEGONE, this);
    }

    public boolean hasConstTerm() {
        if (this.secondHalf.isConstant()) {
            return true;
        }
        if (this.firstHalf.isConstant()) {
            return true;
        }
        boolean firstHasConst = false;
        boolean secondHasConst = false;
        if (this.secondHalf.isPolynomial()) {
            secondHasConst = ((Polynomial)this.secondHalf).hasConstTerm();
        }
        if (secondHasConst) {
            return true;
        }
        if (this.firstHalf.isPolynomial()) {
            firstHasConst = ((Polynomial)this.firstHalf).hasConstTerm();
        }
        return firstHasConst;
    }

    @Override
    public boolean hasVariable(String varName) {
        return this.firstHalf.hasVariable(varName) || this.secondHalf.hasVariable(varName);
    }

    @Override
    public Set getAllVars() {
        Set secondSet;
        HashSet vars = new HashSet();
        Set firstSet = this.firstHalf.getAllVars();
        if (!firstSet.isEmpty()) {
            vars.addAll(firstSet);
        }
        if (!(secondSet = this.secondHalf.getAllVars()).isEmpty()) {
            vars.addAll(secondSet);
        }
        return vars;
    }

    protected static boolean comesBefore(AlgExp exp1, AlgExp exp2) {
        if (exp1.hasVariable() && !exp2.hasVariable()) {
            return true;
        }
        if (exp2.hasVariable() && !exp1.hasVariable()) {
            return false;
        }
        if (exp1.isPolynomial()) {
            return true;
        }
        if (exp2.isPolynomial()) {
            return true;
        }
        if (exp1.isVariable()) {
            exp1 = new SimpleTerm(AlgExp.ONE, (AlgExp)((Variable)exp1));
        }
        if (exp2.isVariable()) {
            exp2 = new SimpleTerm(AlgExp.ONE, (AlgExp)((Variable)exp2));
        }
        if (exp1.isSimpleTerm() && exp2.isSimpleTerm()) {
            SimpleTerm t1 = (SimpleTerm)exp1;
            SimpleTerm t2 = (SimpleTerm)exp2;
            if (t1.getVariable().equals(t2.getVariable())) {
                return t1.getConstant().getVal() > t2.getConstant().getVal();
            }
            return t1.getVariable().getName().compareTo(t2.getVariable().getName()) < 1;
        }
        return true;
    }

    public boolean containsTerm(AlgExp term) {
        if (term.isPolynomial()) {
            return false;
        }
        if (this.firstHalf.equals(term)) {
            return true;
        }
        if (this.secondHalf.equals(term)) {
            return true;
        }
        if (this.firstHalf.isPolynomial() && ((Polynomial)this.firstHalf).containsTerm(term)) {
            return true;
        }
        return this.secondHalf.isPolynomial() && ((Polynomial)this.secondHalf).containsTerm(term);
    }

    public Vector getAllTerms() {
        Vector<AlgExp> terms = new Vector<AlgExp>();
        if (this.firstHalf.isPolynomial()) {
            terms.addAll(((Polynomial)this.firstHalf).getAllTerms());
        } else {
            terms.add(this.firstHalf);
        }
        if (this.secondHalf.isPolynomial()) {
            terms.addAll(((Polynomial)this.secondHalf).getAllTerms());
        } else {
            terms.add(this.secondHalf);
        }
        return terms;
    }

    @Override
    public AlgExp divDecimal(IntConst c) {
        new Exception().printStackTrace();
        return null;
    }
}

