/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.oldpredicates;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.userDef.oldpredicates.AlgebraExp;
import edu.cmu.pact.miss.userDef.oldpredicates.AlgebraExpPoly;
import java.text.ParseException;
import mylib.MathLib;

public class AlgebraExpTerm
extends AlgebraExp {
    @Override
    public boolean isTerm() {
        return true;
    }

    @Override
    public boolean isPolynomial() {
        return false;
    }

    @Override
    public boolean isValidPolynomial() {
        return false;
    }

    public AlgebraExpTerm(String exp) {
        this.setExp(exp);
        this.containsDecimals = exp.indexOf(".") != -1;
    }

    @Override
    String getVarName() {
        String exp = this.getExp();
        int v = exp != null ? (int)exp.toUpperCase().charAt(this.getExp().length() - 1) : 32;
        return 65 <= v && v <= 90 ? this.getExp().substring(this.getExp().length() - 1) : "";
    }

    @Override
    String getCoefficient() {
        String coefficient = null;
        if (this.isTerm() && !this.getVarName().equals("")) {
            coefficient = this.getExp().substring(0, this.getExp().length() - 1);
            if (coefficient.equals("")) {
                coefficient = "1";
            } else if (coefficient.equals("-")) {
                coefficient = "-1";
            }
        }
        return coefficient;
    }

    @Override
    AlgebraExp getLastTerm() {
        return null;
    }

    @Override
    AlgebraExp getLastConstTerm() {
        return null;
    }

    @Override
    boolean isConstTerm() {
        return !this.isVarTerm();
    }

    @Override
    boolean isVarTerm() {
        char v = this.getExp().toUpperCase().charAt(this.getExp().length() - 1);
        return 'A' <= v && v <= 'Z';
    }

    @Override
    boolean isZero() {
        return this.getExp().equals("0");
    }

    @Override
    boolean equals(AlgebraExp term) {
        return term.isTerm() && this.getExp().equals(term.getExp());
    }

    @Override
    public AlgebraExp evalArithmetic() {
        AlgebraExp evalArithmetic = null;
        if (this.getExp().charAt(0) == '-' && this.getExp().charAt(1) == '(' && this.getExp().charAt(this.getExp().length() - 1) == ')') {
            String expBody = this.getExp().substring(2, this.getExp().length() - 1);
            AlgebraExp exp = null;
            try {
                exp = AlgebraExp.parseExp(expBody);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (exp != null) {
                evalArithmetic = exp.multTerm(new AlgebraExpTerm("-1"));
            }
        } else {
            evalArithmetic = this;
        }
        return evalArithmetic;
    }

    @Override
    public AlgebraExp addTerm(AlgebraExp term) {
        if (this.isDecimal() || term.isDecimal()) {
            return this.addTermDec(term);
        }
        term = term.evalArithmetic();
        String c1 = null;
        String c2 = null;
        if (this.isVarTerm() && term.isVarTerm() && this.isSameType(term)) {
            int c;
            c1 = this.getCoefficient();
            c2 = term.getCoefficient();
            try {
                c = Integer.parseInt(c1) + Integer.parseInt(c2);
            }
            catch (Exception e) {
                trace.out("eqfp", "AlgebraExpTerm: " + this + ".addTerm(" + term + ")");
                return null;
            }
            if (c == 0) {
                return new AlgebraExpTerm("0");
            }
            String v = this.getVarName();
            return new AlgebraExpTerm((c == 1 ? "" : (c == -1 ? "-" : "" + c)) + v);
        }
        if (term.isTerm() && !this.isVarTerm() && !term.isVarTerm()) {
            int c;
            c1 = this.toString();
            c2 = term.toString();
            try {
                c = Integer.parseInt(c1) + Integer.parseInt(c2);
            }
            catch (Exception e) {
                trace.out("eqfp", "AlgebraExpTerm: " + this + ".addTerm(" + term + ")");
                return null;
            }
            return new AlgebraExpTerm("" + c);
        }
        return this.comesBefore(term) ? new AlgebraExpPoly("+", this, term) : new AlgebraExpPoly("+", term, this);
    }

    private AlgebraExp addTermDec(AlgebraExp term) {
        term = term.evalArithmetic();
        String c1 = null;
        String c2 = null;
        if (this.isVarTerm() && term.isVarTerm() && this.isSameType(term)) {
            double c;
            c1 = this.getCoefficient();
            c2 = term.getCoefficient();
            try {
                c = Double.parseDouble(c1) + Double.parseDouble(c2);
            }
            catch (Exception e) {
                trace.out("eqfp", "AlgebraExpTerm: " + this + ".addTerm(" + term + ")");
                return null;
            }
            if ((int)c == 0) {
                return new AlgebraExpTerm("0");
            }
            String v = this.getVarName();
            return new AlgebraExpTerm(((int)c == 1 ? "" : ((int)c == -1 ? "-" : "" + c)) + v);
        }
        if (term.isTerm() && !this.isVarTerm() && !term.isVarTerm()) {
            double c;
            c1 = this.toString();
            c2 = term.toString();
            try {
                c = Double.parseDouble(c1) + Double.parseDouble(c2);
            }
            catch (Exception e) {
                trace.out("eqfp", "AlgebraExpTerm: " + this + ".addTerm(" + term + ")");
                return null;
            }
            return new AlgebraExpTerm("" + c);
        }
        return this.comesBefore(term) ? new AlgebraExpPoly("+", this, term) : new AlgebraExpPoly("+", term, this);
    }

    @Override
    public AlgebraExp multTerm(AlgebraExp term) {
        term = term.evalArithmetic();
        if (this.toString().equals("0")) {
            return this;
        }
        if (term.toString().equals("0")) {
            return term;
        }
        AlgebraExp multTerm = null;
        if (this.isParenQuanity()) {
            return this.evalArithmetic().multTerm(term);
        }
        if (term.isFraction()) {
            multTerm = term.multTerm(this);
        } else if (term.isPolynomial()) {
            multTerm = this.isConstTerm() ? new AlgebraExpPoly(term.getOp(), this.multTerm(term.getFirstTerm()), this.multTerm(term.getSecondTerm())) : new AlgebraExpPoly("*", this, term);
        } else {
            String c1 = this.isVarTerm() ? this.getCoefficient() : this.toString();
            String c2 = term.isVarTerm() ? term.getCoefficient() : term.toString();
            String c = null;
            String v = this.getVarName() + term.getVarName();
            if (!this.getVarName().equals("") && this.getVarName().equals(term.getVarName())) {
                return null;
            }
            try {
                c = this.isDecimal() || term.isDecimal() ? "" + Double.parseDouble(c1) * Double.parseDouble(c2) : "" + Integer.parseInt(c1) * Integer.parseInt(c2);
                if (!v.equals("") && c.equals("1")) {
                    c = "";
                } else if (!v.equals("") && c.equals("-1")) {
                    c = "-";
                }
                multTerm = new AlgebraExpTerm(c + v);
            }
            catch (NumberFormatException e) {
                trace.out(this + ".AlgebraExpTerm.multTerm(" + term + ")");
                trace.out("c1 = " + c1 + ", c2 = " + c2);
                e.printStackTrace();
            }
        }
        try {
            if (multTerm != null && multTerm.toString().toUpperCase().indexOf("XX") != -1) {
                multTerm = null;
            }
        }
        catch (NullPointerException e) {
            trace.out("missalgebra", this + ".AlgebraExpTerm.multTerm(" + term + ")");
            trace.out("missalgebra", " ==> " + multTerm);
            e.printStackTrace();
        }
        return multTerm;
    }

    @Override
    public AlgebraExp divTerm(AlgebraExp term) {
        term = term.evalArithmetic();
        if (this.isDecimal() || term.isDecimal()) {
            return this.divTermDec(term);
        }
        if (term.isZero()) {
            return null;
        }
        if (term.isFraction()) {
            if (!term.getNumerator().isZero()) {
                return this.multTerm(new AlgebraExpPoly("/", term.getDenominator(), term.getNumerator()));
            }
            return null;
        }
        if (term.isMultiplication()) {
            AlgebraExp term1 = this.divTerm(term.getFirstTerm());
            return term1 != null ? term1.divTerm(term.getSecondTerm()) : null;
        }
        if (term.isAddition()) {
            return new AlgebraExpPoly("/", this, term);
        }
        if (term.isTerm()) {
            String dividend = this.isVarTerm() ? this.getCoefficient() : this.toString();
            String divisor = term.isVarTerm() ? term.getCoefficient() : term.toString();
            String quatient = "";
            try {
                quatient = MathLib.div((String)dividend, (String)divisor);
            }
            catch (Exception e) {
                trace.out("missalgebra", e.toString());
                trace.out("missalgebra", "AlgebraExp.divTerm(" + term + ")");
            }
            if (!this.isSameType(term)) {
                if (!this.getVarName().equals("")) {
                    if (quatient.indexOf(47) < 0) {
                        if (quatient.equals("1")) {
                            quatient = "";
                        }
                        quatient = quatient + this.getVarName();
                    } else {
                        String[] split = quatient.split("/");
                        if (split[0].equals("1")) {
                            split[0] = "";
                        } else if (split[0].equals("-1")) {
                            split[0] = "-";
                        }
                        quatient = split[0] + this.getVarName() + "/" + split[1];
                    }
                } else {
                    quatient = quatient.indexOf(47) < 0 ? quatient + "/" + term.getVarName() : quatient + term.getVarName();
                }
            }
            AlgebraExp algebraExp = null;
            try {
                algebraExp = AlgebraExp.parseExp(quatient);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return algebraExp;
        }
        return null;
    }

    private AlgebraExp divTermDec(AlgebraExp term) {
        if ((term = term.evalArithmetic()).isZero()) {
            return null;
        }
        if (this.isSimpleTerm() && term.isSimpleTerm()) {
            String var = "";
            double top = this.isVarTerm() ? Double.parseDouble(this.getCoefficient()) : Double.parseDouble(this.toString());
            double bottom = term.isVarTerm() ? Double.parseDouble(term.getCoefficient()) : Double.parseDouble(term.toString());
            double result = top / bottom;
            var = this.isVarTerm() && term.isVarTerm() ? (this.isSameType(term) ? MathLib.div((String)this.getVarName(), (String)term.getVarName()) : this.getVarName() + "/" + term.getVarName()) : (this.isVarTerm() ? this.getVarName() : term.getVarName());
            try {
                if (Math.abs(Math.floor(result) - result) < 1.0E-5) {
                    return AlgebraExp.parseExp(String.valueOf((int)result).concat(var.toString()));
                }
                return AlgebraExp.parseExp(String.valueOf(result).concat(var.toString()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.evalArithmetic().divTerm(term);
    }

    @Override
    public String parseTree() {
        return "|" + this.getExp() + "|";
    }

    public String toString() {
        return this.getExp();
    }
}

