/*
 * Decompiled with CFR 0.152.
 */
package jess;

import jess.Activation;
import jess.Fact;
import jess.JessException;
import jess.Token;

public class ActivationData {
    private final String ruleName;
    private boolean inactive;
    private int salience;
    private TokenData tokenData = null;

    public ActivationData(Activation act) throws JessException {
        this.ruleName = act.getRule().getName();
        this.inactive = act.isInactive();
        this.salience = act.getSalience();
        if (act.getToken() != null) {
            this.tokenData = new TokenData(act.getToken());
        }
    }

    public boolean match(Activation act) {
        if (!this.ruleName.equals(act.getRule().getName())) {
            return false;
        }
        return this.tokenData.match(act.getToken());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[ActivationData: ").append(this.ruleName);
        if (this.inactive) {
            sb.append(" (inactive)");
        }
        sb.append(" ").append(this.tokenData.toString());
        sb.append(" salience=").append(this.salience);
        sb.append("]");
        return sb.toString();
    }

    public class TokenData {
        private int size = 0;
        private Fact topFact = null;
        private TokenData parent = null;
        private int sortcode;

        public TokenData(Token token) {
            Object copy;
            this.size = token.size();
            this.sortcode = token.m_sortcode;
            if (token.topFact() != null && (copy = token.topFact().clone()) instanceof Fact) {
                this.topFact = (Fact)copy;
            }
            if (token.getParent() != null) {
                this.parent = new TokenData(token.getParent());
            }
        }

        public boolean match(Token token) {
            if (this.size != token.size()) {
                return false;
            }
            if (this.sortcode != token.m_sortcode) {
                return false;
            }
            if (!this.topFact.equals((Object)token.topFact())) {
                return false;
            }
            if (this.parent == null) {
                return token.getParent() == null;
            }
            return this.parent.match(token.getParent());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("size=").append(this.size);
            sb.append(" sortcode=").append(this.sortcode);
            this.showFact(sb);
            return sb.toString();
        }

        private StringBuffer showFact(StringBuffer sb) {
            if (this.parent != null) {
                this.parent.showFact(sb);
            }
            if (this.topFact == null) {
                sb.append(" (null fact)");
            } else {
                sb.append(" f-").append(this.topFact.getFactId());
                sb.append(" ").append(this.topFact.toString());
            }
            return sb.append(";");
        }
    }
}

