/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.applet.Applet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import jess.JessException;
import jess.Rete;
import jess.StaticMemberImporter;

public class ClassSource
implements Serializable {
    private transient Object m_appObject;
    private transient ClassLoader m_classLoader;
    private Hashtable m_classImports = new Hashtable();
    private ArrayList m_packageImports = new ArrayList();
    private transient HashMap m_loadedClasses = new HashMap();
    private transient Rete m_engine;

    ClassSource(Object appObject, Rete engine) throws JessException {
        this.m_appObject = appObject;
        this.m_engine = engine;
        this.importPackage("java.lang.");
    }

    public Applet getApplet() {
        if (this.m_appObject instanceof Applet) {
            return (Applet)this.m_appObject;
        }
        return null;
    }

    public Class getAppObjectClass() {
        if (this.m_appObject != null) {
            return this.m_appObject.getClass();
        }
        return Rete.class;
    }

    public void setApplet(Applet applet) {
        this.m_appObject = applet;
    }

    public void setAppObject(Object appObject) {
        this.m_appObject = appObject;
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_classLoader = loader;
    }

    private Class classForName(String name) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.m_loadedClasses.get(name);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader appLoader = this.getAppObjectClass().getClassLoader();
        if (appLoader != null) {
            try {
                clazz = Class.forName(name, true, appLoader);
                this.m_loadedClasses.put(name, clazz);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.m_classLoader != null) {
            try {
                clazz = Class.forName(name, true, this.m_classLoader);
                this.m_loadedClasses.put(name, clazz);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (contextLoader != null) {
                try {
                    clazz = Class.forName(name, true, contextLoader);
                    this.m_loadedClasses.put(name, clazz);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        clazz = Class.forName(name);
        this.m_loadedClasses.put(name, clazz);
        return clazz;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class clazz = (Class)this.m_loadedClasses.get(className);
        if (clazz != null) {
            return clazz;
        }
        if (className.indexOf(".") == -1) {
            String s = (String)this.m_classImports.get(className);
            if (s != null) {
                className = s;
            } else {
                Iterator e = this.m_packageImports.iterator();
                while (e.hasNext()) {
                    s = e.next() + className;
                    try {
                        Class c = this.classForName(s);
                        this.m_classImports.put(className, s);
                        return c;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
        }
        return this.classForName(className);
    }

    public URL getResource(String name) {
        URL u;
        if (this.m_appObject != null ? (u = this.m_appObject.getClass().getResource(name)) != null : this.m_classLoader != null && (u = this.m_classLoader.getResource(name)) != null) {
            return u;
        }
        try {
            URL u2;
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (contextLoader != null && (u2 = contextLoader.getResource(name)) != null) {
                return u2;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Rete.class.getResource(name);
    }

    public void importPackage(String pack) {
        this.m_packageImports.add(pack);
    }

    public void importClass(String clazz) throws JessException {
        this.m_classImports.put(clazz.substring(clazz.lastIndexOf(".") + 1, clazz.length()), clazz);
        try {
            Class aClass = this.findClass(clazz);
            StaticMemberImporter importer = new StaticMemberImporter(aClass);
            importer.addAllStaticFields(this.m_engine);
            importer.addAllStaticMethods(this.m_engine);
        }
        catch (ClassNotFoundException e) {
            throw new JessException("import", "Class not found", (Throwable)e);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.m_loadedClasses = new HashMap();
    }

    public void clear() {
        this.m_packageImports.clear();
        this.m_classImports.clear();
        this.m_loadedClasses.clear();
        this.importPackage("java.lang.");
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public static String classNameOnly(String name) {
        if (name.indexOf(46) > -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    void setEngine(Rete engine) {
        this.m_engine = engine;
    }
}

