/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditLabelNameDialog;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.Hints;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.event.HelpEvent;
import pact.CommWidgets.event.StudentActionEvent;

public class JCommButton
extends JCommWidget
implements ActionListener {
    private static final String TEXT = "Text";
    private static final String ICON = "Icon";
    protected JButton button;
    protected JPanel container;
    protected boolean changeColor;
    protected Font startFont;
    protected boolean locked;
    protected String imageName;

    public JCommButton() {
        this.setLayout(new GridLayout(1, 1));
        this.button = new JButton();
        this.button.addActionListener(this);
        this.add(this.button);
        this.backgroundNormalColor = this.button.getBackground();
        this.actionName = "ButtonPressed";
        this.locked = false;
        this.changeColor = true;
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.originalBorder = this.button.getBorder();
        this.setText("Comm Button");
    }

    @Override
    public MessageObject getDescriptionMessage() {
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommButton");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        mo.setProperty(TEXT, this.getText());
        mo.setProperty(ICON, this.getImageName());
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate button (slot name))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (button (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.button != null) {
            this.button.addMouseListener(l);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        if (this.button != null) {
            this.button.addMouseMotionListener(l);
        }
    }

    @Override
    public MouseListener[] getMouseListeners() {
        if (this.button != null) {
            return this.button.getMouseListeners();
        }
        return null;
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        if (this.button != null) {
            return this.button.getMouseMotionListeners();
        }
        return null;
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        if (this.button != null) {
            this.button.removeMouseMotionListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.button != null) {
            this.button.removeMouseListener(l);
        }
    }

    @Override
    public void doInterfaceDescription(MessageObject messageObject) {
        super.doInterfaceDescription(messageObject);
        Object prop = messageObject.getProperty(TEXT);
        if (prop != null) {
            this.setText(prop.toString());
        }
        if ((prop = messageObject.getProperty(ICON)) != null) {
            this.setImageName(prop.toString());
        }
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateIcon")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Load icon: " + input);
            }
            this.setImageName(input);
        }
        if (action.equalsIgnoreCase("UpdateText")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "UpdateText: " + input);
            }
            this.setText(input);
        }
        if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        } else if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        if (this.changeColor) {
            this.button.setForeground(this.LISPCheckColor);
        }
        if (this.getController() != null && this.getController().getUniversalToolProxy().lockWidget() && !this.commName.equalsIgnoreCase("Hint") && !this.commName.equalsIgnoreCase("Help") && !this.commName.equalsIgnoreCase("Done")) {
            this.setFocusable(false);
            this.locked = true;
        }
    }

    public void setChangeButtonColor(boolean changeFlag) {
        this.changeColor = changeFlag;
    }

    public boolean getChangeButtonColor() {
        return this.changeColor;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            if (this.changeColor) {
                this.button.setForeground(this.correctColor);
                if (this.correctFont != null) {
                    this.button.setFont(this.correctFont);
                }
            }
            if (this.getController() != null && this.getController().getUniversalToolProxy().lockWidget() && !this.commName.equalsIgnoreCase("Hint") && !this.commName.equalsIgnoreCase("Help") && !this.commName.equalsIgnoreCase("Done")) {
                this.setFocusable(false);
                this.locked = true;
            }
            this.fireStudentAction(new StudentActionEvent(this));
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        if (this.changeColor) {
            this.button.setForeground(this.incorrectColor);
            if (this.incorrectFont != null) {
                this.button.setFont(this.incorrectFont);
            }
        }
        if (this.locked) {
            this.locked = false;
        }
        this.setFocusable(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        trace.out("sp", "action performed");
        this.removeHighlight(this.commName);
        if (this.locked) {
            return;
        }
        this.dirty = true;
        this.sendValue();
        if (this.commName.equalsIgnoreCase("hint") || this.commName.equalsIgnoreCase("help")) {
            this.fireHelpEvent(new HelpEvent(this));
        }
    }

    @Override
    public boolean isChangedFromResetState() {
        if (this.getImageName() != null) {
            return true;
        }
        return this.getText() != null && this.getText().length() > 0;
    }

    @Override
    public Object getValue() {
        String tempValue = this.getText();
        if (this.getActionName().equalsIgnoreCase("UpdateIcon") && this.getImageName() != null) {
            return this.imageName;
        }
        if (this.getActionName().equalsIgnoreCase("UpdateText") && this.getText() != null && this.getText().length() > 0) {
            return this.getText();
        }
        if (this.getActionName().equalsIgnoreCase("UpdateInVisible")) {
            return this.isInvisible();
        }
        if (this.commName.equalsIgnoreCase("Hint") || this.commName.equalsIgnoreCase("Help") || this.commName.equalsIgnoreCase("Done")) {
            return "-1";
        }
        return tempValue;
    }

    @Override
    public void reset(TutorController controller) {
        if (controller != null) {
            this.initialize(controller);
        }
        if (this.changeColor) {
            this.button.setForeground(this.startColor);
            if (this.startFont != null) {
                this.button.setFont(this.startFont);
            }
        }
        this.locked = false;
        this.setFocusable(true);
    }

    @Override
    public boolean getLock(String selection) {
        return this.locked;
    }

    public Vector getCurrentState() {
        Vector<MessageObject> v = new Vector<MessageObject>();
        if (this.getText() != null && this.getText().length() > 0) {
            this.setActionName("UpdateText");
            v.addElement(this.getCurrentStateMessage());
        }
        if (this.imageName != null) {
            this.setActionName("UpdateIcon");
            v.addElement(this.getCurrentStateMessage());
        }
        if (this.isInvisible()) {
            this.setActionName("UpdateInVisible");
            v.addElement(this.getCurrentStateMessage());
        }
        this.setActionName("ButtonPressed");
        return v;
    }

    public void setText(String text) {
        this.button.setText(text);
        if (Hints.isHintLabel(text)) {
            this.setHintBtn(true);
        }
    }

    public String getText() {
        return this.button.getText();
    }

    @Override
    public void setToolTipText(String text) {
        this.button.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.button.getToolTipText();
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.button.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.button.setBorder(this.originalBorder);
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
        if (imageName == null || imageName.length() < 1) {
            if (this.button != null) {
                this.button.setIcon(null);
            }
            return;
        }
        Image image = null;
        if (new File(imageName).canRead()) {
            image = Toolkit.getDefaultToolkit().getImage(imageName);
        } else {
            URL imageURL = Utils.getURL(imageName, this);
            if (imageURL != null) {
                image = Toolkit.getDefaultToolkit().getImage(imageURL);
            } else {
                trace.err("Error: cannot find icon " + imageName);
                return;
            }
        }
        ImageIcon icon = new ImageIcon(image, imageName);
        if (this.button != null) {
            this.button.setIcon(icon);
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void setFocus(String subWidgetName) {
        this.button.requestFocus();
    }

    @Override
    public void setBackground(Color c) {
        if (this.button != null) {
            this.button.setBackground(c);
        }
    }

    public void setIcon(Icon icon) {
        if (this.button != null) {
            this.button.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this.button != null) {
            return this.button.getIcon();
        }
        return null;
    }

    @Override
    public void moveFocus() {
        this.button.transferFocus();
    }

    @Override
    public void setFont(Font f) {
        this.startFont = f != null ? f : super.getFont();
        super.setFont(this.startFont);
        if (this.button != null) {
            this.button.setFont(this.startFont);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.button != null) {
            this.button.setEnabled(enabled);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (this.button != null) {
            this.button.addFocusListener(l);
        }
    }

    public void doClick() {
        this.button.doClick();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.locked) {
            return;
        }
        if (e.isControlDown() && this.getController() != null && this.getController().isDefiningStartState()) {
            boolean sendVisible;
            JFrame frame = new JFrame("Modify Label Text");
            String currentDir = System.getProperty("user.dir");
            String title = "Please set the Label for widget " + this.commName + " : ";
            EditLabelNameDialog t = new EditLabelNameDialog(frame, title, this.getText(), this.getImageName(), currentDir, this.isInvisible(), true);
            boolean sendLabel = !t.getNewLabel().equals(this.getText());
            boolean sendIcon = t.getIcon() != null;
            boolean bl = sendVisible = this.isInvisible() != t.isInvisible();
            if (sendLabel || sendIcon || sendVisible) {
                this.getUniversalToolProxy().sendMessage(this.getDescriptionMessage());
            }
            if (sendLabel) {
                this.setText(t.getNewLabel());
                this.dirty = true;
                this.setActionName("UpdateText");
                this.sendValue();
            }
            if (sendIcon) {
                this.setIcon(t.getIcon());
                this.setImageName(t.getIcon().toString());
                this.dirty = true;
                this.setActionName("UpdateIcon");
                this.sendValue();
            }
            if (sendVisible) {
                this.setInvisible(t.isInvisible());
                this.dirty = true;
                this.setActionName("UpdateInVisible");
                this.sendValue();
            }
            this.setActionName("ButtonPressed");
        }
    }

    @Override
    public void setCommName(String commName, TutorController controller) {
        super.setCommName(commName, controller);
        if (Hints.isHintLabel(commName)) {
            this.setHintBtn(true);
        }
    }

    @Override
    public void setHintBtn(boolean isHintBtn) {
        super.setHintBtn(isHintBtn);
    }
}

