/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.env;

import edu.cmu.hcii.ctat.CTATBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CTATEnvironment
extends CTATBase {
    public static boolean isLocalWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isLocalAndroid() {
        String os = System.getProperty("java.vendor").toLowerCase();
        return os.indexOf("android") >= 0;
    }

    public static boolean isLocalMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isLocalUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static boolean isLocalSolaris() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("sunos") >= 0;
    }

    public static boolean isValidName(String text) {
        Pattern pattern = Pattern.compile("# Match a valid Windows filename (unspecified file system).          \n^                                # Anchor to start of string.        \n(?!                              # Assert filename is not: CON, PRN, \n  (?:                            # AUX, NUL, COM1, COM2, COM3, COM4, \n    CON|PRN|AUX|NUL|             # COM5, COM6, COM7, COM8, COM9,     \n    COM[1-9]|LPT[1-9]            # LPT1, LPT2, LPT3, LPT4, LPT5,     \n  )                              # LPT6, LPT7, LPT8, and LPT9...     \n  (?:\\.[^.]*)?                  # followed by optional extension    \n  $                              # and end of string                 \n)                                # End negative lookahead assertion. \n[^<>:\"/\\\\|?*\\x00-\\x1F]*     # Zero or more valid filename chars.\n[^<>:\"/\\\\|?*\\x00-\\x1F\\ .]  # Last char is not a space or dot.  \n$                                # Anchor to end of string.            ", 70);
        Matcher matcher = pattern.matcher(text);
        boolean isMatch = matcher.matches();
        return isMatch;
    }
}

