/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.monitor.CTATClientEntry;
import edu.cmu.hcii.ctat.monitor.CTATMachineProperty;
import edu.cmu.hcii.ctat.monitor.CTATTutorMonitorServerThread;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CTATMachineEntry
extends CTATClientEntry {
    private ArrayList<CTATMachineProperty> properties = null;
    private Boolean autoPS = false;
    private Boolean proxy = false;

    public CTATMachineEntry() {
        this.setClassName("CTATMachineEntry");
        this.debug("CTATMachineEntry ()");
        this.setClientType("machine");
        this.setPort(8080);
        this.setAccess("STREAM");
        this.setMachineGuid(this.getGuid());
        this.properties = new ArrayList();
    }

    public Boolean getProxy() {
        return this.proxy;
    }

    public void setProxy(Boolean proxy) {
        this.proxy = proxy;
    }

    @Override
    public void startLogging() {
        this.debug("startLogging ()");
        if (this.getShouldLog().booleanValue()) {
            this.logger.setFileID("MS-" + this.getGuid() + "-" + this.getHostname());
        } else {
            this.debug("Logging is disabled for this entry");
        }
    }

    @Override
    public void setStatus(String status) {
        super.setStatus(status);
        if (this.getShouldLog().booleanValue()) {
            StringBuffer formatter = new StringBuffer();
            Date stamp = new Date();
            formatter.append(String.format("d", stamp.getTime()));
            formatter.append("\t");
            formatter.append(status);
            if (this.logger != null) {
                this.logger.addLine(formatter.toString());
            }
        }
    }

    public void debugProperties() {
        this.debug("debugProperties ()");
        for (int i = 0; i < this.properties.size(); ++i) {
            CTATMachineProperty prop = this.properties.get(i);
            this.debug("Key: " + prop.getKey());
        }
    }

    public String getProperty(String key) {
        for (int i = 0; i < this.properties.size(); ++i) {
            CTATMachineProperty prop = this.properties.get(i);
            if (!prop.getKey().equals(key)) continue;
            return prop.getValue();
        }
        return "null";
    }

    public CTATMachineProperty findProperty(String key) {
        for (int i = 0; i < this.properties.size(); ++i) {
            CTATMachineProperty prop = this.properties.get(i);
            if (!prop.getKey().equals(key)) continue;
            return prop;
        }
        return null;
    }

    public void addProperty(String key, String value) {
        this.setProperty(key, value);
    }

    public CTATMachineProperty setProperty(String key, String value) {
        CTATMachineProperty newProperty = this.findProperty(key);
        if (newProperty == null) {
            newProperty = new CTATMachineProperty();
            newProperty.setKey(key);
            this.properties.add(newProperty);
        }
        newProperty.setValue(value);
        return newProperty;
    }

    public ArrayList<CTATMachineProperty> getProperties() {
        return this.properties;
    }

    public boolean isWindows() {
        String os = this.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public boolean isMac() {
        String os = this.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public boolean isUnix() {
        String os = this.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public boolean isSolaris() {
        String os = this.getProperty("os.name").toLowerCase();
        return os.indexOf("sunos") >= 0;
    }

    public String getLastTop() {
        return this.getProperty("ps");
    }

    public void setLastTop(String alastTop) {
        this.setProperty("ps", alastTop);
    }

    public Boolean getAutoPS() {
        return this.autoPS;
    }

    public void setAutoPS(Boolean autoPS) {
        this.autoPS = autoPS;
        CTATTutorMonitorServerThread aThread = this.getaThread();
        if (aThread != null) {
            if (this.autoPS.booleanValue()) {
                aThread.send("<?xml version=\"1.0\" encoding=\"utf-8\"?><request command=\"autops\" value=\"true\" />");
            } else {
                aThread.send("<?xml version=\"1.0\" encoding=\"utf-8\"?><request command=\"autops\" value=\"false\" />");
            }
        }
    }

    @Override
    public Boolean fromXML(Element root) {
        if (root.getNodeName().equals("machine")) {
            NodeList children;
            this.properties = new ArrayList();
            this.parseHostConfig(root);
            if (root.getAttribute("proxy").toLowerCase().equals("true") || root.getAttribute("proxy").toLowerCase().equals("yes")) {
                this.debug("This machine is configured as a proxy!");
                this.proxy = true;
            }
            if ((children = root.getChildNodes()) == null) {
                this.debug("Internal error: children list is null");
                return false;
            }
            if (children.getLength() > 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    CTATMachineProperty prop = new CTATMachineProperty();
                    prop.fromXML((Element)node);
                    this.setProperty(prop.getKey(), prop.getValue());
                }
            }
        } else {
            this.debug("Properties tag not found in node, instead got: " + root.getNodeName());
            return false;
        }
        return true;
    }

    @Override
    public String toXML() {
        this.debug("toXML ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toXMLOpen("proxy", this.proxy.toString()));
        for (int i = 0; i < this.properties.size(); ++i) {
            CTATMachineProperty prop = this.properties.get(i);
            buffer.append(prop.toXML());
        }
        buffer.append(this.toXMLClose());
        return buffer.toString();
    }

    @Override
    public String toXMLUpdated() {
        this.debug("toXMLUpdated ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toXMLOpen("proxy", this.proxy.toString()));
        if (this.autoPS.booleanValue()) {
            CTATMachineProperty psProp = this.findProperty("ps");
            if (psProp != null) {
                buffer.append(psProp.toXML());
            } else {
                this.debug("Internal error: no PS found");
            }
        }
        buffer.append(this.toXMLClose());
        return buffer.toString();
    }
}

