/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDB;
import edu.cmu.hcii.ctat.monitor.CTATClientEntry;
import edu.cmu.hcii.ctat.monitor.CTATMachineEntry;
import edu.cmu.hcii.ctat.monitor.CTATTSEntry;
import edu.cmu.hcii.ctat.monitor.CTATTutorMonitorServerThread;
import edu.cmu.hcii.ctat.monitor.CTATWSEntry;
import edu.cmu.hcii.ctat.monitor.CTATXMLBase;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CTATServiceRegistry
extends CTATXMLBase {
    private ArrayList<CTATClientEntry> entries = null;
    private ArrayList<CTATClientEntry> foundEntries = null;
    private Boolean shouldLog = true;
    private CTATBerkeleyDB dbService = null;

    public CTATServiceRegistry() {
        this.setClassName("CTATServiceRegistry");
        this.debug("CTATServiceRegistry ()");
        this.entries = new ArrayList();
    }

    public CTATBerkeleyDB getDbService() {
        return this.dbService;
    }

    public void setDbService(CTATBerkeleyDB dbService) {
        this.dbService = dbService;
    }

    public Boolean getShouldLog() {
        return this.shouldLog;
    }

    public void setShouldLog(Boolean shouldLog) {
        this.shouldLog = shouldLog;
    }

    public ArrayList<CTATClientEntry> getEntries() {
        return this.entries;
    }

    public void resetUpdates() {
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry test = this.entries.get(i);
            test.setUpdated(false);
        }
    }

    public CTATTSEntry addTS() {
        this.debug("addTS ()");
        CTATTSEntry newEntry = new CTATTSEntry();
        newEntry.setDbDriver(this.dbService);
        newEntry.setShouldLog(this.getShouldLog());
        this.entries.add(newEntry);
        return newEntry;
    }

    public CTATMachineEntry addMS() {
        this.debug("addMS ()");
        CTATMachineEntry newEntry = new CTATMachineEntry();
        newEntry.setDbDriver(this.dbService);
        newEntry.setShouldLog(this.getShouldLog());
        this.entries.add(newEntry);
        return newEntry;
    }

    public CTATWSEntry addWS() {
        this.debug("addWS ()");
        CTATWSEntry newEntry = new CTATWSEntry();
        newEntry.setDbDriver(this.dbService);
        newEntry.setShouldLog(this.getShouldLog());
        this.entries.add(newEntry);
        return newEntry;
    }

    public CTATTSEntry findTS(int ID) {
        return (CTATTSEntry)this.getEntry(ID);
    }

    public CTATWSEntry findWS(int ID) {
        return (CTATWSEntry)this.getEntry(ID);
    }

    public CTATMachineEntry findMachine(int ID) {
        return (CTATMachineEntry)this.getEntry(ID);
    }

    public CTATClientEntry addEntry(String type) {
        this.debug("addEntry (" + type + ")");
        CTATClientEntry newEntry = null;
        if (type.equals("WebService")) {
            newEntry = new CTATWSEntry();
            newEntry.setShouldLog(this.getShouldLog());
        }
        if (type.equals("TutoringService")) {
            newEntry = new CTATTSEntry();
            newEntry.setShouldLog(this.getShouldLog());
        }
        newEntry.setDbDriver(this.dbService);
        this.entries.add(newEntry);
        return newEntry;
    }

    public CTATClientEntry getEntry(int ID) {
        this.debug("getEntry ()");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry test = this.entries.get(i);
            if (test.getID() != ID) continue;
            return test;
        }
        return null;
    }

    public CTATClientEntry getEntry(String uuid) {
        this.debug("getEntry ()");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry test = this.entries.get(i);
            if (!test.getGuid().equals(uuid)) continue;
            return test;
        }
        return null;
    }

    public Boolean removeEntry(String uuid) {
        this.debug("removeEntry (" + uuid + ")");
        CTATClientEntry test = this.getEntry(uuid);
        if (test == null) {
            this.debug("Unable to find entry: " + uuid);
            return false;
        }
        this.entries.remove(test);
        if (test.getClientType().equals("machine")) {
            Boolean found = true;
            int entriesFound = 0;
            while (found.booleanValue()) {
                this.debug("while: " + found);
                if (this.entries.size() == 0) {
                    found = false;
                }
                for (int i = 0; i < this.entries.size() && found.booleanValue(); ++i) {
                    this.debug("for: " + found);
                    found = false;
                    CTATClientEntry target = this.entries.get(i);
                    if (!target.getMachineGuid().equals(test.getGuid())) continue;
                    found = this.removeEntry(target.getGuid());
                    ++entriesFound;
                }
            }
            this.debug("Removed " + entriesFound + " service entries");
        }
        return true;
    }

    public Boolean removeEntries(int ID) {
        this.debug("removeEntries (" + ID + ")");
        Boolean found = true;
        int entriesFound = 0;
        if (this.entries.size() == 0) {
            this.debug("No entries in database");
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            this.debug("for: " + found);
            this.debug("i = " + i);
            CTATClientEntry test = this.entries.get(i);
            if (test.getID() != ID) continue;
            this.debug(test.getClientType());
            found = this.removeEntry(test.getGuid());
            ++entriesFound;
            --i;
        }
        this.debug("Removed " + entriesFound + " service entries");
        return true;
    }

    public CTATClientEntry getMachine(String ID) {
        this.debug("getMachine (" + ID + ")");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry entry = this.entries.get(i);
            if (!entry.getGuid().equals(ID)) continue;
            return entry;
        }
        return null;
    }

    public CTATMachineEntry getFirstMachineEntry() {
        this.debug("getFirstMachineEntry ()");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry entry = this.entries.get(i);
            if (!entry.getClientType().equals("machine")) continue;
            return (CTATMachineEntry)entry;
        }
        return null;
    }

    public CTATClientEntry getMachineEntry(int ID) {
        this.debug("getMachineEntry (" + ID + ")");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry entry = this.entries.get(i);
            if (entry.getID() != ID || !entry.getClientType().equals("machine")) continue;
            return entry;
        }
        return null;
    }

    public ArrayList<CTATClientEntry> getMachineServices(String aMachine) {
        this.debug("getMachineServices (String)");
        this.foundEntries = new ArrayList();
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry entry = this.entries.get(i);
            if (!entry.getMachineGuid().equals(aMachine)) continue;
            this.foundEntries.add(entry);
        }
        return this.foundEntries;
    }

    public ArrayList<CTATClientEntry> getMachineServices(CTATClientEntry aMachine) {
        this.debug("getMachineServices (CTATClientEntry)");
        this.foundEntries = new ArrayList();
        if (!aMachine.getClientType().equals("machine")) {
            this.debug("The client entry does not represent a machine");
            return this.foundEntries;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry entry = this.entries.get(i);
            if (!entry.getMachineGuid().equals(aMachine.getMachineGuid())) continue;
            this.foundEntries.add(entry);
        }
        return this.foundEntries;
    }

    public Boolean markMachineDown(int ID) {
        CTATClientEntry test = this.getMachineEntry(ID);
        if (test != null) {
            this.debug("Marking machine as down ...");
            test.setStatus("DOWN");
            return true;
        }
        return false;
    }

    public void markServicesDown(int ID) {
        this.debug("markServicesDown (" + ID + ")");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry entry = this.entries.get(i);
            if (entry.getID() != ID || entry.getClientType().equals("machine")) continue;
            entry.setStatus("DOWN");
        }
    }

    public Boolean fromXMLList(CTATTutorMonitorServerThread aThread, Element root) {
        this.debug("fromXMLList (" + root.getNodeName() + ")");
        int ID = -1;
        if (aThread != null) {
            ID = aThread.getID();
        }
        if (root.getNodeName().equals("services")) {
            NodeList children = root.getChildNodes();
            if (children == null) {
                this.debug("Internal error: children list is null");
                return false;
            }
            if (children.getLength() > 0) {
                ArrayList<CTATClientEntry> tempList = new ArrayList<CTATClientEntry>();
                String machineGUID = "undefined";
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    this.debug("Parsing: " + node.getNodeName());
                    if (node.getNodeName().equals("tutoringservice")) {
                        this.debug("Creating tutoringservice entry ...");
                        CTATTSEntry ts = new CTATTSEntry();
                        ts.setDbDriver(this.dbService);
                        ts.setShouldLog(this.getShouldLog());
                        ts.setID(ID);
                        ts.fromXML((Element)node);
                        ts.setUpdated(true);
                        CTATClientEntry fixedTSEntry = this.getEntry(ts.getGuid());
                        if (fixedTSEntry == null) {
                            ts.setDbDriver(this.dbService);
                            ts.startLogging();
                            ts.setaThread(aThread);
                            tempList.add(ts);
                            this.entries.add(ts);
                            ts.setStatus("START");
                        } else {
                            fixedTSEntry.fromXML((Element)node);
                            fixedTSEntry.setUpdated(true);
                        }
                    }
                    if (node.getNodeName().equals("webservice")) {
                        this.debug("Creating webservice entry ...");
                        CTATWSEntry ws = new CTATWSEntry();
                        ws.setDbDriver(this.dbService);
                        ws.setShouldLog(this.getShouldLog());
                        ws.setID(ID);
                        ws.fromXML((Element)node);
                        ws.setUpdated(true);
                        CTATClientEntry fixedWSEntry = this.getEntry(ws.getGuid());
                        if (fixedWSEntry == null) {
                            ws.setDbDriver(this.dbService);
                            ws.startLogging();
                            ws.setaThread(aThread);
                            tempList.add(ws);
                            this.entries.add(ws);
                            ws.setStatus("START");
                        } else {
                            fixedWSEntry.fromXML((Element)node);
                            fixedWSEntry.setUpdated(true);
                        }
                    }
                    if (!node.getNodeName().equals("machine")) continue;
                    this.debug("Creating machine entry ...");
                    CTATMachineEntry ms = new CTATMachineEntry();
                    ms.setDbDriver(this.dbService);
                    ms.setShouldLog(this.getShouldLog());
                    ms.setID(ID);
                    ms.fromXML((Element)node);
                    ms.setUpdated(true);
                    machineGUID = ms.getMachineGuid();
                    CTATClientEntry fixedMSEntry = this.getEntry(ms.getGuid());
                    if (fixedMSEntry == null) {
                        ms.setDbDriver(this.dbService);
                        ms.startLogging();
                        ms.setaThread(aThread);
                        this.entries.add(ms);
                        ms.setStatus("START");
                        continue;
                    }
                    fixedMSEntry.fromXML((Element)node);
                    fixedMSEntry.setUpdated(true);
                }
                if (!machineGUID.equals("undefined")) {
                    for (int j = 0; j < tempList.size(); ++j) {
                        CTATClientEntry tester = (CTATClientEntry)tempList.get(j);
                        if (tester.getClientType().equals("machine")) continue;
                        tester.setMachineGuid(machineGUID);
                    }
                }
            }
        } else {
            this.debug("Client type tag not found in node, instead got: " + root.getNodeName());
            return false;
        }
        return true;
    }

    @Override
    public String toXML() {
        this.debug("toXML ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<services update=\"all\">");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry entry = this.entries.get(i);
            buffer.append(entry.toXML());
        }
        buffer.append("</services>");
        return buffer.toString();
    }

    public String toXMLUpdated() {
        this.debug("toXMLUpdated ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<services update=\"changed\">");
        this.debug("Serializing : " + this.entries.size() + " entries");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATClientEntry entry = this.entries.get(i);
            buffer.append(entry.toXMLUpdated());
        }
        buffer.append("</services>");
        return buffer.toString();
    }
}

