/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATDeamon;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.monitor.CTATStreamedTableDiskLogger;
import edu.cmu.hcii.ctat.monitor.CTATTutorMonitorServerThread;
import edu.cmu.hcii.ctat.monitor.CTATXMLBase;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CTATSocketServerBase
extends CTATDeamon
implements Runnable {
    private ArrayList<CTATTutorMonitorServerThread> clients = new ArrayList(150);
    private ServerSocket server = null;
    private Thread thread = null;
    private int clientCount = 0;
    private int localPort = 8080;
    protected CTATStreamedTableDiskLogger logger = null;
    private Boolean logXML = false;

    public CTATSocketServerBase() {
        this.setClassName("CTATSocketServerBase");
        this.debug("CTATSocketServerBase ()");
        this.logger = new CTATStreamedTableDiskLogger();
        this.logger.setIncludeDate(false);
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public Boolean getLogXML() {
        return this.logXML;
    }

    public void setLogXML(Boolean logXML) {
        this.logXML = logXML;
        if (this.logXML.booleanValue()) {
            this.logger.setFileID("XML-Log");
        }
    }

    public Boolean runServer() {
        this.debug("runServer ()");
        this.setLocalPort(this.getLocalPort());
        try {
            this.debug("Binding to port " + this.getLocalPort() + ", please wait  ...");
            this.server = new ServerSocket(this.getLocalPort());
            this.start();
            this.debug("Server started: " + this.server.toString());
        }
        catch (IOException ioe) {
            this.debug("Can not bind to port " + this.getLocalPort() + ": " + ioe.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        this.debug("run ()");
        while (this.thread != null) {
            try {
                this.debug("Waiting for a client ...");
                this.addThread(this.server.accept());
            }
            catch (IOException ioe) {
                this.debug("Server accept error: " + ioe);
                this.stop();
            }
        }
        this.debug("Exiting server ...");
        this.shutdown();
    }

    protected void shutdown() {
        this.debug("shutdown ()");
    }

    public void start() {
        this.debug("start ()");
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        this.debug("stop ()");
        if (this.thread != null) {
            CTATTutorMonitorServerThread stopper = (CTATTutorMonitorServerThread)this.thread;
            stopper.stopThread();
            this.thread = null;
        }
    }

    public CTATTutorMonitorServerThread getClientThread(int ID) {
        this.debug("getClientThread ()");
        for (int i = 0; i < this.clientCount; ++i) {
            if (this.clients.get(i).getID() != ID) continue;
            return this.clients.get(i);
        }
        return null;
    }

    private int findClient(int ID) {
        this.debug("findClient ()");
        for (int i = 0; i < this.clientCount; ++i) {
            if (this.clients.get(i).getID() != ID) continue;
            return i;
        }
        return -1;
    }

    public void sendAllSockets(String message) {
        this.debug("sendAllSockets ()");
        this.logger.addLine("[OUT] <?xml version=\"1.0\" encoding=\"UTF-8\"?>" + message);
        for (int i = 0; i < this.clientCount; ++i) {
            this.clients.get(i).send("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + message);
        }
    }

    public void sendClient(int ID, String message) {
        this.debug("sendClient (" + ID + ")");
        if (this.findClient(ID) == -1) {
            this.debug("Error: unable to find socket thread with id: " + ID);
            return;
        }
        this.logger.addLine("[OUT] <?xml version=\"1.0\" encoding=\"UTF-8\"?>" + message);
        this.clients.get(this.findClient(ID)).send("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + message);
    }

    public void sendAllMonitors(String aMessage) {
    }

    public synchronized void handle(int ID, String input) {
        this.debug("handle () <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        if (input == null) {
            return;
        }
        this.debug(input);
        if (input.equals("")) {
            this.debug("Received empty string, removing client ...");
            this.remove(ID);
            return;
        }
        if (input.indexOf("<policy-file-request/>") != -1) {
            this.debug("Processing policy request ...");
            this.sendClient(ID, CTATLink.crossDomainPolicy);
            return;
        }
        this.debug("Moving data processing to higher level ...");
        this.logger.addLine("[IN] <?xml version=\"1.0\" encoding=\"UTF-8\"?>" + input);
        this.debug("Input Recieved: \"" + input + "\"");
        CTATXMLBase helper = new CTATXMLBase();
        Document document = helper.loadXMLFromString(input);
        if (document != null) {
            Element root = document.getDocumentElement();
            this.fromXML(ID, root);
        }
    }

    public Boolean fromXML(int ID, Element root) {
        this.debug("fromXML ()");
        return true;
    }

    public void shutdownService(int ID) {
        this.debug("shutdownService (" + ID + ")");
    }

    public synchronized void remove(int ID) {
        this.debug("remove (" + ID + ")");
        this.shutdownService(ID);
        int pos = this.findClient(ID);
        if (pos >= 0) {
            CTATTutorMonitorServerThread toTerminate = this.clients.get(pos);
            this.debug("Removing client thread " + ID + " at " + pos);
            if (pos < this.clientCount - 1) {
                for (int i = pos + 1; i < this.clientCount; ++i) {
                    this.clients.set(i - 1, this.clients.get(i));
                }
            }
            --this.clientCount;
            try {
                toTerminate.close();
            }
            catch (IOException ioe) {
                this.debug("Error closing thread: " + ioe);
            }
            toTerminate.stopThread();
        }
    }

    private void addThread(Socket socket) {
        this.debug("addThread ()");
        this.debug("Client accepted: " + socket);
        CTATTutorMonitorServerThread client = new CTATTutorMonitorServerThread(this, socket);
        this.clients.add(this.clientCount, client);
        this.debug(client.toString());
        try {
            this.clients.get(this.clientCount).open();
            this.clients.get(this.clientCount).start();
            ++this.clientCount;
        }
        catch (IOException ioe) {
            this.debug("Error opening thread: " + ioe);
        }
    }
}

