/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.pact.BehaviorRecorder.Controller.AuthorHTTPSession;
import edu.cmu.pact.BehaviorRecorder.Controller.AuthorLauncherServer;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.SocketProxy.HTTPToolProxy;
import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.TutoringService.HTTPSession;
import edu.cmu.pact.TutoringService.LauncherHandler;
import edu.cmu.pact.TutoringService.LauncherServer;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.HTTPMessageObject;
import edu.cmu.pact.ctat.MessageObject;
import pact.CommWidgets.StudentInterfaceConnectionStatus;

public class AuthorLauncherHandler
extends LauncherHandler
implements CTATHTTPHandlerInterface {
    public AuthorLauncherHandler(AuthorLauncherServer launcherServer) {
        super(launcherServer);
    }

    public AuthorLauncherHandler(LauncherServer launcherServer) {
        super(launcherServer);
    }

    @Override
    public synchronized boolean handle(CTATHTTPExchange exch, String requestBody) {
        if (trace.getDebugCode("http")) {
            trace.out("http", this.getClass().getSimpleName() + ".handle(" + exch + ") isWS " + exch.isWS() + ", wsThread " + exch.getWsThread());
        }
        this.debug("AuthorLauncherHandler.handle () requestBody " + requestBody);
        String requestMethod = exch.getRequestMethod();
        this.debug("Request method: " + requestMethod + ", Request URI: " + exch.getRequestURI());
        if (requestMethod.equalsIgnoreCase("options")) {
            return this.doOptions(exch);
        }
        if (!exch.isWS()) {
            throw new RuntimeException("CTATHTTPExchange passed to AuthorLauncherServer handler is not a web socket: " + exch);
        }
        if (trace.getDebugCode("ll")) {
            trace.out("ll", "We've got a websocket here, don't close, in fact let's do some really nasty low level input polling");
        }
        if (exch.startWS(this)) {
            return false;
        }
        String guid = exch.getHTTPToolProxy() == null ? null : exch.getHTTPToolProxy().getSessionId();
        try {
            if (requestBody == null) {
                requestBody = exch.getRequestBodyAsString();
            }
            if (guid == null) {
                guid = MessageObject.getPropertyFromXML(requestBody, "session_id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            guid = null;
        }
        if (trace.getDebugCode("tsltsp")) {
            trace.outNT("tsltsp", "guid " + guid + " " + requestBody);
        }
        if (trace.getDebugCode("ll")) {
            trace.out("ll", "guid " + guid + " " + requestBody);
        }
        TSLauncherServer.Session sess = this.launcherServer.getSession(guid);
        if (trace.getDebugCode("http")) {
            trace.out("http", "launcherServer.getSession(" + guid + ") returns " + trace.nh(sess) + ", " + sess);
        }
        if (sess instanceof AuthorHTTPSession) {
            if (!guid.equals(sess.getGuid())) {
                trace.err("CTATTab.connectHTTP() guid from message or exchange " + guid + " != session guid " + sess.getGuid());
            }
            AuthorHTTPSession hSess = (AuthorHTTPSession)sess;
            if (exch.getHTTPToolProxy() != hSess.getToolProxy()) {
                exch.setHTTPToolProxy(hSess.getToolProxy());
                hSess.getToolProxy().setHttpExchange(exch);
            }
            if (exch.isClosed() || "Q".equals(requestBody)) {
                CTATTabManager tabManager;
                Collaborators.abort(hSess, "A participant has left. Please close the tutor.");
                CTATTabManager cTATTabManager = tabManager = this.launcherServer instanceof AuthorLauncherServer ? ((AuthorLauncherServer)this.launcherServer).getTabManager() : null;
                if (tabManager != null) {
                    tabManager.disconnectHTTP(hSess);
                }
                hSess.close();
                return true;
            }
            if (this.handleLogRecord(requestBody, exch, hSess)) {
                return false;
            }
            hSess.postRequestToActionHandler(requestBody, exch);
            return false;
        }
        CTATTabManager tabManager = this.launcherServer instanceof AuthorLauncherServer ? ((AuthorLauncherServer)this.launcherServer).getTabManager() : null;
        CTATTab tab = null;
        AuthorHTTPSession hSess = new AuthorHTTPSession(this.launcherServer, guid, requestBody, exch);
        if (exch.isClosed() || "Q".equals(requestBody)) {
            Collaborators.abort(null, guid, "A participant has left. Please close the tutor.");
            if (tabManager != null) {
                tabManager.disconnectHTTP(hSess);
            }
            hSess.close();
            return true;
        }
        if (trace.getDebugCode("ll")) {
            trace.out("ll", "hSess " + hSess + ", tabManager " + tabManager + ", launcherServer " + this.launcherServer);
        }
        if (!(Utils.isRuntime() || tabManager != null && (tab = tabManager.connectHTTP(guid, hSess)) != null)) {
            trace.err("Error: no behavior graph waiting for connection to session \"" + guid + "\":\n  " + exch);
            AuthorLauncherHandler.sendResponse(exch, "Error: no behavior graph waiting for connection to session \"" + guid + "\"", 404);
            return true;
        }
        if (trace.getDebugCode("ls")) {
            trace.printStack("ls", "ALH.handle() possible restart");
        }
        if (Utils.isRuntime() && hSess.hasRemoteTracer()) {
            this.launcherServer.addSession(hSess);
            HTTPToolProxy htp = new HTTPToolProxy(exch, hSess.getMsgFormat(), null);
            htp.setOutputJSON(this.getOutputJSON());
            exch.setHTTPToolProxy(htp);
            htp.setSessionId(hSess.getGuid());
            hSess.setToolProxy(htp);
            try {
                Collaborators collabs = this.checkForCollaborators(hSess, requestBody);
                if (trace.getDebugCode("http")) {
                    trace.out("http", String.format("%s.handle() calls checkForCollaborators()\n  collabs: %s\n  exch: %s", this.getClass().getSimpleName(), collabs == null ? "null" : collabs.toString(), exch.toString(true)));
                }
            }
            catch (Exception e) {
                trace.err(String.format("Error in %s.handle() from checkForCollaborators(): %s; cause: %s\n  exch: %s", this.getClass().getSimpleName(), e.toString(), e.getCause(), exch.toString(true)));
                e.printStackTrace();
                AuthorLauncherHandler.sendResponse(exch, "Error from collaboration setup on session \"" + guid + "\": " + e, 404);
                return true;
            }
            return false;
        }
        BR_Controller controller = tab == null ? hSess.setupController(null) : tab.getController();
        controller.getLauncher().addNewSession(hSess);
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "ALH.handle() just called addNewSession for guid " + guid);
        }
        controller.setRemoteProxy(hSess);
        HTTPToolProxy htp = new HTTPToolProxy(exch, hSess.getMsgFormat(), hSess.getController());
        htp.setOutputJSON(this.getOutputJSON());
        exch.setHTTPToolProxy(htp);
        hSess.setToolProxy(htp);
        hSess.getController().setUniversalToolProxy(htp);
        htp.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.NewlyConnected);
        HTTPMessageObject setPrefsMsg = new HTTPMessageObject(requestBody, exch, hSess.getMsgFormat(), hSess.getController());
        hSess.finishInitialization(setPrefsMsg);
        return false;
    }

    private Collaborators checkForCollaborators(HTTPSession hSess, String setPrefsAsXML) throws Exception {
        MessageObject setPrefs = MessageObject.parse(setPrefsAsXML);
        Object prop = setPrefs.getProperty("school_name");
        hSess.setSchoolName(prop == null ? "" : prop.toString());
        prop = setPrefs.getProperty("collaborators");
        hSess.setTeam(Collaborators.getUserids(setPrefs, null).toString());
        Collaborators collabs = this.launcherServer.checkForCollaborators(hSess.getGuid(), setPrefs);
        if (collabs != null && collabs.nowRunning()) {
            collabs.sendAllSetPreferences();
        }
        return collabs;
    }
}

