/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.VectorMatcherPanel;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class EditStudentInputDialog
extends JDialog
implements MouseListener {
    private static final long serialVersionUID = 201402281645L;
    private static final String EDIT_STUDENT_INPUT_MATCHING = "Edit Student Input Matching";
    private EdgeData edgeData;
    private BR_Controller controller;
    private String viewType;
    private UnderlinedJLabel concat;
    private UnderlinedJLabel simple;
    private UnderlinedJLabel complex;
    private UnderlinedJLabel current;
    private static final String CONCAT_VIEW_TEXT = "Concat View";
    private static final String SIMPLE_VIEW_TEXT = "Simple View";
    private static final String COMPLEX_VIEW_TEXT = "Complex View";
    private static final Color LINK_COLOR = Color.BLUE;
    private boolean multipleVectorsEnabled;
    private VectorMatcherPanel vectorMatcherPanel;
    private final String serializedBeforeEdit;
    private boolean closedFromMatcherPanel = false;

    public EditStudentInputDialog(EdgeData edgeData, BR_Controller controller) {
        super((Frame)controller.getActiveWindow(), false);
        this.controller = controller;
        this.edgeData = edgeData;
        this.serializedBeforeEdit = edgeData.getEdge().toXMLString();
        this.initUI();
    }

    private void initUI() {
        this.setTitle(EDIT_STUDENT_INPUT_MATCHING);
        JPanel gbPane = new JPanel(new GridBagLayout());
        gbPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        this.viewType = CONCAT_VIEW_TEXT;
        this.concat = new UnderlinedJLabel(CONCAT_VIEW_TEXT);
        this.concat.addMouseListener(this);
        this.current = this.concat;
        this.complex = new UnderlinedJLabel(COMPLEX_VIEW_TEXT);
        this.complex.setForeground(LINK_COLOR);
        this.complex.setUnderlined(true);
        this.complex.addMouseListener(this);
        this.simple = new UnderlinedJLabel(SIMPLE_VIEW_TEXT);
        this.simple.setForeground(LINK_COLOR);
        this.simple.setUnderlined(true);
        this.simple.addMouseListener(this);
        Box viewOptions = new Box(0);
        viewOptions.add(this.concat);
        viewOptions.add(Box.createHorizontalStrut(12));
        viewOptions.add(this.simple);
        viewOptions.add(Box.createHorizontalStrut(12));
        viewOptions.add(this.complex);
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.vectorMatcherPanel = new VectorMatcherPanel(this, this.edgeData, this.controller.getPreferencesModel().getBooleanValue("Allow Tool-Performed Actions"), this.controller.getPreferencesModel().getIntegerValue("Maximum Number of Student Actors"));
        gbPane.add((Component)this.vectorMatcherPanel, c);
        this.setFocusTraversalPolicy(this.vectorMatcherPanel.getCustomFocusTraversalPolicy());
        if (trace.getDebugCode("editstudentinput")) {
            trace.out("editstudentinput", "VMP.focusPolicy " + trace.nh(this.vectorMatcherPanel.getCustomFocusTraversalPolicy()) + ", dialog.focusPolicy " + this.getFocusTraversalPolicy());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!EditStudentInputDialog.this.closedFromMatcherPanel) {
                    EditStudentInputDialog.this.vectorMatcherPanel.closeViaOkCancel();
                }
                EditStudentInputDialog.this.closedFromMatcherPanel = false;
            }
        });
        this.getContentPane().add(gbPane);
        this.pack();
    }

    public static void show(EdgeData edgeData, BR_Controller controller) {
        EditStudentInputDialog d = new EditStudentInputDialog(edgeData, controller);
        d.setVisible(true);
    }

    public void close() {
        this.closedFromMatcherPanel = true;
        this.setVisible(false);
        this.dispose();
        String serializedAfterEdit = this.edgeData.getEdge().toXMLString();
        if (!this.serializedBeforeEdit.equals(serializedAfterEdit)) {
            if (trace.getDebugCode("undo")) {
                trace.out("undo", "EditStudentInputDialog.close() XML before:\n" + this.serializedBeforeEdit + "\nXML after:\n" + serializedAfterEdit);
            }
            ActionEvent ae = new ActionEvent(this, 0, EDIT_STUDENT_INPUT_MATCHING);
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            if (trace.getDebugCode("undo")) {
                trace.out("undo", "Checkpoint: Change Student Input (1)");
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        Object src = me.getSource();
        this.current.setUnderlined(true);
        this.current.setForeground(Color.BLUE);
        if (src == this.concat) {
            if (this.viewType == CONCAT_VIEW_TEXT) {
                return;
            }
            this.viewType = CONCAT_VIEW_TEXT;
        } else if (src == this.simple) {
            if (this.viewType == SIMPLE_VIEW_TEXT) {
                return;
            }
            this.viewType = SIMPLE_VIEW_TEXT;
        } else if (src == this.complex) {
            if (this.viewType == COMPLEX_VIEW_TEXT) {
                return;
            }
            this.viewType = COMPLEX_VIEW_TEXT;
        }
        this.current = (UnderlinedJLabel)src;
        this.current.setForeground(this.getForeground());
        this.current.setUnderlined(false);
        this.vectorMatcherPanel.switchView(this.viewType);
        this.pack();
        this.validate();
        this.repaint();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (me.getSource() != this.current) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public Component getActiveWindow() {
        return this.controller.getActiveWindow();
    }

    private class UnderlinedJLabel
    extends JLabel {
        private boolean drawUnderline;

        public void setUnderlined(boolean d) {
            this.drawUnderline = d;
        }

        public UnderlinedJLabel(String text) {
            super(text);
            this.drawUnderline = false;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.drawUnderline) {
                Color underline = this.getForeground();
                Rectangle2D textBounds = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), g);
                int y = this.getHeight() / 2 + (int)(textBounds.getHeight() / 2.0);
                int w = (int)textBounds.getWidth();
                int x = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
                g.setColor(underline);
                g.drawLine(0, y, w, y);
            }
        }
    }
}

