/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Options;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.StudentInterfacePanel;
import edu.cmu.pact.ctat.model.CtatModeModel;
import edu.cmu.pact.ctat.view.CtatFrame;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import pact.CommWidgets.StudentInterfaceWrapper;
import pact.CommWidgets.TutorWrapper;

public class OpenInterfaceDialog {
    public static final String INTERFACE_DIRECTORY = "Interface Directory";
    private static final String CustomFileOp = "Open interface file";

    private OpenInterfaceDialog() {
    }

    public static int CloseCurrentInterfaceWithUserPrompt(BR_Controller controller) {
        String[] message = new String[]{"Only one student interface can be open at a time.  Do you want to close the current student interface?", " "};
        int value = JOptionPane.showConfirmDialog(controller.getActiveWindow(), message, "Close Current Student Interface", 0, 3);
        if (value != 0) {
            return value;
        }
        return value;
    }

    public static boolean openInterface(CTAT_Launcher server) {
        BR_Controller controller = server.getFocusedController();
        if (controller.getStudentInterface() != null) {
            int result = OpenInterfaceDialog.CloseCurrentInterfaceWithUserPrompt(controller);
            if (result == 1) {
                return false;
            }
            controller.closeStudentInterface();
            server.getCtatFrameController().getDockedFrame().getCtatMenuBar().enableInterfaceMenus(true);
        }
        try {
            File file;
            String currentDir = controller.getPreferencesModel().getStringValue(INTERFACE_DIRECTORY);
            if (currentDir == null || currentDir.length() < 1) {
                currentDir = controller.getPreferencesModel().getStringValue("workspace");
            }
            if (currentDir == null || currentDir.length() < 1) {
                currentDir = System.getProperty("user.dir");
            }
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "currentDir " + currentDir);
            }
            if ((file = DialogUtilities.chooseFile(currentDir, new ClassFilter(), CustomFileOp, CustomFileOp, controller)) == null) {
                return true;
            }
            controller.getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", "OPEN_INTERFACE", file.getAbsolutePath());
            currentDir = file.getParent();
            controller.getPreferencesModel().setStringValue(INTERFACE_DIRECTORY, currentDir);
            StudentInterfaceWrapper window = OpenInterfaceDialog.openInterface(file, controller);
            if (window != null) {
                window.setVisible(true);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (trace.getDebugCode("mps")) {
                trace.out("mps", "oops");
            }
            return false;
        }
        return true;
    }

    public static StudentInterfaceWrapper openInterface(File file, BR_Controller controller) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "opening file " + file.getName());
        }
        Class interfaceClass = OpenInterfaceDialog.getInterfaceClass(file, controller);
        return OpenInterfaceDialog.openInterface(interfaceClass, controller, file.toString());
    }

    public static StudentInterfaceWrapper openInterface(Class interfaceClass, BR_Controller controller, String interfaceFileName) {
        String superclassName;
        String errorMessage = "<html><b>Error:</b> could not load interface <br>" + (interfaceFileName == null ? interfaceClass.getName() : interfaceFileName) + ".<br><br>Make sure your class extends <b>JPanel</b> <br>";
        try {
            superclassName = interfaceClass.getSuperclass().getName();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(controller.getActiveWindow(), errorMessage, "Error loading interface", 1);
            throw new RuntimeException("Can't load file");
        }
        TutorWrapper tutorWrapper = null;
        JPanel tutorPanel = null;
        controller.clearUnmatchedComponentsAndReviseConnectionStatus();
        if (superclassName.equals("javax.swing.JPanel")) {
            controller.resetAllWidgets();
            tutorWrapper = new TutorWrapper(controller);
            try {
                tutorPanel = (JPanel)interfaceClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
            if (tutorPanel instanceof StudentInterfacePanel) {
                ((StudentInterfacePanel)((Object)tutorPanel)).setController(controller);
            }
            controller.setStudentInterface(tutorWrapper, tutorPanel);
            CTAT_Options options = tutorWrapper.setTutorPanel(tutorPanel);
            controller.setOptions(options);
            CtatModeModel cmm = controller.getCtatModeModel();
            ProblemModel pm = controller.getProblemModel();
            if (!"Set Start State".equals(cmm.getCurrentAuthorMode()) && pm != null && pm.getNodeCount() > 0) {
                controller.goToStartState();
            }
        } else {
            JOptionPane.showMessageDialog(controller.getActiveWindow(), errorMessage, "Error loading interface", 1);
            trace.printStack("Error loading interface");
            throw new RuntimeException("Can't load file: superclass == " + superclassName);
        }
        WindowListener[] listeners = tutorWrapper.getWindowListeners();
        for (int i = 0; i < listeners.length; ++i) {
            tutorWrapper.removeWindowListener(listeners[i]);
        }
        tutorWrapper.addWindowListener(((CtatFrame)controller.getDockedFrame()).getCtatMenuBar());
        if (interfaceFileName != null) {
            controller.getPreferencesModel().setStringValue("Interface File", interfaceFileName);
            controller.getPreferencesModel().saveToDisk();
        }
        ((CtatFrame)controller.getDockedFrame()).getCtatMenuBar().enableInterfaceMenus(true);
        if (controller.getUniversalToolProxy() != null) {
            controller.getUniversalToolProxy().handleMessage(MessageObject.create("GetAllInterfaceDescriptions"));
        }
        return tutorWrapper;
    }

    public static Class getInterfaceClass(File file, BR_Controller controller) {
        Class<?> interfaceClass = null;
        File currentDir = file;
        URL url = null;
        boolean found = false;
        File homeDir = currentDir.getParentFile();
        controller.setHomeDir(homeDir.getAbsolutePath() + File.separator);
        PreferencesModel pm = controller.getPreferencesModel();
        if (pm != null) {
            pm.setStringValue(INTERFACE_DIRECTORY, homeDir.getAbsolutePath());
        }
        while (!found) {
            currentDir = currentDir.getParentFile();
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "current dir = " + currentDir);
            }
            if (currentDir == null) {
                String message = "<html>Error: could not load interface <br>" + file + ".<br><br>Make sure your class file is located in a folder <br>hierarchy that matches the package name.";
                JOptionPane.showMessageDialog(controller.getActiveWindow(), message, "Error loading interface", 1);
                trace.printStack("Error loading interface");
                throw new RuntimeException("Can't load file");
            }
            String classname = file.toString().substring(currentDir.toString().length() + 1, file.toString().length() - 6);
            classname = classname.replace('\\', '.');
            classname = classname.replace('/', '.');
            try {
                url = currentDir.toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            URL[] urlList = new URL[]{url};
            URLClassLoader loader = new URLClassLoader(urlList);
            try {
                found = true;
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "loading class: " + classname);
                }
                interfaceClass = loader.loadClass(classname);
            }
            catch (ClassNotFoundException e1) {
                found = false;
            }
            catch (NoClassDefFoundError e2) {
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "" + e2.getMessage());
                }
                if (e2.getMessage().equals("pact/CommWidgets/TutorPanel")) {
                    OpenInterfaceDialog.showIncompatibleInterfaceDialog(controller.getActiveWindow());
                }
                found = false;
            }
            catch (SecurityException e) {
                found = false;
            }
        }
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "System.setProperty(studentInterface.url, " + url.toString() + ")");
        }
        System.setProperty("studentInterface.url", url.toString());
        controller.getProperties().setProperty("studentInterface.url", url.toString());
        return interfaceClass;
    }

    private static void showIncompatibleInterfaceDialog(JFrame d) {
        String message = "<html>This interfaces references pact/CommWidgets/TutorPanel.  <br>This type of interface is not supported past CTAT version 1.5. <br><br>Please see the CTAT help page for information on how to upgrade your interface.";
        String title = "Incompatible Interface";
        JOptionPane.showMessageDialog(null, message, title, 2);
        throw new RuntimeException("Incompatible interface: references pact/CommWidgets/TutorPanel");
    }

    public static class ClassFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return f.isDirectory() || "class".equalsIgnoreCase(this.getExtension(f));
        }

        @Override
        public String getDescription() {
            return "Java class files";
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

