/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.ViewUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RuleNamesDisplayDialog
extends JDialog
implements ActionListener {
    private JPanel contentPanel = new JPanel();
    private JPanel listJPanel = new JPanel();
    private JPanel closeJPanel = new JPanel();
    private JList ruleList;
    private JScrollPane listScrollPane;
    private DefaultListModel listModel;
    private JButton closeJButton = new JButton("Close");
    private BR_Controller controller;

    public RuleNamesDisplayDialog(BR_Controller controller) {
        this(controller, true);
    }

    public RuleNamesDisplayDialog(BR_Controller controller, boolean visible) {
        super(controller.getActiveWindow(), "Skill Names...", false);
        this.controller = controller;
        this.contentPanel.setLayout(new BorderLayout());
        ViewUtils.setStandardBorder(this.contentPanel);
        this.listJPanel.setLayout(new GridLayout(1, 1));
        this.listModel = new DefaultListModel();
        this.ruleList = new JList(this.listModel);
        this.ruleList.setName("ruleList");
        this.ruleList.setSelectionMode(0);
        this.ruleList.setSelectedIndex(-1);
        this.listScrollPane = new JScrollPane(this.ruleList);
        this.listJPanel.add(this.listScrollPane);
        this.closeJPanel.setLayout(new FlowLayout());
        this.closeJPanel.add(this.closeJButton);
        this.contentPanel.add((Component)this.listJPanel, "Center");
        this.contentPanel.add((Component)this.closeJPanel, "South");
        this.getContentPane().add(this.contentPanel);
        this.setLocationRelativeTo(null);
        this.setSize(300, 400);
        this.setRuleProductionList(visible);
        this.closeJButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RuleNamesDisplayDialog.this.setVisible(false);
            }
        });
    }

    private void setRuleProductionList(boolean visible) {
        trace.out("controller = " + this.controller);
        List<String> skillNames = this.controller.getRuleProductionCatalog().getRuleDisplayNames(true);
        int stringsNumber = skillNames.size();
        if (stringsNumber > 0) {
            this.ruleList.setVisibleRowCount(Math.min(stringsNumber, 10));
            Object[] allSkills = new String[stringsNumber];
            skillNames.toArray(allSkills);
            Arrays.sort(allSkills);
            for (int i = 0; i < stringsNumber; ++i) {
                this.listModel.addElement(allSkills[i]);
            }
        } else {
            this.listModel.addElement("No skill names currently defined.");
        }
        if (visible) {
            this.listScrollPane.setVisible(visible);
            this.setVisible(visible);
        }
    }

    public void resetRuleProductionList(boolean visible) {
        this.listModel.removeAllElements();
        this.setRuleProductionList(visible);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.closeJButton) {
            this.setVisible(false);
        }
    }
}

