/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions.matchWithPrecision;
import edu.cmu.pact.Utilities.trace;
import java.util.regex.Matcher;

public class matchWithoutPrecision {
    private int afterDecimalDigits(Matcher m) {
        int[] decimalDigitGroups = new int[]{7, 12};
        int afterDecimal = 0;
        for (int i : decimalDigitGroups) {
            String digitsGroup = m.group(i);
            if (digitsGroup == null) continue;
            afterDecimal = digitsGroup.length();
        }
        return afterDecimal;
    }

    private int meaningfulDigits(Matcher m) {
        int[] decimalDigitGroups = new int[]{7, 12};
        int beforeDecimal = 0;
        String digitsGroup = m.group(5);
        if (digitsGroup != null) {
            boolean foundSignificant = false;
            for (char c : digitsGroup.toCharArray()) {
                if (c != '0') {
                    foundSignificant = true;
                }
                if (!foundSignificant) continue;
                ++beforeDecimal;
            }
        }
        int afterDecimal = 0;
        for (int i : decimalDigitGroups) {
            digitsGroup = m.group(i);
            if (digitsGroup == null) continue;
            afterDecimal = digitsGroup.length();
        }
        return beforeDecimal + afterDecimal;
    }

    private int afterDecimalDigits(String input) {
        return Math.max(this.afterDecimalDigits(this.fpMatcher(input)), this.afterDecimalDigits(this.canonicalFpMatcher(input)));
    }

    private int meaningfulDigits(String input) {
        return Math.max(this.meaningfulDigits(this.fpMatcher(input)), this.meaningfulDigits(this.canonicalFpMatcher(input)));
    }

    public static double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }

    private Matcher fpMatcher(String input) {
        Matcher m = matchWithPrecision.fpPattern.matcher(input);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    private Matcher canonicalFpMatcher(String input) {
        return this.fpMatcher(input) != null ? this.fpMatcher(Double.toString(Double.valueOf(input))) : null;
    }

    public boolean matchWithoutPrecision(String input, String number) {
        Matcher inputMatcher = this.canonicalFpMatcher(input);
        Matcher numberMatcher = this.canonicalFpMatcher(number);
        if (inputMatcher != null && numberMatcher != null && inputMatcher.matches() && numberMatcher.matches()) {
            int inputDigits = this.meaningfulDigits(input);
            int numberDigits = this.meaningfulDigits(number);
            int numberADDigits = this.afterDecimalDigits(number);
            if (trace.getDebugCode("functions")) {
                trace.out("functions", "inputDigits " + inputDigits + ", numberDigits " + numberDigits + ", numberADDigits " + numberADDigits);
            }
            double numberValue = Double.valueOf(number);
            double inputValue = Double.valueOf(input);
            if (trace.getDebugCode("functions")) {
                trace.out("functions", "inputValue " + inputValue + ", numberValue " + numberValue);
            }
            inputValue = numberDigits < inputDigits ? matchWithoutPrecision.round(inputValue, numberADDigits) : inputValue;
            int compareResult = Double.compare(numberValue, inputValue);
            if (trace.getDebugCode("functions")) {
                trace.out("functions", "rounded inputValue " + inputValue + ", compareResult " + compareResult);
            }
            return compareResult == 0;
        }
        return false;
    }

    public boolean matchWithoutPrecision(String input, double number) {
        return this.matchWithoutPrecision(input, Double.toString(number));
    }

    public boolean matchWithoutPrecision(double input, String number) {
        return this.matchWithoutPrecision(Double.toString(input), number);
    }

    public boolean matchWithoutPrecision(double input, double number) {
        return this.matchWithoutPrecision(Double.toString(input), Double.toString(number));
    }

    public void checkMatch(String input, String number) {
        boolean check = this.matchWithoutPrecision(input, number);
        System.out.println("matchWithoutPrecision(" + input + ", " + number + ") = " + check);
    }

    public static void main(String[] args) throws Exception {
        matchWithoutPrecision withoutPrec = new matchWithoutPrecision();
        withoutPrec.checkMatch("8.81", "8.8");
        withoutPrec.checkMatch("0.881", "0.88");
        withoutPrec.checkMatch("0.911", "0.900");
        withoutPrec.checkMatch("0.911", "0.91");
        withoutPrec.checkMatch("0.915", "0.91");
        withoutPrec.checkMatch("0.916", "0.91");
        withoutPrec.checkMatch("0.09", "9E-2");
        withoutPrec.checkMatch("0.091", "9E-2");
        withoutPrec.checkMatch("0.09", "9.000E-2");
        withoutPrec.checkMatch("0.9", ".9");
        withoutPrec.checkMatch("0.9", "0.9");
        withoutPrec.checkMatch("0.89", "0.9");
        withoutPrec.checkMatch("0.84", "0.9");
        withoutPrec.checkMatch("9E-1", "90E-2");
    }
}

