/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions;

import edu.cmu.pact.Utilities.trace;
import java.util.HashMap;
import java.util.regex.Pattern;

public class regExMatch {
    private static HashMap<String, Pattern> savedPatterns = new HashMap();

    public boolean regExMatch(String regex, String teststr) {
        return this.regExMatch(regex, teststr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean regExMatch(String regex, String teststr, String flags) {
        Pattern p;
        HashMap<String, Pattern> hashMap = savedPatterns;
        synchronized (hashMap) {
            String key = this.makeKey(regex, flags);
            p = savedPatterns.get(key);
            if (p == null) {
                int flagBits = this.parseFlags(regex, flags);
                p = Pattern.compile(regex, flagBits);
                savedPatterns.put(key, p);
            }
        }
        return p.matcher(teststr).matches();
    }

    private String makeKey(String regex, String flags) {
        int flagBits = this.parseFlags(regex, flags);
        StringBuffer sb = new StringBuffer(regex);
        sb.append("_0x").append(Integer.toHexString(flagBits));
        return sb.toString();
    }

    private int parseFlags(String regex, String flags) {
        int result = 0;
        if (flags == null) {
            return result;
        }
        flags = flags.toLowerCase();
        char c = ' ';
        block10: for (int i = 0; i < flags.length(); ++i) {
            switch (flags.charAt(i)) {
                case 'i': {
                    result |= 2;
                    continue block10;
                }
                case 'm': {
                    result |= 8;
                    continue block10;
                }
                case 'd': {
                    result |= 0x20;
                    continue block10;
                }
                case 'u': {
                    result |= 0x40;
                    continue block10;
                }
                case 'e': {
                    result |= 0x80;
                    continue block10;
                }
                case 'l': {
                    result |= 1;
                    continue block10;
                }
                case 't': {
                    result |= 0x10;
                    continue block10;
                }
                case 'c': {
                    result |= 4;
                    continue block10;
                }
                default: {
                    trace.err("regExMatch(" + regex + "," + flags + "): unknown flag character '" + c + "' at position " + i);
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length < 2 || args[0].equalsIgnoreCase("-h")) {
            System.err.printf("Too few arguments. Usage:\n  %s -[imdueltc] regex teststr... [-[imdueltc] regex teststr...]\n", new regExMatch().getClass().getSimpleName());
            System.err.println("where--\n  [imdueltc] are flag(s) for case-insensitive, etc.;\n  regex is the regular expression (often you'll want to quote this);\n  teststr... are string(s) to test for matching.\nIf you repeat the arguments after a hyphen, you can retest with the same Pattern cache.");
            System.exit(2);
        }
        int a = 0;
        int result = 0;
        result |= regExMatch.testOnceOrAgain(result, args, a);
        System.out.printf("\nExiting with pattern cache size %d:\n  %s\n", savedPatterns.size(), savedPatterns);
        System.exit(result);
    }

    private static int testOnceOrAgain(int result, String[] args, int a) {
        regExMatch rem = new regExMatch();
        String flags = null;
        if (args[a].startsWith("-")) {
            flags = args[a++].substring(1);
        }
        System.out.printf("Flags '" + flags + "':\n", new Object[0]);
        String regex = args[a++];
        boolean match = false;
        while (a < args.length && !args[a].startsWith("-")) {
            match = rem.regExMatch(regex, args[a], flags);
            System.out.printf("  %s %-7s %s\n", regex, match ? "accepts" : "rejects", args[a]);
            if (!match) {
                result |= 1;
            }
            ++a;
        }
        if (a < args.length) {
            result |= regExMatch.testOnceOrAgain(result, args, a);
        }
        return result;
    }
}

