/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.BRDLoadedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.HintPolicyEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherFactory;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.SolverMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.CtatModeModel;
import edu.cmu.pact.ctatview.CtatMenuBar;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ProblemStateReaderJDom {
    private static XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat().setOmitDeclaration(true).setLineSeparator("").setIndent(""));
    private BR_Controller controller;
    private Document doc = null;
    private boolean unorderedFlag = false;
    private boolean hasEdgesGroups = false;
    private Vector currentAssociatedElements = new Vector();
    private Vector currentAssociatedElementsValues = new Vector();
    private ProblemModel problemModel;
    private Hashtable foAMap;
    private String brdVersion = "";
    private ArrayList<NodeCreatedEvent> nodeCreatedEvents;
    private ArrayList<EdgeCreatedEvent> edgeCreatedEvents;
    private String studentBeginsHereStateName;
    private String behaviorRecorderMode;
    private FeedbackEnum feedback = FeedbackEnum.DEFAULT;

    public ProblemStateReaderJDom(BR_Controller controller) {
        this.nodeCreatedEvents = new ArrayList();
        this.edgeCreatedEvents = new ArrayList();
        this.controller = controller;
        this.foAMap = new Hashtable();
    }

    private Document parse(InputStream is) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        InputStreamReader isr = new InputStreamReader(is, "ISO-8859-1");
        Document doc = builder.build((Reader)isr);
        isr.close();
        return doc;
    }

    boolean loadBRDFileIntoMainProblemState(InputStream is, String problemFullName, String absolutePath) {
        String title = "Error parsing graph file";
        try {
            this.doc = this.parse(is);
        }
        catch (JDOMParseException je) {
            String message = "<html>Error reading file: " + problemFullName + "<br>The format of the file is not recognized. <br>" + (Object)((Object)je) + "<br>Please check the file and try again.";
            Utils.showExceptionOccuredDialog((Exception)((Object)je), message, title);
            return false;
        }
        catch (Exception e2) {
            String message = "<html>Error reading file " + problemFullName + ":<br/>" + e2 + (e2.getCause() == null ? "" : ".<br/>Cause: " + e2.getCause());
            e2.printStackTrace();
            Utils.showExceptionOccuredDialog(null, message, title);
            return false;
        }
        try {
            this.problemModel = this.controller.getProblemModel();
            RuleProduction.Catalog rpc = this.controller.getRuleProductionCatalog();
            if (this.problemModel != null) {
                String problemName = Utils.getBaseName(problemFullName);
                this.problemModel.reset(problemName, absolutePath);
            }
            this.processDocument(this.doc, this.problemModel, rpc);
            this.problemModel = this.controller.getProblemModel();
            this.controller.updateStatusPanel(problemFullName);
        }
        catch (Exception e) {
            String message = "<html>Error processing file " + problemFullName + ":<br/>" + e + (e.getCause() == null ? "" : ".<br/>Cause: " + e.getCause());
            e.printStackTrace();
            Utils.showExceptionOccuredDialog(null, message, title);
            return false;
        }
        return true;
    }

    private void processTopLevelElement(Element element2, ProblemStateReaderJDom psrj, ProblemModel problemModel, RuleProduction.Catalog rpc) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        String elementName = element2.getName();
        if (trace.getDebugCode("jdomreader")) {
            trace.out("jdomreader", "element name = " + elementName);
        }
        if (elementName.equals("startNodeMessages")) {
            this.processStartNodeElement(element2, problemModel);
        } else if (elementName.equals("node")) {
            this.processNode(element2, problemModel);
        } else if (elementName.equals("element")) {
            if (psrj != null) {
                this.processElement(element2, psrj.currentAssociatedElements, psrj.currentAssociatedElementsValues);
            } else {
                this.processElement(element2, null, null);
            }
        } else if (elementName.equals("edge")) {
            this.processEdge(element2, problemModel, rpc);
        } else if (elementName.equals("EdgesGroups")) {
            problemModel.getExampleTracerGraph().getGroupModel().readFromXML(element2, this.unorderedFlag);
            this.hasEdgesGroups = true;
        } else if (elementName.equals("productionRule")) {
            this.processProductionRuleElement(element2, rpc);
        }
    }

    private void processProductionRuleElement(Element element2, RuleProduction.Catalog rpc) {
        if (rpc == null) {
            return;
        }
        String productionRuleName = element2.getChildText("ruleName");
        String productionSet = element2.getChildText("productionSet");
        RuleProduction rp = rpc.checkAddRuleName(productionRuleName, productionSet);
        rp.setLabel(element2.getChildText("label"));
        rp.setDescription(element2.getChildText("description"));
        List hints = element2.getChildren("hintMessage");
        if (hints.size() > 0) {
            rp.setHints(new Vector<String>());
            Iterator it = hints.iterator();
            while (it.hasNext()) {
                rp.addHintItem(((Element)it.next()).getText());
            }
        }
    }

    private void processEdge(Element edgeElement, ProblemModel problemModel, RuleProduction.Catalog rpc) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        boolean updateAuthorUI;
        if (trace.getDebugCode("jdomreader")) {
            trace.out("jdomreader", "processing edge for problem " + problemModel.getProblemFullName());
        }
        Element sourceElement = edgeElement.getChild("sourceID");
        Element destinationElement = edgeElement.getChild("destID");
        Element traversalCountElt = edgeElement.getChild("traversalCount");
        Element actionLabelElement = edgeElement.getChild("actionLabel");
        Element actionLabelUniqueIDElement = actionLabelElement.getChild("uniqueID");
        Element messageElement = actionLabelElement.getChild("message");
        MessageObject messageObject = this.getMessageObject(messageElement);
        int ID = Integer.parseInt(actionLabelUniqueIDElement.getValue());
        int sourceID = Integer.parseInt(sourceElement.getValue());
        int destID = Integer.parseInt(destinationElement.getValue());
        int traversalCount = Integer.parseInt(traversalCountElt == null ? "-1" : traversalCountElt.getValue());
        String buggymsg = actionLabelElement.getChildText("buggyMessage");
        String success = actionLabelElement.getChildText("successMessage");
        String actionType = actionLabelElement.getChildText("actionType");
        String checked = actionLabelElement.getChildText("checkedStatus");
        boolean isPreferPath = actionLabelElement.getAttributeValue("preferPathMark").equals("true");
        if (trace.getDebugCode("jdomreader")) {
            trace.out("jdomreader", "read edge: " + edgeElement.getChildren());
        }
        EdgeData edgeData = this.createEdgeDataForEdge(problemModel, actionLabelElement, messageObject, ID, buggymsg, success, actionType, checked, isPreferPath);
        edgeData.setMinTraversalsStr(actionLabelElement.getAttributeValue("minTraversals"));
        edgeData.setMaxTraversalsStr(actionLabelElement.getAttributeValue("maxTraversals"));
        this.addMatcherForEdge(actionLabelElement, messageObject, edgeData);
        if (actionLabelElement.getChild("callbackFn") != null) {
            String cbfn = actionLabelElement.getChild("callbackFn").getValue();
            if (trace.getDebugCode("jdomreader") && cbfn != null && cbfn.trim().length() > 0) {
                trace.out("jdomreader", "Callback function is = " + cbfn);
            }
            edgeData.setCallbackFn(cbfn);
        }
        this.addRulesForEdge(edgeElement, edgeData, rpc);
        ProblemNode sourceNode = ProblemModel.getNodeForVertexUniqueID(sourceID, problemModel.getProblemGraph());
        ProblemNode destinationNode = ProblemModel.getNodeForVertexUniqueID(destID, problemModel.getProblemGraph());
        if (destinationNode == null) {
            throw new RuntimeException("Could not location destination node for UniqueID " + destID);
        }
        if (sourceNode == null) {
            throw new RuntimeException("Could not location source node for UniqueID " + sourceID);
        }
        edgeData.setTraversalCount(traversalCount);
        ProblemEdge newEdge = problemModel.getProblemGraph().addEdge(sourceNode, destinationNode, edgeData);
        this.createSimStudentFOA(edgeElement, newEdge);
        if (newEdge == null) {
            throw new RuntimeException("Error occuring adding edge between source " + sourceNode + " and destination " + destinationNode);
        }
        boolean bl = updateAuthorUI = !Utils.isRuntime() && problemModel.getController() != null;
        if (updateAuthorUI) {
            newEdge.addEdgeLabels();
        }
        this.edgeCreatedEvents.add(new EdgeCreatedEvent(this, newEdge));
    }

    private int getIntAttr(String attrName, int defaultResult, Element elt, String eltType, int ID) {
        String attrVal = elt.getAttributeValue(attrName);
        try {
            return Integer.parseInt(attrVal);
        }
        catch (NumberFormatException nfe) {
            trace.err("Error reading " + attrName + " for " + eltType + ID + "; using default " + defaultResult + ": " + nfe);
            return defaultResult;
        }
    }

    private EdgeData createEdgeDataForEdge(ProblemModel pm, Element actionLabelElement, MessageObject messageObject, int ID, String buggymsg, String success, String actionType, String checked, boolean isPreferPath) {
        EdgeData edgeData = new EdgeData(pm);
        List hintList = actionLabelElement.getChildren("hintMessage");
        for (Element hint : hintList) {
            String hintMessage = hint.getText();
            if (trace.getDebugCode("jdomreader")) {
                trace.out("jdomreader", "hint message = " + hintMessage);
            }
            edgeData.addHint(hintMessage);
        }
        if (pm.getRandomizeHints()) {
            edgeData.randomizeHintOrder();
        }
        edgeData.setBuggyMsg(buggymsg);
        edgeData.setCheckedStatus(checked);
        if (actionType != null) {
            edgeData.setActionType(actionType);
        }
        edgeData.setSuccessMsg(success);
        edgeData.setPreferredEdge(isPreferPath);
        edgeData.setUniqueID(ID);
        edgeData.setDemoMsgObj(messageObject);
        return edgeData;
    }

    private void addMatcherForEdge(Element actionLabelElement, MessageObject messageObject, EdgeData edgeData) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Element matcherElement = actionLabelElement.getChild("matcher");
        Element solverMatcherElement = actionLabelElement.getChild("solverMatcher");
        Element vectorMatcherElement = actionLabelElement.getChild("matchers");
        Vector<String> currentSelection = messageObject.getSelection();
        Vector<String> currentAction = messageObject.getAction();
        Vector<String> currentInput = messageObject.getInput();
        if (matcherElement != null) {
            Matcher m = this.createMatcher(matcherElement);
            edgeData.setMatcher(m);
            m.setDefaultSelectionVector(currentSelection);
            m.setDefaultActionVector(currentAction);
            m.setDefaultInputVector(currentInput);
        } else if (solverMatcherElement != null) {
            SolverMatcher sm = this.createSolverMatcher(solverMatcherElement, currentSelection, currentInput);
            if (sm != null) {
                edgeData.setMatcher(sm);
            }
        } else if (vectorMatcherElement != null) {
            VectorMatcher vm = this.createVectorMatcher(vectorMatcherElement);
            vm.setDefaultSelectionVector(currentSelection);
            vm.setDefaultActionVector(currentAction);
            vm.setDefaultInputVector(currentInput);
            edgeData.setMatcher(vm);
        } else {
            ExactMatcher m = this.buildDefaultExactMatcher(messageObject, edgeData);
            if (m != null) {
                edgeData.setMatcher(m);
            }
        }
    }

    private void createSimStudentFOA(Element edgeElement, ProblemEdge newEdge) {
        Element simStElement = edgeElement.getChild("SimSt");
        Vector<String> foAWidgetList = new Vector<String>();
        if (simStElement != null) {
            List foAList = simStElement.getChildren("focusOfAttention");
            for (int i = 0; i < foAList.size(); ++i) {
                Element foAElement = (Element)foAList.get(i);
                String widgetName = foAElement.getChildText("target");
                if (trace.getDebugCode("miss-jdom")) {
                    trace.out("miss-jdom", "sungjoo_ProblemStateReader.ProcessEdge: widget = " + widgetName + " JDom = " + this);
                }
                foAWidgetList.add(widgetName);
            }
            this.foAMap.put(newEdge, foAWidgetList);
        }
    }

    private ExactMatcher buildDefaultExactMatcher(MessageObject messageObject, EdgeData edgeData) {
        Vector<String> selection = messageObject.getSelection();
        Vector<String> action = messageObject.getAction();
        Vector<String> input = messageObject.getInput();
        ExactMatcher m = new ExactMatcher(selection, action, input);
        edgeData.setMatcher(m);
        return m;
    }

    private void addRulesForEdge(Element edgeElement, EdgeData edgeData, RuleProduction.Catalog rpc) {
        if (rpc == null) {
            return;
        }
        List ruleElements = edgeElement.getChildren("rule");
        for (Element ruleElement : ruleElements) {
            String ruleLabelText = ruleElement.getChildText("text");
            edgeData.addRuleName(ruleLabelText);
            if (ruleLabelText.contains(" ")) {
                int separatorPosition = ruleLabelText.indexOf(" ");
                String newRuleNameText = ruleLabelText.substring(0, separatorPosition);
                String newProductionSet = ruleLabelText.substring(separatorPosition + 1, ruleLabelText.length());
                rpc.checkAddRuleName(newRuleNameText, newProductionSet);
                continue;
            }
            if (ruleLabelText.equalsIgnoreCase("unnamed")) continue;
            rpc.checkAddRuleName(ruleLabelText, "");
        }
    }

    private SolverMatcher createSolverMatcher(Element solverMatcherElement, Vector defaultSelection, Vector defaultInput) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        try {
            String autoSimplify = solverMatcherElement.getAttributeValue("AutoSimplify", "false");
            String typeinMode = solverMatcherElement.getAttributeValue("TypeinMode", "false");
            String goal = solverMatcherElement.getAttributeValue("Goal", (String)null);
            List<Matcher> sList = this.createChildMatcher(solverMatcherElement, "Selection", 0, true);
            List<Matcher> aList = this.createChildMatcher(solverMatcherElement, "Action", 1, false);
            List<Matcher> iList = this.createChildMatcher(solverMatcherElement, "Input", 2, false);
            boolean[] linkTriggered = new boolean[1];
            String actor = this.findActorInMatcherElement(solverMatcherElement, linkTriggered);
            SolverMatcher sm = new SolverMatcher(true, sList, aList, iList, actor, autoSimplify, typeinMode, goal);
            sm.setLinkTriggered(linkTriggered[0]);
            return sm;
        }
        catch (Exception ie) {
            trace.err("Error creating SolverMatcher for selection " + defaultSelection + ", input " + defaultInput + ": " + ie);
            ie.printStackTrace();
            return null;
        }
    }

    private VectorMatcher createVectorMatcher(Element vectorMatcherElement) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        boolean concat2 = Boolean.valueOf(vectorMatcherElement.getAttributeValue("Concatenation"));
        List<Matcher> sList = this.createChildMatcher(vectorMatcherElement, "Selection", 0, concat2);
        List<Matcher> aList = this.createChildMatcher(vectorMatcherElement, "Action", 1, concat2);
        List<Matcher> iList = this.createChildMatcher(vectorMatcherElement, "Input", 2, concat2);
        boolean[] linkTriggered = new boolean[1];
        String actor = this.findActorInMatcherElement(vectorMatcherElement, linkTriggered);
        VectorMatcher vm = new VectorMatcher(concat2, sList, aList, iList, actor);
        vm.setLinkTriggered(linkTriggered[0]);
        return vm;
    }

    private List<Matcher> createChildMatcher(Element vectorMatcherElement, String tag, int role, boolean concat2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Element elt = vectorMatcherElement.getChild(tag);
        List childElts = elt.getChildren();
        LinkedList<Matcher> matchers = new LinkedList<Matcher>();
        for (int i = 0; i < childElts.size(); ++i) {
            matchers.add(this.createMatcher((Element)childElts.get(i), true, concat2, role));
        }
        return matchers;
    }

    private String findActorInMatcherElement(Element matcherElement, boolean[] linkTriggered) {
        String actor = null;
        Element actorElement = matcherElement.getChild("Actor");
        linkTriggered[0] = false;
        if (actorElement == null) {
            actor = "Student";
        } else {
            actor = actorElement.getValue();
            if (!(actor.equals("Tutor") || actor.equals("Any") || actor.equals("Student") || actor.equals("Tutor (unevaluated)"))) {
                trace.err("PSRJDom: actorElement value \"" + actor + "\" not defined; using " + "Student");
                actor = "Student";
            }
            linkTriggered[0] = Boolean.parseBoolean(actorElement.getAttributeValue("linkTriggered", Boolean.FALSE.toString()));
        }
        if (trace.getDebugCode("actor")) {
            trace.out("actor", "PSRJ.findActorInMatcherElement() returns " + actor);
        }
        return actor;
    }

    private Matcher createMatcher(Element matcherElement) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        return this.createMatcher(matcherElement, false, false, -1);
    }

    private Matcher createMatcher(Element matcherElement, boolean single, boolean concat2, int vector) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        if (matcherElement == null) {
            return null;
        }
        String matcherType = matcherElement.getChildText("matcherType");
        Matcher m = null;
        m = single ? MatcherFactory.buildSingleMatcher(matcherType, concat2, vector) : MatcherFactory.buildMatcher(matcherType);
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "created matcher " + m.getClass() + " for type " + matcherType);
        }
        if (this.controller != null) {
            m.setSessionStorage(this.controller.getSessionStorage());
        }
        List paramList = matcherElement.getChildren("matcherParameter");
        int count = 0;
        for (Element e : paramList) {
            if (e.getAttributeValue("version") == null) {
                e.setAttribute("version", this.brdVersion);
            }
            m.setParameter(e, count);
            ++count;
        }
        m.setReplacementFormula(matcherElement.getAttributeValue("replacementFormula"));
        return m;
    }

    private void processElement(Element elt, List assocElts, List assocVals) {
        if (assocElts == null || assocVals == null) {
            return;
        }
        Element text = elt.getChild("text");
        Element value = elt.getChild("value");
        assocElts.add(text.getValue());
        assocVals.add(value.getValue());
    }

    private void processNode(Element elt, ProblemModel pm) {
        boolean updateAuthorUI;
        Element text = elt.getChild("text");
        Element dimension = elt.getChild("dimension");
        String nodeidStr = elt.getChild("uniqueID").getValue();
        int nodeid = new Integer(nodeidStr);
        NodeView currentNodeView = null;
        boolean bl = updateAuthorUI = !Utils.isRuntime() && pm.getController() != null;
        if (updateAuthorUI) {
            currentNodeView = new NodeView(text.getValue(), pm.getController());
            if (elt.getAttributeValue("locked") != null) {
                boolean locked = elt.getAttributeValue("locked").equals("true");
                currentNodeView.setLocked(locked);
            }
            currentNodeView.setLocation(new Integer(dimension.getChild("x").getValue()), new Integer(dimension.getChild("y").getValue()));
        }
        ProblemGraph r = pm.getProblemGraph();
        ProblemNode problemNode = updateAuthorUI ? new ProblemNode(currentNodeView, pm) : new ProblemNode(pm, text.getValue());
        problemNode.setUniqueID(nodeid);
        if (elt.getAttributeValue("doneState") != null) {
            boolean doneState = elt.getAttributeValue("doneState").equals("true");
            problemNode.setDoneState(doneState);
        }
        ProblemNode tempNode = r.addProblemNode(problemNode);
        if (pm.isFirstNode()) {
            pm.setStartNode(tempNode);
            pm.setStartNodeCreatedFlag(true);
            if (pm.getController() != null) {
                pm.getController().getSolutionState().setCurrentNode(tempNode);
            }
            if (updateAuthorUI) {
                currentNodeView.setFont(CtatMenuBar.defaultFont);
            }
            pm.setFirstNode(false);
        }
        this.nodeCreatedEvents.add(new NodeCreatedEvent(this, problemNode, null));
    }

    private String processStateGraphElement(Element elt, ProblemModel pm) {
        String brdVersion = elt.getAttributeValue("version");
        if (elt.getAttributeValue("lockWidget") != null) {
            boolean LW = elt.getAttributeValue("lockWidget").equals("true");
            pm.setLockWidget(LW);
        }
        if (elt.getAttributeValue("hintPolicy") != null) {
            pm.setHintPolicy(HintPolicyEnum.fromString(elt.getAttributeValue("hintPolicy")));
        }
        pm.setStartNodeMessageVector(new Vector());
        this.behaviorRecorderMode = elt.getAttributeValue("behaviorRecorderMode");
        if (this.behaviorRecorderMode == null) {
            this.behaviorRecorderMode = elt.getAttributeValue("behaviorRecorderMode".replaceFirst("b", "B"));
        }
        this.studentBeginsHereStateName = elt.getAttributeValue("startStateNodeName");
        String hrs = elt.getAttributeValue("highlightRightSelection");
        if (Boolean.FALSE.toString().equalsIgnoreCase(hrs)) {
            pm.setHighlightRightSelection(false);
        } else {
            pm.setHighlightRightSelection(true);
        }
        String cd = elt.getAttributeValue("confirmDone");
        pm.setConfirmDone(cd == null ? null : new Boolean(!Boolean.FALSE.toString().equalsIgnoreCase(cd)));
        String tutorType = elt.getAttributeValue("tutorType");
        if (trace.getDebugCode("eep")) {
            trace.out("eep", "brd tutorType header is " + tutorType);
        }
        try {
            if (tutorType == null || !CtatModeModel.isDefinedModeType(tutorType)) {
                if (Utils.isRuntime()) {
                    this.controller.getCtatModeModel().setMode("Example-tracing Tutor");
                }
            } else if (CtatModeModel.isDefinedModeType(tutorType) && this.controller != null) {
                this.controller.getCtatModeModel().setMode(tutorType);
                if (!Utils.isRuntime()) {
                    this.controller.getCtatFrameController().getDockedFrame().setTutorTypeLabel(tutorType);
                }
            }
            if (tutorType != null && !CtatModeModel.isDefinedModeType(tutorType)) {
                trace.err("brd tutorType header:" + tutorType + " is not recognized");
            }
        }
        catch (Exception e) {
            trace.errStack("error setting tutorType frame", e);
        }
        String ptsc = elt.getAttributeValue("protoTypeStateCommutative");
        if (ptsc == null) {
            ptsc = elt.getAttributeValue("commutative");
        }
        if (ptsc == null) {
            ptsc = elt.getAttributeValue("unordered");
        }
        this.unorderedFlag = Boolean.parseBoolean(ptsc);
        String caseInsensitive = elt.getAttributeValue("protoTypeModeCaseInsensitive");
        if (caseInsensitive == null) {
            caseInsensitive = elt.getAttributeValue("caseInsensitive");
        }
        pm.setCaseInsensitive(caseInsensitive != null && caseInsensitive.equals("true"));
        String tutorTheStudent = elt.getAttributeValue("tutorTheStudent");
        String suppressFeedback = elt.getAttributeValue("suppressStudentFeedback");
        if (tutorTheStudent != null) {
            Boolean b = new Boolean(tutorTheStudent);
            boolean bb = b;
            suppressFeedback = new Boolean(!bb).toString();
        }
        this.feedback = FeedbackEnum.fromString(suppressFeedback);
        BR_Controller ctlr = pm.getController();
        if (ctlr != null) {
            boolean FCAS = elt.getAttributeValue("firstCheckAllStates").equalsIgnoreCase("true");
            ctlr.setFirstCheckAllStatesFlag(FCAS);
        }
        pm.setOutOfOrderMessage(elt.getAttributeValue("outOfOrderMessage"));
        return brdVersion;
    }

    private void processStartNodeElement(Element startNodeElement, ProblemModel pm) {
        List messageElements = startNodeElement.getChildren("message");
        for (Element messageElement : messageElements) {
            MessageObject message = this.getMessageObject(messageElement);
            pm.addStartNodeMessage(message);
        }
        if (this.controller != null) {
            this.controller.getExampleTracer().resetTracer();
        }
    }

    private MessageObject getMessageObject(Element messageElement) {
        return MessageObject.fromElement(messageElement);
    }

    public Hashtable getFoATable() {
        return this.foAMap;
    }

    public String getRulesFromBRDFile(String problemFullName, Map<String, Integer> rulesIncidence) {
        try {
            SAXBuilder builder;
            Document document;
            String result;
            if (trace.getDebugCode("skill")) {
                trace.out("skill", "loadBRDFileIntoProblemGraph(" + problemFullName + ")");
            }
            if ((result = this.getRulesFromPreferredPath(document = (builder = new SAXBuilder()).build(problemFullName), rulesIncidence)) != null) {
                result = problemFullName + ": " + result;
            }
            return result;
        }
        catch (JDOMException je) {
            String result = problemFullName + ": " + je.toString() + "; cause: " + je.getCause();
            trace.err("DOM error reading problem file " + result);
            return result;
        }
        catch (Exception e) {
            String result = problemFullName + ": " + e;
            trace.err("Error reading problem file " + result);
            return result;
        }
    }

    private String getRulesFromPreferredPath(Document document, Map<String, Integer> rulesIncidence) {
        StringBuffer result = new StringBuffer();
        Element root = document.getRootElement();
        List edgeElts = root.getChildren("edge");
        int e = 1;
        for (Element edgeElt : edgeElts) {
            Element actionLabelElt = edgeElt.getChild("actionLabel");
            if (actionLabelElt == null) {
                result.append("Error on edge #" + e + ": no actionLabel. ");
            } else {
                String ppm = actionLabelElt.getAttributeValue("preferPathMark");
                if (Boolean.valueOf(ppm).booleanValue()) {
                    List ruleElts = edgeElt.getChildren("rule");
                    int r = 1;
                    for (Element ruleElt : ruleElts) {
                        String ruleText = ruleElt.getChildText("text");
                        String string = ruleText = ruleText == null ? "" : ruleText.trim();
                        if (ruleText.length() < 1) {
                            result.append("Error on edge #" + e + ", rule #" + r + ": no text. ");
                        } else if (!ruleText.equals("unnamed rule") && !ruleText.equals("unnamed")) {
                            Integer count = rulesIncidence.get(ruleText);
                            if (count == null) {
                                rulesIncidence.put(ruleText, new Integer(1));
                            } else {
                                rulesIncidence.put(ruleText, new Integer(count + 1));
                            }
                        }
                        ++r;
                    }
                }
            }
            ++e;
        }
        return result.toString();
    }

    private void processDocument(Document document, ProblemModel pm, RuleProduction.Catalog rpc) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Element parentElt = document.getRootElement();
        this.processStateGraphElement(parentElt, pm);
        Element groupElt = null;
        List elts = parentElt.getChildren();
        for (Element elt : elts) {
            if ("EdgesGroups".equalsIgnoreCase(elt.getName())) {
                groupElt = elt;
                continue;
            }
            this.processTopLevelElement(elt, this, pm, rpc);
        }
        ArrayList<ProblemModelEvent> creationEvents = new ArrayList<ProblemModelEvent>();
        creationEvents.addAll(this.nodeCreatedEvents);
        creationEvents.addAll(this.edgeCreatedEvents);
        BRDLoadedEvent fireMe = new BRDLoadedEvent(this, creationEvents);
        pm.fireProblemModelEvent(fireMe);
        if (groupElt != null) {
            this.processTopLevelElement(groupElt, this, pm, rpc);
        }
        this.postProcess(parentElt, pm);
    }

    private void postProcess(Element parentElt, ProblemModel pm) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "postProcess() hasEdgesGroups " + this.hasEdgesGroups + ", unorderedFlag " + this.unorderedFlag);
        }
        if (!this.hasEdgesGroups) {
            pm.getExampleTracerGraph().getGroupModel().setGroupOrdered(pm.getExampleTracerGraph().getGroupModel().getTopLevelGroup(), !this.unorderedFlag);
        }
        pm.getExampleTracerGraph().setFeedback(this.feedback);
        if (trace.getDebugCode("pm")) {
            trace.outln("pm", "setStudentBeginsHereState(" + this.studentBeginsHereStateName + "), setBehaviorRecorderMode(" + this.behaviorRecorderMode + ")");
        }
        pm.setStudentBeginsHereState(this.studentBeginsHereStateName);
        pm.setBehaviorRecorderMode(this.behaviorRecorderMode);
    }

    public ProblemModel loadBRDFileIntoProblemModel(String problemFullName, RuleProduction.Catalog ruleProductionCatalog) {
        try {
            if (trace.getDebugCode("br")) {
                trace.out("br", "READ ProblemModel WITH JDOM: " + problemFullName);
            }
            SAXBuilder builder = new SAXBuilder();
            Document document = null;
            File problemFile = new File(problemFullName);
            URI uri = problemFile.toURI();
            try {
                document = builder.build(problemFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (document == null) {
                problemFile = Utils.getFileAsResource(uri.toURL());
            }
            if (uri.getScheme().equals("jar")) {
                String uriString = uri.toString();
                String jarfilename = uriString.substring(0, uriString.lastIndexOf(".jar") + 4);
                String jarentryname = uriString.substring(uriString.lastIndexOf(".jar") + 6);
                JarFile jarfile = new JarFile(new File(jarfilename));
                JarEntry jarentry = jarfile.getJarEntry(jarentryname);
                document = builder.build(jarfile.getInputStream(jarentry));
            } else {
                document = builder.build(problemFile);
            }
            ProblemModel problemModel = new ProblemModel(null);
            if (problemModel != null) {
                String problemName = Utils.getBaseName(problemFullName);
                problemModel.reset(problemName, problemFullName);
                this.processDocument(document, problemModel, ruleProductionCatalog);
            }
            return problemModel;
        }
        catch (Exception e) {
            if (trace.getDebugCode("pm")) {
                trace.out("pm", "error reading file " + problemFullName + ": " + e);
            }
            e.printStackTrace();
            return null;
        }
    }

    public String getBehaviorRecorderMode() {
        return this.behaviorRecorderMode;
    }
}

