/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.VariableViewer;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.View.VariableViewer.SAITablePane;
import edu.cmu.pact.BehaviorRecorder.View.VariableViewer.VTITabbedPane;
import java.awt.Color;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VariableViewer
extends JSplitPane
implements TableModelListener {
    private static final long serialVersionUID = 4576272728118341908L;
    private SAITablePane saiTablePane;
    private CTAT_Launcher server;
    private VTITabbedPane vtiTabbedPane;
    private static final Color ACTIVE_COLOR = Color.WHITE;
    private static final Color INACTIVE_COLOR = new Color(240, 240, 240);

    public VariableViewer(CTAT_Launcher server) {
        this.setOrientation(0);
        this.setName("Variable Viewer Pane");
        this.server = server;
        this.initComponents();
    }

    private void initComponents() {
        BR_Controller controller = this.server.getFocusedController();
        this.saiTablePane = new SAITablePane(controller);
        this.vtiTabbedPane = new VTITabbedPane(controller.getProblemModel());
        this.saiTablePane.setName("SAI JTable");
        this.vtiTabbedPane.setName("InterpretationTabbedPane");
        this.setTopComponent(this.saiTablePane);
        this.setBottomComponent(this.vtiTabbedPane);
        this.saiTablePane.getModel().addTableModelListener(this);
        this.setComponentsEnabled(controller.getInterfaceLoaded());
    }

    public void refresh() {
        if (this.server.getFocusedController().getUniversalToolProxy() != null && this.server.getFocusedController().getUniversalToolProxy().getStudentInterfaceConnectionStatus().isConnected()) {
            this.initComponents();
            this.setComponentsEnabled(true);
        } else {
            this.initComponents();
            this.setComponentsEnabled(false);
        }
    }

    private void setComponentsEnabled(boolean enabled) {
        Color backgroundColor = enabled ? ACTIVE_COLOR : INACTIVE_COLOR;
        this.saiTablePane.setBackground(backgroundColor);
        this.vtiTabbedPane.setTableBackground(backgroundColor);
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        this.setDividerLocation(this.saiTablePane.getRowHeight() * this.saiTablePane.getModel().getRowCount() + this.saiTablePane.getRowMargin());
    }

    public void reset() {
        this.saiTablePane.reset(this.server.getFocusedController());
    }
}

