/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Preferences;

import edu.cmu.pact.Preferences.PreferencesModel;
import java.util.LinkedList;

class GroupNode
extends LinkedList
implements PreferencesModel.Node {
    private final String name;
    private final String description;
    private final String tooltipText;
    private Object editorsPanel = null;

    GroupNode(String name, String description) {
        this.name = name;
        this.description = description;
        this.tooltipText = null;
    }

    GroupNode(String name, String description, String tooltipText) {
        this.name = name;
        this.description = description;
        this.tooltipText = tooltipText;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    boolean hasPreferenceChildren() {
        return this.size() > 0 && this.get(0) instanceof PreferencesModel.Preference;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer();
        this.prettyPrint(result, 0);
        return result.toString();
    }

    private void prettyPrint(StringBuffer result, int indent) {
        for (int i = 0; i < indent; ++i) {
            result.append("  ");
        }
        result.append("Category: ");
        result.append(this.name);
        result.append('\n');
        for (Object child : this) {
            if (child instanceof GroupNode) {
                ((GroupNode)child).prettyPrint(result, indent + 1);
                continue;
            }
            for (int j = 0; j < indent + 1; ++j) {
                result.append("  ");
            }
            result.append("Preference: ");
            result.append(((PreferencesModel.Preference)child).getName());
            result.append('\n');
        }
    }

    Object getEditorsPanel() {
        return this.editorsPanel;
    }

    void setEditorsPanel(Object editorsPanel) {
        this.editorsPanel = editorsPanel;
    }
}

