/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.SocketProxy;

import edu.cmu.pact.Utilities.SocketReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.rmi.server.UID;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptRunner {
    private static Pattern substituteAttributePattern = null;
    private static Pattern substituteElementPattern = null;
    public String reportLineF;
    private static List<String> debug = Arrays.asList(System.getProperty("debug", "").split(","));
    private static volatile boolean stopping = false;
    private static boolean verbose = false;
    private static int startChar = -1;
    private static int eom = 0;
    private static final long DEFAULT_DELAY_MS = 2000L;
    private static long delayMs = 2000L;
    private static final String defaultScript = "test/ScriptRunner.xml";
    private static final String serverHost = "localhost";
    private static int clientPort = 1502;
    private static final String reportLineFmt = "%7d\t%7d\t%7d\n";
    private static final String reportHdrFmt = "%-7s\t%-7s\t%-7s\n";
    private static Pattern delimiters = Pattern.compile("([\"=><])");

    private static synchronized void stopClient(Client client) {
        stopping = true;
        if (client != null) {
            client.quit();
        }
    }

    private static boolean isStopping() {
        return stopping;
    }

    public static void main(String[] args) {
        String host = serverHost;
        int port = clientPort;
        String url = "http://" + host + ":" + port + "/";
        Class<Client> clientClass = Client.class;
        String scriptName = defaultScript;
        int nThreads = 1;
        boolean printReport = false;
        int i = 0;
        try {
            File script;
            block23: for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
                switch (args[i].charAt(1)) {
                    case 'C': 
                    case 'c': {
                        if (debug.contains("startChar")) {
                            System.err.println("+startChar+ -c arg is \"" + args[i + 1] + "\"");
                        }
                        int j = 0;
                        while (true) {
                            char c = args[++i].charAt(j);
                            startChar = c;
                            if (c != '\"' && startChar != 39) break;
                            ++j;
                        }
                        if (args[i].length() > j) continue block23;
                        startChar = -1;
                        continue block23;
                    }
                    case 'D': 
                    case 'd': {
                        try {
                            delayMs = Long.parseLong(args[++i]);
                            continue block23;
                        }
                        catch (NumberFormatException nfe) {
                            throw new Exception("bad delay ms: " + nfe);
                        }
                    }
                    case 'E': 
                    case 'e': {
                        try {
                            eom = Integer.parseInt(args[++i], 16);
                            continue block23;
                        }
                        catch (NumberFormatException nfe) {
                            throw new Exception("bad hex value for eom: " + nfe);
                        }
                    }
                    case 'H': 
                    case 'h': {
                        host = args[++i];
                        continue block23;
                    }
                    case 'P': 
                    case 'p': {
                        port = Integer.parseInt(args[++i]);
                        continue block23;
                    }
                    case 'R': 
                    case 'r': {
                        printReport = true;
                        continue block23;
                    }
                    case 'S': 
                    case 's': {
                        ScriptRunner.createSubstitutionPatterns(args[++i]);
                        continue block23;
                    }
                    case 'T': 
                    case 't': {
                        try {
                            nThreads = Integer.parseInt(args[++i]);
                            continue block23;
                        }
                        catch (NumberFormatException nfe) {
                            throw new Exception("bad thread count: " + nfe);
                        }
                    }
                    case 'U': 
                    case 'u': {
                        url = args[++i];
                        clientClass = HttpClient.class;
                        eom = -1;
                        continue block23;
                    }
                    case 'V': 
                    case 'v': {
                        verbose = true;
                        continue block23;
                    }
                    case '?': {
                        ScriptRunner.usageExit("Help message.");
                        continue block23;
                    }
                    default: {
                        ScriptRunner.usageExit("Invalid option '" + args[i].charAt(1) + "'.");
                    }
                }
            }
            if (args.length > i) {
                scriptName = args[i++];
            }
            if (!(script = new File(scriptName)).canRead() || !script.isFile()) {
                throw new IOException(scriptName + " does not exist or is not readable");
            }
        }
        catch (Exception e) {
            ScriptRunner.usageExit("Error processing command-line arguments: " + e + ".");
        }
        ScriptRunner.promptForInput("Press Enter to start " + nThreads + " thread(s) sending " + (clientClass == HttpClient.class ? "HTTP" : "TCP") + " messsages from script " + scriptName + "\nevery " + delayMs + " ms. Press Enter a 2nd time to stop.");
        final Client[] clients = new Client[nThreads];
        for (int t = 0; t < nThreads; ++t) {
            clients[t] = clientClass == HttpClient.class ? new HttpClient(t, url, scriptName) : new Client(t, host, port, scriptName);
            clients[t].start();
        }
        Thread awaitStopSignal = new Thread(){

            @Override
            public void run() {
                ScriptRunner.promptForInput(null);
                for (Client client : clients) {
                    ScriptRunner.stopClient(client);
                }
            }
        };
        awaitStopSignal.start();
        int nIncompleteResponseThreads = 0;
        if (verbose || printReport) {
            System.out.printf(reportHdrFmt, "Thread#", "No.Sent", "No.Acks");
        }
        for (Client client : clients) {
            try {
                client.join();
                if (verbose || printReport) {
                    client.report(System.out);
                }
                if (client.nReceived >= client.nSent) continue;
                ++nIncompleteResponseThreads;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        awaitStopSignal.interrupt();
        System.out.printf("Number of client threads missing responses: %d\n", nIncompleteResponseThreads);
    }

    private static void createSubstitutionPatterns(String tagOrAttrName) {
        if (tagOrAttrName == null || tagOrAttrName.length() < 1) {
            throw new IllegalArgumentException("Missing or null element or attribute for substitution");
        }
        Matcher m = delimiters.matcher(tagOrAttrName);
        if (m.find()) {
            throw new IllegalArgumentException("Illegal delimiter \"" + m.group() + "\" in element or attribute for substitution");
        }
        substituteAttributePattern = Pattern.compile("(^.* " + tagOrAttrName + "=\")([^\"][^\"]*)(\".*$)");
        substituteElementPattern = Pattern.compile("(^.*<" + tagOrAttrName + ">)([^<][^<]*)(</" + tagOrAttrName + ">.*$)");
    }

    private static int promptForInput(String prompt) {
        if (prompt != null) {
            System.err.println(prompt);
        }
        try {
            block2: while (true) {
                byte[] chars = new byte[10];
                int nChars = System.in.read(chars);
                int i = 0;
                while (true) {
                    if (i >= nChars) continue block2;
                    if (chars[i] == 13 || chars[i] == 10) {
                        if (debug.contains("input")) {
                            System.err.printf("promptForInput buffer %s returning '%c'\n", Arrays.asList(new byte[][]{chars}).toString(), chars[i]);
                        }
                        return chars[i];
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            if (!Thread.interrupted()) {
                System.err.println("Error reading stdin for prompt \"+prompt+\": " + e);
                e.printStackTrace();
            }
            return -1;
        }
    }

    private static void usageExit(String errMsg) {
        if (errMsg != null) {
            System.err.printf("%s\n", errMsg);
        }
        System.err.println("Usage:\n   java -cp ... " + ScriptRunner.class.getName() + " [-?] [-v] [-r] [-h host] [-p port] [-u url] \\\n      [-s substitute] [-c startChar] [-t threads] [-d delay] [-e eom] [script]\nwhere--\n   -? means to print this help message;\n   -v (verbose) means to print additional information;\n   -r means to print a one-line report for each client thread;\n   host is the server for a TCP socket connection (default " + serverHost + ");\n   port is the port for a TCP socket connection (default " + clientPort + ");\n   url is the logging service URL for an HTTP connection (no default);\n   substitute is the name of an element or attribute whose value should be replaced with a value unique\n      to each thread (e.g., SessionID); omit delimiters '=', '<', etc. (no default);\n   startChar means omit characters prior to this one on input lines; e.g., if input lines have a\n      timestamp before the desired XML data, use \"-c <\" to start at the XML left angle bracket;\n   threads is the number of message-sending threads to launch (default 1);\n   delay is the wait time between messages, in milliseconds (default " + 2000L + ");\n   eom is the end-of-message character, entered as 2 hex digits;\n      use \"-1\" for no terminator; the default is 0x" + Integer.toHexString(eom) + ";\n   script is the script file name (default " + defaultScript + ").");
        System.exit(2);
    }

    protected void scriptFinished() {
    }

    static class HttpClient
    extends Client {
        protected final String urlStr;

        HttpClient(int threadNo, String urlStr, String scriptName) {
            super(threadNo, null, -1, scriptName);
            this.urlStr = urlStr;
        }

        @Override
        protected void init() {
        }

        @Override
        protected String sendMsg(String msg) {
            String response = null;
            HttpURLConnection conn = null;
            URL url = null;
            try {
                url = new URL(this.urlStr);
                conn = this.openConnection(url);
                OutputStream os = conn.getOutputStream();
                os.write(msg.getBytes("UTF-8"));
                if (eom >= 0) {
                    os.write(eom);
                }
                os.flush();
                ++this.nSent;
                os.close();
            }
            catch (Exception ex) {
                System.err.println("HttpClient[" + this.threadNo + "].sendMsg() error sending " + this.scriptName + " line #" + this.lineNo + ": " + ex + (ex.getCause() == null ? "" : "; cause: " + ex.getCause()));
                ex.printStackTrace();
            }
            int charNo = 0;
            try {
                InputStream is = conn.getInputStream();
                ByteArrayOutputStream readBuf = new ByteArrayOutputStream();
                int c = is.read();
                while (c >= 0) {
                    readBuf.write(c);
                    ++charNo;
                    c = is.read();
                }
                response = readBuf.toString("UTF-8");
                if (debug.contains("http")) {
                    System.err.println("content of " + this.urlStr + " response;\n  headers " + conn.getHeaderFields() + "\n  body: " + (response == null ? null : response.trim()));
                }
                if (200 == conn.getResponseCode()) {
                    ++this.nReceived;
                }
                is.close();
                if (verbose) {
                    System.out.printf("line %3d: server response code %d, body \"%s\"\n", this.lineNo, conn.getResponseCode(), response == null ? null : response.trim());
                }
                return response;
            }
            catch (Exception ex) {
                System.err.println("HttpClient[" + this.threadNo + "] error getting response for " + this.scriptName + " line #" + this.lineNo + ": received " + charNo + " bytes" + ex + (ex.getCause() == null ? "" : "; cause: " + ex.getCause()));
                ex.printStackTrace();
                response = null;
                return response;
            }
        }

        private HttpURLConnection openConnection(URL url) throws IOException {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.connect();
            return conn;
        }
    }

    static class Client
    extends Thread {
        protected int nSent = 0;
        protected int nReceived = 0;
        protected String scriptName;
        private Listener listener;
        private final int clientPort;
        private final String host;
        private Socket outSocket = null;
        private PrintWriter outStream = null;
        protected long lineNo = 0L;
        protected final int threadNo;
        private String substValue;

        Client(int threadNo, String h, int p, String scriptName) {
            this.threadNo = threadNo;
            this.clientPort = p;
            this.host = h;
            this.scriptName = scriptName;
            try {
                this.init();
            }
            catch (Exception e) {
                System.out.println("error creating client for host " + h + ", port " + p + ": " + e);
            }
            if (substituteAttributePattern != null) {
                this.substValue = "S" + new UID().toString();
            }
        }

        protected void init() throws Exception {
            InetAddress addr = InetAddress.getByName(this.host);
            this.outSocket = new Socket(addr, this.clientPort);
            this.outStream = new PrintWriter(this.outSocket.getOutputStream(), false);
            this.listener = new Listener(this.getOutSocket(), this);
            this.listener.start();
        }

        @Override
        public void run() {
            try {
                BufferedReader script = new BufferedReader(new FileReader(this.scriptName));
                if (debug.contains("line")) {
                    System.err.printf("%3d: +line+ scriptName %s, script %s\n", this.lineNo, this.scriptName, script);
                }
                String msg = "teste";
                while (!ScriptRunner.isStopping() && (msg = script.readLine()) != null) {
                    int startCharPos;
                    ++this.lineNo;
                    if (msg.length() < 1) continue;
                    if (debug.contains("line")) {
                        System.err.printf("%3d: +line+ %s\n", this.lineNo, msg);
                    }
                    if (startChar >= 0 && (startCharPos = msg.indexOf(startChar)) >= 0) {
                        msg = msg.substring(startCharPos);
                    }
                    msg = this.substituteTagOrAttribute(msg);
                    this.sendMsg(msg);
                    this.delay(delayMs);
                }
                this.scriptFinished();
            }
            catch (IOException ioe) {
                System.out.println("Error on file " + this.scriptName);
                ioe.printStackTrace(System.out);
            }
        }

        protected String substituteTagOrAttribute(String msg) {
            String result = msg;
            if (substituteElementPattern != null) {
                result = this.substitute(substituteElementPattern, msg);
            }
            if (substituteAttributePattern != null && result.equals(msg)) {
                result = this.substitute(substituteAttributePattern, msg);
            }
            return result;
        }

        private String substitute(Pattern substPattern, String text) {
            Matcher m = substPattern.matcher(text);
            if (!m.matches()) {
                return text;
            }
            return m.group(1) + this.substValue + m.group(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scriptFinished() throws IOException {
            if (this.outStream != null) {
                this.outStream.close();
            }
            if (this.outSocket != null) {
                this.outSocket.close();
            }
            Client client = this;
            synchronized (client) {
                this.notifyAll();
            }
        }

        protected int delay(long delayMs) {
            if (delayMs < 1L) {
                return 0;
            }
            int interruptCount = 0;
            long now = System.currentTimeMillis();
            long then = now + delayMs;
            while (now < then) {
                try {
                    Thread.sleep(then - now);
                    break;
                }
                catch (InterruptedException ie) {
                    ++interruptCount;
                    if (ScriptRunner.isStopping()) {
                        return interruptCount;
                    }
                    now = System.currentTimeMillis();
                }
            }
            if (debug.contains("delay")) {
                System.err.printf("%3d: delayMs(%d) returns %d\n", this.lineNo, delayMs, interruptCount);
            }
            return interruptCount;
        }

        protected String sendMsg(String msg) {
            this.outStream.printf("%s\u0000", msg);
            this.outStream.flush();
            ++this.nSent;
            return null;
        }

        public void report(PrintStream ps) {
            ps.printf(ScriptRunner.reportLineFmt, this.threadNo, this.nSent, this.nReceived);
        }

        public synchronized Socket getOutSocket() {
            return this.outSocket;
        }

        protected void quit() {
            this.interrupt();
            if (this.listener != null) {
                this.listener.interrupt();
            }
        }
    }

    static class Listener
    extends Thread {
        private final Socket sock;
        private final Client client;

        Listener(Socket sock, Client client) {
            this.sock = sock;
            this.client = client;
        }

        @Override
        public void run() {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "UTF-8"));
                int i = 0;
                while (!ScriptRunner.isStopping()) {
                    System.out.println("\nListener call #" + ++i + " to readToEom()");
                    String msg = SocketReader.readToEom(in, eom);
                    if (verbose) {
                        System.out.println("\nListener received:\n" + msg);
                    }
                    if (msg.length() < 1) {
                        ScriptRunner.stopClient(this.client);
                        continue;
                    }
                    ++this.client.nReceived;
                }
            }
            catch (Exception e) {
                System.out.println("error from input reader: " + e);
                e.printStackTrace(System.out);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.println("error closing input reader: " + ioe);
                }
                try {
                    if (this.sock != null) {
                        this.sock.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.println("error closing socket: " + ioe);
                }
            }
        }
    }
}

