/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.pact.BehaviorRecorder.Controller.AuthorHTTPSession;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.SocketProxy.ActionHandler;
import edu.cmu.pact.SocketProxy.HTTPToolProxy;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pact.CommWidgets.RemoteProxy;

public class Collaborators {
    private static final String ERROR_TYPE = "ErrorType";
    private static final String COLLABORATION_FAILURE = "Collaboration Failure";
    public static final long WAIT_TIME = 120000L;
    private Map<String, Collaborator> collabs = null;
    private int nReady = 0;
    private int nFinished = 0;
    private final String schoolName;
    private static final String UsernameFmt = "Collaborator_%d_of_%d_%s";
    private static final String SessionIDFmt = "CollabSession_%d_of_%d_%s_%s";
    private static final Pattern SessionIDPattern = Pattern.compile("CollabSession_([0-9]+)_of_([0-9]+)_([^_]+)_(.*)");
    public static DateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSS");
    public static final String COLLABORATORS_SET_PREFS_PROP = "collaborators";
    public static final String PARTICIPANT_HAS_LEFT = "A participant has left. Please close the tutor.";
    private static final Pattern CollaboratorClassName1 = Pattern.compile("collaborators[^(]*\\( *([^,()]+)", 2);
    private static final Pattern CollaboratorClassName2 = Pattern.compile("(?:,([^,()]+))?(?:,([^,()]+))*\\)");
    private static final String UseridListDelimiter = ",";
    private static final Pattern UseridListDelimiterPattern = Pattern.compile(",");

    private Collaborators(String schoolName, List<String> userids, TSLauncherServer.Session mySession, int myPosition) {
        Collaborator myCollab;
        this.schoolName = schoolName;
        this.collabs = new LinkedHashMap<String, Collaborator>();
        for (int i = 0; i < userids.size(); ++i) {
            String userid = userids.get(i);
            this.collabs.put(userid.trim().toLowerCase(), new Collaborator(userid, i + 1));
        }
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "Collaborators.<init> map of collabs " + this.collabs);
        }
        if ((myCollab = this.getCollaborator(mySession.getUserGuid())) == null) {
            throw new IllegalArgumentException("No collaborator found for session[" + mySession + "].userGuid " + mySession.getUserGuid());
        }
        myCollab.setSession(mySession);
        myCollab.setPosition(myPosition);
    }

    public boolean isEmpty() {
        return this.collabs.isEmpty();
    }

    public Collaborator getCollaborator(TSLauncherServer.Session sess, boolean requireSessionIdMatch) {
        Collaborator collab;
        if (trace.getDebugCode("collab")) {
            trace.outNT("collab", "Collab.getCollaborator() sess.userGuid " + sess.getUserGuid() + ", sess.guid " + sess.getGuid() + ";\n  this " + this);
        }
        if ((collab = this.getCollaborator(sess.getUserGuid())) == null) {
            return null;
        }
        if (!requireSessionIdMatch) {
            return collab;
        }
        if (collab.session != null && sess.getGuid().equals(collab.session.getGuid())) {
            return collab;
        }
        return null;
    }

    State getState() {
        State result = this.nReady < 1 ? State.New : (this.nFinished < 1 ? (this.nReady < this.collabs.size() ? State.Awaiting : State.Running) : State.Finishing);
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "getState() result " + (Object)((Object)result) + ", nReady " + this.nReady + ", nFinished " + this.nFinished + ", size() " + this.collabs.size());
        }
        return result;
    }

    String getSchoolName() {
        return this.schoolName;
    }

    private int enqueue(MessageObject mo, Collaborator myCollab) {
        int count = 0;
        Object oldActor = mo.getProperty("Actor");
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "enqueue(" + mo.getMessageType() + ") oldActor " + oldActor + " " + this);
        }
        if (!Collaborators.isMsgToBeShared(mo)) {
            return 0;
        }
        for (Collaborator collab : this.collabs.values()) {
            ActionHandler handler = null;
            HTTPToolProxy htp = null;
            BR_Controller controller = collab.session.getController();
            if (controller == null) {
                if (collab.session instanceof AuthorHTTPSession) {
                    htp = ((AuthorHTTPSession)collab.session).getToolProxy();
                }
            } else {
                RemoteProxy proxy = controller.getRemoteProxy();
                ActionHandler actionHandler = handler = proxy != null ? proxy.getActionHandler() : null;
            }
            if (handler == null && htp == null) {
                trace.err(String.format("%s.enqueue(): cannot retrieve handler or htp for collaborator %s from session %s", this.getClass().getSimpleName(), collab.toString(), collab.session.toString()));
                continue;
            }
            String actor = "Student" + Integer.toString(myCollab.position);
            mo.setProperty("Actor", actor);
            if (myCollab.equals(collab)) {
                if (handler != null) {
                    handler.enqueue(mo);
                }
            } else {
                MessageObject moToShare = null;
                if (!mo.isMessageType("InterfaceAction")) {
                    moToShare = mo.copy();
                    moToShare.setTransactionId(MessageObject.makeTransactionId());
                    moToShare.setProperty("trigger", "USER");
                    moToShare.setProperty("subtype", actor);
                    moToShare.setProperty("Action", "display:5000");
                } else {
                    moToShare = PseudoTutorMessageBuilder.buildToolInterfaceAction(mo.getSelection(), mo.getAction(), mo.getInput(), "USER", actor);
                }
                if (controller != null) {
                    controller.getUniversalToolProxy().handleMessageByPlatform(moToShare, true);
                    handler.enqueue(moToShare);
                } else {
                    htp.sendXMLString(moToShare.toString());
                }
            }
            if (trace.getDebugCode("collab")) {
                trace.outNT("collab", "enqueued to session[" + count + "] " + collab.session.getGuid());
            }
            ++count;
        }
        mo.setProperty("Actor", oldActor);
        return count;
    }

    public static boolean isMsgToBeShared(MessageObject mo) {
        if ("InterfaceAction".equalsIgnoreCase(mo.getMessageType())) {
            return true;
        }
        if ("UntutoredAction".equalsIgnoreCase(mo.getMessageType())) {
            return true;
        }
        if ("InterfaceForceDisconnect".equalsIgnoreCase(mo.getMessageType())) {
            return true;
        }
        return "TutoringServiceError".equalsIgnoreCase(mo.getMessageType()) && COLLABORATION_FAILURE.equals(mo.getProperty(ERROR_TYPE));
    }

    public static Collaborators create(TSLauncherServer.Session session, MessageObject setPrefs) throws NotReadyException {
        int[] rtnPosition = new int[]{-1};
        List<String> userids = Collaborators.getUserids(setPrefs, rtnPosition);
        if (userids.size() < 2) {
            return null;
        }
        int position = rtnPosition[0];
        String schoolName = (String)setPrefs.getProperty("school_name");
        Collaborators result = session.getLauncherServer().getAllCollaborators().add(schoolName, userids, session, position);
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "Collaborators.create(" + schoolName + UseridListDelimiter + userids + ") session " + session + ", result\n  " + result);
        }
        Collaborator self = result.getCollaborator(session, true);
        self.setSetPreferencesMessage(setPrefs);
        if (!(session instanceof AuthorHTTPSession) || !((AuthorHTTPSession)session).hasRemoteTracer()) {
            result.waitForOtherCollaborators();
        }
        return result;
    }

    public static boolean editSetPreferences(MessageObject setPrefs, String collabID, int teamSize, String sessionID) {
        if (Utils.isRuntime()) {
            return false;
        }
        int position = -1;
        int i = 0;
        try {
            String cid;
            int total;
            Matcher m = SessionIDPattern.matcher(sessionID);
            boolean isCollabSession = m.matches();
            if (trace.getDebugCode("collab")) {
                trace.out("collab", String.format("Collab.editSetPreferences(): sessionID %s %s match", sessionID, isCollabSession ? "is" : "not"));
            }
            if (!isCollabSession) {
                return false;
            }
            position = Integer.parseInt(m.group(++i));
            if ((total = Integer.parseInt(m.group(++i))) != teamSize) {
                throw new IllegalArgumentException("Collaborators session " + sessionID + " not match teamSize " + teamSize);
            }
            if (!(cid = m.group(++i)).equals(collabID)) {
                throw new IllegalArgumentException("Collaborators session " + sessionID + " not match collabID " + collabID);
            }
            String origID = m.group(++i);
            if (trace.getDebugCode("collab")) {
                trace.out("collab", String.format("Collab.editSetPreferences(%s): position %d, total %d, cid %s, origID %s", setPrefs == null ? null : setPrefs.summary(), position, total, cid, origID));
            }
        }
        catch (Exception e) {
            trace.errStack("Error parsing collaborator session id \"" + sessionID + "\" at group " + i + ": " + e, e);
            return false;
        }
        String studentName = String.format(UsernameFmt, position, teamSize, collabID);
        setPrefs.setProperty("user_guid", studentName);
        String schoolName = "school_" + collabID;
        setPrefs.setProperty("school_name", schoolName);
        i = 1;
        StringBuilder sb = new StringBuilder(String.format(UsernameFmt, i, teamSize, collabID));
        while (++i <= teamSize) {
            sb.append(UseridListDelimiter).append(String.format(UsernameFmt, i, teamSize, collabID));
        }
        setPrefs.setProperty(COLLABORATORS_SET_PREFS_PROP, sb.toString());
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "Collab.editSetPreferences() to rtn true: student name " + studentName + ", school name " + schoolName + ", collaborators " + sb);
        }
        return true;
    }

    public static String editSessionIDForCollaboration(String originalID, String collabID, int position, int teamSize) {
        String result = originalID;
        if (teamSize > 1) {
            result = String.format(SessionIDFmt, position, teamSize, collabID, originalID);
        }
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "editSessionIDForCollaboration() returns " + result);
        }
        return result;
    }

    public static List<String> getUserids(MessageObject setPrefs, int[] rtnPosition) {
        String myUserid = (String)setPrefs.getProperty("user_guid");
        List<String> userids = Collaborators.getUseridsFromCollaboratorsProperty(setPrefs, myUserid, rtnPosition);
        if (userids == null) {
            userids = Collaborators.getUseridsFromCondition(setPrefs, myUserid, rtnPosition);
        }
        if (userids == null) {
            String className = (String)setPrefs.getProperty("class_name");
            userids = Collaborators.getUseridsFromClassName(className, myUserid, rtnPosition);
        }
        if (userids == null) {
            userids = new ArrayList<String>(1);
        }
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "getUserids() for " + myUserid + " returns " + userids + ", position " + (rtnPosition == null ? null : String.valueOf(rtnPosition[0])));
        }
        return userids;
    }

    private static List<String> getUseridsFromCollaboratorsProperty(MessageObject setPrefs, String myUserid, int[] rtnPosition) {
        String userIDstring = (String)setPrefs.getProperty(COLLABORATORS_SET_PREFS_PROP);
        if (userIDstring == null || userIDstring.length() < 1) {
            return null;
        }
        return Collaborators.parseUserIDsFromTeamList(userIDstring, myUserid, rtnPosition);
    }

    private static List<String> getUseridsFromCondition(MessageObject setPrefs, String myUserid, int[] rtnPosition) {
        for (int i = 0; i < 10; ++i) {
            String type = (String)setPrefs.getProperty("study_condition_type" + i);
            if (type == null || !COLLABORATORS_SET_PREFS_PROP.equalsIgnoreCase(type)) continue;
            String name = (String)setPrefs.getProperty("study_condition_name" + i);
            if (name == null) {
                trace.err("Message has property study_condition_type" + i + " with value " + type + " but null " + "study_condition_name" + i + " property");
                continue;
            }
            return Collaborators.parseUserIDsFromTeamList(name, myUserid, rtnPosition);
        }
        return null;
    }

    private static List<String> parseUserIDsFromTeamList(String userIDstring, String myUserid, int[] rtnPosition) {
        if (myUserid != null) {
            myUserid = myUserid.trim().toLowerCase();
        }
        if (rtnPosition != null) {
            rtnPosition[0] = -1;
        }
        String[] userIDs = UseridListDelimiterPattern.split(userIDstring.toLowerCase());
        ArrayList<String> result = new ArrayList<String>(userIDs.length);
        for (int j = 0; j < userIDs.length; ++j) {
            String trimmed = userIDs[j].trim();
            if (trimmed == null || trimmed.length() < 1) continue;
            result.add(trimmed);
            if (!trimmed.equals(myUserid) || rtnPosition == null) continue;
            rtnPosition[0] = result.size();
        }
        return result;
    }

    private synchronized void waitForOtherCollaborators() throws NotReadyException {
        long now = System.currentTimeMillis();
        long end = now + 120000L;
        while (this.nReady < this.collabs.size() && now < end) {
            Exception ex = null;
            if (trace.getDebugCode("collab")) {
                trace.printStack("collab", String.format("Collaborators[%s].waitForOtherCs() in loop: nReady %d, collabs[%s].size %d, to wait %d ms", trace.nh(this), this.nReady, trace.nh(this.collabs), this.collabs.size(), end - now));
            }
            try {
                this.wait(end - now);
            }
            catch (Exception e) {
                ex = e;
            }
            now = System.currentTimeMillis();
            if (!trace.getDebugCode("collab")) continue;
            trace.outNT("collab", "Collaborators.waitForOtherCs() wait ended with " + (end - now) + " ms left; exception " + ex + ", cause " + (ex == null ? null : ex.getCause()));
        }
        if (trace.getDebugCode("collab")) {
            Object[] objectArray = new Object[5];
            objectArray[0] = trace.nh(this);
            objectArray[1] = this.nReady;
            objectArray[2] = trace.nh(this.collabs);
            objectArray[3] = this.collabs.size();
            now = System.currentTimeMillis();
            objectArray[4] = end - now;
            trace.out("collab", String.format("Collaborators[%s].waitForOtherCs() exited loop: nReady %d, collabs[%s].size %d, ms left %d", objectArray));
        }
        if (this.nReady < this.collabs.size()) {
            LinkedList<String> absences = new LinkedList<String>();
            for (Collaborator collab : this.collabs.values()) {
                if (collab.session != null) continue;
                absences.add(collab.userid);
            }
            throw new NotReadyException("nReady " + this.nReady + ", collabs.size() " + this.collabs.size(), absences);
        }
        this.notifyAll();
    }

    private static List<String> getUseridsFromClassName(String className, String myUserid, int[] position) {
        if (position != null && position.length > 0) {
            position[0] = -1;
        }
        if (className == null) {
            return null;
        }
        className = className.trim();
        myUserid = myUserid.trim();
        Matcher m = CollaboratorClassName1.matcher(className);
        int p = 1;
        int end = -1;
        String group = "";
        boolean matched = m.find();
        if (matched) {
            end = m.end(1);
            group = m.group(1).trim();
        }
        if (!matched || m.group(p) == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(group.trim().toLowerCase());
        if (trace.getDebugCode("collabclass")) {
            trace.out("collabclass", "Collab.getUseridsFromClassName(" + className + ", " + myUserid + ") found1 " + matched + ", end " + end);
        }
        boolean foundMyUserid = false;
        if (myUserid.length() > 0 && myUserid.equalsIgnoreCase(group)) {
            foundMyUserid = true;
            if (position != null && position.length > 0) {
                position[0] = p;
            }
        }
        m = CollaboratorClassName2.matcher(className);
        matched = m.find(end);
        if (trace.getDebugCode("collabclass")) {
            trace.out("collabclass", "Collab.getUseridsFromClassName(" + className + ", " + myUserid + ") found2 " + matched);
        }
        if (!matched) {
            if (position != null && position.length > 0) {
                position[0] = -1;
            }
            return null;
        }
        ++p;
        while (matched) {
            block17: {
                try {
                    end = m.end(1);
                    group = m.group(1);
                    if (trace.getDebugCode("collabclass")) {
                        trace.out("collabclass", "Collab.getUseridsFromClassName() end " + end + ", group(1) " + group);
                    }
                    if (group == null) break;
                    group = group.trim().toLowerCase();
                    result.add(group.trim().toLowerCase());
                    if (myUserid.length() > 0 && myUserid.equalsIgnoreCase(group)) {
                        foundMyUserid = true;
                        if (position != null && position.length > 0) {
                            position[0] = p;
                        }
                    }
                    matched = m.find(end);
                    if (!trace.getDebugCode("collabclass")) break block17;
                    trace.out("collabclass", "Collab.getUseridsFromClassName(" + className + ", " + myUserid + ") found3 " + matched);
                }
                catch (Exception e) {
                    if (!trace.getDebugCode("collabclass")) break;
                    trace.out("collabclass", "Collab.getUseridsFromClassName() error at group(" + p + "): " + e);
                    break;
                }
            }
            ++p;
        }
        if (trace.getDebugCode("collabclass")) {
            trace.out("collabclass", "Collab.getUseridsFromClassName(..., " + myUserid + ") result " + result + ", foundMyUserid " + foundMyUserid + ", position " + (position == null ? "null" : Integer.toString(position[0])));
        }
        return result;
    }

    public String toString() {
        return super.toString() + "{school " + this.schoolName + ", state " + (Object)((Object)this.getState()) + ", nReady " + this.nReady + ", nFinished " + this.nFinished + "\n  " + this.collabs + "}";
    }

    public static String makeKeyWithNamespace(String namespace, String name) {
        namespace = namespace == null ? "" : namespace;
        name = name == null ? "" : name;
        return namespace.toLowerCase().trim() + ' ' + name.toLowerCase().trim();
    }

    public static boolean abort(BR_Controller controller, String callingSessionID, String message) {
        TSLauncherServer ls = null;
        if (controller == null || controller.getLauncher() == null || (ls = controller.getLauncher().getLauncherServer()) == null) {
            return false;
        }
        TSLauncherServer.Session callingSession = ls.getSession(callingSessionID);
        return Collaborators.abort(callingSession, message);
    }

    public static boolean abort(TSLauncherServer.Session callingSession, String message) {
        TSLauncherServer ls = callingSession.getLauncherServer();
        Collaborator collab = ls.getAllCollaborators().findCollaborator(callingSession);
        if (collab == null) {
            return false;
        }
        MessageObject mo = Collaborators.makeAbortMessage(message);
        ls.updateTimeStamp(callingSession.getGuid());
        mo.setTransactionInfo(ls.createTransactionInfo(callingSession.getGuid()));
        return ls != null && ls.enqueueToCollaborators(callingSession.getGuid(), mo) > 0;
    }

    private static MessageObject makeAbortMessage(String message) {
        MessageObject newMessage = MessageObject.create("TutoringServiceError", "SendNoteProperty");
        newMessage.setProperty(ERROR_TYPE, COLLABORATION_FAILURE);
        newMessage.setProperty("Details", message);
        return newMessage;
    }

    public Collaborator getCollaborator(String userid) {
        Collaborator result = null;
        if (userid != null) {
            result = this.collabs.get(userid.trim().toLowerCase());
        }
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "Collaborators.getCollaborator(" + userid + ") => " + result);
        }
        return result;
    }

    public static void remove(TSLauncherServer.Session sess) {
        TSLauncherServer ls;
        if (sess == null || (ls = sess.getLauncherServer()) == null) {
            return;
        }
        ls.getAllCollaborators().removeSession(sess);
    }

    public static boolean handleTutoringServiceErrorMessage(MessageObject mo, BR_Controller controller) {
        SingleSessionLauncher launcher;
        if (controller == null || (launcher = controller.getLauncher()) == null) {
            return false;
        }
        Collaborator collab = launcher.findCollaborator();
        if (trace.getDebugCode("collab")) {
            trace.out("collab", "handleTutoringServiceErrorMessage() findCollaborator() returns " + collab);
        }
        if (collab == null) {
            return false;
        }
        controller.handleMessageUTP(mo);
        String sessionID = null;
        if (collab.session instanceof TSLauncherServer.Session) {
            sessionID = collab.session.getGuid();
        }
        if (sessionID == null) {
            return false;
        }
        if (launcher.getLauncherServer() != null) {
            launcher.getLauncherServer().removeSession(sessionID);
        }
        return true;
    }

    public List<String> getSessionIds() {
        ArrayList<String> sessionIds = new ArrayList<String>(this.collabs.size());
        for (Collaborator collab : this.collabs.values()) {
            if (collab.userid == null || collab.userid.length() < 1) continue;
            if (collab.session == null) {
                sessionIds.add("");
                continue;
            }
            sessionIds.add(collab.session.getGuid());
        }
        return sessionIds;
    }

    public boolean nowRunning() {
        return this.getState() == State.Running;
    }

    public int sendAllSetPreferences() {
        int nSent = 0;
        for (Collaborator collab : this.collabs.values()) {
            HTTPToolProxy htp;
            HTTPToolProxy hTTPToolProxy = htp = collab.session instanceof AuthorHTTPSession ? ((AuthorHTTPSession)collab.session).getToolProxy() : null;
            if (htp == null) {
                trace.err(String.format("%.sendAllSetPreferences(): cannot retrieve htp for collaborator %s from session %s", this.getClass().getSimpleName(), collab.toString(), collab.session.toString()));
                continue;
            }
            MessageObject setPrefs = collab.getSetPreferencesMessage();
            if (setPrefs == null) {
                trace.err(String.format("%.sendAllSetPreferences(): null SetPreferences for collaborator %s from session %s", this.getClass().getSimpleName(), collab.toString(), collab.session.toString()));
                continue;
            }
            htp.sendXMLString(setPrefs.toString());
            collab.setSetPreferencesMessage(null);
            if (trace.getDebugCode("collab")) {
                trace.out("collab", "sendAllSetPreferences() enqueued SetPrefs to session[" + nSent + "] " + collab.session.getGuid());
            }
            ++nSent;
        }
        return nSent;
    }

    public class Collaborator {
        private final String userid;
        private int position;
        TSLauncherServer.Session session = null;
        private MessageObject setPreferencesMessage = null;

        private Collaborator(String userid, int position) {
            this.userid = userid;
            this.position = position;
        }

        public String toString() {
            return "(" + this.userid + ", " + this.position + ", " + this.session + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSession(TSLauncherServer.Session session) {
            Collaborators collaborators = Collaborators.this;
            synchronized (collaborators) {
                TSLauncherServer.Session oldSession = this.session;
                if (session != null && this.session == null) {
                    Collaborators.this.nReady++;
                }
                this.session = session;
                Collaborators.this.notifyAll();
                if (trace.getDebugCode("collab")) {
                    trace.printStack("collab", String.format("Collaborators[%s].collab[%s].setSession(%s).notify() nReady %d, oldSession %s", Collaborators.this, this, session, Collaborators.this.nReady, oldSession));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collaborators remove() {
            Collaborators collaborators = Collaborators.this;
            synchronized (collaborators) {
                if (this.session != null) {
                    Collaborators.this.nFinished++;
                }
                this.session = null;
                Collaborators.this.collabs.remove(this.userid.trim().toLowerCase());
                return Collaborators.this;
            }
        }

        private int enqueueToCollaborators(MessageObject mo) {
            return Collaborators.this.enqueue(mo, this);
        }

        Collaborators getCollaborators() {
            return Collaborators.this;
        }

        private Thread abort(final String message) {
            if (this.session == null) {
                return null;
            }
            class Abort
            implements Runnable {
                Abort() {
                }

                @Override
                public void run() {
                    if (Collaborator.this.session.getController() != null) {
                        MessageObject newMessage = Collaborators.makeAbortMessage(message);
                        if (trace.getDebugCode("collab")) {
                            trace.out("collab", "Collaborator.abort(" + message + ") " + this);
                        }
                        Collaborator.this.session.getController().handleMessageUTP(newMessage);
                    }
                }
            }
            Thread result = new Thread((Runnable)new Abort(), "Abort-" + this.session.getGuid());
            result.start();
            return result;
        }

        String getUserid() {
            return this.userid;
        }

        int getPosition() {
            return this.position;
        }

        void setPosition(int position) {
            if (this.position != position) {
                try {
                    throw new IllegalArgumentException("old position " + this.position + " != new " + position);
                }
                catch (IllegalArgumentException iae) {
                    trace.errStack("Failed integrity check: " + this, iae);
                }
            }
            this.position = position;
        }

        TSLauncherServer.Session getSession() {
            return this.session;
        }

        public MessageObject getSetPreferencesMessage() {
            return this.setPreferencesMessage;
        }

        void setSetPreferencesMessage(MessageObject setPreferencesMessage) {
            if (trace.getDebugCode("collab")) {
                trace.out("collab", "setSetPreferencesMessage(" + setPreferencesMessage + ") on " + this);
            }
            this.setPreferencesMessage = setPreferencesMessage;
        }
    }

    public static class All
    extends HashMap<String, List<Collaborators>> {
        private static final long serialVersionUID = 20130212L;

        synchronized Collaborators add(String schoolName, List<String> userIDs, TSLauncherServer.Session mySession, int myPosition) {
            String key = Collaborators.makeKeyWithNamespace(schoolName, userIDs.toString());
            LinkedList<Collaborators> resultList = (LinkedList<Collaborators>)this.get(key);
            if (trace.getDebugCode("collab")) {
                trace.out("collab", "add(" + schoolName + ", " + userIDs + ", " + mySession.getGuid() + ", " + myPosition + ") key " + key + ", resultList " + resultList);
            }
            if (resultList == null) {
                resultList = new LinkedList<Collaborators>();
                this.put(key, resultList);
            }
            for (Collaborators result : resultList) {
                Collaborator collab = result.getCollaborator(mySession, false);
                if (trace.getDebugCode("collab")) {
                    trace.out("collab", "add(" + schoolName + ", " + userIDs + ", " + mySession.getGuid() + ", " + myPosition + ") finds result " + result);
                }
                if (collab == null || result.getState() != State.Awaiting) continue;
                collab.setSession(mySession);
                collab.setPosition(myPosition);
                return result;
            }
            Collaborators result = new Collaborators(schoolName, userIDs, mySession, myPosition);
            resultList.add(result);
            return result;
        }

        synchronized Collaborators getCollaborators(TSLauncherServer.Session sess) {
            return this.internalGetCollaborators(sess, null);
        }

        private synchronized Collaborators internalGetCollaborators(TSLauncherServer.Session sess, Collaborator[] rtnCollab) {
            Collaborators result = null;
            if (rtnCollab != null) {
                rtnCollab[0] = null;
            }
            if (sess != null) {
                String listKey = Collaborators.makeKeyWithNamespace(sess.getSchoolName(), sess.getTeam());
                List collabsList = (List)this.get(listKey);
                if (trace.getDebugCode("collab")) {
                    trace.outNT("collab", "Collab.findCollaborator() listKey " + listKey + ";\n  list " + collabsList);
                }
                if (collabsList != null) {
                    for (Collaborators collabs : collabsList) {
                        Collaborator collab = collabs.getCollaborator(sess, true);
                        if (collab == null) continue;
                        result = collabs;
                        if (rtnCollab == null) break;
                        rtnCollab[0] = collab;
                        break;
                    }
                }
            }
            if (trace.getDebugCode("collab")) {
                trace.outNT("collab", "Collab.getCollaborators() for session " + sess + " => " + result);
            }
            return result;
        }

        synchronized Collaborator findCollaborator(TSLauncherServer.Session sess) {
            Collaborator[] result = new Collaborator[1];
            this.internalGetCollaborators(sess, result);
            if (trace.getDebugCode("collab")) {
                trace.outNT("collab", "Collab.findCollaborator() for session " + sess + " => " + result[0]);
            }
            return result[0];
        }

        synchronized Collaborators removeSession(TSLauncherServer.Session sess) {
            Collaborator collab = this.findCollaborator(sess);
            if (trace.getDebugCode("collab")) {
                trace.out("collab", "Collaborators.All.removeSession(" + sess + ") finds Collaborator " + collab);
            }
            if (collab == null) {
                return null;
            }
            Collaborators result = collab.remove();
            if (trace.getDebugCode("collab")) {
                trace.out("collab", "Collaborators.All.removeSession(" + sess + ") Collaborators result " + result);
            }
            if (!result.isEmpty()) {
                return result;
            }
            String key = Collaborators.makeKeyWithNamespace(sess.getSchoolName(), sess.getTeam());
            List collabsList = (List)this.get(key);
            if (collabsList != null) {
                collabsList.remove(result);
                if (collabsList.isEmpty()) {
                    this.remove(key);
                }
            }
            return result;
        }

        synchronized int enqueueToCollaborators(TSLauncherServer.Session sess, MessageObject mo) {
            Collaborator collab;
            if (trace.getDebugCode("collab")) {
                trace.out("collab", "All.enqueue() keySet " + this.keySet());
            }
            if ((collab = this.findCollaborator(sess)) == null) {
                return 0;
            }
            if (trace.getDebugCode("collab")) {
                trace.outNT("collab", "enqueueToCollaborators(" + mo.getMessageType() + "): " + collab);
            }
            return collab.enqueueToCollaborators(mo);
        }
    }

    static enum State {
        New,
        Awaiting,
        Running,
        Finishing;

    }

    public static class NotReadyException
    extends Exception {
        private static final long serialVersionUID = 20130212L;
        public final List<String> absences;

        public NotReadyException(String message, List<String> absences) {
            super(message);
            this.absences = absences;
        }
    }
}

