/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerBase;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.pact.SocketProxy.HTTPToolProxy;
import edu.cmu.pact.SocketProxy.LogServlet;
import edu.cmu.pact.TutoringService.HTTPSession;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.io.IOException;

public class LauncherHandler
extends CTATHTTPHandlerBase
implements CTATHTTPHandlerInterface {
    public static final String CTATSESSION_HEADER = "ctatsession";
    protected TSLauncherServer launcherServer;

    protected LauncherHandler(TSLauncherServer launcherServer) {
        super(CTATLink.logdir + "/access.log");
        this.launcherServer = launcherServer;
    }

    @Override
    public synchronized boolean handle(CTATHTTPExchange exch, String requestBody) {
        this.debug("handle () requestBody " + requestBody);
        String requestMethod = exch.getRequestMethod();
        this.debug("Request method: " + requestMethod + ", Request URI: " + exch.getRequestURI());
        if (requestMethod.equalsIgnoreCase("options")) {
            return this.doOptions(exch);
        }
        if (exch.startWS(this)) {
            return false;
        }
        String msg = requestBody;
        try {
            if (msg == null) {
                msg = exch.getRequestBodyAsString();
            }
            if (HTTPToolProxy.handlePolicyFileRequest(msg, exch)) {
                return true;
            }
        }
        catch (IOException ioe) {
            this.sendHTMLResponse(exch, "<p>Error retrieving request body: " + ioe + ".</p><p>Cause: " + ioe.getCause() + "</p>", 400);
            exch.close();
        }
        catch (Exception e) {
            this.sendHTMLResponse(exch, "<p>Error processing request: " + e + ".</p><p>Cause: " + e.getCause() + "</p>", 500);
            exch.close();
        }
        String guid = MessageObject.getPropertyFromXML(msg, "session_id");
        if (guid == null) {
            guid = MessageObject.getPropertyFromXML(msg, "Guid");
        }
        if (guid == null) {
            guid = exch.getRequestHeaderConcatenated(CTATSESSION_HEADER);
        }
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "guid " + guid + " LauncherHandler.handle( " + exch + " )");
        }
        if (guid == null || guid.length() < 1) {
            trace.err("Error: no session id \"" + guid + "\" found in HTTP request:\n  " + exch);
            LauncherHandler.sendResponse(exch, "Error no session id " + guid + " found in HTTP request", 404);
            return true;
        }
        TSLauncherServer.Session sess = this.launcherServer.getSession(guid);
        if (sess == null) {
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "LauncherHandler accepted new session: guid " + guid + ", CTATHTTPExchange " + exch);
            }
            HTTPSession hSess = new HTTPSession(this.launcherServer, guid, requestBody, exch, this);
            hSess.startActionHandler();
            return true;
        }
        if (sess instanceof HTTPSession) {
            if (this.handleLogRecord(requestBody, exch, (HTTPSession)sess)) {
                return true;
            }
            ((HTTPSession)sess).postRequestToActionHandler(requestBody, exch);
            return false;
        }
        trace.err("Error session " + guid + " type " + sess.getClass().getSimpleName() + " not an HTTPSession; request:\n  " + exch);
        LauncherHandler.sendResponse(exch, "Error session " + guid + " found but not an HTTPSession", 500);
        return true;
    }

    protected boolean handleLogRecord(String requestBody, CTATHTTPExchange exch, HTTPSession sess) {
        try {
            return LogServlet.handleLogRecord(requestBody, exch, sess.getLogServlet());
        }
        catch (Exception e) {
            String resp = "<p>Error processing request: " + e + ".</p><p>Cause: " + e.getCause() + "</p>";
            trace.errStack("Error from LogServlet.handleLogRecord(" + exch.toString(true) + "\n): " + resp, e);
            this.sendHTMLResponse(exch, resp, 500);
            exch.close();
            return false;
        }
    }

    protected boolean doOptions(CTATHTTPExchange exch) {
        String allowHeaders = exch.getRequestHeaderConcatenated("Access-Control-Request-Headers");
        exch.addResponseHeader("Access-Control-Allow-Origin", "*");
        exch.addResponseHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
        exch.addResponseHeader("Access-Control-Allow-Headers", allowHeaders);
        exch.addResponseHeader("Access-Control-Max-Age", "1728000");
        exch.addResponseHeader("Content-Length", "0");
        LauncherHandler.sendResponse(exch, "", 200);
        return true;
    }
}

