/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.client;

import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Options;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintPanel;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintWindowInterface;
import edu.cmu.pact.Utilities.MessageEvent;
import edu.cmu.pact.Utilities.MessageEventListener;
import edu.cmu.pact.client.HintMessagesManagerForClient;
import edu.cmu.pact.client.MessageConnection;
import edu.cmu.pact.client.ProblemAdvance;
import edu.cmu.pact.client.TutorAddon;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.LogContext;
import edu.cmu.pslc.logging.Message;
import edu.cmu.pslc.logging.PlainMessage;
import edu.cmu.pslc.logging.ToolMessage;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import pact.CommWidgets.WrapperSupport;

public class TutorMessageDisplay
implements TutorAddon,
MessageEventListener {
    private HintMessagesManagerForClient messagesManager;
    private HintPanel hintPanel;
    private LogContext logger = null;
    MessageConnection msgConn = null;
    private TutorController tutorController;
    protected List<String> filter;
    protected ProblemAdvance problemAdvance;

    public TutorMessageDisplay(LogContext logContext, Container frame, String host, int port) {
        this(logContext, frame, host, port, null);
    }

    public TutorMessageDisplay(LogContext logContext, Container frame, String host, int port, ProblemAdvance advance) {
        this.tutorController = new TutorController(logContext, this);
        this.messagesManager = new HintMessagesManagerForClient(this.tutorController);
        this.messagesManager.setStudentInterfaceWrapper(this);
        this.hintPanel = new HintPanel(this.tutorController, this.messagesManager);
        this.messagesManager.setHintInterface(this.hintPanel);
        this.msgConn = new MessageConnection(host, port);
        this.logger = logContext;
        this.msgConn.addMessageEventListener(this.messagesManager);
        this.problemAdvance = advance;
        this.msgConn.addMessageEventListener(this);
        if (this.problemAdvance != null) {
            this.problemAdvance.setMessageConnection(this.msgConn);
            this.msgConn.addMessageEventListener(this.problemAdvance);
        }
        if (frame != null) {
            frame.add(this.hintPanel);
            frame.validate();
            frame.setVisible(true);
        }
        this.msgConn.openConnection();
        ArrayList<String> preferenceNames = new ArrayList<String>();
        ArrayList<String> preferenceValues = new ArrayList<String>();
        ContextMessage cm = logContext.getContextMessage();
        preferenceNames.add("log_to_remote_server");
        preferenceValues.add("false");
        preferenceNames.add("log_to_disk");
        preferenceValues.add("false");
        preferenceNames.add("user_guid");
        preferenceValues.add(logContext.getUserId());
        preferenceNames.add("problem_name");
        preferenceValues.add(logContext.getProblemName());
        preferenceNames.add("question_file");
        preferenceValues.add(logContext.getQuestionFile());
        preferenceNames.add("session_id");
        preferenceValues.add(logContext.getSessionId());
        preferenceNames.add("ProblemName");
        preferenceValues.add(logContext.getQuestionFile());
        preferenceNames.add("problem_context");
        preferenceValues.add(logContext.getContextMessage().getNameAttribute());
        preferenceNames.add("context_message_id");
        preferenceValues.add(logContext.getContextMessage().getContextMessageId());
        this.startTutoringServiceSession(preferenceNames, preferenceValues);
    }

    public MessageConnection getMessageConnection() {
        return this.msgConn;
    }

    @Override
    public void requestHint() {
        ToolMessage msg = this.createHintRequest();
        if (this.logger != null) {
            this.logger.logIt((Message)msg, new Date());
        }
        this.msgConn.unfilteredSendString(msg.toString(false));
    }

    public void sendString(String msg) {
        this.msgConn.unfilteredSendString(msg);
    }

    public void requestLoadProblem(String filename) {
    }

    @Override
    public void requestDone() {
        ToolMessage msg = this.createDoneRequest();
        if (this.logger != null) {
            this.logger.logIt((Message)msg, new Date());
        }
        this.msgConn.unfilteredSendString(msg.toString(false));
    }

    private ToolMessage createHintRequest() {
        if (this.logger == null) {
            return null;
        }
        ToolMessage msg = ToolMessage.create((ContextMessage)this.logger.getContextMessage());
        msg.setAsHintRequest();
        msg.addSai("Help", "ButtonPressed", "-1");
        return msg;
    }

    private ToolMessage createDoneRequest() {
        if (this.logger == null) {
            return null;
        }
        ToolMessage msg = ToolMessage.create((ContextMessage)this.logger.getContextMessage());
        msg.setAsAttempt();
        msg.addSai("done", "ButtonPressed", "-1");
        return msg;
    }

    String createSetPreferenceRequest(List preferences, List values) {
        if (this.logger == null) {
            return null;
        }
        PlainMessage msg = PlainMessage.create((ContextMessage)this.logger.getContextMessage());
        msg.addProperty("MessageType", "SetPreferences");
        for (int i = 0; i < preferences.size(); ++i) {
            msg.addProperty(preferences.get(i).toString(), values.get(i).toString());
        }
        return msg.toString();
    }

    String sendInterfaceIdentification(String sessionGuid) {
        if (sessionGuid == null) {
            sessionGuid = new UID().toString();
        }
        String msg = "<message><verb>NotePropertySet</verb><properties><MessageType>InterfaceIdentification</MessageType><Guid>" + sessionGuid + "</Guid></properties></message>";
        this.sendString(msg);
        return sessionGuid;
    }

    @Override
    public String startTutoringServiceSession(List preferenceNames, List preferenceValues) {
        String sessionGuid = this.sendInterfaceIdentification(null);
        String setPrefsMsg = this.createSetPreferenceRequest(preferenceNames, preferenceValues);
        this.sendString(setPrefsMsg);
        return sessionGuid;
    }

    @Override
    public ProblemAdvance getProblemAdvance() {
        return this.problemAdvance;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TutorMessageDisplay");
        String host = null;
        int port = 1502;
        block4: for (int i = 0; i < args.length; ++i) {
            switch (i) {
                case 0: {
                    host = args[i];
                    continue block4;
                }
                case 1: {
                    port = Integer.parseInt(args[i]);
                }
            }
        }
        frame.validate();
        frame.setVisible(true);
    }

    @Override
    public LogContext getLogger() {
        return this.logger;
    }

    @Override
    public void enableLMSLogin(boolean loginEnabled) {
    }

    @Override
    public JFrame getActiveWindow() {
        return null;
    }

    @Override
    public int getHeight() {
        return this.hintPanel != null ? this.hintPanel.getHeight() : 0;
    }

    @Override
    public HintWindowInterface getHintInterface() {
        return this.hintPanel;
    }

    @Override
    public JComponent getTutorPanel() {
        return this.hintPanel;
    }

    @Override
    public void reset() {
        this.hintPanel.reset();
    }

    @Override
    public int getWidth() {
        return this.hintPanel != null ? this.hintPanel.getWidth() : 0;
    }

    @Override
    public WrapperSupport getWrapperSupport() {
        return null;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setLocation(int x, int y) {
    }

    @Override
    public CTAT_Options setTutorPanel(JComponent tutorPanel) {
        return null;
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public void showAdvanceProblemMenuItem() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void addMessageEventListener(MessageEventListener me) {
        if (this.msgConn != null) {
            this.msgConn.addMessageEventListener(me);
        }
    }

    @Override
    public void openConnection() {
        if (this.msgConn != null) {
            this.msgConn.openConnection();
        }
    }

    @Override
    public void closeConnection() {
        if (this.msgConn != null) {
            this.msgConn.stopListener();
        }
    }

    @Override
    public void removeMessageEventListener(MessageEventListener me) {
        if (this.msgConn != null) {
            this.msgConn.addMessageEventListener(me);
        }
    }

    @Override
    public boolean filter(String str) {
        if (this.filter != null) {
            int actionStart = str.indexOf("<action>");
            int actionEnd = str.indexOf("</action>");
            if (actionStart >= 0 && actionEnd > actionStart) {
                String action = str.substring(actionStart + "<action>".length(), actionEnd);
                for (String filtered : this.filter) {
                    if (!filtered.equals(action)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void setFilter(List<String> filter) {
        this.filter = filter;
    }

    @Override
    public void messageEventOccurred(MessageEvent me) {
        if (this.logger == null) {
            return;
        }
        Object msg = me.getMessage();
        if (msg instanceof Message) {
            this.logger.logIt((Message)msg, new Date());
        } else if (msg instanceof String) {
            this.logger.logIt((String)msg, new Date());
        }
    }
}

