/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.model;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.CtatListModel;
import edu.cmu.pact.ctat.model.SelectionBiasedComparator;
import edu.cmu.pact.ctat.model.StartStateModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.text.JTextComponent;

public class ActionListModel
extends CtatListModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 201403142005L;
    private StartStateModel startStateModel;
    private String selection;
    private Set<String> selectionActions = new HashSet<String>();

    public ActionListModel(Collection<String> items, StartStateModel startStateModel) {
        super(items);
        this.startStateModel = startStateModel;
    }

    public boolean isActionForSelection(String actionName) {
        if (actionName == null) {
            return false;
        }
        return this.selectionActions.contains(actionName);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (trace.getDebugCode("editstudentinput")) {
            trace.out("editstudentinput", "ActionListModel.propertyChange(" + evt.toString() + ")");
        }
        if (this.startStateModel == null) {
            return;
        }
        if (!(evt.getSource() instanceof JTextComponent)) {
            return;
        }
        if (evt.getPropertyName() != "text") {
            return;
        }
        this.selection = ((JTextComponent)evt.getSource()).getText();
        this.reviseActionList(this.startStateModel);
    }

    private void reviseActionList(StartStateModel startStateModel) {
        if (this.selection == null || this.selection.trim().length() < 1) {
            this.selectionActions.clear();
            this.addAll(startStateModel.getAllActionNames());
        } else {
            this.selectionActions = startStateModel.getActionNames(this.selection);
            LinkedHashSet<String> resultSet = new LinkedHashSet<String>(startStateModel.getAllActionNames());
            resultSet.addAll(this.selectionActions);
            ArrayList<String> result = new ArrayList<String>(resultSet);
            Collections.sort(result, new SelectionBiasedComparator(this.selectionActions));
            this.addAll(result, false);
        }
    }

    @Override
    public void startStateReceived(EventObject evt) {
        if (!(evt.getSource() instanceof StartStateModel)) {
            trace.err("CtatListModel.startStateReceived(" + evt + ") caller not StartStateModel");
            return;
        }
        this.reviseActionList((StartStateModel)evt.getSource());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (sb.charAt(sb.length() - 1) == ']') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(", selection ").append(this.selection);
        sb.append(", selectionActions ").append(this.selectionActions);
        sb.append(']');
        return sb.toString();
    }
}

