/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctatview;

import edu.cmu.pact.ctatview.DockManager;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.View;

public class DockWindowAdapter
extends DockingWindowAdapter
implements WindowListener,
DockingWindowListener {
    private final DockManager dockManager;
    private final int showWindowMenuId;
    private static final boolean TESTING = false;

    public DockWindowAdapter(DockManager dockManager, int viewCount) {
        this.dockManager = dockManager;
        this.showWindowMenuId = viewCount;
    }

    public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
        if (removedFromWindow.isShowing() && this.showWindowMenuId != this.dockManager.getGraphEditorId()) {
            this.dockManager.setMenuVisibilityMarker(this.showWindowMenuId, false);
        }
        this.handleChildren(removedWindow, 1, removedWindow.isClosable());
    }

    private void handleChildren(DockingWindow dw, int depth, Boolean add) {
        int n = dw.getChildWindowCount();
        for (int i = 0; i < n; ++i) {
            DockingWindow cw = dw.getChildWindow(i);
            int cid = this.dockManager.findView(cw);
            if (add != null && cid > 0) {
                boolean mark = add;
                if (mark) {
                    mark &= cw.isClosable();
                }
                this.dockManager.setMenuVisibilityMarker(cid, mark);
            }
            if (cw.getChildWindowCount() <= 0) continue;
            this.handleChildren(cw, depth + 1, add);
        }
    }

    public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
        if (addedWindow.getWidth() > 0 && this.showWindowMenuId != this.dockManager.getGraphEditorId()) {
            this.dockManager.setMenuVisibilityMarker(this.showWindowMenuId, true);
            this.dockManager.refreshWindow(this.showWindowMenuId);
        }
        this.handleChildren(addedWindow, 1, true);
        this.handleChildren(addedToWindow, 1, true);
    }

    public void windowRestoring(DockingWindow window) {
    }

    public void windowRestored(DockingWindow window) {
    }

    public void windowUndocking(DockingWindow window) {
    }

    public void windowUndocked(DockingWindow window) {
    }

    public void windowDocking(DockingWindow window) {
    }

    public void windowDocked(DockingWindow window) {
    }

    public void windowMinimized(DockingWindow window) {
    }

    public void windowMinimizing(DockingWindow window) {
    }

    public void windowMaximized(DockingWindow window) {
    }

    public void windowMaximizing(DockingWindow window) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    public void windowHidden(DockingWindow window) {
    }

    public void windowShown(DockingWindow window) {
    }

    public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
    }
}

