/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.PeerLearning.GameShow.Competitor;
import edu.cmu.pact.miss.PeerLearning.GameShow.Connection;
import edu.cmu.pact.miss.PeerLearning.GameShow.ContestOrganizer;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowUtilities;
import edu.cmu.pact.miss.PeerLearning.GameShow.ProblemType;
import edu.cmu.pact.miss.PeerLearning.GameShow.TimeoutDelay;
import edu.cmu.pact.miss.PeerLearning.GameShow.TimeoutRecovery;
import edu.cmu.pact.miss.SimSt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Timer;

public class ContestServer
implements TimeoutRecovery {
    SimSt simSt;
    ServerSocket serverSocket;
    Socket socket1;
    Socket socket2;
    private int port = 4444;
    protected SortedSet<Connection> connections;
    private List<ContestOrganizer> contests;
    private Connection waitingForMatch = null;
    private Timer challengeRequestResponse;
    public static final String JOIN = "JoinProgram";
    public static final String REQUEST_CONTEST = "RequestContest";
    public static final String SOLUTION = "SolutionMade";
    public static final String REQUEST_NEXT = "RequestNextProblem";
    public static final String REQUEST_UPDATE = "RequestUpdate";
    public static final String LEAVE = "LeaveProgram";
    public static final String LIST = "ListAvailable";
    public static final String START_CONTEST = "StartContest";
    public static final String START_PROBLEM = "StartProblem";
    public static final String ASSESSED = "SolutionAssessed";
    public static final String END_CONTEST = "EndContest";
    public static final String SUBMIT_PROBLEMS = "SubmitProblems";
    public static final String AGREE_CONTEST = "AgreeContest";
    public static final String CONTEST_REQUESTED = "ContestRequested";
    public static final String CONTEST_AGREED = "ContestAgreed";
    public static final String REQUEST_PROBLEM = "RequestProblem";
    public static final String CHAT_PRIVATE_MESSAGE = "ChatPrivateMessage";
    public static final String CHAT_GROUP_MESSAGE = "ChatGroupMessage";
    public static final String ANNOUNCE_MESSAGE = "AnnounceMessage";
    public static final String ANNOUNCE_PRIVATE_MESSAGE = "AnnouncePrivateMessage";
    public static final String REQUEST_PROBLEM_BANK = "RequestProblemBank";
    public static final String PROBLEM_BANK_LIST = "ProblemBankList";
    public static final String DUPLICATE_USERID = "DuplicateUserID";
    public static final String FORFEIT = "GameForfeited";
    public static final String CANCEL = "GameCancelled";
    public static final String LEADERBOARD = "Leaderboard";
    public static final String OUTSTANDING = "Outstanding";
    public static final String GAME_START_MSG = "$1 and $2 have just started a game.";
    public static final String GAME_RETURN_MSG = "$1 has returned from a game.";
    public static final String JOIN_MSG = "$1 has joined.";
    public static final String LEAVE_MSG = "$1 has left.";
    public static final String WIN_MSG = "$1 just won in a game against $2.";
    public static final String TIE_MSG = "$1 and $2's game just ended in a tie.";
    public static final String FORFEIT_MSG = "$2 forfeited a game to $1.";
    public static final String OUTSTAND_ME_MSG = "You already have an outstanding challenge.";
    public static final String OUTSTAND_MSG = "$1 already has an outstanding challenge.";
    public static final String PROBLEM_REQUEST_EXIT = "ProblemRequestExited";
    public static final String PROBLEM_REQUEST_TIMEOUT = "ProblemRequestTimedOut";
    public static final String CHALLENGE_REQUEST_TIMEOUT = "ChallengeRequestTimedOut";
    public static final String PROBLEM_ANSWER_TIMEOUT = "ProblemAnswerTimedOut";
    public static final String PROBLEM_REQUEST_EXIT_MSG = "** Request to provide problem was exited.  A random problem will be used instead. **";
    public static final String PROBLEM_REQUEST_TIMEOUT_MSG = "** Request to provide problem timed out.  A random problem will be used instead. **";
    public static final String CHALLENGE_REQUEST_TIMEOUT_MSG = "** Challenge request from $1 timed out.  It has been declined for you. **";
    public static final String CHALLENGE_NOT_CURRENT_MSG = "This challenge is no longer current.";
    public static final int CHALLENGE_TIMEOUT_TIME = 60000;
    public static final int PROBLEM_REQUEST_TIMEOUT_TIME = 60000;
    public static final int PROBLEM_SOLVE_TIMEOUT_TIME = 120000;
    public static final String COMPETITOR_FILE = "competitors.csv";
    public static final String PROBLEM_FILE = "problemStats.csv";
    static Hashtable<String, Competitor> competitors = new Hashtable();
    static Hashtable<String, ProblemType> problemStatistics = new Hashtable();

    public ContestServer(SimSt ss) {
        this.simSt = ss;
        this.runServer();
    }

    public ContestServer() {
        this.runServer();
    }

    public ContestServer(int portNum) {
        this.port = portNum;
        this.runServer();
    }

    public void runServer() {
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            System.out.println("Could not listen on port: " + this.port);
            System.exit(-1);
        }
        Comparator<Connection> comp = new Comparator<Connection>(){

            @Override
            public int compare(Connection arg0, Connection arg1) {
                if (arg0 == null || arg1 == null) {
                    return -1;
                }
                int one = ContestServer.competitors.get((Object)arg0.userid).rating;
                int two = ContestServer.competitors.get((Object)arg1.userid).rating;
                if (one < two) {
                    return -1;
                }
                if (one == two) {
                    int comps = arg0.name.compareTo(arg1.name);
                    if (comps != 0) {
                        return comps;
                    }
                    return arg0.userid.compareTo(arg1.userid);
                }
                return 1;
            }
        };
        this.connections = Collections.synchronizedSortedSet(new TreeSet<Connection>(comp));
        this.contests = new LinkedList<ContestOrganizer>();
        ContestServer.readCompetitorFile();
        ContestServer.readProblemStatisticFile();
        System.out.println("Starting a new Thread AcceptThread: " + Thread.currentThread());
        new Thread(new AcceptThread()).start();
        System.out.println("Started a new Thread AcceptThread: " + Thread.currentThread());
    }

    private void arrangeContest(Connection connection) {
        if (this.waitingForMatch == null) {
            this.waitingForMatch = connection;
        } else {
            Connection contestant1 = this.waitingForMatch;
            this.waitingForMatch = null;
            Connection contestant2 = connection;
            ContestOrganizer organizer = new ContestOrganizer(this, contestant1, contestant2);
            this.contests.add(organizer);
            this.connections.remove(contestant1);
            this.connections.remove(contestant2);
            this.sendAnnounceMessage(GameShowUtilities.replaceTwoPieces(GAME_START_MSG, contestant1.name, contestant2.name));
            this.reportConnections();
        }
    }

    private boolean arrangeContest(Connection connection, String challengee) {
        if (connection.hasOutstandingChallenge()) {
            System.out.println(connection.name + " was outstanding - abort!");
            connection.writer.println("Outstanding,You already have an outstanding challenge.,self");
            return false;
        }
        for (Connection challengeConnection : this.connections) {
            if (!challengeConnection.userid.equals(challengee)) continue;
            if (challengeConnection.hasOutstandingChallenge()) {
                System.out.println(challengeConnection.name + " was outstanding - abort!");
                connection.writer.println("Outstanding," + GameShowUtilities.replacePiece(OUTSTAND_MSG, challengeConnection.name) + "," + challengeConnection.userid);
                return false;
            }
            connection.setOutstandingChallenge(true);
            challengeConnection.setOutstandingChallenge(true);
            challengeConnection.writer.println("ContestRequested," + connection.userid);
            System.out.println(challengeConnection.userid + ":" + CONTEST_REQUESTED + "," + connection.userid);
            this.challengeRequestResponse = new Timer(60000, new TimeoutDelay(this, CHALLENGE_REQUEST_TIMEOUT, challengeConnection, connection));
            this.challengeRequestResponse.setRepeats(false);
            this.challengeRequestResponse.start();
            return true;
        }
        return false;
    }

    public void refuseContest(Connection connection, String challenger) {
        for (Connection challengeConnection : this.connections) {
            if (!challengeConnection.userid.equals(challenger)) continue;
            connection.setOutstandingChallenge(false);
            challengeConnection.setOutstandingChallenge(false);
            challengeConnection.writer.println("ContestAgreed," + connection.userid + ",false");
            System.out.println(challengeConnection.userid + ":" + CONTEST_AGREED + "," + connection.userid + ",false");
            new Thread(new ListenerThread(challengeConnection)).start();
            return;
        }
    }

    public void acceptContest(Connection connection, String challenger) {
        for (Connection challengeConnection : this.connections) {
            if (!challengeConnection.userid.equals(challenger)) continue;
            connection.setOutstandingChallenge(false);
            challengeConnection.setOutstandingChallenge(false);
            challengeConnection.writer.println("ContestAgreed," + connection.userid + ",true");
            System.out.println(challengeConnection.userid + ":" + CONTEST_AGREED + "," + connection.userid + ",true");
            Connection contestant1 = challengeConnection;
            Connection contestant2 = connection;
            ContestOrganizer organizer = new ContestOrganizer(this, contestant1, contestant2);
            this.contests.add(organizer);
            this.connections.remove(contestant1);
            this.connections.remove(contestant2);
            this.sendAnnounceMessage(GameShowUtilities.replaceTwoPieces(GAME_START_MSG, contestant1.name, contestant2.name));
            this.reportConnections();
            return;
        }
    }

    public static String requestProblemBank() {
        String bank = "";
        String[] examples = GameShowUtilities.generateExamples();
        for (int i = 0; i < examples.length; ++i) {
            String pattern = GameShowUtilities.determinePattern(examples[i]);
            ProblemType type = problemStatistics.get(pattern);
            if (type == null) continue;
            int pct = (int)((double)type.successCount * 100.0 / (double)type.attemptCount);
            String diff = 5 - (pct - 1) / 20 + "-star.png";
            bank = bank + examples[i] + ";" + type.attemptCount + ";" + diff + ",";
        }
        return bank;
    }

    private void acceptConnection() {
        try {
            System.out.println("Enter in acceptConnection: " + Thread.currentThread());
            Socket socket = this.serverSocket.accept();
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            Connection connection = new Connection(socket, out, in);
            new Thread(new ListenerThread(connection)).start();
            System.out.println("Exit from acceptConnection: " + Thread.currentThread());
        }
        catch (IOException e) {
            System.out.println("Accept failed: 4444");
            System.exit(-1);
        }
    }

    public synchronized void returnConnection(Connection connect) {
        Connection remove = null;
        for (Connection c : this.connections) {
            if (!c.userid.equals(connect.userid)) continue;
            remove = connect;
        }
        if (remove != null) {
            remove.writer.println(DUPLICATE_USERID);
            System.out.println(remove.userid + ":" + DUPLICATE_USERID);
            this.connections.remove(remove);
            return;
        }
        this.sendAnnounceMessage(GameShowUtilities.replacePiece(GAME_RETURN_MSG, connect.name));
        this.connections.add(connect);
        new Thread(new ListenerThread(connect)).start();
        this.reportConnections();
    }

    private void reportConnections() {
        String report = "ListAvailable,";
        for (Connection connect : this.connections) {
            report = report + connect.name + ";" + connect.img + ";" + ContestServer.competitors.get((Object)connect.userid).rating + ";" + ContestServer.competitors.get((Object)connect.userid).wins + ";" + ContestServer.competitors.get((Object)connect.userid).losses + ";" + ContestServer.competitors.get((Object)connect.userid).ties + ";" + connect.userid + ",";
        }
        for (Connection connect : this.connections) {
            connect.writer.println(report);
            System.out.println(connect.userid + ":" + report);
        }
        ContestServer.writeCompetitorFile();
    }

    public static void updateProblemStatistics(String problem, int attempts, int successes) {
        String problemType = GameShowUtilities.determinePattern(problem);
        if (problemStatistics.containsKey(problemType)) {
            ProblemType stats = problemStatistics.get(problemType);
            stats.addAttempts(attempts, successes);
        } else {
            problemStatistics.put(problemType, new ProblemType(problemType, attempts, successes));
        }
        ContestServer.writeProblemStatisticFile();
    }

    private static synchronized void writeProblemStatisticFile() {
        try {
            FileWriter f = new FileWriter(new File(PROBLEM_FILE));
            for (String c : problemStatistics.keySet()) {
                f.write(problemStatistics.get(c) + "\n");
            }
            f.flush();
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static synchronized void readProblemStatisticFile() {
        try {
            File file = new File(PROBLEM_FILE);
            if (!file.exists()) {
                return;
            }
            BufferedReader f = new BufferedReader(new FileReader(file));
            String line = f.readLine();
            while (line != null && !line.equals("-1")) {
                String[] problemDetails = line.split(",");
                int attempts = Integer.parseInt(problemDetails[1]);
                int successes = Integer.parseInt(problemDetails[2]);
                ProblemType problem = new ProblemType(problemDetails[0], attempts, successes);
                problemStatistics.put(problemDetails[0], problem);
                line = f.readLine();
            }
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static synchronized void writeCompetitorFile() {
        try {
            FileWriter f = new FileWriter(new File(COMPETITOR_FILE));
            for (String c : competitors.keySet()) {
                f.write(competitors.get(c) + "\n");
            }
            f.flush();
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static synchronized void readCompetitorFile() {
        try {
            File file = new File(COMPETITOR_FILE);
            if (!file.exists()) {
                return;
            }
            BufferedReader f = new BufferedReader(new FileReader(file));
            String line = f.readLine();
            while (line != null && !line.equals("-1")) {
                String[] competitorDetails = line.split(",");
                Competitor compete = new Competitor(competitorDetails[0], competitorDetails[1], competitorDetails[6]);
                compete.rating = Integer.parseInt(competitorDetails[2]);
                compete.wins = Integer.parseInt(competitorDetails[3]);
                compete.losses = Integer.parseInt(competitorDetails[4]);
                compete.ties = Integer.parseInt(competitorDetails[5]);
                compete.classroom = competitorDetails[7];
                competitors.put(compete.userid, compete);
                line = f.readLine();
            }
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAnnounceMessage(String message) {
        message = "** " + message + " **";
        for (Connection connect : this.connections) {
            connect.writer.println("AnnounceMessage," + message);
            System.out.println(connect.userid + ":" + ANNOUNCE_MESSAGE + "," + message);
        }
    }

    public void announceWin(String winner, String loser) {
        this.sendAnnounceMessage(GameShowUtilities.replaceTwoPieces(WIN_MSG, winner, loser));
    }

    public void announceForfeit(String forfeitee, String forfeiter) {
        this.sendAnnounceMessage(GameShowUtilities.replaceTwoPieces(FORFEIT_MSG, forfeitee, forfeiter));
    }

    public void announceTie(String contestant1, String contestant2) {
        this.sendAnnounceMessage(GameShowUtilities.replaceTwoPieces(TIE_MSG, contestant1, contestant2));
    }

    public static void updateRatingTie(String one, String two) {
        int diff;
        double lowChanceWin;
        double newScoreLower;
        Competitor compOne = ContestServer.findCompetitor(one);
        Competitor compTwo = ContestServer.findCompetitor(two);
        if (compOne == null) {
            compOne = new Competitor(one, "", one);
        }
        if (compTwo == null) {
            compTwo = new Competitor(two, "", two);
        }
        Competitor lower = compOne;
        Competitor higher = compTwo;
        if (compOne.rating > compTwo.rating) {
            lower = compTwo;
            higher = compOne;
        }
        if ((newScoreLower = (double)lower.rating + 8.0 * (1.0 - (lowChanceWin = 1.0 / (1.0 + Math.pow(10.0, (double)(-(diff = lower.rating - higher.rating)) / 50.0))))) > 100.0) {
            newScoreLower = 100.0;
        }
        lower.rating = !lower.stat && newScoreLower < (double)higher.rating ? (int)newScoreLower : higher.rating;
        ++compOne.ties;
        ++compTwo.ties;
        ContestServer.writeCompetitorFile();
    }

    private static Competitor findCompetitor(String userid) {
        for (Competitor check : competitors.values()) {
            if (!check.userid.equals(userid)) continue;
            return check;
        }
        return null;
    }

    public static void updateRating(String winner, String loser) {
        Competitor win = ContestServer.findCompetitor(winner);
        Competitor lose = ContestServer.findCompetitor(loser);
        if (win == null) {
            win = new Competitor(winner, "", winner);
        }
        if (lose == null) {
            lose = new Competitor(loser, "", loser);
        }
        int diff = win.rating - lose.rating;
        double winChanceWin = 1.0 / (1.0 + Math.pow(10.0, (double)(-diff) / 50.0));
        double loseChanceWin = 1.0 / (1.0 + Math.pow(10.0, (double)diff / 50.0));
        double newScoreWinner = (double)win.rating + 16.0 * (1.0 - winChanceWin);
        double newScoreLoser = (double)lose.rating + 16.0 * (0.0 - loseChanceWin);
        if (newScoreWinner > 100.0) {
            newScoreWinner = 100.0;
        }
        if (newScoreLoser < 1.0) {
            newScoreLoser = 1.0;
        }
        if (!win.stat) {
            win.rating = (int)newScoreWinner;
        }
        if (!lose.stat) {
            lose.rating = (int)newScoreLoser;
        }
        ++win.wins;
        ++lose.losses;
        ContestServer.writeCompetitorFile();
    }

    public static int projectWin(int winnerRating, int loserRating) {
        int diff = winnerRating - loserRating;
        double winChanceWin = 1.0 / (1.0 + Math.pow(10.0, (double)(-diff) / 50.0));
        double newScoreWinner = (double)winnerRating + 16.0 * (1.0 - winChanceWin);
        if (newScoreWinner > 100.0) {
            newScoreWinner = 100.0;
        }
        return (int)newScoreWinner;
    }

    public static int projectLoss(int loserRating, int winnerRating) {
        int diff = winnerRating - loserRating;
        double loseChanceWin = 1.0 / (1.0 + Math.pow(10.0, (double)diff / 50.0));
        double newScoreLoser = (double)loserRating + 16.0 * (0.0 - loseChanceWin);
        if (newScoreLoser < 1.0) {
            newScoreLoser = 1.0;
        }
        return (int)newScoreLoser;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.println("Port " + args[0]);
            new ContestServer(Integer.parseInt(args[0]));
        } else {
            new ContestServer();
        }
    }

    @Override
    public void timeoutRecovery(String timeoutType, Connection connection1, Connection connection2) {
        if (timeoutType.equals(CHALLENGE_REQUEST_TIMEOUT)) {
            connection1.setOutstandingChallenge(false);
            connection1.writer.println("ChallengeRequestTimedOut," + connection2.userid + "," + connection2.name);
            System.out.println(connection1.userid + ":" + CHALLENGE_REQUEST_TIMEOUT + "," + connection2.userid);
            if (connection2 != null) {
                connection2.setOutstandingChallenge(false);
                connection2.writer.println("ContestAgreed," + connection1.userid + ",false");
                System.out.println(connection2.userid + ":" + CONTEST_AGREED + "," + connection1.userid + ",false");
                new Thread(new ListenerThread(connection2)).start();
            }
        }
    }

    class ListenerThread
    extends Thread {
        boolean activeListener = true;
        Connection connection;

        ListenerThread(Connection connect) {
            this.connection = connect;
        }

        @Override
        public void run() {
            String incomingMsg = "";
            try {
                while (this.activeListener && (incomingMsg = this.connection.reader.readLine()) != null) {
                    System.out.println("Client (server): " + incomingMsg);
                    if (incomingMsg.startsWith(ContestServer.JOIN)) {
                        this.joinProgram(incomingMsg);
                    } else if (incomingMsg.startsWith(ContestServer.LEAVE)) {
                        this.leaveProgram(incomingMsg);
                    } else if (incomingMsg.startsWith(ContestServer.REQUEST_CONTEST)) {
                        this.requestContest(incomingMsg);
                    } else if (incomingMsg.startsWith(ContestServer.AGREE_CONTEST)) {
                        this.agreeContest(incomingMsg);
                    } else if (incomingMsg.startsWith(ContestServer.CHAT_GROUP_MESSAGE)) {
                        this.sendChatMessage(incomingMsg);
                    } else if (incomingMsg.startsWith(ContestServer.LEADERBOARD)) {
                        this.sendLeaderboard(incomingMsg);
                    } else {
                        this.leaveProgram(incomingMsg);
                    }
                    trace.out("ss-gameshow", "Listening to " + this.connection.name);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void sendLeaderboard(String incomingMsg) {
            String[] args = incomingMsg.split(",");
            String classname = "";
            if (args.length > 1) {
                classname = args[1];
            }
            Comparator<Competitor> comp = new Comparator<Competitor>(){

                @Override
                public int compare(Competitor arg0, Competitor arg1) {
                    int one = arg0.rating;
                    int two = arg1.rating;
                    if (one < two) {
                        return -1;
                    }
                    if (one == two) {
                        int comps = arg0.name.compareTo(arg1.name);
                        if (comps != 0) {
                            return comps;
                        }
                        return arg0.userid.compareTo(arg1.userid);
                    }
                    return 1;
                }
            };
            SortedSet<Competitor> leaderList = Collections.synchronizedSortedSet(new TreeSet<Competitor>(comp));
            for (Competitor c : competitors.values()) {
                if (!c.classroom.equals(classname)) continue;
                leaderList.add(c);
            }
            String list = ContestServer.LEADERBOARD;
            String spaces = "........................................";
            int listCount = 0;
            while (leaderList.size() > 0 && listCount < 10) {
                Competitor c = leaderList.last();
                String s = c.name + c.rating;
                s = s.length() < 20 ? c.name + spaces.substring(0, 20 - s.length()) + c.rating : c.name + spaces.substring(0, 1) + c.rating;
                list = list + "," + ++listCount + ". " + s;
                leaderList.remove(c);
            }
            Calendar cal = Calendar.getInstance();
            String now = cal.get(12) < 10 ? cal.get(10) + ":0" + cal.get(12) : cal.get(10) + ":" + cal.get(12);
            if (now.startsWith("0:")) {
                now = now.replace("0:", "12:");
            }
            list = list + ",(Updated: " + now + ")";
            this.connection.writer.println(list);
            System.out.println(this.connection.userid + ": " + list);
        }

        public void sendChatMessage(String incomingMsg) {
            String chat = incomingMsg.substring(incomingMsg.indexOf(44) + 1);
            chat = this.connection.name + "'s Tutor: " + chat;
            for (Connection connect : ContestServer.this.connections) {
                connect.writer.println("ChatGroupMessage," + chat);
                System.out.println(connect.userid + ":" + ContestServer.CHAT_GROUP_MESSAGE + "," + chat);
            }
        }

        protected void joinProgram(String args) {
            String[] argList = args.split(",");
            String id = "";
            String classname = "";
            boolean stat = false;
            if (argList.length > 5 && argList[5].equals("static")) {
                stat = true;
            }
            if (argList.length > 3) {
                id = argList[3];
            }
            if (argList.length > 4) {
                classname = argList[4];
            }
            if (argList.length > 2) {
                this.connection.setImage(argList[2]);
            }
            if (argList.length > 1) {
                Competitor compete;
                this.connection.setName(argList[1]);
                this.connection.setUserID(id);
                if (!competitors.containsKey(this.connection.userid)) {
                    compete = new Competitor(this.connection.name, this.connection.img, id);
                    compete.stat = stat;
                    compete.classroom = classname;
                    competitors.put(compete.userid, compete);
                } else {
                    compete = competitors.get(this.connection.userid);
                    if (this.connection.name != null) {
                        compete.name = this.connection.name;
                    }
                    if (this.connection.img != null) {
                        compete.img = this.connection.img;
                    }
                    if (id.length() > 0 && compete.userid.length() > 0 && !id.equals(compete.userid)) {
                        trace.err("Same student name between different students!");
                    } else if (!id.equals("") && compete.userid.equals("")) {
                        compete.userid = id;
                    }
                    compete.stat = stat;
                }
                ContestServer.this.sendAnnounceMessage(GameShowUtilities.replacePiece(ContestServer.JOIN_MSG, this.connection.name));
            }
            Connection remove = null;
            for (Connection c : ContestServer.this.connections) {
                if (!c.userid.equals(this.connection.userid)) continue;
                remove = c;
            }
            if (remove != null) {
                remove.writer.println(ContestServer.DUPLICATE_USERID);
                System.out.println(remove.userid + ":" + ContestServer.DUPLICATE_USERID);
                ContestServer.this.connections.remove(remove);
            }
            this.connection.valid = true;
            ContestServer.this.connections.add(this.connection);
            ContestServer.this.reportConnections();
        }

        protected void leaveProgram(String args) {
            this.connection.writer.println(ContestServer.LEAVE);
            System.out.println(this.connection.userid + ":" + ContestServer.LEAVE);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            ContestServer.this.connections.remove(this.connection);
            this.connection.writer.close();
            try {
                this.connection.reader.close();
                this.connection.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.activeListener = false;
            if (this.connection.valid) {
                ContestServer.this.sendAnnounceMessage(GameShowUtilities.replacePiece(ContestServer.LEAVE_MSG, this.connection.name));
                ContestServer.this.reportConnections();
            }
        }

        protected void requestContest(String args) {
            String[] challengee = args.split(",");
            boolean result = false;
            if (challengee.length > 1) {
                result = ContestServer.this.arrangeContest(this.connection, challengee[1]);
            } else {
                ContestServer.this.arrangeContest(this.connection);
            }
            if (result) {
                this.activeListener = false;
            }
        }

        private void agreeContest(String args) {
            String[] challengee = args.split(",");
            if (ContestServer.this.challengeRequestResponse != null) {
                ContestServer.this.challengeRequestResponse.stop();
            }
            if (challengee.length > 2 && challengee[2].equals("false")) {
                ContestServer.this.refuseContest(this.connection, challengee[1]);
            } else {
                ContestServer.this.acceptContest(this.connection, challengee[1]);
                this.activeListener = false;
            }
        }
    }

    class AcceptThread
    extends Thread {
        AcceptThread() {
        }

        @Override
        public void run() {
            while (true) {
                System.out.println("Calling acceptConnection AcceptThread running: " + Thread.currentThread());
                ContestServer.this.acceptConnection();
                System.out.println("Called acceptConnection AcceptThread running: " + Thread.currentThread());
            }
        }
    }
}

